/**
 * @file constants.hh
 *
 * @brief  Configuration constants
 *
 * @author  Haikel Guemar (haikel.guemar@sysfera.com)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef _CONSTANTS_HH_
#define _CONSTANTS_HH_

#include <string>
#ifdef __WIN32__
#define DIET_API_LIB __declspec(dllexport)
#else
#define DIET_API_LIB
#endif
namespace diet {
typedef enum {
  NONE_PARAMETER,
  BOOL_PARAMETER,
  INT_PARAMETER,
  ULONG_PARAMETER,
  STRING_PARAMETER,
  ADDRESS_PARAMETER,
  AGENT_PARAMETER,  // like int
} c_type_t;

typedef enum {
  CONFIGFILE = 0,
  TRACELEVEL,
  MANAME,             // MA for client to attach to
  AGENTTYPE,          // Is this agent an LA or MA
  DIETPORT,           // End point definition
  DIETHOSTNAME,       // End point definition
  NAME,               // Agent name
  PARENTNAME,         // Parent to attach to
  FASTUSE,
  LDAPUSE, LDAPBASE, LDAPMASK,
  NWSUSE, NWSNAMESERVER, NWSFORECASTER,
  USELOGSERVICE, LSOUTBUFFERSIZE, LSFLUSHINTERVAL,
  NEIGHBOURS, MAXNEIGHBOURS, MINNEIGHBOURS, UPDATELINKPERIOD,
  BINDSERVICEPORT, USECONCJOBLIMIT, MAXCONCJOBS,
  LOCATIONID,         // For alternative transfer cost prediction
  MADAGNAME,
  USEWFLOGSERVICE,
  /* New : For user scheduler support. */
  MODULENAME,
  MODULECFG,
  BATCHNAME,
  BATCHQUEUE,
  PATHTONFS,
  PATHTOTMP,
  // RequestID begins with this value
  INITREQUESTID,
  // file to touch at the end of the initialization
  MAXMSGSIZE,
  MAXDISKSPACE,
  MAXMEMSPACE,
  CACHEALGORITHM,
  SHAREFILES,
  DATABACKUPFILE,
  RESTOREONSTART,
  STORAGEDIR,
  USE_SPECIFIC_SCHEDULING,
  INTERNOARQUEUENAME,
  CLIENT_MAX_NB_SED,
  CLOUDURL,
  EMINAME,
  ERINAME,
  EKINAME,
  KEYNAME,
  VMTYPE,
  VMMINCOUNT,
  VMMAXCOUNT,
  PATHTOCERT,
  PATHTOPK,
  PATHTOSSHKEY,
  INSTANTIATEVMS,
  SECURITYGROUP,
  USERNAME,
  PASSWORD,
  FORCE_CLIENT_REBIND,
  NBRETRY,
  /* For Security support */

  SSLENABLED,
  SECURITYLEVEL,
  SSLROOTCERTIFICATE,
  SSLPRIVATEKEY,
  SSLPRIVATEKEYPASSWORD,

  NB_PARAM_TYPE
}param_type_t;

struct param_t {
  param_type_t key;
  const std::string value;
  // TODO: unused today but may help get rid of "simple_cast"
  c_type_t type;
};

extern DIET_API_LIB param_t params[];
}

#endif /* _CONSTANTS_HH_ */
