/**
 * @file AdvancedDagdaComponent.hh
 *
 * @brief  Advanced Dagda component implementation
 *
 * @author  Gael Le Mahec (lemahec@clermont.in2p3.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef __ADVANCED_DAGDA_COMPONENT_HH__
#define __ADVANCED_DAGDA_COMPONENT_HH__

#include <ctime>
#include <map>
#include <string>

#include "DagdaImpl.hh"
#include "NetworkStats.hh"

#define DGD_OBJ_TYPE(obj) ((obj).desc.specific._d() == DIET_FILE ?      \
                           DIET_FILE_OBJ : DIET_MEM_OBJ)

class AdvancedDagdaComponent;

typedef enum {DIET_MEM_OBJ, DIET_FILE_OBJ} dagda_object_type_t;
typedef int (*managementFunc)(AdvancedDagdaComponent *manager, size_t needed,
                              dagda_object_type_t type);

class AdvancedDagdaComponent : public SimpleDagdaImpl {
public:
  explicit
  AdvancedDagdaComponent(dagda_manager_type_t t)
    : SimpleDagdaImpl(t), mngFunction(NULL),
    stats(NULL), shareFiles(false) {
  }

  AdvancedDagdaComponent(dagda_manager_type_t t, managementFunc function)
  : SimpleDagdaImpl(t), mngFunction(function),
  stats(NULL), shareFiles(false) {
  }

  AdvancedDagdaComponent(dagda_manager_type_t t, managementFunc function,
                         NetworkStats * stats) :
  SimpleDagdaImpl(t), mngFunction(function),
  stats(stats), shareFiles(false) {
  }

  AdvancedDagdaComponent(dagda_manager_type_t t, NetworkStats * stats)
  : SimpleDagdaImpl(t), mngFunction(NULL),
  stats(stats), shareFiles(false) {
  }

  // With file sharing.
  AdvancedDagdaComponent(dagda_manager_type_t t, bool shareFiles)
  : SimpleDagdaImpl(t), mngFunction(NULL),
  stats(NULL), shareFiles(shareFiles) {
  }

  AdvancedDagdaComponent(dagda_manager_type_t t, managementFunc function,
                         bool shareFiles)
  : SimpleDagdaImpl(t), mngFunction(function),
  stats(NULL), shareFiles(shareFiles) {
  }

  AdvancedDagdaComponent(dagda_manager_type_t t, managementFunc function,
                         NetworkStats * stats, bool shareFiles)
  : SimpleDagdaImpl(t), mngFunction(function),
  stats(stats), shareFiles(shareFiles) {
  }

  AdvancedDagdaComponent(dagda_manager_type_t t, NetworkStats * stats,
                         bool shareFiles)
  : SimpleDagdaImpl(t), mngFunction(NULL),
  stats(stats), shareFiles(shareFiles) {
  }


  virtual char *
  sendFile(const corba_data_t &data, const char *dest);

  virtual char *
  sendData(const char *ID, const char *dest);

  virtual void
  lclAddData(const char *src, const corba_data_t &data);

  virtual void
  registerFile(const corba_data_t &data);

  std::map<std::string, corba_data_t> *
  getData() {
    return SimpleDagdaImpl::getData();
  }

  virtual corba_data_t *
  getData(const char *dataID);

  virtual char *
  getBestSource(const char *dest, const char *dataID);

  virtual clock_t
  getRegisterTime(const char *dataID);

  virtual clock_t
  getLastUsageTime(const char *dataID);

  virtual unsigned long
  getNbUsage(const char *dataID);

  virtual void
  setRegisterTime(const char *dataID, clock_t time);

  virtual void
  setRegisterTime(const char *dataID);

  virtual void
  setUsageTime(std::string id, clock_t time);

  virtual void
  setUsageTime(std::string id);

  virtual void
  incNbUsage(const char *dataID);

  virtual void
  shareData(const corba_data_t &data);

private:
  managementFunc mngFunction;
  std::map<std::string, clock_t> registerTime;
  std::map<std::string, clock_t> lastUsageTime;
  std::map<std::string, unsigned long> nbUsage;
  omni_mutex registerMutex;
  omni_mutex lastUsageMutex;
  omni_mutex nbUsageMutex;
  NetworkStats *stats;
  bool shareFiles;
};
#endif /* ifndef __ADVANCED_DAGDA_COMPONENT_HH__ */
