/**
 * @file BatchCreator.hh
 *
 * @brief  Batch System Management with performance prediction
 *
 * @author  Yves Caniou (yves.caniou@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _BATCH_CREATOR_HH_
#define _BATCH_CREATOR_HH_

#include "deltacloud_config.h"

class BatchSystem;

class BatchCreator {
public:
  typedef enum {
    OAR1_6,
    LOADLEVELER,
    SGE,
    PBS,
    OAR2_X,
    SLURM,
#ifdef DIET_USE_EC2CLOUD
    EUCALYPTUS,
#endif
#ifdef DIET_USE_DELTACLOUD
    DELTACLOUD,
#endif
    NUMBER_OF_SUPPORTED_BATCH
  } batchID_t;

  static const char *const batchNames[NUMBER_OF_SUPPORTED_BATCH];

  BatchCreator();

  /** Returns a new inherited instance of the class BatchSystem corresponding
      to the name @param batchName .
      Returns NULL if batch system is not managed.
   */
  static BatchSystem *
  getBatchSystem(const char *batchName);

  /** Returns 1 if the batch system is managed by DIET, 0 otherwise */
  static int
  existBatchScheduler(const char *batchName, batchID_t *batchID);
};

#endif /* ifndef _BATCH_CREATOR_HH_ */
