/**
* @file EnvParser.hh
* 
* @brief  Environment variables parser 
* 
* @author  Haikel Guemar (haikel.guemar@sysfera.com)
* 
* @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/



#ifndef _ENV_PARSER_HH_
#define _ENV_PARSER_HH_



#include <map>
#include <string>
#include <vector>

#include "CommonParser.hh"
#include "EnvException.hh"

/**
 * @author hguemar <hguemar@sysfera.com>
 *
 * @class EnvParser
 * @brief Environment variables parser
 *
 * environment variables parser, relevant options are stored in a std::map
 */
class EnvParser {
public:
  /**
   * @brief constructor
   * @param envp environment variables array
   * @param config parser configuration
   */
  EnvParser(char *envp[], ConfigMap& config);
  /**
   * @brief do the parsing
   */
  void
  parse();

  /**
   * @brief subscript operator returning option value
   * @param key option name
   * @return  option value (switchs return "true") or empty string
   */
  std::string&
  operator[](const std::string& key);  // setter
  /**
   * @brief const subscript operator returning option value
   * @param key option name
   * @return  option value (switchs return "true") or empty string
   */
  const std::string&
  operator[](const std::string& key) const;  // getter

  /**
   * @brief return configuration
   * @return configuration map (option name, value)
   */
  const std::map<std::string, std::string>&
  getConfiguration() const;

private:
  void
  lint() const;
  void
  parseEnv(char *envp[]);

  // option name, environment name
  typedef std::vector<std::string> Env;
  Env env_;  // *raw* environments
  ConfigMap config_;  // parser configuration
  mutable OptionMap options_;  // our options
};

#endif /* _ENV_PARSER_HH_ */
