/**
* @file  WfLogServiceImpl.cc
* 
* @brief Workflow LogService 
* 
* @author  Gaël Le Mahec (gael.le.mahec@ens-lyon.fr)
* 
* @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/

#include "WfLogServiceImpl.hh"

WfLogServiceFwdrImpl::WfLogServiceFwdrImpl(Forwarder_ptr fwdr,
                                           const char* objName) {
  this->forwarder = Forwarder::_duplicate(fwdr);
  this->objName = CORBA::string_dup(objName);
}

void
WfLogServiceFwdrImpl::createDag(const char* dagId, const char* wfId) {
  forwarder->createDag(dagId, wfId, objName);
}

void
WfLogServiceFwdrImpl::createDagNode(const char* dagNodeId, const char* dagId,
                                    const char* wfId) {
  forwarder->createDagNode(dagNodeId, dagId, wfId, objName);
}

void
WfLogServiceFwdrImpl::createDagNodeData(const char* dagNodeId,
                                        const char* wfId,
                                        const char* dagNodePortId,
                                        const char* dataId) {
  forwarder->createDagNodeData(dagNodeId, wfId,
                               dagNodePortId, dataId,
                               objName);
}

void
WfLogServiceFwdrImpl::createDagNodeLink(const char* srcNodeId,
                                        const char* srcWfId,
                                        const char* destNodeId,
                                        const char* destWfId) {
  forwarder->createDagNodeLink(srcNodeId, srcWfId,
                               destNodeId, destWfId, objName);
}

void
WfLogServiceFwdrImpl::createDagNodePort(const char* dagNodePortId,
                                        const char* portDirection,
                                        const char* dagNodeId,
                                        const char* wfId) {
  forwarder->createDagNodePort(dagNodePortId, portDirection,
                               dagNodeId, wfId, objName);
}

void
WfLogServiceFwdrImpl::createDataElements(const char* dataId,
                                         const char* elementIdList) {
  forwarder->createDataElements(dataId, elementIdList, objName);
}

void
WfLogServiceFwdrImpl::createSinkData(const char* sinkId, const char* wfId,
                                     const char* dataId) {
  forwarder->createSinkData(sinkId, wfId, dataId, objName);
}

void
WfLogServiceFwdrImpl::createSourceDataTree(const char* sourceId,
                                           const char* wfId,
                                           const char* dataIdTree) {
  forwarder->createSourceDataTree(sourceId, wfId, dataIdTree, objName);
}

void
WfLogServiceFwdrImpl::initWorkflow(const char* wfId, const char* name,
                                   const char* parentWfId) {
  forwarder->initWorkflow(wfId, name, parentWfId, objName);
}

void
WfLogServiceFwdrImpl::nodeIsDone(const char* dagNodeId, const char* wfId) {
  forwarder->nodeIsDone(dagNodeId, wfId, objName);
}

void
WfLogServiceFwdrImpl::nodeIsFailed(const char* dagNodeId, const char* wfId) {
  forwarder->nodeIsFailed(dagNodeId, wfId, objName);
}

void
WfLogServiceFwdrImpl::nodeIsReady(const char* dagNodeId, const char* wfId) {
  forwarder->nodeIsReady(dagNodeId, wfId, objName);
}

void
WfLogServiceFwdrImpl::nodeIsRunning(const char* dagNodeId, const char* wfId) {
  forwarder->nodeIsRunning(dagNodeId, wfId, objName);
}

void
WfLogServiceFwdrImpl::nodeIsStarting(const char* dagNodeId, const char* wfId,
                                     const char* pbName, const char* hostname) {
  forwarder->nodeIsStarting(dagNodeId, wfId, pbName, hostname, objName);
}

void
WfLogServiceFwdrImpl::setInPortDependencies(const char* dagNodePortId,
                                            const char* dagNodeId,
                                            const char* wfId,
                                            const char* dependencies) {
  forwarder->setInPortDependencies(dagNodePortId, dagNodeId,
                                   wfId, dependencies, objName);
}

void
WfLogServiceFwdrImpl::updateDag(const char* dagId, const char* wfId,
                                const char* dagState, const char* data) {
  forwarder->updateDag(dagId, wfId, dagState, data, objName);
}

void
WfLogServiceFwdrImpl::updateWorkflow(const char* wfId, const char* wfState,
                                     const char* data) {
  forwarder->updateWorkflow(wfId, wfState, data, objName);
}
