/**
 * @file progs.hh
 *
 * @brief  DIET all data transfers example: a server for transfering all data types
 *
 * @author  Benjamin Depardon (Benjamin.Depardon@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef _PROGS_HH_
#define _PROGS_HH_


#include <iostream>

template <class T>
void
printMatrix(T *mat, size_t m, size_t n, bool rm) {
  size_t i, j;

  std:: cout << "Matrix is ";
  if (rm) {
    std::cout << "row major\n";
  } else {
    std::cout << "column major\n";
  }

  for (i = 0; i < (m); i++) {
    for (j = 0; j < (n); j++) {
      if (rm) {
        std::cout << mat[j + i * (n)] << " ";
      } else {
        std::cout << mat[i + j * (m)] << " ";
      }
    }
    std::cout << "\n";
  }
  std::cout << "\n";
} /* printMatrix */


template <class T>
void
printVector(T *vec, size_t n) {
  size_t i;

  for (i = 0; i < n; i++) {
    std::cout << vec[i] << " ";
  }
  std::cout << "\n";
}


/*
 * Sum 2 column-major matrices (modulo tA and tB):
 * if tA == 'T', then A is row-major ...
 */
template <class T>
int
MatSUM(char tA, char tB, size_t m, size_t n, T *A, T *B, T *C) {
  size_t i, j;

  if (tA == 'T') {
    if (tB == 'T') {
      for (i = 0; i < m; i++) {
        for (j = 0; j < n; j++) {
          C[j * m + i] = A[i * n + j] + B[i * n + j];
        }
      }
    } else {
      for (i = 0; i < m; i++) {
        for (j = 0; j < n; j++) {
          C[j * m + i] = A[i * n + j] + B[j * m + i];
        }
      }
    }
  } else {
    if (tB == 'T') {
      for (i = 0; i < m; i++) {
        for (j = 0; j < n; j++) {
          C[j * m + i] = A[j * m + i] + B[i * n + j];
        }
      }
    } else {
      for (i = 0; i < m; i++) {
        for (j = 0; j < n; j++) {
          C[j * m + i] = A[j * m + i] + B[j * m + i];
        }
      }
    }
  }

  return 0;
} /* MatSUM */



/*
 * Sum 2 vectors
 */

template <class T>
int
VecSUM(size_t n, T *A, T *B, T *C) {
  size_t i;

  for (i = 0; i < n; i++) {
    C[i] = A[i] + B[i];
  }

  return 0;
}

#endif  // _PROGS_HH_
