/**
 * @file  Vector.h
 *
 * @brief  Plug-in Scheduler: Information vector management
 *
 * @author  Alan Su (Alan.Su@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _VECTOR_H_
#define _VECTOR_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct Vector_s {
  const void **v_obj;
  int v_size;
  int v_capacity;
} *Vector_t;

typedef const struct Vector_s *VectorConst_t;

typedef int (*compfn_t)(const void *, const void *);

Vector_t
new_Vector();

Vector_t
new_Vector1(int capacity);

void
free_Vector(Vector_t v);

int
Vector_add(Vector_t v, const void *o);

int
Vector_addAtPosition(Vector_t v, const void *o, int idx);

int
Vector_capacity(const VectorConst_t v);

int
Vector_clear(Vector_t v);

int
Vector_contains(const VectorConst_t v, const void *o);

Vector_t
Vector_copy(const VectorConst_t v);

const void *
Vector_elementAt(const VectorConst_t v, int idx);

int
Vector_ensureCapacity(Vector_t v, int capacity);

int
Vector_indexOf(const VectorConst_t v, const void *o);

int
Vector_indexOf3(const VectorConst_t v, const void *o, compfn_t c);

int
Vector_isEmpty(const VectorConst_t v);

const void *
Vector_lastElement(const VectorConst_t v);

int
Vector_lastIndexOf(const VectorConst_t v, const void *o);

int
Vector_remove(Vector_t v, const void *o);

int
Vector_remove3(Vector_t v, const void *o, compfn_t c);

void *
Vector_removeAtPosition(Vector_t v, int idx);

const void *
Vector_set(Vector_t v, const void *o, int idx);

int
Vector_size(const VectorConst_t v);

void
Vector_sort(Vector_t v, int (*sort_fn)(const void *a, const void *b));

int
Vector_trimToSize(Vector_t v);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* _VECTOR_H_ */
