/**
 * @file concatenation.c
 *
 * @brief   DIET server for Batch submission
 *
 * @author   Yves Caniou (Yves.Caniou@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include </usr/lib/mpich/include/mpi.h>
#include <stdio.h>
#include <stdlib.h>

#define NB_ARGS 4
#define MAX_STRING_LENGTH 100
#define SLEEPING_TIME 30

int
main(argc, argv)
int argc;
char *argv[];

{
  int size, my_num;
  char chaine[MAX_STRING_LENGTH];
  FILE *output_file, *file;
  size_t count;

  MPI_Init(&argc, &argv);

  if (argc != NB_ARGS + 1) {
    fprintf(stderr, "%s requires %d arguments:\n"
                    "- a filename\n"
                    "- a string (which will be printed by all process)\n"
                    "- a filename\n"
                    "- the output file\n",
            argv[0],
            NB_ARGS);
  }

  MPI_Comm_rank(MPI_COMM_WORLD, &my_num);
  MPI_Comm_size(MPI_COMM_WORLD, &size);

  printf("Hello world from %d out of %d : %s\n", my_num, size, argv[2]);
  printf("%d sleeping for %d seconds\n\n", my_num, SLEEPING_TIME);

  if (my_num == 0) {
    file = fopen(argv[1], "r");
    output_file = fopen(argv[NB_ARGS], "w+");
    while (!feof(file)) {
      count = fread(&chaine, sizeof(char), MAX_STRING_LENGTH, file);
      fwrite(chaine, sizeof(char), count, output_file);
    }
    fclose(file);
    file = fopen(argv[3], "r");
    while (!feof(file)) {
      count = fread(&chaine, sizeof(char), MAX_STRING_LENGTH, file);
      fwrite(chaine, sizeof(char), count, output_file);
    }
    fclose(file);
    fclose(output_file);
  }

  sleep(SLEEPING_TIME);

  MPI_Finalize();
  exit(0);
}
