/*
 * DIETLoopContainersTests.cpp
 *
 * TODO : description
 *
 * Created on: 15 march 2011
 * Author: bdepardo
 */

#include <string>

#include <DIET_client.h>
#include <DIET_grpc.h>

#include "fixtures.hpp"
#include "utils.hpp"


BOOST_FIXTURE_TEST_SUITE(workflows_loop_containers_sink,
                         AllDataTransferSeDFixtureWF)

#include "genericSimpleWfClientTest.hpp"

const std::string &expectedResult = "## WF OUTPUT (int2out) :\nTOTAL NB OF RESULTS: 1\n[0]=((3, 4), (3, 7), (7, 10), (10, 17), (17, 27)#UNDEF)\n## WF OUTPUT (int3out) :\nTOTAL NB OF RESULTS: 1\n[0]=((3, 7), (7, 10), (10, 17), (17, 27), (27, 44)#UNDEF)\n";


BOOST_AUTO_TEST_CASE(loop_container_character) {
  BOOST_TEST_MESSAGE("-- Test: workflow loop containers character");

  genericSimpleWorkflowClient(WF_DIRECTORY "loop_container_CCADD.xml",
                              "Loop Containers character",
                              DIET_WF_FUNCTIONAL,
                              WF_DIRECTORY "data_loop_container.xml",
							  WF_DIRECTORY "data_out.xml",
							  "",
							  expectedResult);
}

BOOST_AUTO_TEST_CASE(loop_container_short) {
  BOOST_TEST_MESSAGE("-- Test: workflow loop containers short");

  genericSimpleWorkflowClient(WF_DIRECTORY "loop_container_BCADD.xml",
                              "Loop Containers short",
                              DIET_WF_FUNCTIONAL,
                              WF_DIRECTORY "data_loop_container.xml",
							  WF_DIRECTORY "data_out.xml",
							  "",
							  expectedResult);
}

BOOST_AUTO_TEST_CASE(loop_container_int) {
  BOOST_TEST_MESSAGE("-- Test: workflow loop containers int");

  genericSimpleWorkflowClient(WF_DIRECTORY "loop_container_ICADD.xml",
                              "Loop Containers int",
                              DIET_WF_FUNCTIONAL,
                              WF_DIRECTORY "data_loop_container.xml",
							  WF_DIRECTORY "data_out.xml",
							  "",
							  expectedResult);
}

BOOST_AUTO_TEST_CASE(loop_container_long) {
  BOOST_TEST_MESSAGE("-- Test: workflow loop containers long");

  genericSimpleWorkflowClient(WF_DIRECTORY "loop_container_LCADD.xml",
                              "Loop Containers long",
                              DIET_WF_FUNCTIONAL,
                              WF_DIRECTORY "data_loop_container.xml",
							  WF_DIRECTORY "data_out.xml",
							  "",
							  expectedResult);
}


BOOST_AUTO_TEST_SUITE_END()
