/**
 * @file Cori_Metric.cc
 *
 * @brief  This is the API impl file to use CoRI
 *
 * @author  Frauenkron Peter (Peter.Frauenkron@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include "Cori_Metric.hh"
#include <iostream>
#include "debug.hh"

using namespace std;

Cori_Metric::Cori_Metric(diet_est_collect_tag_t type,
                         const void *data) {
  collector_type = type;

  switch (collector_type) {
  case EST_COLL_EASY: {
    cori_easy = new Cori_Data_Easy();
  }
  break;
#if defined HAVE_ALT_BATCH && not defined CLEAN_CORILIB_FROM_BATCH_STAFF
  case EST_COLL_BATCH:
    cori_batch = new Cori_batch((diet_profile_t *) data);
    break;
#endif
  default: {
    INTERNAL_WARNING("Collector called " << collector_type << " doesn't exist");
  }
  break;
  } // switch
}
diet_est_collect_tag_t
Cori_Metric::get_Collector_type() {
  return this->collector_type;
}

int
Cori_Metric::start(diet_est_collect_tag_t type) {
  collector_type = type;

  switch (collector_type) {
#if not defined CLEAN_CORILIB_FROM_BATCH_STAFF and defined HAVE_ALT_BATCH
  case EST_COLL_BATCH:
    // do I need to 'start' some Batch things?
    // Maybe one day, a process that monitors a batch systems if needed?
    return 0;

#endif
  case EST_COLL_EASY: {
    // no need to start - very dynamic functions
    return 0;
  }
  break;
  default: {
    INTERNAL_WARNING("Collector called " << collector_type << " doesn't exist");
    return 0;  // this warnig should not stop the start up of the SeD
  }
  break;
  } // switch
} // start

int
Cori_Metric::call_cori_metric(int type_Info,
                              estVector_t *information,
                              const void *data) {
  switch (collector_type) {
#if not defined CLEAN_CORILIB_FROM_BATCH_STAFF and defined HAVE_ALT_BATCH
  case EST_COLL_BATCH:
    return cori_batch->get_Information(type_Info,
                                       information,
                                       data);

    break;
#endif
  case EST_COLL_EASY: {
    return cori_easy->get_Information(type_Info,
                                      information,
                                      data);
  }
  break;
  default: {
    diet_est_set_internal(*information, type_Info, 0);
    ERROR_DEBUG("CoRI: Collector " << collector_type << " doesn't exist!", 1);
    // fixme : add the default value to every type_info
  }
  break;
  } // switch
  return 1;
} // call_cori_metric
