/**
 * @file remove.cc
 *
 * @brief  Example for dynamically killing an element and underlying hierachy
 *
 * @author  Benjamin Depardon (benjamin.depardon@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#include <iostream>
#include <cstring>
#include <cstdlib>

#include "DIET_admin.h"

using namespace std;

int
main(int argc, char **argv) {
  if (argc < 3) {
    cout << "Usage: " << argv[0] <<
    " <SED|AGENT> <element name> [recursive: 0|1]" << endl;
    return 1;
  }

  dynamic_type_t type;
  char *name = argv[2];
  bool recursive = false;
  int res;

  if (argc == 4) {
    recursive = atoi(argv[3]);
  }

  if (!strcmp(argv[1], "SED")) {
    type = SED;
  } else {
    type = AGENT;
  }
  cout << "Element name: " << name << endl;

  res = diet_remove_from_hierarchy(type, name, recursive);

  if (res) {
    cout << "** A problem occured during the removal of ";
    if (type == SED) {
      cout << "SeD ";
    } else {
      cout << "agent ";
    }
    cout << name << " (error code=" << res << ")." << endl;
  } else {
    cout << "** " << name << " has been removed." << endl;
  }

  return res;
} // main
