/**
* @file  WfLogDispatcher.hh
* 
* @brief Workflow Log Dispatcher
* 
* @author  Benjamin Isnard (benjamin.isnard@ens-lyon.fr)
* 
* @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/


#ifndef WFLOGDISPATCHER_HH_
#define WFLOGDISPATCHER_HH_

#include "EventDispatcher.hh"
#include "EventTypes.hh"
#include "DagNodePort.hh"
#include "Dag.hh"
#include "FWorkflow.hh"
#include "WfPortAdapter.hh"
#include "WfLogService.hh"
#ifdef WIN32
#define DIET_API_LIB __declspec(dllexport)
#else
#define DIET_API_LIB
#endif

class DIET_API_LIB WfLogDispatcher : public events::EventDispatcher {
public:
  explicit WfLogDispatcher(std::ostream& output);
  void
  setWfLogService(WfLogService_var logService);

  // creation of object
  void
  onEventCreateWorkflow(
    const events::EventCreateObject<FWorkflow, FWorkflow>* event);

  void
  onEventCreateWfDag(const events::EventCreateObject<Dag, FWorkflow>* event);

  void
  onEventCreateDagNode(const events::EventCreateObject<DagNode, Dag>* event);

  void
  onEventCreateDagNodePort(
    const events::EventCreateObject<DagNodePort, DagNode>* event);

  void
  onEventCreateDagNodeLink(
    const events::EventCreateDirectedLink<DagNode, DagNode>* event);

  // specific event handler for a source class
  void
  onWorkflowInstanciate(
    const events::EventFrom<FWorkflow,
                            events::EventStandardMsg<FWorkflow,
                                                     FWorkflow::INST> >* event);
  void
  onWorkflowInstDone(
    const events::EventFrom<FWorkflow,
                            events::EventStandardMsg<FWorkflow,
                                                     FWorkflow::INSTDONE> >*
    event);

  void
  onWorkflowInstError(
    const events::EventFrom<FWorkflow,
                            events::EventStandardMsg<FWorkflow,
                                                     FWorkflow::INSTERROR> >*
    event);

  void
  onWorkflowCancelled(
    const events::EventFrom<FWorkflow,
                            events::EventStandardMsg<FWorkflow,
                                                     FWorkflow::CANCELLED> >*
    event);

  void
  onWorkflowCompleted(
    const events::EventFrom<FWorkflow,
                            events::EventStandardMsg<FWorkflow,
                                                     FWorkflow::COMPLETED> >*
    event);

  void
  onDagChangeId(const events::EventFrom<Dag,
                                        events::EventStandardMsg<Dag,
                                                                 Dag::MODID > >*
                event);

  void
  onDagIsEmpty(
    const events::EventFrom<Dag,
                            events::EventStandardMsg<Dag,
                                                     Dag::EMPTY > >* event);

  void
  onDagStateChange(
    const events::EventFrom<Dag,
                            events::EventStandardMsg<Dag,
                                                     Dag::STATE > >* event);

  void
  onDagNodeReady(
    const events::EventFrom<DagNode,
                            events::EventStandardMsg<DagNode,
                                                     DagNode::READY> >* event);

  void
  onDagNodeStart(
    const events::EventFrom<DagNodeLauncher,
                            events::EventStandardMsg<DagNodeLauncher,
                                                     DagNode::START> >* event);

  void
  onDagNodeFinish(
    const events::EventFrom<DagNodeLauncher,
                            events::EventStandardMsg<DagNodeLauncher,
                                                     DagNode::FINISH> >* event);

  void
  onDagNodeFailed(
    const events::EventFrom<DagNodeLauncher,
                            events::EventStandardMsg<DagNodeLauncher,
                                                     DagNode::FAILED> >* event);

  void
  onInPortDepend(
    const events::EventFrom<DagNodeInPort,
                            events::EventStandardMsg<DagNodeInPort,
                                                     DagNodeInPort::DEPEND> >*
    event);

  void
  onDataElements(
    const events::EventFrom<WfDataIDAdapter,
                            events::EventStandardMsg<WfDataIDAdapter,
                                                     WfDataIDAdapter::ELTIDLIST> >*
    event);

  void
  onDagNodeSetDataID(
    const events::EventFrom<DagNodePort,
                            events::EventStandardMsg<DagNodePort,
                                                     DagNodePort::DATAID> >*
    event);

  void
  onSourceDataTree(
    const events::EventFrom<FSourceNode,
                            events::EventStandardMsg<FSourceNode,
                                                     FSourceNode::DATATREE> >*
    event);

  void
  onSinkData(
    const events::EventFrom<FSinkNode,
                            events::EventStandardMsg<FSinkNode,
                                                     FSinkNode::DATAID>  >*
    event);

private:
  bool
  isOnline();

  std::ostream& myOutput;
  WfLogService_var myWfLogSrv;
};


#endif
