/**
 * @file Cori_Easy_Disk.hh
 *
 * @brief  CoRI: Collectors for disk ressource
 *
 * @author  Frauenkron Peter (Peter.Frauenkron@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef _CORI_EASY_DISK_HH_
#define _CORI_EASY_DISK_HH_

#include <cstdlib>
#include <iostream>
#include <fstream>

#define FILESIZE_MB 10  // MB
#define KILOBYTE 1024
#define MEGABYTE KILOBYTE * KILOBYTE
#define FILESIZE FILESIZE_MB * MEGABYTE
#define BUFFSIZE 1024
#define COUNTPERBUFFER 20

class Easy_Disk {
public:
  int
  get_Read_Speed(const char *path, double *result);

  int
  get_Write_Speed(const char *path, double *result);

  int
  get_Available_DiskSpace(const char *path, double *result);

  int
  get_Total_DiskSpace(const char *path, double *result);

private:
  int
  create_file(char **path_file);

  int
  gatherSizeDisks(int typeOfInfo, double *result, const char *path);

  int
  get_Write_Speed_by_gettimeofday(const char *path, double *result);

  int
  get_Write_Speed_by_sig_alarm(const char *path, double *result);

  int
  get_Read_Speed_by_gettimeofday(const char *path, double *result);

  int
  get_Read_Speed_by_sig_alarm(const char *path, double *result);

  int
  openfile(char **path, std::ofstream *outfile);

  double
  search_for_percent(FILE *file, int typeOfInfo);
};

#endif  // _CORI_EASY_DISK_HH_
