/**
 * @file  RequestID.hh
 *
 * @brief  Identifier for a request
 *
 * @author   Sylvain DAHAN (Sylvain.Dahan@lifc.univ-fcomte.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _REQUEST_ID_
#define _REQUEST_ID_

#include <omniORB4/CORBA.h>



class RequestID {
public:
  // FIXME: should be explicit but breaks build
  // src/agent/Agen
  /**
   * Creates a new RequestID.
   *
   * @param reqID the value of the RequestID.
   */
  RequestID(CORBA::Long reqID): value(reqID) {
  }

  /**
   * Clones a RequestID.
   *
   * @param reqID the RequestID to clone.
   */
  RequestID(const RequestID &reqID) {
    value = reqID.value;
  }

  /**
   * the current instance get the same value as \c reqID
   *
   * @param reqID The RequestID where the value is taken.
   */
  inline RequestID &
  operator = (const RequestID &reqID) {
    value = reqID.value;
    return *this;
  }

  /**
   * Converts the RequestID to a \c CORBA::Long value.
   */
  inline operator
  CORBA::Long() const {
    return value;
  }

  friend bool
    operator < (const RequestID &a, const RequestID &b);

  friend bool
    operator == (const RequestID &a, const RequestID &b);

private:
  /**
   * the value of RequestID
   */
  CORBA::Long value;
};

/**
 * returns true if the representation of \c a is lesser than the
 * representation of \c b.
 *
 * @param a a RequestID
 *
 * @param b a RequestID
 */
inline bool operator < (const RequestID &a, const RequestID &b) {
  return a.value < b.value;
}

/**
 * returns true if \c a and \c b represent the same ID.
 *
 * @param a a RequestID
 *
 * @param b a RequestID
 */
inline bool operator == (const RequestID &a, const RequestID &b) {
  return a.value == b.value;
}

#endif  // _REQUEST_ID_
