/**
 * @file Cori_Metric.hh
 *
 * @brief  This is the API header file to use CoRI Metric management
 *
 * @author  Frauenkron Peter (Peter.Frauenkron@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef _CORI_METRIC_HH_
#define _CORI_METRIC_HH_

#include "Cori_Data_Easy.hh"

#if not defined CLEAN_CORILIB_FROM_BATCH_STAFF and defined HAVE_ALT_BATCH
#include "Cori_batch.hh"
#endif

class Cori_Metric {
public:
  /**
   * Initialize the CoRI Metric of this SeD
   * @param type_collector is the program where you get the information from
   *                for exemple EASY, GANGLIA, NAGIOS
   *                ={EASY, BATCH*} are the supported programs
   *                                    (*only if installed)
   * @param data can be used to help initialize the collector.
   *        Not used for the moment in any collector
   */

  Cori_Metric(diet_est_collect_tag_t type_collector, const void *data);

  /**
   * type_Info is the type of the information you want collecting
   * information is the result
   * returns 1 if an error occurs. In this case, the information vector
   *                               is set to defaults (dummy) values
   */
  int
  call_cori_metric(int type_Info, estVector_t *information, const void *data);

  diet_est_collect_tag_t
  get_Collector_type();

  int
  start(diet_est_collect_tag_t type);

private:
  diet_est_collect_tag_t collector_type;
  diet_est_collect_tag_t type_collector;

  Cori_Data_Easy *cori_easy;
#if not defined CLEAN_CORILIB_FROM_BATCH_STAFF and defined HAVE_ALT_BATCH
  Cori_batch *cori_batch;
#endif
};


#endif  // _CORI_METRIC_HH_
