/**
 * @file client.cc
 *
 * @brief  Client used to dynamically add and remove a service using a library
 *
 * @author  Benjamin Depardon (benjamin.depardon@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include <iostream>
#include <cstring>
#include <cstdlib>

#include "DIET_client.h"
#include "DIET_Dagda.h"

void
usage(char *s) {
  std::cout << "Usage: " << s <<
  " <file.cfg> [add/rem/call] [lib/service Name/service Name] [//message]" <<
  std::endl;
  exit(1);
}


int
checkUsage(int argc, char **argv) {
  if (argc < 4) {
    usage(argv[0]);
  }
  return 0;
}

int
main(int argc, char *argv[]) {
  diet_profile_t *profile = NULL;
  std::string service;

  checkUsage(argc, argv);

  if (diet_initialize(argv[1], argc, argv)) {
    std::cerr << "DIET initialization failed !" << std::endl;
    return 1;
  }

  if (!strcmp(argv[2], "add")) {
    service = "addDyn";
    profile = diet_profile_alloc(strdup(service.c_str()), 0, 0, 0);
    if (diet_file_set(diet_parameter(profile, 0), argv[3], DIET_PERSISTENT)) {
      std::cerr << "Problem while sending file '" << argv[3] << "'" <<
      std::endl;
      return 1;
    }
  } else if (!strcmp(argv[2], "rem")) {
    service = "remDyn";
    std::cout << "*** removing '" << argv[3] << "'" << std::endl;
    profile = diet_profile_alloc(strdup(service.c_str()), 0, 0, 0);
    diet_string_set(diet_parameter(profile, 0), argv[3], DIET_VOLATILE);
  } else if (!strcmp(argv[2], "call")) {
    service = argv[3];
    profile = diet_profile_alloc(strdup(service.c_str()), 0, 0, 0);
    diet_string_set(diet_parameter(profile, 0), argv[4], DIET_VOLATILE);
  } else {
    diet_finalize();
    return -1;
  }

  /* Submit */
  std::cout << "*** Profile set, will now call the service ***" << std::endl;
  if (diet_call(profile)) {
    return 1;
  }
  std::cout << "DIET CALL finished" << std::endl;


  /* End */
  diet_profile_free(profile);
  diet_finalize();

  return 0;
} // main
