/*
 * @file CloudCredentials.hh
 *
 * @brief   Contains informations to log to a cloud
 *
 * @author  Lamiel Toch (lamiel.toch@ens-lyon.fr)
 *          Guillaume Verger (guillaume.verger@inria.fr)
 *
 * @section Licence
 *   |LICENCE|
 */

#ifndef _CLOUDCREDENTIALS_HH
#define _CLOUDCREDENTIALS_HH

#include <string>

class CloudCredentials{
  public:
    CloudCredentials(const std::string& url, const std::string& usr,
        const std::string& passwd):
      username(usr), password(passwd), base_url(url) { }

    CloudCredentials() {};
    ~CloudCredentials(){};

    CloudCredentials(const CloudCredentials& cred):
      username(cred.username), password(cred.password),
      base_url(cred.base_url) { }

    std::string username; // eg : "oneadmin";
    std::string password; // eg : "mypassword";
    std::string base_url; // eg : "http://localhost:3001/api";
} ;

#endif /* _CLOUDCREDENTIALS_HH */
