/**
 * @file EventManager.cc
 *
 * @brief   Event Manager (Notifier class)
 *
 * @author  Benjamin Isnard (benjamin.isnard@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include <iostream>
#include <algorithm>
#include "EventManager.hh"

using namespace std;
using namespace events;

EventManager *EventManager::_instance = NULL;

EventManager::~EventManager(){
	for (unsigned int i = 0; i <_observers.size(); i++){
		delete _observers[i];
	}
}

EventManager *
EventManager::getEventMgr() {
  if (_instance == NULL) {
    _instance = new EventManager();
  }
  return _instance;
}

void
EventManager::addObserver(EventObserver *observer) {
  _observers.push_back(observer);
}

void
EventManager::delObserver(EventObserver *observer){
	_observers.erase(std::remove(_observers.begin(), _observers.end(), observer));
}


void
EventManager::sendEvent(EventBase *event) {
  // send notification to all observers
  for (unsigned int i = 0; i < _observers.size(); i++) {
    if (_observers[i]->isObserver(event)) {
      try {
        _observers[i]->handleEvent(event);
      } catch (std::ios_base::failure &e) {
        cerr << "Sending event failed: ios failure caught: " << e.what() <<
        endl;
      }
    }
  }

} // sendEvent
