/**
 * @file soapC.c
 *
 * @brief  Batch System implementation for Amazon EC2 compatible clouds
 *
 * @author - Adrian Muresan (adrian.muresan@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */
/****************************************************************************/
/* Batch System implementation for Amazon EC2 compatible clouds             */
/* Auto-generated file by using gSOAP that provides an implementation       */
/* of a SOAP client for the EC2 interface.                                  */
/****************************************************************************/
/* soapC.c
   Generated by gSOAP 2.7.16 from euca.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

  SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.16 2010-04-20 15:04:34 GMT")


#ifndef WITH_NOGLOBAL

  SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
  {
    if (soap->header)
      soap_serialize_SOAP_ENV__Header(soap, soap->header);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
  {
    if (soap->header)
      {       soap->part = SOAP_IN_HEADER;
        if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
          return soap->error;
        soap->part = SOAP_END_HEADER;
      }
    return SOAP_OK;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
  {
    soap->part = SOAP_IN_HEADER;
    soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
    soap->part = SOAP_END_HEADER;
    return soap->header == NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
  {
    if (!soap->header)
      {       if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
          soap_default_SOAP_ENV__Header(soap, soap->header);
      }
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
  {
    if (!soap->fault)
      {       soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
        if (!soap->fault)
          return;
        soap_default_SOAP_ENV__Fault(soap, soap->fault);
      }
    if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
      {       soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
        soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
      }
    if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
      {       soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
        soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
      }
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
  {
    if (soap->fault)
      soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
  {
    if (soap->fault)
      return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
    return SOAP_OK;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
  {
    return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
  }

  SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
  {
    soap_fault(soap);
    if (soap->version == 2)
      return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
    return (const char**)&soap->fault->faultcode;
  }

  SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
  {
    soap_fault(soap);
    if (soap->version == 2)
      {       if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
          {       soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
            soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
          }
        return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
      }
    return (const char**)&soap->fault->faultcode;
  }

  SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
  {
    soap_fault(soap);
    if (soap->version == 2)
      return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
    return (const char**)&soap->fault->faultstring;
  }

  SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
  {
    soap_fault(soap);
    if (soap->version == 1)
      {       if (!soap->fault->detail)
          {       soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
            soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
          }
        return (const char**)&soap->fault->detail->__any;
      }
    if (!soap->fault->SOAP_ENV__Detail)
      {       soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
        soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
      }
    return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
  }

#endif

#ifndef WITH_NOIDREF
  SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
  {
    int t;
    if (soap->version == 1)
      {       for (;;)
          {       if (!soap_getelement(soap, &t))
              if (soap->error || soap_ignore_element(soap))
                break;
          }
      }
    if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
      soap->error = SOAP_OK;
    return soap->error;
  }
#endif

#ifndef WITH_NOIDREF
  SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
  {
    if (soap_peek_element(soap))
      return NULL;
    if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
      *type = soap_lookup_type(soap, soap->href);
    switch (*type)
      {
      case SOAP_TYPE_byte:
        return soap_in_byte(soap, NULL, NULL, "xsd:byte");
      case SOAP_TYPE_int:
        return soap_in_int(soap, NULL, NULL, "xsd:int");
      case SOAP_TYPE_time:
        return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
      case SOAP_TYPE_xsd__boolean_:
        return soap_in_xsd__boolean_(soap, NULL, NULL, "xsd:boolean");
      case SOAP_TYPE_wsse__FaultcodeEnum:
        return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, "wsse:FaultcodeEnum");
      case SOAP_TYPE_wsu__tTimestampFault:
        return soap_in_wsu__tTimestampFault(soap, NULL, NULL, "wsu:tTimestampFault");
      case SOAP_TYPE_ec2__RegionItemType:
        return soap_in_ec2__RegionItemType(soap, NULL, NULL, "ec2:RegionItemType");
      case SOAP_TYPE_ec2__RegionSetType:
        return soap_in_ec2__RegionSetType(soap, NULL, NULL, "ec2:RegionSetType");
      case SOAP_TYPE_ec2__DescribeRegionsResponseType:
        return soap_in_ec2__DescribeRegionsResponseType(soap, NULL, NULL, "ec2:DescribeRegionsResponseType");
      case SOAP_TYPE_ec2__DescribeRegionsSetItemType:
        return soap_in_ec2__DescribeRegionsSetItemType(soap, NULL, NULL, "ec2:DescribeRegionsSetItemType");
      case SOAP_TYPE_ec2__DescribeRegionsSetType:
        return soap_in_ec2__DescribeRegionsSetType(soap, NULL, NULL, "ec2:DescribeRegionsSetType");
      case SOAP_TYPE_ec2__DescribeRegionsType:
        return soap_in_ec2__DescribeRegionsType(soap, NULL, NULL, "ec2:DescribeRegionsType");
      case SOAP_TYPE_ec2__CancelBundleTaskResponseType:
        return soap_in_ec2__CancelBundleTaskResponseType(soap, NULL, NULL, "ec2:CancelBundleTaskResponseType");
      case SOAP_TYPE_ec2__CancelBundleTaskType:
        return soap_in_ec2__CancelBundleTaskType(soap, NULL, NULL, "ec2:CancelBundleTaskType");
      case SOAP_TYPE_ec2__BundleInstanceTasksSetType:
        return soap_in_ec2__BundleInstanceTasksSetType(soap, NULL, NULL, "ec2:BundleInstanceTasksSetType");
      case SOAP_TYPE_ec2__DescribeBundleTasksResponseType:
        return soap_in_ec2__DescribeBundleTasksResponseType(soap, NULL, NULL, "ec2:DescribeBundleTasksResponseType");
      case SOAP_TYPE_ec2__DescribeBundleTasksItemType:
        return soap_in_ec2__DescribeBundleTasksItemType(soap, NULL, NULL, "ec2:DescribeBundleTasksItemType");
      case SOAP_TYPE_ec2__DescribeBundleTasksInfoType:
        return soap_in_ec2__DescribeBundleTasksInfoType(soap, NULL, NULL, "ec2:DescribeBundleTasksInfoType");
      case SOAP_TYPE_ec2__DescribeBundleTasksType:
        return soap_in_ec2__DescribeBundleTasksType(soap, NULL, NULL, "ec2:DescribeBundleTasksType");
      case SOAP_TYPE_ec2__BundleInstanceTaskErrorType:
        return soap_in_ec2__BundleInstanceTaskErrorType(soap, NULL, NULL, "ec2:BundleInstanceTaskErrorType");
      case SOAP_TYPE_ec2__BundleInstanceTaskType:
        return soap_in_ec2__BundleInstanceTaskType(soap, NULL, NULL, "ec2:BundleInstanceTaskType");
      case SOAP_TYPE_ec2__BundleInstanceResponseType:
        return soap_in_ec2__BundleInstanceResponseType(soap, NULL, NULL, "ec2:BundleInstanceResponseType");
      case SOAP_TYPE_ec2__BundleInstanceS3StorageType:
        return soap_in_ec2__BundleInstanceS3StorageType(soap, NULL, NULL, "ec2:BundleInstanceS3StorageType");
      case SOAP_TYPE_ec2__BundleInstanceTaskStorageType:
        return soap_in_ec2__BundleInstanceTaskStorageType(soap, NULL, NULL, "ec2:BundleInstanceTaskStorageType");
      case SOAP_TYPE_ec2__BundleInstanceType:
        return soap_in_ec2__BundleInstanceType(soap, NULL, NULL, "ec2:BundleInstanceType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType:
        return soap_in_ec2__DescribeSnapshotsSetItemResponseType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetItemResponseType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType:
        return soap_in_ec2__DescribeSnapshotsSetResponseType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetResponseType");
      case SOAP_TYPE_ec2__DescribeSnapshotsResponseType:
        return soap_in_ec2__DescribeSnapshotsResponseType(soap, NULL, NULL, "ec2:DescribeSnapshotsResponseType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetItemType:
        return soap_in_ec2__DescribeSnapshotsSetItemType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetItemType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetType:
        return soap_in_ec2__DescribeSnapshotsSetType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetType");
      case SOAP_TYPE_ec2__DescribeSnapshotsType:
        return soap_in_ec2__DescribeSnapshotsType(soap, NULL, NULL, "ec2:DescribeSnapshotsType");
      case SOAP_TYPE_ec2__DeleteSnapshotResponseType:
        return soap_in_ec2__DeleteSnapshotResponseType(soap, NULL, NULL, "ec2:DeleteSnapshotResponseType");
      case SOAP_TYPE_ec2__DeleteSnapshotType:
        return soap_in_ec2__DeleteSnapshotType(soap, NULL, NULL, "ec2:DeleteSnapshotType");
      case SOAP_TYPE_ec2__CreateSnapshotResponseType:
        return soap_in_ec2__CreateSnapshotResponseType(soap, NULL, NULL, "ec2:CreateSnapshotResponseType");
      case SOAP_TYPE_ec2__CreateSnapshotType:
        return soap_in_ec2__CreateSnapshotType(soap, NULL, NULL, "ec2:CreateSnapshotType");
      case SOAP_TYPE_ec2__DetachVolumeResponseType:
        return soap_in_ec2__DetachVolumeResponseType(soap, NULL, NULL, "ec2:DetachVolumeResponseType");
      case SOAP_TYPE_ec2__DetachVolumeType:
        return soap_in_ec2__DetachVolumeType(soap, NULL, NULL, "ec2:DetachVolumeType");
      case SOAP_TYPE_ec2__AttachVolumeResponseType:
        return soap_in_ec2__AttachVolumeResponseType(soap, NULL, NULL, "ec2:AttachVolumeResponseType");
      case SOAP_TYPE_ec2__AttachVolumeType:
        return soap_in_ec2__AttachVolumeType(soap, NULL, NULL, "ec2:AttachVolumeType");
      case SOAP_TYPE_ec2__AttachmentSetItemResponseType:
        return soap_in_ec2__AttachmentSetItemResponseType(soap, NULL, NULL, "ec2:AttachmentSetItemResponseType");
      case SOAP_TYPE_ec2__AttachmentSetResponseType:
        return soap_in_ec2__AttachmentSetResponseType(soap, NULL, NULL, "ec2:AttachmentSetResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType:
        return soap_in_ec2__DescribeVolumesSetItemResponseType(soap, NULL, NULL, "ec2:DescribeVolumesSetItemResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesSetResponseType:
        return soap_in_ec2__DescribeVolumesSetResponseType(soap, NULL, NULL, "ec2:DescribeVolumesSetResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesResponseType:
        return soap_in_ec2__DescribeVolumesResponseType(soap, NULL, NULL, "ec2:DescribeVolumesResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesSetItemType:
        return soap_in_ec2__DescribeVolumesSetItemType(soap, NULL, NULL, "ec2:DescribeVolumesSetItemType");
      case SOAP_TYPE_ec2__DescribeVolumesSetType:
        return soap_in_ec2__DescribeVolumesSetType(soap, NULL, NULL, "ec2:DescribeVolumesSetType");
      case SOAP_TYPE_ec2__DescribeVolumesType:
        return soap_in_ec2__DescribeVolumesType(soap, NULL, NULL, "ec2:DescribeVolumesType");
      case SOAP_TYPE_ec2__DeleteVolumeResponseType:
        return soap_in_ec2__DeleteVolumeResponseType(soap, NULL, NULL, "ec2:DeleteVolumeResponseType");
      case SOAP_TYPE_ec2__DeleteVolumeType:
        return soap_in_ec2__DeleteVolumeType(soap, NULL, NULL, "ec2:DeleteVolumeType");
      case SOAP_TYPE_ec2__CreateVolumeResponseType:
        return soap_in_ec2__CreateVolumeResponseType(soap, NULL, NULL, "ec2:CreateVolumeResponseType");
      case SOAP_TYPE_ec2__CreateVolumeType:
        return soap_in_ec2__CreateVolumeType(soap, NULL, NULL, "ec2:CreateVolumeType");
      case SOAP_TYPE_ec2__DisassociateAddressResponseType:
        return soap_in_ec2__DisassociateAddressResponseType(soap, NULL, NULL, "ec2:DisassociateAddressResponseType");
      case SOAP_TYPE_ec2__DisassociateAddressType:
        return soap_in_ec2__DisassociateAddressType(soap, NULL, NULL, "ec2:DisassociateAddressType");
      case SOAP_TYPE_ec2__AssociateAddressResponseType:
        return soap_in_ec2__AssociateAddressResponseType(soap, NULL, NULL, "ec2:AssociateAddressResponseType");
      case SOAP_TYPE_ec2__AssociateAddressType:
        return soap_in_ec2__AssociateAddressType(soap, NULL, NULL, "ec2:AssociateAddressType");
      case SOAP_TYPE_ec2__DescribeAddressesResponseItemType:
        return soap_in_ec2__DescribeAddressesResponseItemType(soap, NULL, NULL, "ec2:DescribeAddressesResponseItemType");
      case SOAP_TYPE_ec2__DescribeAddressesResponseInfoType:
        return soap_in_ec2__DescribeAddressesResponseInfoType(soap, NULL, NULL, "ec2:DescribeAddressesResponseInfoType");
      case SOAP_TYPE_ec2__DescribeAddressesResponseType:
        return soap_in_ec2__DescribeAddressesResponseType(soap, NULL, NULL, "ec2:DescribeAddressesResponseType");
      case SOAP_TYPE_ec2__DescribeAddressesItemType:
        return soap_in_ec2__DescribeAddressesItemType(soap, NULL, NULL, "ec2:DescribeAddressesItemType");
      case SOAP_TYPE_ec2__DescribeAddressesInfoType:
        return soap_in_ec2__DescribeAddressesInfoType(soap, NULL, NULL, "ec2:DescribeAddressesInfoType");
      case SOAP_TYPE_ec2__DescribeAddressesType:
        return soap_in_ec2__DescribeAddressesType(soap, NULL, NULL, "ec2:DescribeAddressesType");
      case SOAP_TYPE_ec2__ReleaseAddressResponseType:
        return soap_in_ec2__ReleaseAddressResponseType(soap, NULL, NULL, "ec2:ReleaseAddressResponseType");
      case SOAP_TYPE_ec2__ReleaseAddressType:
        return soap_in_ec2__ReleaseAddressType(soap, NULL, NULL, "ec2:ReleaseAddressType");
      case SOAP_TYPE_ec2__AllocateAddressResponseType:
        return soap_in_ec2__AllocateAddressResponseType(soap, NULL, NULL, "ec2:AllocateAddressResponseType");
      case SOAP_TYPE_ec2__AllocateAddressType:
        return soap_in_ec2__AllocateAddressType(soap, NULL, NULL, "ec2:AllocateAddressType");
      case SOAP_TYPE_ec2__AvailabilityZoneItemType:
        return soap_in_ec2__AvailabilityZoneItemType(soap, NULL, NULL, "ec2:AvailabilityZoneItemType");
      case SOAP_TYPE_ec2__AvailabilityZoneSetType:
        return soap_in_ec2__AvailabilityZoneSetType(soap, NULL, NULL, "ec2:AvailabilityZoneSetType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType:
        return soap_in_ec2__DescribeAvailabilityZonesResponseType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesResponseType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType:
        return soap_in_ec2__DescribeAvailabilityZonesSetItemType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesSetItemType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType:
        return soap_in_ec2__DescribeAvailabilityZonesSetType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesSetType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesType:
        return soap_in_ec2__DescribeAvailabilityZonesType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesType");
      case SOAP_TYPE_ec2__ConfirmProductInstanceResponseType:
        return soap_in_ec2__ConfirmProductInstanceResponseType(soap, NULL, NULL, "ec2:ConfirmProductInstanceResponseType");
      case SOAP_TYPE_ec2__ProductCodesSetItemType:
        return soap_in_ec2__ProductCodesSetItemType(soap, NULL, NULL, "ec2:ProductCodesSetItemType");
      case SOAP_TYPE_ec2__ConfirmProductInstanceType:
        return soap_in_ec2__ConfirmProductInstanceType(soap, NULL, NULL, "ec2:ConfirmProductInstanceType");
      case SOAP_TYPE_ec2__AttributeValueType:
        return soap_in_ec2__AttributeValueType(soap, NULL, NULL, "ec2:AttributeValueType");
      case SOAP_TYPE_ec2__NullableAttributeValueType:
        return soap_in_ec2__NullableAttributeValueType(soap, NULL, NULL, "ec2:NullableAttributeValueType");
      case SOAP_TYPE_ec2__DescribeImageAttributeResponseType:
        return soap_in_ec2__DescribeImageAttributeResponseType(soap, NULL, NULL, "ec2:DescribeImageAttributeResponseType");
      case SOAP_TYPE_ec2__DescribeImageAttributeType:
        return soap_in_ec2__DescribeImageAttributeType(soap, NULL, NULL, "ec2:DescribeImageAttributeType");
      case SOAP_TYPE_ec2__ResetImageAttributeResponseType:
        return soap_in_ec2__ResetImageAttributeResponseType(soap, NULL, NULL, "ec2:ResetImageAttributeResponseType");
      case SOAP_TYPE_ec2__EmptyElementType:
        return soap_in_ec2__EmptyElementType(soap, NULL, NULL, "ec2:EmptyElementType");
      case SOAP_TYPE_ec2__ResetImageAttributeType:
        return soap_in_ec2__ResetImageAttributeType(soap, NULL, NULL, "ec2:ResetImageAttributeType");
      case SOAP_TYPE_ec2__ModifyImageAttributeResponseType:
        return soap_in_ec2__ModifyImageAttributeResponseType(soap, NULL, NULL, "ec2:ModifyImageAttributeResponseType");
      case SOAP_TYPE_ec2__ProductCodeItemType:
        return soap_in_ec2__ProductCodeItemType(soap, NULL, NULL, "ec2:ProductCodeItemType");
      case SOAP_TYPE_ec2__LaunchPermissionItemType:
        return soap_in_ec2__LaunchPermissionItemType(soap, NULL, NULL, "ec2:LaunchPermissionItemType");
      case SOAP_TYPE_ec2__LaunchPermissionListType:
        return soap_in_ec2__LaunchPermissionListType(soap, NULL, NULL, "ec2:LaunchPermissionListType");
      case SOAP_TYPE_ec2__ProductCodeListType:
        return soap_in_ec2__ProductCodeListType(soap, NULL, NULL, "ec2:ProductCodeListType");
      case SOAP_TYPE_ec2__LaunchPermissionOperationType:
        return soap_in_ec2__LaunchPermissionOperationType(soap, NULL, NULL, "ec2:LaunchPermissionOperationType");
      case SOAP_TYPE_ec2__ModifyImageAttributeType:
        return soap_in_ec2__ModifyImageAttributeType(soap, NULL, NULL, "ec2:ModifyImageAttributeType");
      case SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType:
        return soap_in_ec2__RevokeSecurityGroupIngressResponseType(soap, NULL, NULL, "ec2:RevokeSecurityGroupIngressResponseType");
      case SOAP_TYPE_ec2__RevokeSecurityGroupIngressType:
        return soap_in_ec2__RevokeSecurityGroupIngressType(soap, NULL, NULL, "ec2:RevokeSecurityGroupIngressType");
      case SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType:
        return soap_in_ec2__AuthorizeSecurityGroupIngressResponseType(soap, NULL, NULL, "ec2:AuthorizeSecurityGroupIngressResponseType");
      case SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType:
        return soap_in_ec2__AuthorizeSecurityGroupIngressType(soap, NULL, NULL, "ec2:AuthorizeSecurityGroupIngressType");
      case SOAP_TYPE_ec2__SecurityGroupItemType:
        return soap_in_ec2__SecurityGroupItemType(soap, NULL, NULL, "ec2:SecurityGroupItemType");
      case SOAP_TYPE_ec2__UserIdGroupPairType:
        return soap_in_ec2__UserIdGroupPairType(soap, NULL, NULL, "ec2:UserIdGroupPairType");
      case SOAP_TYPE_ec2__IpRangeItemType:
        return soap_in_ec2__IpRangeItemType(soap, NULL, NULL, "ec2:IpRangeItemType");
      case SOAP_TYPE_ec2__IpRangeSetType:
        return soap_in_ec2__IpRangeSetType(soap, NULL, NULL, "ec2:IpRangeSetType");
      case SOAP_TYPE_ec2__UserIdGroupPairSetType:
        return soap_in_ec2__UserIdGroupPairSetType(soap, NULL, NULL, "ec2:UserIdGroupPairSetType");
      case SOAP_TYPE_ec2__IpPermissionType:
        return soap_in_ec2__IpPermissionType(soap, NULL, NULL, "ec2:IpPermissionType");
      case SOAP_TYPE_ec2__IpPermissionSetType:
        return soap_in_ec2__IpPermissionSetType(soap, NULL, NULL, "ec2:IpPermissionSetType");
      case SOAP_TYPE_ec2__SecurityGroupSetType:
        return soap_in_ec2__SecurityGroupSetType(soap, NULL, NULL, "ec2:SecurityGroupSetType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType:
        return soap_in_ec2__DescribeSecurityGroupsResponseType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsResponseType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType:
        return soap_in_ec2__DescribeSecurityGroupsSetItemType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsSetItemType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsSetType:
        return soap_in_ec2__DescribeSecurityGroupsSetType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsSetType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsType:
        return soap_in_ec2__DescribeSecurityGroupsType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsType");
      case SOAP_TYPE_ec2__DeleteSecurityGroupResponseType:
        return soap_in_ec2__DeleteSecurityGroupResponseType(soap, NULL, NULL, "ec2:DeleteSecurityGroupResponseType");
      case SOAP_TYPE_ec2__DeleteSecurityGroupType:
        return soap_in_ec2__DeleteSecurityGroupType(soap, NULL, NULL, "ec2:DeleteSecurityGroupType");
      case SOAP_TYPE_ec2__CreateSecurityGroupResponseType:
        return soap_in_ec2__CreateSecurityGroupResponseType(soap, NULL, NULL, "ec2:CreateSecurityGroupResponseType");
      case SOAP_TYPE_ec2__CreateSecurityGroupType:
        return soap_in_ec2__CreateSecurityGroupType(soap, NULL, NULL, "ec2:CreateSecurityGroupType");
      case SOAP_TYPE_ec2__DescribeImagesResponseItemType:
        return soap_in_ec2__DescribeImagesResponseItemType(soap, NULL, NULL, "ec2:DescribeImagesResponseItemType");
      case SOAP_TYPE_ec2__DescribeImagesResponseInfoType:
        return soap_in_ec2__DescribeImagesResponseInfoType(soap, NULL, NULL, "ec2:DescribeImagesResponseInfoType");
      case SOAP_TYPE_ec2__DescribeImagesResponseType:
        return soap_in_ec2__DescribeImagesResponseType(soap, NULL, NULL, "ec2:DescribeImagesResponseType");
      case SOAP_TYPE_ec2__DescribeImagesExecutableByType:
        return soap_in_ec2__DescribeImagesExecutableByType(soap, NULL, NULL, "ec2:DescribeImagesExecutableByType");
      case SOAP_TYPE_ec2__DescribeImagesOwnerType:
        return soap_in_ec2__DescribeImagesOwnerType(soap, NULL, NULL, "ec2:DescribeImagesOwnerType");
      case SOAP_TYPE_ec2__DescribeImagesItemType:
        return soap_in_ec2__DescribeImagesItemType(soap, NULL, NULL, "ec2:DescribeImagesItemType");
      case SOAP_TYPE_ec2__DescribeImagesOwnersType:
        return soap_in_ec2__DescribeImagesOwnersType(soap, NULL, NULL, "ec2:DescribeImagesOwnersType");
      case SOAP_TYPE_ec2__DescribeImagesInfoType:
        return soap_in_ec2__DescribeImagesInfoType(soap, NULL, NULL, "ec2:DescribeImagesInfoType");
      case SOAP_TYPE_ec2__DescribeImagesExecutableBySetType:
        return soap_in_ec2__DescribeImagesExecutableBySetType(soap, NULL, NULL, "ec2:DescribeImagesExecutableBySetType");
      case SOAP_TYPE_ec2__DescribeImagesType:
        return soap_in_ec2__DescribeImagesType(soap, NULL, NULL, "ec2:DescribeImagesType");
      case SOAP_TYPE_ec2__ReservationSetType:
        return soap_in_ec2__ReservationSetType(soap, NULL, NULL, "ec2:ReservationSetType");
      case SOAP_TYPE_ec2__DescribeInstancesResponseType:
        return soap_in_ec2__DescribeInstancesResponseType(soap, NULL, NULL, "ec2:DescribeInstancesResponseType");
      case SOAP_TYPE_ec2__DescribeInstancesItemType:
        return soap_in_ec2__DescribeInstancesItemType(soap, NULL, NULL, "ec2:DescribeInstancesItemType");
      case SOAP_TYPE_ec2__DescribeInstancesInfoType:
        return soap_in_ec2__DescribeInstancesInfoType(soap, NULL, NULL, "ec2:DescribeInstancesInfoType");
      case SOAP_TYPE_ec2__DescribeInstancesType:
        return soap_in_ec2__DescribeInstancesType(soap, NULL, NULL, "ec2:DescribeInstancesType");
      case SOAP_TYPE_ec2__RebootInstancesResponseType:
        return soap_in_ec2__RebootInstancesResponseType(soap, NULL, NULL, "ec2:RebootInstancesResponseType");
      case SOAP_TYPE_ec2__RebootInstancesItemType:
        return soap_in_ec2__RebootInstancesItemType(soap, NULL, NULL, "ec2:RebootInstancesItemType");
      case SOAP_TYPE_ec2__RebootInstancesInfoType:
        return soap_in_ec2__RebootInstancesInfoType(soap, NULL, NULL, "ec2:RebootInstancesInfoType");
      case SOAP_TYPE_ec2__RebootInstancesType:
        return soap_in_ec2__RebootInstancesType(soap, NULL, NULL, "ec2:RebootInstancesType");
      case SOAP_TYPE_ec2__TerminateInstancesResponseItemType:
        return soap_in_ec2__TerminateInstancesResponseItemType(soap, NULL, NULL, "ec2:TerminateInstancesResponseItemType");
      case SOAP_TYPE_ec2__TerminateInstancesResponseInfoType:
        return soap_in_ec2__TerminateInstancesResponseInfoType(soap, NULL, NULL, "ec2:TerminateInstancesResponseInfoType");
      case SOAP_TYPE_ec2__TerminateInstancesResponseType:
        return soap_in_ec2__TerminateInstancesResponseType(soap, NULL, NULL, "ec2:TerminateInstancesResponseType");
      case SOAP_TYPE_ec2__TerminateInstancesItemType:
        return soap_in_ec2__TerminateInstancesItemType(soap, NULL, NULL, "ec2:TerminateInstancesItemType");
      case SOAP_TYPE_ec2__TerminateInstancesInfoType:
        return soap_in_ec2__TerminateInstancesInfoType(soap, NULL, NULL, "ec2:TerminateInstancesInfoType");
      case SOAP_TYPE_ec2__TerminateInstancesType:
        return soap_in_ec2__TerminateInstancesType(soap, NULL, NULL, "ec2:TerminateInstancesType");
      case SOAP_TYPE_ec2__GetConsoleOutputResponseType:
        return soap_in_ec2__GetConsoleOutputResponseType(soap, NULL, NULL, "ec2:GetConsoleOutputResponseType");
      case SOAP_TYPE_ec2__GetConsoleOutputType:
        return soap_in_ec2__GetConsoleOutputType(soap, NULL, NULL, "ec2:GetConsoleOutputType");
      case SOAP_TYPE_ec2__PlacementResponseType:
        return soap_in_ec2__PlacementResponseType(soap, NULL, NULL, "ec2:PlacementResponseType");
      case SOAP_TYPE_ec2__ProductCodesSetType:
        return soap_in_ec2__ProductCodesSetType(soap, NULL, NULL, "ec2:ProductCodesSetType");
      case SOAP_TYPE_ec2__InstanceStateType:
        return soap_in_ec2__InstanceStateType(soap, NULL, NULL, "ec2:InstanceStateType");
      case SOAP_TYPE_ec2__RunningInstancesItemType:
        return soap_in_ec2__RunningInstancesItemType(soap, NULL, NULL, "ec2:RunningInstancesItemType");
      case SOAP_TYPE_ec2__ReservationInfoType:
        return soap_in_ec2__ReservationInfoType(soap, NULL, NULL, "ec2:ReservationInfoType");
      case SOAP_TYPE_ec2__RunningInstancesSetType:
        return soap_in_ec2__RunningInstancesSetType(soap, NULL, NULL, "ec2:RunningInstancesSetType");
      case SOAP_TYPE_ec2__RunInstancesResponseType:
        return soap_in_ec2__RunInstancesResponseType(soap, NULL, NULL, "ec2:RunInstancesResponseType");
      case SOAP_TYPE_ec2__BlockDeviceMappingItemType:
        return soap_in_ec2__BlockDeviceMappingItemType(soap, NULL, NULL, "ec2:BlockDeviceMappingItemType");
      case SOAP_TYPE_ec2__GroupItemType:
        return soap_in_ec2__GroupItemType(soap, NULL, NULL, "ec2:GroupItemType");
      case SOAP_TYPE_ec2__BlockDeviceMappingType:
        return soap_in_ec2__BlockDeviceMappingType(soap, NULL, NULL, "ec2:BlockDeviceMappingType");
      case SOAP_TYPE_ec2__PlacementRequestType:
        return soap_in_ec2__PlacementRequestType(soap, NULL, NULL, "ec2:PlacementRequestType");
      case SOAP_TYPE_ec2__UserDataType:
        return soap_in_ec2__UserDataType(soap, NULL, NULL, "ec2:UserDataType");
      case SOAP_TYPE_ec2__GroupSetType:
        return soap_in_ec2__GroupSetType(soap, NULL, NULL, "ec2:GroupSetType");
      case SOAP_TYPE_ec2__RunInstancesType:
        return soap_in_ec2__RunInstancesType(soap, NULL, NULL, "ec2:RunInstancesType");
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseItemType:
        return soap_in_ec2__DescribeKeyPairsResponseItemType(soap, NULL, NULL, "ec2:DescribeKeyPairsResponseItemType");
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseInfoType:
        return soap_in_ec2__DescribeKeyPairsResponseInfoType(soap, NULL, NULL, "ec2:DescribeKeyPairsResponseInfoType");
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseType:
        return soap_in_ec2__DescribeKeyPairsResponseType(soap, NULL, NULL, "ec2:DescribeKeyPairsResponseType");
      case SOAP_TYPE_ec2__DescribeKeyPairsItemType:
        return soap_in_ec2__DescribeKeyPairsItemType(soap, NULL, NULL, "ec2:DescribeKeyPairsItemType");
      case SOAP_TYPE_ec2__DescribeKeyPairsInfoType:
        return soap_in_ec2__DescribeKeyPairsInfoType(soap, NULL, NULL, "ec2:DescribeKeyPairsInfoType");
      case SOAP_TYPE_ec2__DescribeKeyPairsType:
        return soap_in_ec2__DescribeKeyPairsType(soap, NULL, NULL, "ec2:DescribeKeyPairsType");
      case SOAP_TYPE_ec2__DeleteKeyPairResponseType:
        return soap_in_ec2__DeleteKeyPairResponseType(soap, NULL, NULL, "ec2:DeleteKeyPairResponseType");
      case SOAP_TYPE_ec2__DeleteKeyPairType:
        return soap_in_ec2__DeleteKeyPairType(soap, NULL, NULL, "ec2:DeleteKeyPairType");
      case SOAP_TYPE_ec2__CreateKeyPairResponseType:
        return soap_in_ec2__CreateKeyPairResponseType(soap, NULL, NULL, "ec2:CreateKeyPairResponseType");
      case SOAP_TYPE_ec2__CreateKeyPairType:
        return soap_in_ec2__CreateKeyPairType(soap, NULL, NULL, "ec2:CreateKeyPairType");
      case SOAP_TYPE_ec2__DeregisterImageResponseType:
        return soap_in_ec2__DeregisterImageResponseType(soap, NULL, NULL, "ec2:DeregisterImageResponseType");
      case SOAP_TYPE_ec2__DeregisterImageType:
        return soap_in_ec2__DeregisterImageType(soap, NULL, NULL, "ec2:DeregisterImageType");
      case SOAP_TYPE_ec2__RegisterImageResponseType:
        return soap_in_ec2__RegisterImageResponseType(soap, NULL, NULL, "ec2:RegisterImageResponseType");
      case SOAP_TYPE_ec2__RegisterImageType:
        return soap_in_ec2__RegisterImageType(soap, NULL, NULL, "ec2:RegisterImageType");
      case SOAP_TYPE_ds__RSAKeyValueType:
        return soap_in_ds__RSAKeyValueType(soap, NULL, NULL, "ds:RSAKeyValueType");
      case SOAP_TYPE_ds__DSAKeyValueType:
        return soap_in_ds__DSAKeyValueType(soap, NULL, NULL, "ds:DSAKeyValueType");
      case SOAP_TYPE_ds__X509IssuerSerialType:
        return soap_in_ds__X509IssuerSerialType(soap, NULL, NULL, "ds:X509IssuerSerialType");
      case SOAP_TYPE_ds__X509DataType:
        return soap_in_ds__X509DataType(soap, NULL, NULL, "ds:X509DataType");
      case SOAP_TYPE_ds__RetrievalMethodType:
        return soap_in_ds__RetrievalMethodType(soap, NULL, NULL, "ds:RetrievalMethodType");
      case SOAP_TYPE_ds__KeyValueType:
        return soap_in_ds__KeyValueType(soap, NULL, NULL, "ds:KeyValueType");
      case SOAP_TYPE_ds__DigestMethodType:
        return soap_in_ds__DigestMethodType(soap, NULL, NULL, "ds:DigestMethodType");
      case SOAP_TYPE_ds__TransformType:
        return soap_in_ds__TransformType(soap, NULL, NULL, "ds:TransformType");
      case SOAP_TYPE_ds__TransformsType:
        return soap_in_ds__TransformsType(soap, NULL, NULL, "ds:TransformsType");
      case SOAP_TYPE_ds__ReferenceType:
        return soap_in_ds__ReferenceType(soap, NULL, NULL, "ds:ReferenceType");
      case SOAP_TYPE_ds__SignatureMethodType:
        return soap_in_ds__SignatureMethodType(soap, NULL, NULL, "ds:SignatureMethodType");
      case SOAP_TYPE_ds__CanonicalizationMethodType:
        return soap_in_ds__CanonicalizationMethodType(soap, NULL, NULL, "ds:CanonicalizationMethodType");
      case SOAP_TYPE_ds__KeyInfoType:
        return soap_in_ds__KeyInfoType(soap, NULL, NULL, "ds:KeyInfoType");
      case SOAP_TYPE_ds__SignedInfoType:
        return soap_in_ds__SignedInfoType(soap, NULL, NULL, "ds:SignedInfoType");
      case SOAP_TYPE_ds__SignatureType:
        return soap_in_ds__SignatureType(soap, NULL, NULL, "ds:SignatureType");
      case SOAP_TYPE_PointerToec2__DescribeRegionsResponseType:
        return soap_in_PointerToec2__DescribeRegionsResponseType(soap, NULL, NULL, "ec2:DescribeRegionsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeRegionsType:
        return soap_in_PointerToec2__DescribeRegionsType(soap, NULL, NULL, "ec2:DescribeRegionsType");
      case SOAP_TYPE_PointerToec2__CancelBundleTaskResponseType:
        return soap_in_PointerToec2__CancelBundleTaskResponseType(soap, NULL, NULL, "ec2:CancelBundleTaskResponseType");
      case SOAP_TYPE_PointerToec2__CancelBundleTaskType:
        return soap_in_PointerToec2__CancelBundleTaskType(soap, NULL, NULL, "ec2:CancelBundleTaskType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksResponseType:
        return soap_in_PointerToec2__DescribeBundleTasksResponseType(soap, NULL, NULL, "ec2:DescribeBundleTasksResponseType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksType:
        return soap_in_PointerToec2__DescribeBundleTasksType(soap, NULL, NULL, "ec2:DescribeBundleTasksType");
      case SOAP_TYPE_PointerToec2__BundleInstanceResponseType:
        return soap_in_PointerToec2__BundleInstanceResponseType(soap, NULL, NULL, "ec2:BundleInstanceResponseType");
      case SOAP_TYPE_PointerToec2__BundleInstanceType:
        return soap_in_PointerToec2__BundleInstanceType(soap, NULL, NULL, "ec2:BundleInstanceType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsResponseType:
        return soap_in_PointerToec2__DescribeSnapshotsResponseType(soap, NULL, NULL, "ec2:DescribeSnapshotsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsType:
        return soap_in_PointerToec2__DescribeSnapshotsType(soap, NULL, NULL, "ec2:DescribeSnapshotsType");
      case SOAP_TYPE_PointerToec2__DeleteSnapshotResponseType:
        return soap_in_PointerToec2__DeleteSnapshotResponseType(soap, NULL, NULL, "ec2:DeleteSnapshotResponseType");
      case SOAP_TYPE_PointerToec2__DeleteSnapshotType:
        return soap_in_PointerToec2__DeleteSnapshotType(soap, NULL, NULL, "ec2:DeleteSnapshotType");
      case SOAP_TYPE_PointerToec2__CreateSnapshotResponseType:
        return soap_in_PointerToec2__CreateSnapshotResponseType(soap, NULL, NULL, "ec2:CreateSnapshotResponseType");
      case SOAP_TYPE_PointerToec2__CreateSnapshotType:
        return soap_in_PointerToec2__CreateSnapshotType(soap, NULL, NULL, "ec2:CreateSnapshotType");
      case SOAP_TYPE_PointerToec2__DetachVolumeResponseType:
        return soap_in_PointerToec2__DetachVolumeResponseType(soap, NULL, NULL, "ec2:DetachVolumeResponseType");
      case SOAP_TYPE_PointerToec2__DetachVolumeType:
        return soap_in_PointerToec2__DetachVolumeType(soap, NULL, NULL, "ec2:DetachVolumeType");
      case SOAP_TYPE_PointerToec2__AttachVolumeResponseType:
        return soap_in_PointerToec2__AttachVolumeResponseType(soap, NULL, NULL, "ec2:AttachVolumeResponseType");
      case SOAP_TYPE_PointerToec2__AttachVolumeType:
        return soap_in_PointerToec2__AttachVolumeType(soap, NULL, NULL, "ec2:AttachVolumeType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesResponseType:
        return soap_in_PointerToec2__DescribeVolumesResponseType(soap, NULL, NULL, "ec2:DescribeVolumesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesType:
        return soap_in_PointerToec2__DescribeVolumesType(soap, NULL, NULL, "ec2:DescribeVolumesType");
      case SOAP_TYPE_PointerToec2__DeleteVolumeResponseType:
        return soap_in_PointerToec2__DeleteVolumeResponseType(soap, NULL, NULL, "ec2:DeleteVolumeResponseType");
      case SOAP_TYPE_PointerToec2__DeleteVolumeType:
        return soap_in_PointerToec2__DeleteVolumeType(soap, NULL, NULL, "ec2:DeleteVolumeType");
      case SOAP_TYPE_PointerToec2__CreateVolumeResponseType:
        return soap_in_PointerToec2__CreateVolumeResponseType(soap, NULL, NULL, "ec2:CreateVolumeResponseType");
      case SOAP_TYPE_PointerToec2__CreateVolumeType:
        return soap_in_PointerToec2__CreateVolumeType(soap, NULL, NULL, "ec2:CreateVolumeType");
      case SOAP_TYPE_PointerToec2__DisassociateAddressResponseType:
        return soap_in_PointerToec2__DisassociateAddressResponseType(soap, NULL, NULL, "ec2:DisassociateAddressResponseType");
      case SOAP_TYPE_PointerToec2__DisassociateAddressType:
        return soap_in_PointerToec2__DisassociateAddressType(soap, NULL, NULL, "ec2:DisassociateAddressType");
      case SOAP_TYPE_PointerToec2__AssociateAddressResponseType:
        return soap_in_PointerToec2__AssociateAddressResponseType(soap, NULL, NULL, "ec2:AssociateAddressResponseType");
      case SOAP_TYPE_PointerToec2__AssociateAddressType:
        return soap_in_PointerToec2__AssociateAddressType(soap, NULL, NULL, "ec2:AssociateAddressType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseType:
        return soap_in_PointerToec2__DescribeAddressesResponseType(soap, NULL, NULL, "ec2:DescribeAddressesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesType:
        return soap_in_PointerToec2__DescribeAddressesType(soap, NULL, NULL, "ec2:DescribeAddressesType");
      case SOAP_TYPE_PointerToec2__ReleaseAddressResponseType:
        return soap_in_PointerToec2__ReleaseAddressResponseType(soap, NULL, NULL, "ec2:ReleaseAddressResponseType");
      case SOAP_TYPE_PointerToec2__ReleaseAddressType:
        return soap_in_PointerToec2__ReleaseAddressType(soap, NULL, NULL, "ec2:ReleaseAddressType");
      case SOAP_TYPE_PointerToec2__AllocateAddressResponseType:
        return soap_in_PointerToec2__AllocateAddressResponseType(soap, NULL, NULL, "ec2:AllocateAddressResponseType");
      case SOAP_TYPE_PointerToec2__AllocateAddressType:
        return soap_in_PointerToec2__AllocateAddressType(soap, NULL, NULL, "ec2:AllocateAddressType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesResponseType:
        return soap_in_PointerToec2__DescribeAvailabilityZonesResponseType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesType:
        return soap_in_PointerToec2__DescribeAvailabilityZonesType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesType");
      case SOAP_TYPE_PointerToec2__ConfirmProductInstanceResponseType:
        return soap_in_PointerToec2__ConfirmProductInstanceResponseType(soap, NULL, NULL, "ec2:ConfirmProductInstanceResponseType");
      case SOAP_TYPE_PointerToec2__ConfirmProductInstanceType:
        return soap_in_PointerToec2__ConfirmProductInstanceType(soap, NULL, NULL, "ec2:ConfirmProductInstanceType");
      case SOAP_TYPE_PointerToec2__DescribeImageAttributeResponseType:
        return soap_in_PointerToec2__DescribeImageAttributeResponseType(soap, NULL, NULL, "ec2:DescribeImageAttributeResponseType");
      case SOAP_TYPE_PointerToec2__DescribeImageAttributeType:
        return soap_in_PointerToec2__DescribeImageAttributeType(soap, NULL, NULL, "ec2:DescribeImageAttributeType");
      case SOAP_TYPE_PointerToec2__ResetImageAttributeResponseType:
        return soap_in_PointerToec2__ResetImageAttributeResponseType(soap, NULL, NULL, "ec2:ResetImageAttributeResponseType");
      case SOAP_TYPE_PointerToec2__ResetImageAttributeType:
        return soap_in_PointerToec2__ResetImageAttributeType(soap, NULL, NULL, "ec2:ResetImageAttributeType");
      case SOAP_TYPE_PointerToec2__ModifyImageAttributeResponseType:
        return soap_in_PointerToec2__ModifyImageAttributeResponseType(soap, NULL, NULL, "ec2:ModifyImageAttributeResponseType");
      case SOAP_TYPE_PointerToec2__ModifyImageAttributeType:
        return soap_in_PointerToec2__ModifyImageAttributeType(soap, NULL, NULL, "ec2:ModifyImageAttributeType");
      case SOAP_TYPE_PointerToec2__RevokeSecurityGroupIngressResponseType:
        return soap_in_PointerToec2__RevokeSecurityGroupIngressResponseType(soap, NULL, NULL, "ec2:RevokeSecurityGroupIngressResponseType");
      case SOAP_TYPE_PointerToec2__RevokeSecurityGroupIngressType:
        return soap_in_PointerToec2__RevokeSecurityGroupIngressType(soap, NULL, NULL, "ec2:RevokeSecurityGroupIngressType");
      case SOAP_TYPE_PointerToec2__AuthorizeSecurityGroupIngressResponseType:
        return soap_in_PointerToec2__AuthorizeSecurityGroupIngressResponseType(soap, NULL, NULL, "ec2:AuthorizeSecurityGroupIngressResponseType");
      case SOAP_TYPE_PointerToec2__AuthorizeSecurityGroupIngressType:
        return soap_in_PointerToec2__AuthorizeSecurityGroupIngressType(soap, NULL, NULL, "ec2:AuthorizeSecurityGroupIngressType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsResponseType:
        return soap_in_PointerToec2__DescribeSecurityGroupsResponseType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsType:
        return soap_in_PointerToec2__DescribeSecurityGroupsType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsType");
      case SOAP_TYPE_PointerToec2__DeleteSecurityGroupResponseType:
        return soap_in_PointerToec2__DeleteSecurityGroupResponseType(soap, NULL, NULL, "ec2:DeleteSecurityGroupResponseType");
      case SOAP_TYPE_PointerToec2__DeleteSecurityGroupType:
        return soap_in_PointerToec2__DeleteSecurityGroupType(soap, NULL, NULL, "ec2:DeleteSecurityGroupType");
      case SOAP_TYPE_PointerToec2__CreateSecurityGroupResponseType:
        return soap_in_PointerToec2__CreateSecurityGroupResponseType(soap, NULL, NULL, "ec2:CreateSecurityGroupResponseType");
      case SOAP_TYPE_PointerToec2__CreateSecurityGroupType:
        return soap_in_PointerToec2__CreateSecurityGroupType(soap, NULL, NULL, "ec2:CreateSecurityGroupType");
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseType:
        return soap_in_PointerToec2__DescribeImagesResponseType(soap, NULL, NULL, "ec2:DescribeImagesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeImagesType:
        return soap_in_PointerToec2__DescribeImagesType(soap, NULL, NULL, "ec2:DescribeImagesType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesResponseType:
        return soap_in_PointerToec2__DescribeInstancesResponseType(soap, NULL, NULL, "ec2:DescribeInstancesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesType:
        return soap_in_PointerToec2__DescribeInstancesType(soap, NULL, NULL, "ec2:DescribeInstancesType");
      case SOAP_TYPE_PointerToec2__RebootInstancesResponseType:
        return soap_in_PointerToec2__RebootInstancesResponseType(soap, NULL, NULL, "ec2:RebootInstancesResponseType");
      case SOAP_TYPE_PointerToec2__RebootInstancesType:
        return soap_in_PointerToec2__RebootInstancesType(soap, NULL, NULL, "ec2:RebootInstancesType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseType:
        return soap_in_PointerToec2__TerminateInstancesResponseType(soap, NULL, NULL, "ec2:TerminateInstancesResponseType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesType:
        return soap_in_PointerToec2__TerminateInstancesType(soap, NULL, NULL, "ec2:TerminateInstancesType");
      case SOAP_TYPE_PointerToec2__GetConsoleOutputResponseType:
        return soap_in_PointerToec2__GetConsoleOutputResponseType(soap, NULL, NULL, "ec2:GetConsoleOutputResponseType");
      case SOAP_TYPE_PointerToec2__GetConsoleOutputType:
        return soap_in_PointerToec2__GetConsoleOutputType(soap, NULL, NULL, "ec2:GetConsoleOutputType");
      case SOAP_TYPE_PointerToec2__RunInstancesResponseType:
        return soap_in_PointerToec2__RunInstancesResponseType(soap, NULL, NULL, "ec2:RunInstancesResponseType");
      case SOAP_TYPE_PointerToec2__RunInstancesType:
        return soap_in_PointerToec2__RunInstancesType(soap, NULL, NULL, "ec2:RunInstancesType");
      case SOAP_TYPE_PointerToec2__DeleteKeyPairResponseType:
        return soap_in_PointerToec2__DeleteKeyPairResponseType(soap, NULL, NULL, "ec2:DeleteKeyPairResponseType");
      case SOAP_TYPE_PointerToec2__DeleteKeyPairType:
        return soap_in_PointerToec2__DeleteKeyPairType(soap, NULL, NULL, "ec2:DeleteKeyPairType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseType:
        return soap_in_PointerToec2__DescribeKeyPairsResponseType(soap, NULL, NULL, "ec2:DescribeKeyPairsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsType:
        return soap_in_PointerToec2__DescribeKeyPairsType(soap, NULL, NULL, "ec2:DescribeKeyPairsType");
      case SOAP_TYPE_PointerToec2__CreateKeyPairResponseType:
        return soap_in_PointerToec2__CreateKeyPairResponseType(soap, NULL, NULL, "ec2:CreateKeyPairResponseType");
      case SOAP_TYPE_PointerToec2__CreateKeyPairType:
        return soap_in_PointerToec2__CreateKeyPairType(soap, NULL, NULL, "ec2:CreateKeyPairType");
      case SOAP_TYPE_PointerToec2__DeregisterImageResponseType:
        return soap_in_PointerToec2__DeregisterImageResponseType(soap, NULL, NULL, "ec2:DeregisterImageResponseType");
      case SOAP_TYPE_PointerToec2__DeregisterImageType:
        return soap_in_PointerToec2__DeregisterImageType(soap, NULL, NULL, "ec2:DeregisterImageType");
      case SOAP_TYPE_PointerToec2__RegisterImageResponseType:
        return soap_in_PointerToec2__RegisterImageResponseType(soap, NULL, NULL, "ec2:RegisterImageResponseType");
      case SOAP_TYPE_PointerToec2__RegisterImageType:
        return soap_in_PointerToec2__RegisterImageType(soap, NULL, NULL, "ec2:RegisterImageType");
      case SOAP_TYPE_PointerToec2__RegionItemType:
        return soap_in_PointerToec2__RegionItemType(soap, NULL, NULL, "ec2:RegionItemType");
      case SOAP_TYPE_PointerToec2__RegionSetType:
        return soap_in_PointerToec2__RegionSetType(soap, NULL, NULL, "ec2:RegionSetType");
      case SOAP_TYPE_PointerToec2__DescribeRegionsSetItemType:
        return soap_in_PointerToec2__DescribeRegionsSetItemType(soap, NULL, NULL, "ec2:DescribeRegionsSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeRegionsSetType:
        return soap_in_PointerToec2__DescribeRegionsSetType(soap, NULL, NULL, "ec2:DescribeRegionsSetType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTasksSetType:
        return soap_in_PointerToec2__BundleInstanceTasksSetType(soap, NULL, NULL, "ec2:BundleInstanceTasksSetType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksItemType:
        return soap_in_PointerToec2__DescribeBundleTasksItemType(soap, NULL, NULL, "ec2:DescribeBundleTasksItemType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksInfoType:
        return soap_in_PointerToec2__DescribeBundleTasksInfoType(soap, NULL, NULL, "ec2:DescribeBundleTasksInfoType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskErrorType:
        return soap_in_PointerToec2__BundleInstanceTaskErrorType(soap, NULL, NULL, "ec2:BundleInstanceTaskErrorType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskType:
        return soap_in_PointerToec2__BundleInstanceTaskType(soap, NULL, NULL, "ec2:BundleInstanceTaskType");
      case SOAP_TYPE_PointerToec2__BundleInstanceS3StorageType:
        return soap_in_PointerToec2__BundleInstanceS3StorageType(soap, NULL, NULL, "ec2:BundleInstanceS3StorageType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskStorageType:
        return soap_in_PointerToec2__BundleInstanceTaskStorageType(soap, NULL, NULL, "ec2:BundleInstanceTaskStorageType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetItemResponseType:
        return soap_in_PointerToec2__DescribeSnapshotsSetItemResponseType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetItemResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetResponseType:
        return soap_in_PointerToec2__DescribeSnapshotsSetResponseType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetItemType:
        return soap_in_PointerToec2__DescribeSnapshotsSetItemType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetType:
        return soap_in_PointerToec2__DescribeSnapshotsSetType(soap, NULL, NULL, "ec2:DescribeSnapshotsSetType");
      case SOAP_TYPE_PointerToxsd__boolean_:
        return soap_in_PointerToxsd__boolean_(soap, NULL, NULL, "xsd:boolean");
      case SOAP_TYPE_PointerToec2__AttachmentSetItemResponseType:
        return soap_in_PointerToec2__AttachmentSetItemResponseType(soap, NULL, NULL, "ec2:AttachmentSetItemResponseType");
      case SOAP_TYPE_PointerToec2__AttachmentSetResponseType:
        return soap_in_PointerToec2__AttachmentSetResponseType(soap, NULL, NULL, "ec2:AttachmentSetResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetItemResponseType:
        return soap_in_PointerToec2__DescribeVolumesSetItemResponseType(soap, NULL, NULL, "ec2:DescribeVolumesSetItemResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetResponseType:
        return soap_in_PointerToec2__DescribeVolumesSetResponseType(soap, NULL, NULL, "ec2:DescribeVolumesSetResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetItemType:
        return soap_in_PointerToec2__DescribeVolumesSetItemType(soap, NULL, NULL, "ec2:DescribeVolumesSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetType:
        return soap_in_PointerToec2__DescribeVolumesSetType(soap, NULL, NULL, "ec2:DescribeVolumesSetType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseItemType:
        return soap_in_PointerToec2__DescribeAddressesResponseItemType(soap, NULL, NULL, "ec2:DescribeAddressesResponseItemType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseInfoType:
        return soap_in_PointerToec2__DescribeAddressesResponseInfoType(soap, NULL, NULL, "ec2:DescribeAddressesResponseInfoType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesItemType:
        return soap_in_PointerToec2__DescribeAddressesItemType(soap, NULL, NULL, "ec2:DescribeAddressesItemType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesInfoType:
        return soap_in_PointerToec2__DescribeAddressesInfoType(soap, NULL, NULL, "ec2:DescribeAddressesInfoType");
      case SOAP_TYPE_PointerToec2__AvailabilityZoneItemType:
        return soap_in_PointerToec2__AvailabilityZoneItemType(soap, NULL, NULL, "ec2:AvailabilityZoneItemType");
      case SOAP_TYPE_PointerToec2__AvailabilityZoneSetType:
        return soap_in_PointerToec2__AvailabilityZoneSetType(soap, NULL, NULL, "ec2:AvailabilityZoneSetType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesSetItemType:
        return soap_in_PointerToec2__DescribeAvailabilityZonesSetItemType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesSetType:
        return soap_in_PointerToec2__DescribeAvailabilityZonesSetType(soap, NULL, NULL, "ec2:DescribeAvailabilityZonesSetType");
      case SOAP_TYPE_PointerToec2__ProductCodesSetItemType:
        return soap_in_PointerToec2__ProductCodesSetItemType(soap, NULL, NULL, "ec2:ProductCodesSetItemType");
      case SOAP_TYPE_PointerToec2__NullableAttributeValueType:
        return soap_in_PointerToec2__NullableAttributeValueType(soap, NULL, NULL, "ec2:NullableAttributeValueType");
      case SOAP_TYPE_PointerToec2__EmptyElementType:
        return soap_in_PointerToec2__EmptyElementType(soap, NULL, NULL, "ec2:EmptyElementType");
      case SOAP_TYPE_PointerToec2__ProductCodeItemType:
        return soap_in_PointerToec2__ProductCodeItemType(soap, NULL, NULL, "ec2:ProductCodeItemType");
      case SOAP_TYPE_PointerToec2__LaunchPermissionItemType:
        return soap_in_PointerToec2__LaunchPermissionItemType(soap, NULL, NULL, "ec2:LaunchPermissionItemType");
      case SOAP_TYPE_PointerToec2__LaunchPermissionListType:
        return soap_in_PointerToec2__LaunchPermissionListType(soap, NULL, NULL, "ec2:LaunchPermissionListType");
      case SOAP_TYPE_PointerToec2__ProductCodeListType:
        return soap_in_PointerToec2__ProductCodeListType(soap, NULL, NULL, "ec2:ProductCodeListType");
      case SOAP_TYPE_PointerToec2__LaunchPermissionOperationType:
        return soap_in_PointerToec2__LaunchPermissionOperationType(soap, NULL, NULL, "ec2:LaunchPermissionOperationType");
      case SOAP_TYPE_PointerToec2__IpPermissionSetType:
        return soap_in_PointerToec2__IpPermissionSetType(soap, NULL, NULL, "ec2:IpPermissionSetType");
      case SOAP_TYPE_PointerToec2__SecurityGroupItemType:
        return soap_in_PointerToec2__SecurityGroupItemType(soap, NULL, NULL, "ec2:SecurityGroupItemType");
      case SOAP_TYPE_PointerToec2__UserIdGroupPairType:
        return soap_in_PointerToec2__UserIdGroupPairType(soap, NULL, NULL, "ec2:UserIdGroupPairType");
      case SOAP_TYPE_PointerToec2__IpRangeItemType:
        return soap_in_PointerToec2__IpRangeItemType(soap, NULL, NULL, "ec2:IpRangeItemType");
      case SOAP_TYPE_PointerToec2__IpRangeSetType:
        return soap_in_PointerToec2__IpRangeSetType(soap, NULL, NULL, "ec2:IpRangeSetType");
      case SOAP_TYPE_PointerToec2__UserIdGroupPairSetType:
        return soap_in_PointerToec2__UserIdGroupPairSetType(soap, NULL, NULL, "ec2:UserIdGroupPairSetType");
      case SOAP_TYPE_PointerToec2__IpPermissionType:
        return soap_in_PointerToec2__IpPermissionType(soap, NULL, NULL, "ec2:IpPermissionType");
      case SOAP_TYPE_PointerToec2__SecurityGroupSetType:
        return soap_in_PointerToec2__SecurityGroupSetType(soap, NULL, NULL, "ec2:SecurityGroupSetType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsSetItemType:
        return soap_in_PointerToec2__DescribeSecurityGroupsSetItemType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsSetType:
        return soap_in_PointerToec2__DescribeSecurityGroupsSetType(soap, NULL, NULL, "ec2:DescribeSecurityGroupsSetType");
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseItemType:
        return soap_in_PointerToec2__DescribeImagesResponseItemType(soap, NULL, NULL, "ec2:DescribeImagesResponseItemType");
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseInfoType:
        return soap_in_PointerToec2__DescribeImagesResponseInfoType(soap, NULL, NULL, "ec2:DescribeImagesResponseInfoType");
      case SOAP_TYPE_PointerToec2__DescribeImagesExecutableByType:
        return soap_in_PointerToec2__DescribeImagesExecutableByType(soap, NULL, NULL, "ec2:DescribeImagesExecutableByType");
      case SOAP_TYPE_PointerToec2__DescribeImagesOwnerType:
        return soap_in_PointerToec2__DescribeImagesOwnerType(soap, NULL, NULL, "ec2:DescribeImagesOwnerType");
      case SOAP_TYPE_PointerToec2__DescribeImagesItemType:
        return soap_in_PointerToec2__DescribeImagesItemType(soap, NULL, NULL, "ec2:DescribeImagesItemType");
      case SOAP_TYPE_PointerToec2__DescribeImagesOwnersType:
        return soap_in_PointerToec2__DescribeImagesOwnersType(soap, NULL, NULL, "ec2:DescribeImagesOwnersType");
      case SOAP_TYPE_PointerToec2__DescribeImagesInfoType:
        return soap_in_PointerToec2__DescribeImagesInfoType(soap, NULL, NULL, "ec2:DescribeImagesInfoType");
      case SOAP_TYPE_PointerToec2__DescribeImagesExecutableBySetType:
        return soap_in_PointerToec2__DescribeImagesExecutableBySetType(soap, NULL, NULL, "ec2:DescribeImagesExecutableBySetType");
      case SOAP_TYPE_PointerToec2__ReservationInfoType:
        return soap_in_PointerToec2__ReservationInfoType(soap, NULL, NULL, "ec2:ReservationInfoType");
      case SOAP_TYPE_PointerToec2__ReservationSetType:
        return soap_in_PointerToec2__ReservationSetType(soap, NULL, NULL, "ec2:ReservationSetType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesItemType:
        return soap_in_PointerToec2__DescribeInstancesItemType(soap, NULL, NULL, "ec2:DescribeInstancesItemType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesInfoType:
        return soap_in_PointerToec2__DescribeInstancesInfoType(soap, NULL, NULL, "ec2:DescribeInstancesInfoType");
      case SOAP_TYPE_PointerToec2__RebootInstancesItemType:
        return soap_in_PointerToec2__RebootInstancesItemType(soap, NULL, NULL, "ec2:RebootInstancesItemType");
      case SOAP_TYPE_PointerToec2__RebootInstancesInfoType:
        return soap_in_PointerToec2__RebootInstancesInfoType(soap, NULL, NULL, "ec2:RebootInstancesInfoType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseItemType:
        return soap_in_PointerToec2__TerminateInstancesResponseItemType(soap, NULL, NULL, "ec2:TerminateInstancesResponseItemType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseInfoType:
        return soap_in_PointerToec2__TerminateInstancesResponseInfoType(soap, NULL, NULL, "ec2:TerminateInstancesResponseInfoType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesItemType:
        return soap_in_PointerToec2__TerminateInstancesItemType(soap, NULL, NULL, "ec2:TerminateInstancesItemType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesInfoType:
        return soap_in_PointerToec2__TerminateInstancesInfoType(soap, NULL, NULL, "ec2:TerminateInstancesInfoType");
      case SOAP_TYPE_PointerToec2__PlacementResponseType:
        return soap_in_PointerToec2__PlacementResponseType(soap, NULL, NULL, "ec2:PlacementResponseType");
      case SOAP_TYPE_PointerToec2__ProductCodesSetType:
        return soap_in_PointerToec2__ProductCodesSetType(soap, NULL, NULL, "ec2:ProductCodesSetType");
      case SOAP_TYPE_PointerToec2__InstanceStateType:
        return soap_in_PointerToec2__InstanceStateType(soap, NULL, NULL, "ec2:InstanceStateType");
      case SOAP_TYPE_PointerToec2__RunningInstancesItemType:
        return soap_in_PointerToec2__RunningInstancesItemType(soap, NULL, NULL, "ec2:RunningInstancesItemType");
      case SOAP_TYPE_PointerToec2__RunningInstancesSetType:
        return soap_in_PointerToec2__RunningInstancesSetType(soap, NULL, NULL, "ec2:RunningInstancesSetType");
      case SOAP_TYPE_PointerToec2__BlockDeviceMappingItemType:
        return soap_in_PointerToec2__BlockDeviceMappingItemType(soap, NULL, NULL, "ec2:BlockDeviceMappingItemType");
      case SOAP_TYPE_PointerToec2__GroupItemType:
        return soap_in_PointerToec2__GroupItemType(soap, NULL, NULL, "ec2:GroupItemType");
      case SOAP_TYPE_PointerToec2__BlockDeviceMappingType:
        return soap_in_PointerToec2__BlockDeviceMappingType(soap, NULL, NULL, "ec2:BlockDeviceMappingType");
      case SOAP_TYPE_PointerToec2__PlacementRequestType:
        return soap_in_PointerToec2__PlacementRequestType(soap, NULL, NULL, "ec2:PlacementRequestType");
      case SOAP_TYPE_PointerToec2__UserDataType:
        return soap_in_PointerToec2__UserDataType(soap, NULL, NULL, "ec2:UserDataType");
      case SOAP_TYPE_PointerToec2__GroupSetType:
        return soap_in_PointerToec2__GroupSetType(soap, NULL, NULL, "ec2:GroupSetType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseItemType:
        return soap_in_PointerToec2__DescribeKeyPairsResponseItemType(soap, NULL, NULL, "ec2:DescribeKeyPairsResponseItemType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseInfoType:
        return soap_in_PointerToec2__DescribeKeyPairsResponseInfoType(soap, NULL, NULL, "ec2:DescribeKeyPairsResponseInfoType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsItemType:
        return soap_in_PointerToec2__DescribeKeyPairsItemType(soap, NULL, NULL, "ec2:DescribeKeyPairsItemType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsInfoType:
        return soap_in_PointerToec2__DescribeKeyPairsInfoType(soap, NULL, NULL, "ec2:DescribeKeyPairsInfoType");
      case SOAP_TYPE_PointerTo_wsse__Security:
        return soap_in_PointerTo_wsse__Security(soap, NULL, NULL, "wsse:Security");
      case SOAP_TYPE_PointerTods__SignatureType:
        return soap_in_PointerTods__SignatureType(soap, NULL, NULL, "ds:SignatureType");
      case SOAP_TYPE_PointerTo_wsse__BinarySecurityToken:
        return soap_in_PointerTo_wsse__BinarySecurityToken(soap, NULL, NULL, "wsse:BinarySecurityToken");
      case SOAP_TYPE_PointerTo_wsse__UsernameToken:
        return soap_in_PointerTo_wsse__UsernameToken(soap, NULL, NULL, "wsse:UsernameToken");
      case SOAP_TYPE_PointerTo_wsu__Timestamp:
        return soap_in_PointerTo_wsu__Timestamp(soap, NULL, NULL, "wsu:Timestamp");
      case SOAP_TYPE_PointerTods__X509IssuerSerialType:
        return soap_in_PointerTods__X509IssuerSerialType(soap, NULL, NULL, "ds:X509IssuerSerialType");
      case SOAP_TYPE_PointerTods__RSAKeyValueType:
        return soap_in_PointerTods__RSAKeyValueType(soap, NULL, NULL, "ds:RSAKeyValueType");
      case SOAP_TYPE_PointerTods__DSAKeyValueType:
        return soap_in_PointerTods__DSAKeyValueType(soap, NULL, NULL, "ds:DSAKeyValueType");
      case SOAP_TYPE_PointerTods__TransformType:
        return soap_in_PointerTods__TransformType(soap, NULL, NULL, "ds:TransformType");
      case SOAP_TYPE_PointerTods__DigestMethodType:
        return soap_in_PointerTods__DigestMethodType(soap, NULL, NULL, "ds:DigestMethodType");
      case SOAP_TYPE_PointerTods__TransformsType:
        return soap_in_PointerTods__TransformsType(soap, NULL, NULL, "ds:TransformsType");
      case SOAP_TYPE_PointerToint:
        return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
      case SOAP_TYPE_PointerToPointerTods__ReferenceType:
        return soap_in_PointerToPointerTods__ReferenceType(soap, NULL, NULL, "ds:ReferenceType");
      case SOAP_TYPE_PointerTods__ReferenceType:
        return soap_in_PointerTods__ReferenceType(soap, NULL, NULL, "ds:ReferenceType");
      case SOAP_TYPE_PointerTods__SignatureMethodType:
        return soap_in_PointerTods__SignatureMethodType(soap, NULL, NULL, "ds:SignatureMethodType");
      case SOAP_TYPE_PointerTods__CanonicalizationMethodType:
        return soap_in_PointerTods__CanonicalizationMethodType(soap, NULL, NULL, "ds:CanonicalizationMethodType");
      case SOAP_TYPE_PointerTo_wsse__SecurityTokenReference:
        return soap_in_PointerTo_wsse__SecurityTokenReference(soap, NULL, NULL, "wsse:SecurityTokenReference");
      case SOAP_TYPE_PointerTods__X509DataType:
        return soap_in_PointerTods__X509DataType(soap, NULL, NULL, "ds:X509DataType");
      case SOAP_TYPE_PointerTods__RetrievalMethodType:
        return soap_in_PointerTods__RetrievalMethodType(soap, NULL, NULL, "ds:RetrievalMethodType");
      case SOAP_TYPE_PointerTods__KeyValueType:
        return soap_in_PointerTods__KeyValueType(soap, NULL, NULL, "ds:KeyValueType");
      case SOAP_TYPE_PointerTo_c14n__InclusiveNamespaces:
        return soap_in_PointerTo_c14n__InclusiveNamespaces(soap, NULL, NULL, "c14n:InclusiveNamespaces");
      case SOAP_TYPE_PointerTods__KeyInfoType:
        return soap_in_PointerTods__KeyInfoType(soap, NULL, NULL, "ds:KeyInfoType");
      case SOAP_TYPE_PointerTods__SignedInfoType:
        return soap_in_PointerTods__SignedInfoType(soap, NULL, NULL, "ds:SignedInfoType");
      case SOAP_TYPE_PointerTo_wsse__Embedded:
        return soap_in_PointerTo_wsse__Embedded(soap, NULL, NULL, "wsse:Embedded");
      case SOAP_TYPE_PointerTo_wsse__KeyIdentifier:
        return soap_in_PointerTo_wsse__KeyIdentifier(soap, NULL, NULL, "wsse:KeyIdentifier");
      case SOAP_TYPE_PointerTo_wsse__Reference:
        return soap_in_PointerTo_wsse__Reference(soap, NULL, NULL, "wsse:Reference");
      case SOAP_TYPE_PointerTo_wsse__Password:
        return soap_in_PointerTo_wsse__Password(soap, NULL, NULL, "wsse:Password");
      case SOAP_TYPE__QName:
        {       char **s;
          s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
          return s ? *s : NULL;
        }
      case SOAP_TYPE_string:
        {       char **s;
          s = soap_in_string(soap, NULL, NULL, "xsd:string");
          return s ? *s : NULL;
        }
      default:
        {       const char *t = soap->type;
          if (!*t)
            t = soap->tag;
          if (!soap_match_tag(soap, t, "xsd:byte"))
            {       *type = SOAP_TYPE_byte;
              return soap_in_byte(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "xsd:int"))
            {       *type = SOAP_TYPE_int;
              return soap_in_int(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "xsd:dateTime"))
            {       *type = SOAP_TYPE_time;
              return soap_in_time(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "xsd:boolean"))
            {       *type = SOAP_TYPE_xsd__boolean_;
              return soap_in_xsd__boolean_(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:FaultcodeEnum"))
            {       *type = SOAP_TYPE_wsse__FaultcodeEnum;
              return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsu:tTimestampFault"))
            {       *type = SOAP_TYPE_wsu__tTimestampFault;
              return soap_in_wsu__tTimestampFault(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RegionItemType"))
            {       *type = SOAP_TYPE_ec2__RegionItemType;
              return soap_in_ec2__RegionItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RegionSetType"))
            {       *type = SOAP_TYPE_ec2__RegionSetType;
              return soap_in_ec2__RegionSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeRegionsResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeRegionsResponseType;
              return soap_in_ec2__DescribeRegionsResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeRegionsSetItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeRegionsSetItemType;
              return soap_in_ec2__DescribeRegionsSetItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeRegionsSetType"))
            {       *type = SOAP_TYPE_ec2__DescribeRegionsSetType;
              return soap_in_ec2__DescribeRegionsSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeRegionsType"))
            {       *type = SOAP_TYPE_ec2__DescribeRegionsType;
              return soap_in_ec2__DescribeRegionsType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CancelBundleTaskResponseType"))
            {       *type = SOAP_TYPE_ec2__CancelBundleTaskResponseType;
              return soap_in_ec2__CancelBundleTaskResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CancelBundleTaskType"))
            {       *type = SOAP_TYPE_ec2__CancelBundleTaskType;
              return soap_in_ec2__CancelBundleTaskType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BundleInstanceTasksSetType"))
            {       *type = SOAP_TYPE_ec2__BundleInstanceTasksSetType;
              return soap_in_ec2__BundleInstanceTasksSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeBundleTasksResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeBundleTasksResponseType;
              return soap_in_ec2__DescribeBundleTasksResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeBundleTasksItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeBundleTasksItemType;
              return soap_in_ec2__DescribeBundleTasksItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeBundleTasksInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeBundleTasksInfoType;
              return soap_in_ec2__DescribeBundleTasksInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeBundleTasksType"))
            {       *type = SOAP_TYPE_ec2__DescribeBundleTasksType;
              return soap_in_ec2__DescribeBundleTasksType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BundleInstanceTaskErrorType"))
            {       *type = SOAP_TYPE_ec2__BundleInstanceTaskErrorType;
              return soap_in_ec2__BundleInstanceTaskErrorType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BundleInstanceTaskType"))
            {       *type = SOAP_TYPE_ec2__BundleInstanceTaskType;
              return soap_in_ec2__BundleInstanceTaskType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BundleInstanceResponseType"))
            {       *type = SOAP_TYPE_ec2__BundleInstanceResponseType;
              return soap_in_ec2__BundleInstanceResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BundleInstanceS3StorageType"))
            {       *type = SOAP_TYPE_ec2__BundleInstanceS3StorageType;
              return soap_in_ec2__BundleInstanceS3StorageType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BundleInstanceTaskStorageType"))
            {       *type = SOAP_TYPE_ec2__BundleInstanceTaskStorageType;
              return soap_in_ec2__BundleInstanceTaskStorageType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BundleInstanceType"))
            {       *type = SOAP_TYPE_ec2__BundleInstanceType;
              return soap_in_ec2__BundleInstanceType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSnapshotsSetItemResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType;
              return soap_in_ec2__DescribeSnapshotsSetItemResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSnapshotsSetResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType;
              return soap_in_ec2__DescribeSnapshotsSetResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSnapshotsResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeSnapshotsResponseType;
              return soap_in_ec2__DescribeSnapshotsResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSnapshotsSetItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeSnapshotsSetItemType;
              return soap_in_ec2__DescribeSnapshotsSetItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSnapshotsSetType"))
            {       *type = SOAP_TYPE_ec2__DescribeSnapshotsSetType;
              return soap_in_ec2__DescribeSnapshotsSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSnapshotsType"))
            {       *type = SOAP_TYPE_ec2__DescribeSnapshotsType;
              return soap_in_ec2__DescribeSnapshotsType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteSnapshotResponseType"))
            {       *type = SOAP_TYPE_ec2__DeleteSnapshotResponseType;
              return soap_in_ec2__DeleteSnapshotResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteSnapshotType"))
            {       *type = SOAP_TYPE_ec2__DeleteSnapshotType;
              return soap_in_ec2__DeleteSnapshotType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateSnapshotResponseType"))
            {       *type = SOAP_TYPE_ec2__CreateSnapshotResponseType;
              return soap_in_ec2__CreateSnapshotResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateSnapshotType"))
            {       *type = SOAP_TYPE_ec2__CreateSnapshotType;
              return soap_in_ec2__CreateSnapshotType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DetachVolumeResponseType"))
            {       *type = SOAP_TYPE_ec2__DetachVolumeResponseType;
              return soap_in_ec2__DetachVolumeResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DetachVolumeType"))
            {       *type = SOAP_TYPE_ec2__DetachVolumeType;
              return soap_in_ec2__DetachVolumeType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AttachVolumeResponseType"))
            {       *type = SOAP_TYPE_ec2__AttachVolumeResponseType;
              return soap_in_ec2__AttachVolumeResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AttachVolumeType"))
            {       *type = SOAP_TYPE_ec2__AttachVolumeType;
              return soap_in_ec2__AttachVolumeType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AttachmentSetItemResponseType"))
            {       *type = SOAP_TYPE_ec2__AttachmentSetItemResponseType;
              return soap_in_ec2__AttachmentSetItemResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AttachmentSetResponseType"))
            {       *type = SOAP_TYPE_ec2__AttachmentSetResponseType;
              return soap_in_ec2__AttachmentSetResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeVolumesSetItemResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType;
              return soap_in_ec2__DescribeVolumesSetItemResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeVolumesSetResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeVolumesSetResponseType;
              return soap_in_ec2__DescribeVolumesSetResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeVolumesResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeVolumesResponseType;
              return soap_in_ec2__DescribeVolumesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeVolumesSetItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeVolumesSetItemType;
              return soap_in_ec2__DescribeVolumesSetItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeVolumesSetType"))
            {       *type = SOAP_TYPE_ec2__DescribeVolumesSetType;
              return soap_in_ec2__DescribeVolumesSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeVolumesType"))
            {       *type = SOAP_TYPE_ec2__DescribeVolumesType;
              return soap_in_ec2__DescribeVolumesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteVolumeResponseType"))
            {       *type = SOAP_TYPE_ec2__DeleteVolumeResponseType;
              return soap_in_ec2__DeleteVolumeResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteVolumeType"))
            {       *type = SOAP_TYPE_ec2__DeleteVolumeType;
              return soap_in_ec2__DeleteVolumeType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateVolumeResponseType"))
            {       *type = SOAP_TYPE_ec2__CreateVolumeResponseType;
              return soap_in_ec2__CreateVolumeResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateVolumeType"))
            {       *type = SOAP_TYPE_ec2__CreateVolumeType;
              return soap_in_ec2__CreateVolumeType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DisassociateAddressResponseType"))
            {       *type = SOAP_TYPE_ec2__DisassociateAddressResponseType;
              return soap_in_ec2__DisassociateAddressResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DisassociateAddressType"))
            {       *type = SOAP_TYPE_ec2__DisassociateAddressType;
              return soap_in_ec2__DisassociateAddressType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AssociateAddressResponseType"))
            {       *type = SOAP_TYPE_ec2__AssociateAddressResponseType;
              return soap_in_ec2__AssociateAddressResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AssociateAddressType"))
            {       *type = SOAP_TYPE_ec2__AssociateAddressType;
              return soap_in_ec2__AssociateAddressType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAddressesResponseItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeAddressesResponseItemType;
              return soap_in_ec2__DescribeAddressesResponseItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAddressesResponseInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeAddressesResponseInfoType;
              return soap_in_ec2__DescribeAddressesResponseInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAddressesResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeAddressesResponseType;
              return soap_in_ec2__DescribeAddressesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAddressesItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeAddressesItemType;
              return soap_in_ec2__DescribeAddressesItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAddressesInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeAddressesInfoType;
              return soap_in_ec2__DescribeAddressesInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAddressesType"))
            {       *type = SOAP_TYPE_ec2__DescribeAddressesType;
              return soap_in_ec2__DescribeAddressesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ReleaseAddressResponseType"))
            {       *type = SOAP_TYPE_ec2__ReleaseAddressResponseType;
              return soap_in_ec2__ReleaseAddressResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ReleaseAddressType"))
            {       *type = SOAP_TYPE_ec2__ReleaseAddressType;
              return soap_in_ec2__ReleaseAddressType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AllocateAddressResponseType"))
            {       *type = SOAP_TYPE_ec2__AllocateAddressResponseType;
              return soap_in_ec2__AllocateAddressResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AllocateAddressType"))
            {       *type = SOAP_TYPE_ec2__AllocateAddressType;
              return soap_in_ec2__AllocateAddressType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AvailabilityZoneItemType"))
            {       *type = SOAP_TYPE_ec2__AvailabilityZoneItemType;
              return soap_in_ec2__AvailabilityZoneItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AvailabilityZoneSetType"))
            {       *type = SOAP_TYPE_ec2__AvailabilityZoneSetType;
              return soap_in_ec2__AvailabilityZoneSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAvailabilityZonesResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType;
              return soap_in_ec2__DescribeAvailabilityZonesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAvailabilityZonesSetItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType;
              return soap_in_ec2__DescribeAvailabilityZonesSetItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAvailabilityZonesSetType"))
            {       *type = SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType;
              return soap_in_ec2__DescribeAvailabilityZonesSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeAvailabilityZonesType"))
            {       *type = SOAP_TYPE_ec2__DescribeAvailabilityZonesType;
              return soap_in_ec2__DescribeAvailabilityZonesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ConfirmProductInstanceResponseType"))
            {       *type = SOAP_TYPE_ec2__ConfirmProductInstanceResponseType;
              return soap_in_ec2__ConfirmProductInstanceResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ProductCodesSetItemType"))
            {       *type = SOAP_TYPE_ec2__ProductCodesSetItemType;
              return soap_in_ec2__ProductCodesSetItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ConfirmProductInstanceType"))
            {       *type = SOAP_TYPE_ec2__ConfirmProductInstanceType;
              return soap_in_ec2__ConfirmProductInstanceType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AttributeValueType"))
            {       *type = SOAP_TYPE_ec2__AttributeValueType;
              return soap_in_ec2__AttributeValueType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:NullableAttributeValueType"))
            {       *type = SOAP_TYPE_ec2__NullableAttributeValueType;
              return soap_in_ec2__NullableAttributeValueType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImageAttributeResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeImageAttributeResponseType;
              return soap_in_ec2__DescribeImageAttributeResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImageAttributeType"))
            {       *type = SOAP_TYPE_ec2__DescribeImageAttributeType;
              return soap_in_ec2__DescribeImageAttributeType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ResetImageAttributeResponseType"))
            {       *type = SOAP_TYPE_ec2__ResetImageAttributeResponseType;
              return soap_in_ec2__ResetImageAttributeResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:EmptyElementType"))
            {       *type = SOAP_TYPE_ec2__EmptyElementType;
              return soap_in_ec2__EmptyElementType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ResetImageAttributeType"))
            {       *type = SOAP_TYPE_ec2__ResetImageAttributeType;
              return soap_in_ec2__ResetImageAttributeType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ModifyImageAttributeResponseType"))
            {       *type = SOAP_TYPE_ec2__ModifyImageAttributeResponseType;
              return soap_in_ec2__ModifyImageAttributeResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ProductCodeItemType"))
            {       *type = SOAP_TYPE_ec2__ProductCodeItemType;
              return soap_in_ec2__ProductCodeItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:LaunchPermissionItemType"))
            {       *type = SOAP_TYPE_ec2__LaunchPermissionItemType;
              return soap_in_ec2__LaunchPermissionItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:LaunchPermissionListType"))
            {       *type = SOAP_TYPE_ec2__LaunchPermissionListType;
              return soap_in_ec2__LaunchPermissionListType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ProductCodeListType"))
            {       *type = SOAP_TYPE_ec2__ProductCodeListType;
              return soap_in_ec2__ProductCodeListType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:LaunchPermissionOperationType"))
            {       *type = SOAP_TYPE_ec2__LaunchPermissionOperationType;
              return soap_in_ec2__LaunchPermissionOperationType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ModifyImageAttributeType"))
            {       *type = SOAP_TYPE_ec2__ModifyImageAttributeType;
              return soap_in_ec2__ModifyImageAttributeType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RevokeSecurityGroupIngressResponseType"))
            {       *type = SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType;
              return soap_in_ec2__RevokeSecurityGroupIngressResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RevokeSecurityGroupIngressType"))
            {       *type = SOAP_TYPE_ec2__RevokeSecurityGroupIngressType;
              return soap_in_ec2__RevokeSecurityGroupIngressType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AuthorizeSecurityGroupIngressResponseType"))
            {       *type = SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType;
              return soap_in_ec2__AuthorizeSecurityGroupIngressResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:AuthorizeSecurityGroupIngressType"))
            {       *type = SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType;
              return soap_in_ec2__AuthorizeSecurityGroupIngressType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:SecurityGroupItemType"))
            {       *type = SOAP_TYPE_ec2__SecurityGroupItemType;
              return soap_in_ec2__SecurityGroupItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:UserIdGroupPairType"))
            {       *type = SOAP_TYPE_ec2__UserIdGroupPairType;
              return soap_in_ec2__UserIdGroupPairType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:IpRangeItemType"))
            {       *type = SOAP_TYPE_ec2__IpRangeItemType;
              return soap_in_ec2__IpRangeItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:IpRangeSetType"))
            {       *type = SOAP_TYPE_ec2__IpRangeSetType;
              return soap_in_ec2__IpRangeSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:UserIdGroupPairSetType"))
            {       *type = SOAP_TYPE_ec2__UserIdGroupPairSetType;
              return soap_in_ec2__UserIdGroupPairSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:IpPermissionType"))
            {       *type = SOAP_TYPE_ec2__IpPermissionType;
              return soap_in_ec2__IpPermissionType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:IpPermissionSetType"))
            {       *type = SOAP_TYPE_ec2__IpPermissionSetType;
              return soap_in_ec2__IpPermissionSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:SecurityGroupSetType"))
            {       *type = SOAP_TYPE_ec2__SecurityGroupSetType;
              return soap_in_ec2__SecurityGroupSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSecurityGroupsResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType;
              return soap_in_ec2__DescribeSecurityGroupsResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSecurityGroupsSetItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType;
              return soap_in_ec2__DescribeSecurityGroupsSetItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSecurityGroupsSetType"))
            {       *type = SOAP_TYPE_ec2__DescribeSecurityGroupsSetType;
              return soap_in_ec2__DescribeSecurityGroupsSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeSecurityGroupsType"))
            {       *type = SOAP_TYPE_ec2__DescribeSecurityGroupsType;
              return soap_in_ec2__DescribeSecurityGroupsType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteSecurityGroupResponseType"))
            {       *type = SOAP_TYPE_ec2__DeleteSecurityGroupResponseType;
              return soap_in_ec2__DeleteSecurityGroupResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteSecurityGroupType"))
            {       *type = SOAP_TYPE_ec2__DeleteSecurityGroupType;
              return soap_in_ec2__DeleteSecurityGroupType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateSecurityGroupResponseType"))
            {       *type = SOAP_TYPE_ec2__CreateSecurityGroupResponseType;
              return soap_in_ec2__CreateSecurityGroupResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateSecurityGroupType"))
            {       *type = SOAP_TYPE_ec2__CreateSecurityGroupType;
              return soap_in_ec2__CreateSecurityGroupType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesResponseItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesResponseItemType;
              return soap_in_ec2__DescribeImagesResponseItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesResponseInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesResponseInfoType;
              return soap_in_ec2__DescribeImagesResponseInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesResponseType;
              return soap_in_ec2__DescribeImagesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesExecutableByType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesExecutableByType;
              return soap_in_ec2__DescribeImagesExecutableByType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesOwnerType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesOwnerType;
              return soap_in_ec2__DescribeImagesOwnerType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesItemType;
              return soap_in_ec2__DescribeImagesItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesOwnersType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesOwnersType;
              return soap_in_ec2__DescribeImagesOwnersType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesInfoType;
              return soap_in_ec2__DescribeImagesInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesExecutableBySetType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesExecutableBySetType;
              return soap_in_ec2__DescribeImagesExecutableBySetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeImagesType"))
            {       *type = SOAP_TYPE_ec2__DescribeImagesType;
              return soap_in_ec2__DescribeImagesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ReservationSetType"))
            {       *type = SOAP_TYPE_ec2__ReservationSetType;
              return soap_in_ec2__ReservationSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeInstancesResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeInstancesResponseType;
              return soap_in_ec2__DescribeInstancesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeInstancesItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeInstancesItemType;
              return soap_in_ec2__DescribeInstancesItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeInstancesInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeInstancesInfoType;
              return soap_in_ec2__DescribeInstancesInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeInstancesType"))
            {       *type = SOAP_TYPE_ec2__DescribeInstancesType;
              return soap_in_ec2__DescribeInstancesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RebootInstancesResponseType"))
            {       *type = SOAP_TYPE_ec2__RebootInstancesResponseType;
              return soap_in_ec2__RebootInstancesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RebootInstancesItemType"))
            {       *type = SOAP_TYPE_ec2__RebootInstancesItemType;
              return soap_in_ec2__RebootInstancesItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RebootInstancesInfoType"))
            {       *type = SOAP_TYPE_ec2__RebootInstancesInfoType;
              return soap_in_ec2__RebootInstancesInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RebootInstancesType"))
            {       *type = SOAP_TYPE_ec2__RebootInstancesType;
              return soap_in_ec2__RebootInstancesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:TerminateInstancesResponseItemType"))
            {       *type = SOAP_TYPE_ec2__TerminateInstancesResponseItemType;
              return soap_in_ec2__TerminateInstancesResponseItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:TerminateInstancesResponseInfoType"))
            {       *type = SOAP_TYPE_ec2__TerminateInstancesResponseInfoType;
              return soap_in_ec2__TerminateInstancesResponseInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:TerminateInstancesResponseType"))
            {       *type = SOAP_TYPE_ec2__TerminateInstancesResponseType;
              return soap_in_ec2__TerminateInstancesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:TerminateInstancesItemType"))
            {       *type = SOAP_TYPE_ec2__TerminateInstancesItemType;
              return soap_in_ec2__TerminateInstancesItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:TerminateInstancesInfoType"))
            {       *type = SOAP_TYPE_ec2__TerminateInstancesInfoType;
              return soap_in_ec2__TerminateInstancesInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:TerminateInstancesType"))
            {       *type = SOAP_TYPE_ec2__TerminateInstancesType;
              return soap_in_ec2__TerminateInstancesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:GetConsoleOutputResponseType"))
            {       *type = SOAP_TYPE_ec2__GetConsoleOutputResponseType;
              return soap_in_ec2__GetConsoleOutputResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:GetConsoleOutputType"))
            {       *type = SOAP_TYPE_ec2__GetConsoleOutputType;
              return soap_in_ec2__GetConsoleOutputType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:PlacementResponseType"))
            {       *type = SOAP_TYPE_ec2__PlacementResponseType;
              return soap_in_ec2__PlacementResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ProductCodesSetType"))
            {       *type = SOAP_TYPE_ec2__ProductCodesSetType;
              return soap_in_ec2__ProductCodesSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:InstanceStateType"))
            {       *type = SOAP_TYPE_ec2__InstanceStateType;
              return soap_in_ec2__InstanceStateType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RunningInstancesItemType"))
            {       *type = SOAP_TYPE_ec2__RunningInstancesItemType;
              return soap_in_ec2__RunningInstancesItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:ReservationInfoType"))
            {       *type = SOAP_TYPE_ec2__ReservationInfoType;
              return soap_in_ec2__ReservationInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RunningInstancesSetType"))
            {       *type = SOAP_TYPE_ec2__RunningInstancesSetType;
              return soap_in_ec2__RunningInstancesSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RunInstancesResponseType"))
            {       *type = SOAP_TYPE_ec2__RunInstancesResponseType;
              return soap_in_ec2__RunInstancesResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BlockDeviceMappingItemType"))
            {       *type = SOAP_TYPE_ec2__BlockDeviceMappingItemType;
              return soap_in_ec2__BlockDeviceMappingItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:GroupItemType"))
            {       *type = SOAP_TYPE_ec2__GroupItemType;
              return soap_in_ec2__GroupItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:BlockDeviceMappingType"))
            {       *type = SOAP_TYPE_ec2__BlockDeviceMappingType;
              return soap_in_ec2__BlockDeviceMappingType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:PlacementRequestType"))
            {       *type = SOAP_TYPE_ec2__PlacementRequestType;
              return soap_in_ec2__PlacementRequestType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:UserDataType"))
            {       *type = SOAP_TYPE_ec2__UserDataType;
              return soap_in_ec2__UserDataType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:GroupSetType"))
            {       *type = SOAP_TYPE_ec2__GroupSetType;
              return soap_in_ec2__GroupSetType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RunInstancesType"))
            {       *type = SOAP_TYPE_ec2__RunInstancesType;
              return soap_in_ec2__RunInstancesType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeKeyPairsResponseItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeKeyPairsResponseItemType;
              return soap_in_ec2__DescribeKeyPairsResponseItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeKeyPairsResponseInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeKeyPairsResponseInfoType;
              return soap_in_ec2__DescribeKeyPairsResponseInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeKeyPairsResponseType"))
            {       *type = SOAP_TYPE_ec2__DescribeKeyPairsResponseType;
              return soap_in_ec2__DescribeKeyPairsResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeKeyPairsItemType"))
            {       *type = SOAP_TYPE_ec2__DescribeKeyPairsItemType;
              return soap_in_ec2__DescribeKeyPairsItemType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeKeyPairsInfoType"))
            {       *type = SOAP_TYPE_ec2__DescribeKeyPairsInfoType;
              return soap_in_ec2__DescribeKeyPairsInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DescribeKeyPairsType"))
            {       *type = SOAP_TYPE_ec2__DescribeKeyPairsType;
              return soap_in_ec2__DescribeKeyPairsType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteKeyPairResponseType"))
            {       *type = SOAP_TYPE_ec2__DeleteKeyPairResponseType;
              return soap_in_ec2__DeleteKeyPairResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeleteKeyPairType"))
            {       *type = SOAP_TYPE_ec2__DeleteKeyPairType;
              return soap_in_ec2__DeleteKeyPairType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateKeyPairResponseType"))
            {       *type = SOAP_TYPE_ec2__CreateKeyPairResponseType;
              return soap_in_ec2__CreateKeyPairResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:CreateKeyPairType"))
            {       *type = SOAP_TYPE_ec2__CreateKeyPairType;
              return soap_in_ec2__CreateKeyPairType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeregisterImageResponseType"))
            {       *type = SOAP_TYPE_ec2__DeregisterImageResponseType;
              return soap_in_ec2__DeregisterImageResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:DeregisterImageType"))
            {       *type = SOAP_TYPE_ec2__DeregisterImageType;
              return soap_in_ec2__DeregisterImageType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RegisterImageResponseType"))
            {       *type = SOAP_TYPE_ec2__RegisterImageResponseType;
              return soap_in_ec2__RegisterImageResponseType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ec2:RegisterImageType"))
            {       *type = SOAP_TYPE_ec2__RegisterImageType;
              return soap_in_ec2__RegisterImageType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:RSAKeyValueType"))
            {       *type = SOAP_TYPE_ds__RSAKeyValueType;
              return soap_in_ds__RSAKeyValueType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:DSAKeyValueType"))
            {       *type = SOAP_TYPE_ds__DSAKeyValueType;
              return soap_in_ds__DSAKeyValueType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:X509IssuerSerialType"))
            {       *type = SOAP_TYPE_ds__X509IssuerSerialType;
              return soap_in_ds__X509IssuerSerialType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:X509DataType"))
            {       *type = SOAP_TYPE_ds__X509DataType;
              return soap_in_ds__X509DataType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:RetrievalMethodType"))
            {       *type = SOAP_TYPE_ds__RetrievalMethodType;
              return soap_in_ds__RetrievalMethodType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:KeyValueType"))
            {       *type = SOAP_TYPE_ds__KeyValueType;
              return soap_in_ds__KeyValueType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:DigestMethodType"))
            {       *type = SOAP_TYPE_ds__DigestMethodType;
              return soap_in_ds__DigestMethodType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:TransformType"))
            {       *type = SOAP_TYPE_ds__TransformType;
              return soap_in_ds__TransformType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:TransformsType"))
            {       *type = SOAP_TYPE_ds__TransformsType;
              return soap_in_ds__TransformsType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:ReferenceType"))
            {       *type = SOAP_TYPE_ds__ReferenceType;
              return soap_in_ds__ReferenceType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:SignatureMethodType"))
            {       *type = SOAP_TYPE_ds__SignatureMethodType;
              return soap_in_ds__SignatureMethodType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:CanonicalizationMethodType"))
            {       *type = SOAP_TYPE_ds__CanonicalizationMethodType;
              return soap_in_ds__CanonicalizationMethodType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:KeyInfoType"))
            {       *type = SOAP_TYPE_ds__KeyInfoType;
              return soap_in_ds__KeyInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:SignedInfoType"))
            {       *type = SOAP_TYPE_ds__SignedInfoType;
              return soap_in_ds__SignedInfoType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "ds:SignatureType"))
            {       *type = SOAP_TYPE_ds__SignatureType;
              return soap_in_ds__SignatureType(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "xsd:QName"))
            {       char **s;
              *type = SOAP_TYPE__QName;
              s = soap_in__QName(soap, NULL, NULL, NULL);
              return s ? *s : NULL;
            }
          if (!soap_match_tag(soap, t, "xsd:string"))
            {       char **s;
              *type = SOAP_TYPE_string;
              s = soap_in_string(soap, NULL, NULL, NULL);
              return s ? *s : NULL;
            }
          t = soap->tag;
          if (!soap_match_tag(soap, t, "wsse:Security"))
            {       *type = SOAP_TYPE__wsse__Security;
              return soap_in__wsse__Security(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "c14n:InclusiveNamespaces"))
            {       *type = SOAP_TYPE__c14n__InclusiveNamespaces;
              return soap_in__c14n__InclusiveNamespaces(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:SecurityTokenReference"))
            {       *type = SOAP_TYPE__wsse__SecurityTokenReference;
              return soap_in__wsse__SecurityTokenReference(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:KeyIdentifier"))
            {       *type = SOAP_TYPE__wsse__KeyIdentifier;
              return soap_in__wsse__KeyIdentifier(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:Embedded"))
            {       *type = SOAP_TYPE__wsse__Embedded;
              return soap_in__wsse__Embedded(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:Reference"))
            {       *type = SOAP_TYPE__wsse__Reference;
              return soap_in__wsse__Reference(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:BinarySecurityToken"))
            {       *type = SOAP_TYPE__wsse__BinarySecurityToken;
              return soap_in__wsse__BinarySecurityToken(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:Password"))
            {       *type = SOAP_TYPE__wsse__Password;
              return soap_in__wsse__Password(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsse:UsernameToken"))
            {       *type = SOAP_TYPE__wsse__UsernameToken;
              return soap_in__wsse__UsernameToken(soap, NULL, NULL, NULL);
            }
          if (!soap_match_tag(soap, t, "wsu:Timestamp"))
            {       *type = SOAP_TYPE__wsu__Timestamp;
              return soap_in__wsu__Timestamp(soap, NULL, NULL, NULL);
            }
        }
      }
    soap->error = SOAP_TAG_MISMATCH;
    return NULL;
  }
#endif

  SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
  {
    if (!soap_peek_element(soap))
      {       int t;
        DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
        if (soap->mustUnderstand && !soap->other)
          return soap->error = SOAP_MUSTUNDERSTAND;
        if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
          {       DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
            return soap->error = SOAP_TAG_MISMATCH;
          }
        if (!*soap->id || !soap_getelement(soap, &t))
          {       soap->peeked = 0;
            if (soap->fignore)
              soap->error = soap->fignore(soap, soap->tag);
            else
              soap->error = SOAP_OK;
            DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
            if (!soap->error && soap->body)
              {       soap->level++;
                while (!soap_ignore_element(soap))
                 ;
                if (soap->error == SOAP_NO_TAG)
                  soap->error = soap_element_end_in(soap, NULL);
              }
          }
      }
    return soap->error;
  }

#ifndef WITH_NOIDREF
  SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
  {
    int i;
    struct soap_plist *pp;
    if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
      for (i = 0; i < SOAP_PTRHASH; i++)
        for (pp = soap->pht[i]; pp; pp = pp->next)
          if (pp->mark1 == 2 || pp->mark2 == 2)
            if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
              return soap->error;
    return SOAP_OK;
  }
#endif

#ifndef WITH_NOIDREF
  SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
  {
    switch (type)
      {
      case SOAP_TYPE_byte:
        return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
      case SOAP_TYPE_int:
        return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
      case SOAP_TYPE_time:
        return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
      case SOAP_TYPE_xsd__boolean_:
        return soap_out_xsd__boolean_(soap, tag, id, (const enum xsd__boolean_ *)ptr, "xsd:boolean");
      case SOAP_TYPE_wsse__FaultcodeEnum:
        return soap_out_wsse__FaultcodeEnum(soap, tag, id, (const enum wsse__FaultcodeEnum *)ptr, "wsse:FaultcodeEnum");
      case SOAP_TYPE_wsu__tTimestampFault:
        return soap_out_wsu__tTimestampFault(soap, tag, id, (const enum wsu__tTimestampFault *)ptr, "wsu:tTimestampFault");
      case SOAP_TYPE_ec2__RegionItemType:
        return soap_out_ec2__RegionItemType(soap, tag, id, (const struct ec2__RegionItemType *)ptr, "ec2:RegionItemType");
      case SOAP_TYPE_ec2__RegionSetType:
        return soap_out_ec2__RegionSetType(soap, tag, id, (const struct ec2__RegionSetType *)ptr, "ec2:RegionSetType");
      case SOAP_TYPE_ec2__DescribeRegionsResponseType:
        return soap_out_ec2__DescribeRegionsResponseType(soap, tag, id, (const struct ec2__DescribeRegionsResponseType *)ptr, "ec2:DescribeRegionsResponseType");
      case SOAP_TYPE_ec2__DescribeRegionsSetItemType:
        return soap_out_ec2__DescribeRegionsSetItemType(soap, tag, id, (const struct ec2__DescribeRegionsSetItemType *)ptr, "ec2:DescribeRegionsSetItemType");
      case SOAP_TYPE_ec2__DescribeRegionsSetType:
        return soap_out_ec2__DescribeRegionsSetType(soap, tag, id, (const struct ec2__DescribeRegionsSetType *)ptr, "ec2:DescribeRegionsSetType");
      case SOAP_TYPE_ec2__DescribeRegionsType:
        return soap_out_ec2__DescribeRegionsType(soap, tag, id, (const struct ec2__DescribeRegionsType *)ptr, "ec2:DescribeRegionsType");
      case SOAP_TYPE_ec2__CancelBundleTaskResponseType:
        return soap_out_ec2__CancelBundleTaskResponseType(soap, tag, id, (const struct ec2__CancelBundleTaskResponseType *)ptr, "ec2:CancelBundleTaskResponseType");
      case SOAP_TYPE_ec2__CancelBundleTaskType:
        return soap_out_ec2__CancelBundleTaskType(soap, tag, id, (const struct ec2__CancelBundleTaskType *)ptr, "ec2:CancelBundleTaskType");
      case SOAP_TYPE_ec2__BundleInstanceTasksSetType:
        return soap_out_ec2__BundleInstanceTasksSetType(soap, tag, id, (const struct ec2__BundleInstanceTasksSetType *)ptr, "ec2:BundleInstanceTasksSetType");
      case SOAP_TYPE_ec2__DescribeBundleTasksResponseType:
        return soap_out_ec2__DescribeBundleTasksResponseType(soap, tag, id, (const struct ec2__DescribeBundleTasksResponseType *)ptr, "ec2:DescribeBundleTasksResponseType");
      case SOAP_TYPE_ec2__DescribeBundleTasksItemType:
        return soap_out_ec2__DescribeBundleTasksItemType(soap, tag, id, (const struct ec2__DescribeBundleTasksItemType *)ptr, "ec2:DescribeBundleTasksItemType");
      case SOAP_TYPE_ec2__DescribeBundleTasksInfoType:
        return soap_out_ec2__DescribeBundleTasksInfoType(soap, tag, id, (const struct ec2__DescribeBundleTasksInfoType *)ptr, "ec2:DescribeBundleTasksInfoType");
      case SOAP_TYPE_ec2__DescribeBundleTasksType:
        return soap_out_ec2__DescribeBundleTasksType(soap, tag, id, (const struct ec2__DescribeBundleTasksType *)ptr, "ec2:DescribeBundleTasksType");
      case SOAP_TYPE_ec2__BundleInstanceTaskErrorType:
        return soap_out_ec2__BundleInstanceTaskErrorType(soap, tag, id, (const struct ec2__BundleInstanceTaskErrorType *)ptr, "ec2:BundleInstanceTaskErrorType");
      case SOAP_TYPE_ec2__BundleInstanceTaskType:
        return soap_out_ec2__BundleInstanceTaskType(soap, tag, id, (const struct ec2__BundleInstanceTaskType *)ptr, "ec2:BundleInstanceTaskType");
      case SOAP_TYPE_ec2__BundleInstanceResponseType:
        return soap_out_ec2__BundleInstanceResponseType(soap, tag, id, (const struct ec2__BundleInstanceResponseType *)ptr, "ec2:BundleInstanceResponseType");
      case SOAP_TYPE_ec2__BundleInstanceS3StorageType:
        return soap_out_ec2__BundleInstanceS3StorageType(soap, tag, id, (const struct ec2__BundleInstanceS3StorageType *)ptr, "ec2:BundleInstanceS3StorageType");
      case SOAP_TYPE_ec2__BundleInstanceTaskStorageType:
        return soap_out_ec2__BundleInstanceTaskStorageType(soap, tag, id, (const struct ec2__BundleInstanceTaskStorageType *)ptr, "ec2:BundleInstanceTaskStorageType");
      case SOAP_TYPE_ec2__BundleInstanceType:
        return soap_out_ec2__BundleInstanceType(soap, tag, id, (const struct ec2__BundleInstanceType *)ptr, "ec2:BundleInstanceType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType:
        return soap_out_ec2__DescribeSnapshotsSetItemResponseType(soap, tag, id, (const struct ec2__DescribeSnapshotsSetItemResponseType *)ptr, "ec2:DescribeSnapshotsSetItemResponseType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType:
        return soap_out_ec2__DescribeSnapshotsSetResponseType(soap, tag, id, (const struct ec2__DescribeSnapshotsSetResponseType *)ptr, "ec2:DescribeSnapshotsSetResponseType");
      case SOAP_TYPE_ec2__DescribeSnapshotsResponseType:
        return soap_out_ec2__DescribeSnapshotsResponseType(soap, tag, id, (const struct ec2__DescribeSnapshotsResponseType *)ptr, "ec2:DescribeSnapshotsResponseType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetItemType:
        return soap_out_ec2__DescribeSnapshotsSetItemType(soap, tag, id, (const struct ec2__DescribeSnapshotsSetItemType *)ptr, "ec2:DescribeSnapshotsSetItemType");
      case SOAP_TYPE_ec2__DescribeSnapshotsSetType:
        return soap_out_ec2__DescribeSnapshotsSetType(soap, tag, id, (const struct ec2__DescribeSnapshotsSetType *)ptr, "ec2:DescribeSnapshotsSetType");
      case SOAP_TYPE_ec2__DescribeSnapshotsType:
        return soap_out_ec2__DescribeSnapshotsType(soap, tag, id, (const struct ec2__DescribeSnapshotsType *)ptr, "ec2:DescribeSnapshotsType");
      case SOAP_TYPE_ec2__DeleteSnapshotResponseType:
        return soap_out_ec2__DeleteSnapshotResponseType(soap, tag, id, (const struct ec2__DeleteSnapshotResponseType *)ptr, "ec2:DeleteSnapshotResponseType");
      case SOAP_TYPE_ec2__DeleteSnapshotType:
        return soap_out_ec2__DeleteSnapshotType(soap, tag, id, (const struct ec2__DeleteSnapshotType *)ptr, "ec2:DeleteSnapshotType");
      case SOAP_TYPE_ec2__CreateSnapshotResponseType:
        return soap_out_ec2__CreateSnapshotResponseType(soap, tag, id, (const struct ec2__CreateSnapshotResponseType *)ptr, "ec2:CreateSnapshotResponseType");
      case SOAP_TYPE_ec2__CreateSnapshotType:
        return soap_out_ec2__CreateSnapshotType(soap, tag, id, (const struct ec2__CreateSnapshotType *)ptr, "ec2:CreateSnapshotType");
      case SOAP_TYPE_ec2__DetachVolumeResponseType:
        return soap_out_ec2__DetachVolumeResponseType(soap, tag, id, (const struct ec2__DetachVolumeResponseType *)ptr, "ec2:DetachVolumeResponseType");
      case SOAP_TYPE_ec2__DetachVolumeType:
        return soap_out_ec2__DetachVolumeType(soap, tag, id, (const struct ec2__DetachVolumeType *)ptr, "ec2:DetachVolumeType");
      case SOAP_TYPE_ec2__AttachVolumeResponseType:
        return soap_out_ec2__AttachVolumeResponseType(soap, tag, id, (const struct ec2__AttachVolumeResponseType *)ptr, "ec2:AttachVolumeResponseType");
      case SOAP_TYPE_ec2__AttachVolumeType:
        return soap_out_ec2__AttachVolumeType(soap, tag, id, (const struct ec2__AttachVolumeType *)ptr, "ec2:AttachVolumeType");
      case SOAP_TYPE_ec2__AttachmentSetItemResponseType:
        return soap_out_ec2__AttachmentSetItemResponseType(soap, tag, id, (const struct ec2__AttachmentSetItemResponseType *)ptr, "ec2:AttachmentSetItemResponseType");
      case SOAP_TYPE_ec2__AttachmentSetResponseType:
        return soap_out_ec2__AttachmentSetResponseType(soap, tag, id, (const struct ec2__AttachmentSetResponseType *)ptr, "ec2:AttachmentSetResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType:
        return soap_out_ec2__DescribeVolumesSetItemResponseType(soap, tag, id, (const struct ec2__DescribeVolumesSetItemResponseType *)ptr, "ec2:DescribeVolumesSetItemResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesSetResponseType:
        return soap_out_ec2__DescribeVolumesSetResponseType(soap, tag, id, (const struct ec2__DescribeVolumesSetResponseType *)ptr, "ec2:DescribeVolumesSetResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesResponseType:
        return soap_out_ec2__DescribeVolumesResponseType(soap, tag, id, (const struct ec2__DescribeVolumesResponseType *)ptr, "ec2:DescribeVolumesResponseType");
      case SOAP_TYPE_ec2__DescribeVolumesSetItemType:
        return soap_out_ec2__DescribeVolumesSetItemType(soap, tag, id, (const struct ec2__DescribeVolumesSetItemType *)ptr, "ec2:DescribeVolumesSetItemType");
      case SOAP_TYPE_ec2__DescribeVolumesSetType:
        return soap_out_ec2__DescribeVolumesSetType(soap, tag, id, (const struct ec2__DescribeVolumesSetType *)ptr, "ec2:DescribeVolumesSetType");
      case SOAP_TYPE_ec2__DescribeVolumesType:
        return soap_out_ec2__DescribeVolumesType(soap, tag, id, (const struct ec2__DescribeVolumesType *)ptr, "ec2:DescribeVolumesType");
      case SOAP_TYPE_ec2__DeleteVolumeResponseType:
        return soap_out_ec2__DeleteVolumeResponseType(soap, tag, id, (const struct ec2__DeleteVolumeResponseType *)ptr, "ec2:DeleteVolumeResponseType");
      case SOAP_TYPE_ec2__DeleteVolumeType:
        return soap_out_ec2__DeleteVolumeType(soap, tag, id, (const struct ec2__DeleteVolumeType *)ptr, "ec2:DeleteVolumeType");
      case SOAP_TYPE_ec2__CreateVolumeResponseType:
        return soap_out_ec2__CreateVolumeResponseType(soap, tag, id, (const struct ec2__CreateVolumeResponseType *)ptr, "ec2:CreateVolumeResponseType");
      case SOAP_TYPE_ec2__CreateVolumeType:
        return soap_out_ec2__CreateVolumeType(soap, tag, id, (const struct ec2__CreateVolumeType *)ptr, "ec2:CreateVolumeType");
      case SOAP_TYPE_ec2__DisassociateAddressResponseType:
        return soap_out_ec2__DisassociateAddressResponseType(soap, tag, id, (const struct ec2__DisassociateAddressResponseType *)ptr, "ec2:DisassociateAddressResponseType");
      case SOAP_TYPE_ec2__DisassociateAddressType:
        return soap_out_ec2__DisassociateAddressType(soap, tag, id, (const struct ec2__DisassociateAddressType *)ptr, "ec2:DisassociateAddressType");
      case SOAP_TYPE_ec2__AssociateAddressResponseType:
        return soap_out_ec2__AssociateAddressResponseType(soap, tag, id, (const struct ec2__AssociateAddressResponseType *)ptr, "ec2:AssociateAddressResponseType");
      case SOAP_TYPE_ec2__AssociateAddressType:
        return soap_out_ec2__AssociateAddressType(soap, tag, id, (const struct ec2__AssociateAddressType *)ptr, "ec2:AssociateAddressType");
      case SOAP_TYPE_ec2__DescribeAddressesResponseItemType:
        return soap_out_ec2__DescribeAddressesResponseItemType(soap, tag, id, (const struct ec2__DescribeAddressesResponseItemType *)ptr, "ec2:DescribeAddressesResponseItemType");
      case SOAP_TYPE_ec2__DescribeAddressesResponseInfoType:
        return soap_out_ec2__DescribeAddressesResponseInfoType(soap, tag, id, (const struct ec2__DescribeAddressesResponseInfoType *)ptr, "ec2:DescribeAddressesResponseInfoType");
      case SOAP_TYPE_ec2__DescribeAddressesResponseType:
        return soap_out_ec2__DescribeAddressesResponseType(soap, tag, id, (const struct ec2__DescribeAddressesResponseType *)ptr, "ec2:DescribeAddressesResponseType");
      case SOAP_TYPE_ec2__DescribeAddressesItemType:
        return soap_out_ec2__DescribeAddressesItemType(soap, tag, id, (const struct ec2__DescribeAddressesItemType *)ptr, "ec2:DescribeAddressesItemType");
      case SOAP_TYPE_ec2__DescribeAddressesInfoType:
        return soap_out_ec2__DescribeAddressesInfoType(soap, tag, id, (const struct ec2__DescribeAddressesInfoType *)ptr, "ec2:DescribeAddressesInfoType");
      case SOAP_TYPE_ec2__DescribeAddressesType:
        return soap_out_ec2__DescribeAddressesType(soap, tag, id, (const struct ec2__DescribeAddressesType *)ptr, "ec2:DescribeAddressesType");
      case SOAP_TYPE_ec2__ReleaseAddressResponseType:
        return soap_out_ec2__ReleaseAddressResponseType(soap, tag, id, (const struct ec2__ReleaseAddressResponseType *)ptr, "ec2:ReleaseAddressResponseType");
      case SOAP_TYPE_ec2__ReleaseAddressType:
        return soap_out_ec2__ReleaseAddressType(soap, tag, id, (const struct ec2__ReleaseAddressType *)ptr, "ec2:ReleaseAddressType");
      case SOAP_TYPE_ec2__AllocateAddressResponseType:
        return soap_out_ec2__AllocateAddressResponseType(soap, tag, id, (const struct ec2__AllocateAddressResponseType *)ptr, "ec2:AllocateAddressResponseType");
      case SOAP_TYPE_ec2__AllocateAddressType:
        return soap_out_ec2__AllocateAddressType(soap, tag, id, (const struct ec2__AllocateAddressType *)ptr, "ec2:AllocateAddressType");
      case SOAP_TYPE_ec2__AvailabilityZoneItemType:
        return soap_out_ec2__AvailabilityZoneItemType(soap, tag, id, (const struct ec2__AvailabilityZoneItemType *)ptr, "ec2:AvailabilityZoneItemType");
      case SOAP_TYPE_ec2__AvailabilityZoneSetType:
        return soap_out_ec2__AvailabilityZoneSetType(soap, tag, id, (const struct ec2__AvailabilityZoneSetType *)ptr, "ec2:AvailabilityZoneSetType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType:
        return soap_out_ec2__DescribeAvailabilityZonesResponseType(soap, tag, id, (const struct ec2__DescribeAvailabilityZonesResponseType *)ptr, "ec2:DescribeAvailabilityZonesResponseType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType:
        return soap_out_ec2__DescribeAvailabilityZonesSetItemType(soap, tag, id, (const struct ec2__DescribeAvailabilityZonesSetItemType *)ptr, "ec2:DescribeAvailabilityZonesSetItemType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType:
        return soap_out_ec2__DescribeAvailabilityZonesSetType(soap, tag, id, (const struct ec2__DescribeAvailabilityZonesSetType *)ptr, "ec2:DescribeAvailabilityZonesSetType");
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesType:
        return soap_out_ec2__DescribeAvailabilityZonesType(soap, tag, id, (const struct ec2__DescribeAvailabilityZonesType *)ptr, "ec2:DescribeAvailabilityZonesType");
      case SOAP_TYPE_ec2__ConfirmProductInstanceResponseType:
        return soap_out_ec2__ConfirmProductInstanceResponseType(soap, tag, id, (const struct ec2__ConfirmProductInstanceResponseType *)ptr, "ec2:ConfirmProductInstanceResponseType");
      case SOAP_TYPE_ec2__ProductCodesSetItemType:
        return soap_out_ec2__ProductCodesSetItemType(soap, tag, id, (const struct ec2__ProductCodesSetItemType *)ptr, "ec2:ProductCodesSetItemType");
      case SOAP_TYPE_ec2__ConfirmProductInstanceType:
        return soap_out_ec2__ConfirmProductInstanceType(soap, tag, id, (const struct ec2__ConfirmProductInstanceType *)ptr, "ec2:ConfirmProductInstanceType");
      case SOAP_TYPE_ec2__AttributeValueType:
        return soap_out_ec2__AttributeValueType(soap, tag, id, (const struct ec2__AttributeValueType *)ptr, "ec2:AttributeValueType");
      case SOAP_TYPE_ec2__NullableAttributeValueType:
        return soap_out_ec2__NullableAttributeValueType(soap, tag, id, (const struct ec2__NullableAttributeValueType *)ptr, "ec2:NullableAttributeValueType");
      case SOAP_TYPE_ec2__DescribeImageAttributeResponseType:
        return soap_out_ec2__DescribeImageAttributeResponseType(soap, tag, id, (const struct ec2__DescribeImageAttributeResponseType *)ptr, "ec2:DescribeImageAttributeResponseType");
      case SOAP_TYPE_ec2__DescribeImageAttributeType:
        return soap_out_ec2__DescribeImageAttributeType(soap, tag, id, (const struct ec2__DescribeImageAttributeType *)ptr, "ec2:DescribeImageAttributeType");
      case SOAP_TYPE_ec2__ResetImageAttributeResponseType:
        return soap_out_ec2__ResetImageAttributeResponseType(soap, tag, id, (const struct ec2__ResetImageAttributeResponseType *)ptr, "ec2:ResetImageAttributeResponseType");
      case SOAP_TYPE_ec2__EmptyElementType:
        return soap_out_ec2__EmptyElementType(soap, tag, id, (const struct ec2__EmptyElementType *)ptr, "ec2:EmptyElementType");
      case SOAP_TYPE_ec2__ResetImageAttributeType:
        return soap_out_ec2__ResetImageAttributeType(soap, tag, id, (const struct ec2__ResetImageAttributeType *)ptr, "ec2:ResetImageAttributeType");
      case SOAP_TYPE_ec2__ModifyImageAttributeResponseType:
        return soap_out_ec2__ModifyImageAttributeResponseType(soap, tag, id, (const struct ec2__ModifyImageAttributeResponseType *)ptr, "ec2:ModifyImageAttributeResponseType");
      case SOAP_TYPE_ec2__ProductCodeItemType:
        return soap_out_ec2__ProductCodeItemType(soap, tag, id, (const struct ec2__ProductCodeItemType *)ptr, "ec2:ProductCodeItemType");
      case SOAP_TYPE_ec2__LaunchPermissionItemType:
        return soap_out_ec2__LaunchPermissionItemType(soap, tag, id, (const struct ec2__LaunchPermissionItemType *)ptr, "ec2:LaunchPermissionItemType");
      case SOAP_TYPE_ec2__LaunchPermissionListType:
        return soap_out_ec2__LaunchPermissionListType(soap, tag, id, (const struct ec2__LaunchPermissionListType *)ptr, "ec2:LaunchPermissionListType");
      case SOAP_TYPE_ec2__ProductCodeListType:
        return soap_out_ec2__ProductCodeListType(soap, tag, id, (const struct ec2__ProductCodeListType *)ptr, "ec2:ProductCodeListType");
      case SOAP_TYPE_ec2__LaunchPermissionOperationType:
        return soap_out_ec2__LaunchPermissionOperationType(soap, tag, id, (const struct ec2__LaunchPermissionOperationType *)ptr, "ec2:LaunchPermissionOperationType");
      case SOAP_TYPE_ec2__ModifyImageAttributeType:
        return soap_out_ec2__ModifyImageAttributeType(soap, tag, id, (const struct ec2__ModifyImageAttributeType *)ptr, "ec2:ModifyImageAttributeType");
      case SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType:
        return soap_out_ec2__RevokeSecurityGroupIngressResponseType(soap, tag, id, (const struct ec2__RevokeSecurityGroupIngressResponseType *)ptr, "ec2:RevokeSecurityGroupIngressResponseType");
      case SOAP_TYPE_ec2__RevokeSecurityGroupIngressType:
        return soap_out_ec2__RevokeSecurityGroupIngressType(soap, tag, id, (const struct ec2__RevokeSecurityGroupIngressType *)ptr, "ec2:RevokeSecurityGroupIngressType");
      case SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType:
        return soap_out_ec2__AuthorizeSecurityGroupIngressResponseType(soap, tag, id, (const struct ec2__AuthorizeSecurityGroupIngressResponseType *)ptr, "ec2:AuthorizeSecurityGroupIngressResponseType");
      case SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType:
        return soap_out_ec2__AuthorizeSecurityGroupIngressType(soap, tag, id, (const struct ec2__AuthorizeSecurityGroupIngressType *)ptr, "ec2:AuthorizeSecurityGroupIngressType");
      case SOAP_TYPE_ec2__SecurityGroupItemType:
        return soap_out_ec2__SecurityGroupItemType(soap, tag, id, (const struct ec2__SecurityGroupItemType *)ptr, "ec2:SecurityGroupItemType");
      case SOAP_TYPE_ec2__UserIdGroupPairType:
        return soap_out_ec2__UserIdGroupPairType(soap, tag, id, (const struct ec2__UserIdGroupPairType *)ptr, "ec2:UserIdGroupPairType");
      case SOAP_TYPE_ec2__IpRangeItemType:
        return soap_out_ec2__IpRangeItemType(soap, tag, id, (const struct ec2__IpRangeItemType *)ptr, "ec2:IpRangeItemType");
      case SOAP_TYPE_ec2__IpRangeSetType:
        return soap_out_ec2__IpRangeSetType(soap, tag, id, (const struct ec2__IpRangeSetType *)ptr, "ec2:IpRangeSetType");
      case SOAP_TYPE_ec2__UserIdGroupPairSetType:
        return soap_out_ec2__UserIdGroupPairSetType(soap, tag, id, (const struct ec2__UserIdGroupPairSetType *)ptr, "ec2:UserIdGroupPairSetType");
      case SOAP_TYPE_ec2__IpPermissionType:
        return soap_out_ec2__IpPermissionType(soap, tag, id, (const struct ec2__IpPermissionType *)ptr, "ec2:IpPermissionType");
      case SOAP_TYPE_ec2__IpPermissionSetType:
        return soap_out_ec2__IpPermissionSetType(soap, tag, id, (const struct ec2__IpPermissionSetType *)ptr, "ec2:IpPermissionSetType");
      case SOAP_TYPE_ec2__SecurityGroupSetType:
        return soap_out_ec2__SecurityGroupSetType(soap, tag, id, (const struct ec2__SecurityGroupSetType *)ptr, "ec2:SecurityGroupSetType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType:
        return soap_out_ec2__DescribeSecurityGroupsResponseType(soap, tag, id, (const struct ec2__DescribeSecurityGroupsResponseType *)ptr, "ec2:DescribeSecurityGroupsResponseType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType:
        return soap_out_ec2__DescribeSecurityGroupsSetItemType(soap, tag, id, (const struct ec2__DescribeSecurityGroupsSetItemType *)ptr, "ec2:DescribeSecurityGroupsSetItemType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsSetType:
        return soap_out_ec2__DescribeSecurityGroupsSetType(soap, tag, id, (const struct ec2__DescribeSecurityGroupsSetType *)ptr, "ec2:DescribeSecurityGroupsSetType");
      case SOAP_TYPE_ec2__DescribeSecurityGroupsType:
        return soap_out_ec2__DescribeSecurityGroupsType(soap, tag, id, (const struct ec2__DescribeSecurityGroupsType *)ptr, "ec2:DescribeSecurityGroupsType");
      case SOAP_TYPE_ec2__DeleteSecurityGroupResponseType:
        return soap_out_ec2__DeleteSecurityGroupResponseType(soap, tag, id, (const struct ec2__DeleteSecurityGroupResponseType *)ptr, "ec2:DeleteSecurityGroupResponseType");
      case SOAP_TYPE_ec2__DeleteSecurityGroupType:
        return soap_out_ec2__DeleteSecurityGroupType(soap, tag, id, (const struct ec2__DeleteSecurityGroupType *)ptr, "ec2:DeleteSecurityGroupType");
      case SOAP_TYPE_ec2__CreateSecurityGroupResponseType:
        return soap_out_ec2__CreateSecurityGroupResponseType(soap, tag, id, (const struct ec2__CreateSecurityGroupResponseType *)ptr, "ec2:CreateSecurityGroupResponseType");
      case SOAP_TYPE_ec2__CreateSecurityGroupType:
        return soap_out_ec2__CreateSecurityGroupType(soap, tag, id, (const struct ec2__CreateSecurityGroupType *)ptr, "ec2:CreateSecurityGroupType");
      case SOAP_TYPE_ec2__DescribeImagesResponseItemType:
        return soap_out_ec2__DescribeImagesResponseItemType(soap, tag, id, (const struct ec2__DescribeImagesResponseItemType *)ptr, "ec2:DescribeImagesResponseItemType");
      case SOAP_TYPE_ec2__DescribeImagesResponseInfoType:
        return soap_out_ec2__DescribeImagesResponseInfoType(soap, tag, id, (const struct ec2__DescribeImagesResponseInfoType *)ptr, "ec2:DescribeImagesResponseInfoType");
      case SOAP_TYPE_ec2__DescribeImagesResponseType:
        return soap_out_ec2__DescribeImagesResponseType(soap, tag, id, (const struct ec2__DescribeImagesResponseType *)ptr, "ec2:DescribeImagesResponseType");
      case SOAP_TYPE_ec2__DescribeImagesExecutableByType:
        return soap_out_ec2__DescribeImagesExecutableByType(soap, tag, id, (const struct ec2__DescribeImagesExecutableByType *)ptr, "ec2:DescribeImagesExecutableByType");
      case SOAP_TYPE_ec2__DescribeImagesOwnerType:
        return soap_out_ec2__DescribeImagesOwnerType(soap, tag, id, (const struct ec2__DescribeImagesOwnerType *)ptr, "ec2:DescribeImagesOwnerType");
      case SOAP_TYPE_ec2__DescribeImagesItemType:
        return soap_out_ec2__DescribeImagesItemType(soap, tag, id, (const struct ec2__DescribeImagesItemType *)ptr, "ec2:DescribeImagesItemType");
      case SOAP_TYPE_ec2__DescribeImagesOwnersType:
        return soap_out_ec2__DescribeImagesOwnersType(soap, tag, id, (const struct ec2__DescribeImagesOwnersType *)ptr, "ec2:DescribeImagesOwnersType");
      case SOAP_TYPE_ec2__DescribeImagesInfoType:
        return soap_out_ec2__DescribeImagesInfoType(soap, tag, id, (const struct ec2__DescribeImagesInfoType *)ptr, "ec2:DescribeImagesInfoType");
      case SOAP_TYPE_ec2__DescribeImagesExecutableBySetType:
        return soap_out_ec2__DescribeImagesExecutableBySetType(soap, tag, id, (const struct ec2__DescribeImagesExecutableBySetType *)ptr, "ec2:DescribeImagesExecutableBySetType");
      case SOAP_TYPE_ec2__DescribeImagesType:
        return soap_out_ec2__DescribeImagesType(soap, tag, id, (const struct ec2__DescribeImagesType *)ptr, "ec2:DescribeImagesType");
      case SOAP_TYPE_ec2__ReservationSetType:
        return soap_out_ec2__ReservationSetType(soap, tag, id, (const struct ec2__ReservationSetType *)ptr, "ec2:ReservationSetType");
      case SOAP_TYPE_ec2__DescribeInstancesResponseType:
        return soap_out_ec2__DescribeInstancesResponseType(soap, tag, id, (const struct ec2__DescribeInstancesResponseType *)ptr, "ec2:DescribeInstancesResponseType");
      case SOAP_TYPE_ec2__DescribeInstancesItemType:
        return soap_out_ec2__DescribeInstancesItemType(soap, tag, id, (const struct ec2__DescribeInstancesItemType *)ptr, "ec2:DescribeInstancesItemType");
      case SOAP_TYPE_ec2__DescribeInstancesInfoType:
        return soap_out_ec2__DescribeInstancesInfoType(soap, tag, id, (const struct ec2__DescribeInstancesInfoType *)ptr, "ec2:DescribeInstancesInfoType");
      case SOAP_TYPE_ec2__DescribeInstancesType:
        return soap_out_ec2__DescribeInstancesType(soap, tag, id, (const struct ec2__DescribeInstancesType *)ptr, "ec2:DescribeInstancesType");
      case SOAP_TYPE_ec2__RebootInstancesResponseType:
        return soap_out_ec2__RebootInstancesResponseType(soap, tag, id, (const struct ec2__RebootInstancesResponseType *)ptr, "ec2:RebootInstancesResponseType");
      case SOAP_TYPE_ec2__RebootInstancesItemType:
        return soap_out_ec2__RebootInstancesItemType(soap, tag, id, (const struct ec2__RebootInstancesItemType *)ptr, "ec2:RebootInstancesItemType");
      case SOAP_TYPE_ec2__RebootInstancesInfoType:
        return soap_out_ec2__RebootInstancesInfoType(soap, tag, id, (const struct ec2__RebootInstancesInfoType *)ptr, "ec2:RebootInstancesInfoType");
      case SOAP_TYPE_ec2__RebootInstancesType:
        return soap_out_ec2__RebootInstancesType(soap, tag, id, (const struct ec2__RebootInstancesType *)ptr, "ec2:RebootInstancesType");
      case SOAP_TYPE_ec2__TerminateInstancesResponseItemType:
        return soap_out_ec2__TerminateInstancesResponseItemType(soap, tag, id, (const struct ec2__TerminateInstancesResponseItemType *)ptr, "ec2:TerminateInstancesResponseItemType");
      case SOAP_TYPE_ec2__TerminateInstancesResponseInfoType:
        return soap_out_ec2__TerminateInstancesResponseInfoType(soap, tag, id, (const struct ec2__TerminateInstancesResponseInfoType *)ptr, "ec2:TerminateInstancesResponseInfoType");
      case SOAP_TYPE_ec2__TerminateInstancesResponseType:
        return soap_out_ec2__TerminateInstancesResponseType(soap, tag, id, (const struct ec2__TerminateInstancesResponseType *)ptr, "ec2:TerminateInstancesResponseType");
      case SOAP_TYPE_ec2__TerminateInstancesItemType:
        return soap_out_ec2__TerminateInstancesItemType(soap, tag, id, (const struct ec2__TerminateInstancesItemType *)ptr, "ec2:TerminateInstancesItemType");
      case SOAP_TYPE_ec2__TerminateInstancesInfoType:
        return soap_out_ec2__TerminateInstancesInfoType(soap, tag, id, (const struct ec2__TerminateInstancesInfoType *)ptr, "ec2:TerminateInstancesInfoType");
      case SOAP_TYPE_ec2__TerminateInstancesType:
        return soap_out_ec2__TerminateInstancesType(soap, tag, id, (const struct ec2__TerminateInstancesType *)ptr, "ec2:TerminateInstancesType");
      case SOAP_TYPE_ec2__GetConsoleOutputResponseType:
        return soap_out_ec2__GetConsoleOutputResponseType(soap, tag, id, (const struct ec2__GetConsoleOutputResponseType *)ptr, "ec2:GetConsoleOutputResponseType");
      case SOAP_TYPE_ec2__GetConsoleOutputType:
        return soap_out_ec2__GetConsoleOutputType(soap, tag, id, (const struct ec2__GetConsoleOutputType *)ptr, "ec2:GetConsoleOutputType");
      case SOAP_TYPE_ec2__PlacementResponseType:
        return soap_out_ec2__PlacementResponseType(soap, tag, id, (const struct ec2__PlacementResponseType *)ptr, "ec2:PlacementResponseType");
      case SOAP_TYPE_ec2__ProductCodesSetType:
        return soap_out_ec2__ProductCodesSetType(soap, tag, id, (const struct ec2__ProductCodesSetType *)ptr, "ec2:ProductCodesSetType");
      case SOAP_TYPE_ec2__InstanceStateType:
        return soap_out_ec2__InstanceStateType(soap, tag, id, (const struct ec2__InstanceStateType *)ptr, "ec2:InstanceStateType");
      case SOAP_TYPE_ec2__RunningInstancesItemType:
        return soap_out_ec2__RunningInstancesItemType(soap, tag, id, (const struct ec2__RunningInstancesItemType *)ptr, "ec2:RunningInstancesItemType");
      case SOAP_TYPE_ec2__ReservationInfoType:
        return soap_out_ec2__ReservationInfoType(soap, tag, id, (const struct ec2__ReservationInfoType *)ptr, "ec2:ReservationInfoType");
      case SOAP_TYPE_ec2__RunningInstancesSetType:
        return soap_out_ec2__RunningInstancesSetType(soap, tag, id, (const struct ec2__RunningInstancesSetType *)ptr, "ec2:RunningInstancesSetType");
      case SOAP_TYPE_ec2__RunInstancesResponseType:
        return soap_out_ec2__RunInstancesResponseType(soap, tag, id, (const struct ec2__RunInstancesResponseType *)ptr, "ec2:RunInstancesResponseType");
      case SOAP_TYPE_ec2__BlockDeviceMappingItemType:
        return soap_out_ec2__BlockDeviceMappingItemType(soap, tag, id, (const struct ec2__BlockDeviceMappingItemType *)ptr, "ec2:BlockDeviceMappingItemType");
      case SOAP_TYPE_ec2__GroupItemType:
        return soap_out_ec2__GroupItemType(soap, tag, id, (const struct ec2__GroupItemType *)ptr, "ec2:GroupItemType");
      case SOAP_TYPE_ec2__BlockDeviceMappingType:
        return soap_out_ec2__BlockDeviceMappingType(soap, tag, id, (const struct ec2__BlockDeviceMappingType *)ptr, "ec2:BlockDeviceMappingType");
      case SOAP_TYPE_ec2__PlacementRequestType:
        return soap_out_ec2__PlacementRequestType(soap, tag, id, (const struct ec2__PlacementRequestType *)ptr, "ec2:PlacementRequestType");
      case SOAP_TYPE_ec2__UserDataType:
        return soap_out_ec2__UserDataType(soap, tag, id, (const struct ec2__UserDataType *)ptr, "ec2:UserDataType");
      case SOAP_TYPE_ec2__GroupSetType:
        return soap_out_ec2__GroupSetType(soap, tag, id, (const struct ec2__GroupSetType *)ptr, "ec2:GroupSetType");
      case SOAP_TYPE_ec2__RunInstancesType:
        return soap_out_ec2__RunInstancesType(soap, tag, id, (const struct ec2__RunInstancesType *)ptr, "ec2:RunInstancesType");
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseItemType:
        return soap_out_ec2__DescribeKeyPairsResponseItemType(soap, tag, id, (const struct ec2__DescribeKeyPairsResponseItemType *)ptr, "ec2:DescribeKeyPairsResponseItemType");
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseInfoType:
        return soap_out_ec2__DescribeKeyPairsResponseInfoType(soap, tag, id, (const struct ec2__DescribeKeyPairsResponseInfoType *)ptr, "ec2:DescribeKeyPairsResponseInfoType");
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseType:
        return soap_out_ec2__DescribeKeyPairsResponseType(soap, tag, id, (const struct ec2__DescribeKeyPairsResponseType *)ptr, "ec2:DescribeKeyPairsResponseType");
      case SOAP_TYPE_ec2__DescribeKeyPairsItemType:
        return soap_out_ec2__DescribeKeyPairsItemType(soap, tag, id, (const struct ec2__DescribeKeyPairsItemType *)ptr, "ec2:DescribeKeyPairsItemType");
      case SOAP_TYPE_ec2__DescribeKeyPairsInfoType:
        return soap_out_ec2__DescribeKeyPairsInfoType(soap, tag, id, (const struct ec2__DescribeKeyPairsInfoType *)ptr, "ec2:DescribeKeyPairsInfoType");
      case SOAP_TYPE_ec2__DescribeKeyPairsType:
        return soap_out_ec2__DescribeKeyPairsType(soap, tag, id, (const struct ec2__DescribeKeyPairsType *)ptr, "ec2:DescribeKeyPairsType");
      case SOAP_TYPE_ec2__DeleteKeyPairResponseType:
        return soap_out_ec2__DeleteKeyPairResponseType(soap, tag, id, (const struct ec2__DeleteKeyPairResponseType *)ptr, "ec2:DeleteKeyPairResponseType");
      case SOAP_TYPE_ec2__DeleteKeyPairType:
        return soap_out_ec2__DeleteKeyPairType(soap, tag, id, (const struct ec2__DeleteKeyPairType *)ptr, "ec2:DeleteKeyPairType");
      case SOAP_TYPE_ec2__CreateKeyPairResponseType:
        return soap_out_ec2__CreateKeyPairResponseType(soap, tag, id, (const struct ec2__CreateKeyPairResponseType *)ptr, "ec2:CreateKeyPairResponseType");
      case SOAP_TYPE_ec2__CreateKeyPairType:
        return soap_out_ec2__CreateKeyPairType(soap, tag, id, (const struct ec2__CreateKeyPairType *)ptr, "ec2:CreateKeyPairType");
      case SOAP_TYPE_ec2__DeregisterImageResponseType:
        return soap_out_ec2__DeregisterImageResponseType(soap, tag, id, (const struct ec2__DeregisterImageResponseType *)ptr, "ec2:DeregisterImageResponseType");
      case SOAP_TYPE_ec2__DeregisterImageType:
        return soap_out_ec2__DeregisterImageType(soap, tag, id, (const struct ec2__DeregisterImageType *)ptr, "ec2:DeregisterImageType");
      case SOAP_TYPE_ec2__RegisterImageResponseType:
        return soap_out_ec2__RegisterImageResponseType(soap, tag, id, (const struct ec2__RegisterImageResponseType *)ptr, "ec2:RegisterImageResponseType");
      case SOAP_TYPE_ec2__RegisterImageType:
        return soap_out_ec2__RegisterImageType(soap, tag, id, (const struct ec2__RegisterImageType *)ptr, "ec2:RegisterImageType");
      case SOAP_TYPE__wsse__Security:
        return soap_out__wsse__Security(soap, "wsse:Security", id, (const struct _wsse__Security *)ptr, NULL);
      case SOAP_TYPE_ds__RSAKeyValueType:
        return soap_out_ds__RSAKeyValueType(soap, tag, id, (const struct ds__RSAKeyValueType *)ptr, "ds:RSAKeyValueType");
      case SOAP_TYPE_ds__DSAKeyValueType:
        return soap_out_ds__DSAKeyValueType(soap, tag, id, (const struct ds__DSAKeyValueType *)ptr, "ds:DSAKeyValueType");
      case SOAP_TYPE_ds__X509IssuerSerialType:
        return soap_out_ds__X509IssuerSerialType(soap, tag, id, (const struct ds__X509IssuerSerialType *)ptr, "ds:X509IssuerSerialType");
      case SOAP_TYPE_ds__X509DataType:
        return soap_out_ds__X509DataType(soap, tag, id, (const struct ds__X509DataType *)ptr, "ds:X509DataType");
      case SOAP_TYPE_ds__RetrievalMethodType:
        return soap_out_ds__RetrievalMethodType(soap, tag, id, (const struct ds__RetrievalMethodType *)ptr, "ds:RetrievalMethodType");
      case SOAP_TYPE_ds__KeyValueType:
        return soap_out_ds__KeyValueType(soap, tag, id, (const struct ds__KeyValueType *)ptr, "ds:KeyValueType");
      case SOAP_TYPE_ds__DigestMethodType:
        return soap_out_ds__DigestMethodType(soap, tag, id, (const struct ds__DigestMethodType *)ptr, "ds:DigestMethodType");
      case SOAP_TYPE_ds__TransformType:
        return soap_out_ds__TransformType(soap, tag, id, (const struct ds__TransformType *)ptr, "ds:TransformType");
      case SOAP_TYPE__c14n__InclusiveNamespaces:
        return soap_out__c14n__InclusiveNamespaces(soap, "c14n:InclusiveNamespaces", id, (const struct _c14n__InclusiveNamespaces *)ptr, NULL);
      case SOAP_TYPE_ds__TransformsType:
        return soap_out_ds__TransformsType(soap, tag, id, (const struct ds__TransformsType *)ptr, "ds:TransformsType");
      case SOAP_TYPE_ds__ReferenceType:
        return soap_out_ds__ReferenceType(soap, tag, id, (const struct ds__ReferenceType *)ptr, "ds:ReferenceType");
      case SOAP_TYPE_ds__SignatureMethodType:
        return soap_out_ds__SignatureMethodType(soap, tag, id, (const struct ds__SignatureMethodType *)ptr, "ds:SignatureMethodType");
      case SOAP_TYPE_ds__CanonicalizationMethodType:
        return soap_out_ds__CanonicalizationMethodType(soap, tag, id, (const struct ds__CanonicalizationMethodType *)ptr, "ds:CanonicalizationMethodType");
      case SOAP_TYPE_ds__KeyInfoType:
        return soap_out_ds__KeyInfoType(soap, tag, id, (const struct ds__KeyInfoType *)ptr, "ds:KeyInfoType");
      case SOAP_TYPE_ds__SignedInfoType:
        return soap_out_ds__SignedInfoType(soap, tag, id, (const struct ds__SignedInfoType *)ptr, "ds:SignedInfoType");
      case SOAP_TYPE_ds__SignatureType:
        return soap_out_ds__SignatureType(soap, tag, id, (const struct ds__SignatureType *)ptr, "ds:SignatureType");
      case SOAP_TYPE__wsse__SecurityTokenReference:
        return soap_out__wsse__SecurityTokenReference(soap, "wsse:SecurityTokenReference", id, (const struct _wsse__SecurityTokenReference *)ptr, NULL);
      case SOAP_TYPE__wsse__KeyIdentifier:
        return soap_out__wsse__KeyIdentifier(soap, "wsse:KeyIdentifier", id, (const struct _wsse__KeyIdentifier *)ptr, NULL);
      case SOAP_TYPE__wsse__Embedded:
        return soap_out__wsse__Embedded(soap, "wsse:Embedded", id, (const struct _wsse__Embedded *)ptr, NULL);
      case SOAP_TYPE__wsse__Reference:
        return soap_out__wsse__Reference(soap, "wsse:Reference", id, (const struct _wsse__Reference *)ptr, NULL);
      case SOAP_TYPE__wsse__BinarySecurityToken:
        return soap_out__wsse__BinarySecurityToken(soap, "wsse:BinarySecurityToken", id, (const struct _wsse__BinarySecurityToken *)ptr, NULL);
      case SOAP_TYPE__wsse__Password:
        return soap_out__wsse__Password(soap, "wsse:Password", id, (const struct _wsse__Password *)ptr, NULL);
      case SOAP_TYPE__wsse__UsernameToken:
        return soap_out__wsse__UsernameToken(soap, "wsse:UsernameToken", id, (const struct _wsse__UsernameToken *)ptr, NULL);
      case SOAP_TYPE__wsu__Timestamp:
        return soap_out__wsu__Timestamp(soap, "wsu:Timestamp", id, (const struct _wsu__Timestamp *)ptr, NULL);
      case SOAP_TYPE_PointerToec2__DescribeRegionsResponseType:
        return soap_out_PointerToec2__DescribeRegionsResponseType(soap, tag, id, (struct ec2__DescribeRegionsResponseType *const*)ptr, "ec2:DescribeRegionsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeRegionsType:
        return soap_out_PointerToec2__DescribeRegionsType(soap, tag, id, (struct ec2__DescribeRegionsType *const*)ptr, "ec2:DescribeRegionsType");
      case SOAP_TYPE_PointerToec2__CancelBundleTaskResponseType:
        return soap_out_PointerToec2__CancelBundleTaskResponseType(soap, tag, id, (struct ec2__CancelBundleTaskResponseType *const*)ptr, "ec2:CancelBundleTaskResponseType");
      case SOAP_TYPE_PointerToec2__CancelBundleTaskType:
        return soap_out_PointerToec2__CancelBundleTaskType(soap, tag, id, (struct ec2__CancelBundleTaskType *const*)ptr, "ec2:CancelBundleTaskType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksResponseType:
        return soap_out_PointerToec2__DescribeBundleTasksResponseType(soap, tag, id, (struct ec2__DescribeBundleTasksResponseType *const*)ptr, "ec2:DescribeBundleTasksResponseType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksType:
        return soap_out_PointerToec2__DescribeBundleTasksType(soap, tag, id, (struct ec2__DescribeBundleTasksType *const*)ptr, "ec2:DescribeBundleTasksType");
      case SOAP_TYPE_PointerToec2__BundleInstanceResponseType:
        return soap_out_PointerToec2__BundleInstanceResponseType(soap, tag, id, (struct ec2__BundleInstanceResponseType *const*)ptr, "ec2:BundleInstanceResponseType");
      case SOAP_TYPE_PointerToec2__BundleInstanceType:
        return soap_out_PointerToec2__BundleInstanceType(soap, tag, id, (struct ec2__BundleInstanceType *const*)ptr, "ec2:BundleInstanceType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsResponseType:
        return soap_out_PointerToec2__DescribeSnapshotsResponseType(soap, tag, id, (struct ec2__DescribeSnapshotsResponseType *const*)ptr, "ec2:DescribeSnapshotsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsType:
        return soap_out_PointerToec2__DescribeSnapshotsType(soap, tag, id, (struct ec2__DescribeSnapshotsType *const*)ptr, "ec2:DescribeSnapshotsType");
      case SOAP_TYPE_PointerToec2__DeleteSnapshotResponseType:
        return soap_out_PointerToec2__DeleteSnapshotResponseType(soap, tag, id, (struct ec2__DeleteSnapshotResponseType *const*)ptr, "ec2:DeleteSnapshotResponseType");
      case SOAP_TYPE_PointerToec2__DeleteSnapshotType:
        return soap_out_PointerToec2__DeleteSnapshotType(soap, tag, id, (struct ec2__DeleteSnapshotType *const*)ptr, "ec2:DeleteSnapshotType");
      case SOAP_TYPE_PointerToec2__CreateSnapshotResponseType:
        return soap_out_PointerToec2__CreateSnapshotResponseType(soap, tag, id, (struct ec2__CreateSnapshotResponseType *const*)ptr, "ec2:CreateSnapshotResponseType");
      case SOAP_TYPE_PointerToec2__CreateSnapshotType:
        return soap_out_PointerToec2__CreateSnapshotType(soap, tag, id, (struct ec2__CreateSnapshotType *const*)ptr, "ec2:CreateSnapshotType");
      case SOAP_TYPE_PointerToec2__DetachVolumeResponseType:
        return soap_out_PointerToec2__DetachVolumeResponseType(soap, tag, id, (struct ec2__DetachVolumeResponseType *const*)ptr, "ec2:DetachVolumeResponseType");
      case SOAP_TYPE_PointerToec2__DetachVolumeType:
        return soap_out_PointerToec2__DetachVolumeType(soap, tag, id, (struct ec2__DetachVolumeType *const*)ptr, "ec2:DetachVolumeType");
      case SOAP_TYPE_PointerToec2__AttachVolumeResponseType:
        return soap_out_PointerToec2__AttachVolumeResponseType(soap, tag, id, (struct ec2__AttachVolumeResponseType *const*)ptr, "ec2:AttachVolumeResponseType");
      case SOAP_TYPE_PointerToec2__AttachVolumeType:
        return soap_out_PointerToec2__AttachVolumeType(soap, tag, id, (struct ec2__AttachVolumeType *const*)ptr, "ec2:AttachVolumeType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesResponseType:
        return soap_out_PointerToec2__DescribeVolumesResponseType(soap, tag, id, (struct ec2__DescribeVolumesResponseType *const*)ptr, "ec2:DescribeVolumesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesType:
        return soap_out_PointerToec2__DescribeVolumesType(soap, tag, id, (struct ec2__DescribeVolumesType *const*)ptr, "ec2:DescribeVolumesType");
      case SOAP_TYPE_PointerToec2__DeleteVolumeResponseType:
        return soap_out_PointerToec2__DeleteVolumeResponseType(soap, tag, id, (struct ec2__DeleteVolumeResponseType *const*)ptr, "ec2:DeleteVolumeResponseType");
      case SOAP_TYPE_PointerToec2__DeleteVolumeType:
        return soap_out_PointerToec2__DeleteVolumeType(soap, tag, id, (struct ec2__DeleteVolumeType *const*)ptr, "ec2:DeleteVolumeType");
      case SOAP_TYPE_PointerToec2__CreateVolumeResponseType:
        return soap_out_PointerToec2__CreateVolumeResponseType(soap, tag, id, (struct ec2__CreateVolumeResponseType *const*)ptr, "ec2:CreateVolumeResponseType");
      case SOAP_TYPE_PointerToec2__CreateVolumeType:
        return soap_out_PointerToec2__CreateVolumeType(soap, tag, id, (struct ec2__CreateVolumeType *const*)ptr, "ec2:CreateVolumeType");
      case SOAP_TYPE_PointerToec2__DisassociateAddressResponseType:
        return soap_out_PointerToec2__DisassociateAddressResponseType(soap, tag, id, (struct ec2__DisassociateAddressResponseType *const*)ptr, "ec2:DisassociateAddressResponseType");
      case SOAP_TYPE_PointerToec2__DisassociateAddressType:
        return soap_out_PointerToec2__DisassociateAddressType(soap, tag, id, (struct ec2__DisassociateAddressType *const*)ptr, "ec2:DisassociateAddressType");
      case SOAP_TYPE_PointerToec2__AssociateAddressResponseType:
        return soap_out_PointerToec2__AssociateAddressResponseType(soap, tag, id, (struct ec2__AssociateAddressResponseType *const*)ptr, "ec2:AssociateAddressResponseType");
      case SOAP_TYPE_PointerToec2__AssociateAddressType:
        return soap_out_PointerToec2__AssociateAddressType(soap, tag, id, (struct ec2__AssociateAddressType *const*)ptr, "ec2:AssociateAddressType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseType:
        return soap_out_PointerToec2__DescribeAddressesResponseType(soap, tag, id, (struct ec2__DescribeAddressesResponseType *const*)ptr, "ec2:DescribeAddressesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesType:
        return soap_out_PointerToec2__DescribeAddressesType(soap, tag, id, (struct ec2__DescribeAddressesType *const*)ptr, "ec2:DescribeAddressesType");
      case SOAP_TYPE_PointerToec2__ReleaseAddressResponseType:
        return soap_out_PointerToec2__ReleaseAddressResponseType(soap, tag, id, (struct ec2__ReleaseAddressResponseType *const*)ptr, "ec2:ReleaseAddressResponseType");
      case SOAP_TYPE_PointerToec2__ReleaseAddressType:
        return soap_out_PointerToec2__ReleaseAddressType(soap, tag, id, (struct ec2__ReleaseAddressType *const*)ptr, "ec2:ReleaseAddressType");
      case SOAP_TYPE_PointerToec2__AllocateAddressResponseType:
        return soap_out_PointerToec2__AllocateAddressResponseType(soap, tag, id, (struct ec2__AllocateAddressResponseType *const*)ptr, "ec2:AllocateAddressResponseType");
      case SOAP_TYPE_PointerToec2__AllocateAddressType:
        return soap_out_PointerToec2__AllocateAddressType(soap, tag, id, (struct ec2__AllocateAddressType *const*)ptr, "ec2:AllocateAddressType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesResponseType:
        return soap_out_PointerToec2__DescribeAvailabilityZonesResponseType(soap, tag, id, (struct ec2__DescribeAvailabilityZonesResponseType *const*)ptr, "ec2:DescribeAvailabilityZonesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesType:
        return soap_out_PointerToec2__DescribeAvailabilityZonesType(soap, tag, id, (struct ec2__DescribeAvailabilityZonesType *const*)ptr, "ec2:DescribeAvailabilityZonesType");
      case SOAP_TYPE_PointerToec2__ConfirmProductInstanceResponseType:
        return soap_out_PointerToec2__ConfirmProductInstanceResponseType(soap, tag, id, (struct ec2__ConfirmProductInstanceResponseType *const*)ptr, "ec2:ConfirmProductInstanceResponseType");
      case SOAP_TYPE_PointerToec2__ConfirmProductInstanceType:
        return soap_out_PointerToec2__ConfirmProductInstanceType(soap, tag, id, (struct ec2__ConfirmProductInstanceType *const*)ptr, "ec2:ConfirmProductInstanceType");
      case SOAP_TYPE_PointerToec2__DescribeImageAttributeResponseType:
        return soap_out_PointerToec2__DescribeImageAttributeResponseType(soap, tag, id, (struct ec2__DescribeImageAttributeResponseType *const*)ptr, "ec2:DescribeImageAttributeResponseType");
      case SOAP_TYPE_PointerToec2__DescribeImageAttributeType:
        return soap_out_PointerToec2__DescribeImageAttributeType(soap, tag, id, (struct ec2__DescribeImageAttributeType *const*)ptr, "ec2:DescribeImageAttributeType");
      case SOAP_TYPE_PointerToec2__ResetImageAttributeResponseType:
        return soap_out_PointerToec2__ResetImageAttributeResponseType(soap, tag, id, (struct ec2__ResetImageAttributeResponseType *const*)ptr, "ec2:ResetImageAttributeResponseType");
      case SOAP_TYPE_PointerToec2__ResetImageAttributeType:
        return soap_out_PointerToec2__ResetImageAttributeType(soap, tag, id, (struct ec2__ResetImageAttributeType *const*)ptr, "ec2:ResetImageAttributeType");
      case SOAP_TYPE_PointerToec2__ModifyImageAttributeResponseType:
        return soap_out_PointerToec2__ModifyImageAttributeResponseType(soap, tag, id, (struct ec2__ModifyImageAttributeResponseType *const*)ptr, "ec2:ModifyImageAttributeResponseType");
      case SOAP_TYPE_PointerToec2__ModifyImageAttributeType:
        return soap_out_PointerToec2__ModifyImageAttributeType(soap, tag, id, (struct ec2__ModifyImageAttributeType *const*)ptr, "ec2:ModifyImageAttributeType");
      case SOAP_TYPE_PointerToec2__RevokeSecurityGroupIngressResponseType:
        return soap_out_PointerToec2__RevokeSecurityGroupIngressResponseType(soap, tag, id, (struct ec2__RevokeSecurityGroupIngressResponseType *const*)ptr, "ec2:RevokeSecurityGroupIngressResponseType");
      case SOAP_TYPE_PointerToec2__RevokeSecurityGroupIngressType:
        return soap_out_PointerToec2__RevokeSecurityGroupIngressType(soap, tag, id, (struct ec2__RevokeSecurityGroupIngressType *const*)ptr, "ec2:RevokeSecurityGroupIngressType");
      case SOAP_TYPE_PointerToec2__AuthorizeSecurityGroupIngressResponseType:
        return soap_out_PointerToec2__AuthorizeSecurityGroupIngressResponseType(soap, tag, id, (struct ec2__AuthorizeSecurityGroupIngressResponseType *const*)ptr, "ec2:AuthorizeSecurityGroupIngressResponseType");
      case SOAP_TYPE_PointerToec2__AuthorizeSecurityGroupIngressType:
        return soap_out_PointerToec2__AuthorizeSecurityGroupIngressType(soap, tag, id, (struct ec2__AuthorizeSecurityGroupIngressType *const*)ptr, "ec2:AuthorizeSecurityGroupIngressType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsResponseType:
        return soap_out_PointerToec2__DescribeSecurityGroupsResponseType(soap, tag, id, (struct ec2__DescribeSecurityGroupsResponseType *const*)ptr, "ec2:DescribeSecurityGroupsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsType:
        return soap_out_PointerToec2__DescribeSecurityGroupsType(soap, tag, id, (struct ec2__DescribeSecurityGroupsType *const*)ptr, "ec2:DescribeSecurityGroupsType");
      case SOAP_TYPE_PointerToec2__DeleteSecurityGroupResponseType:
        return soap_out_PointerToec2__DeleteSecurityGroupResponseType(soap, tag, id, (struct ec2__DeleteSecurityGroupResponseType *const*)ptr, "ec2:DeleteSecurityGroupResponseType");
      case SOAP_TYPE_PointerToec2__DeleteSecurityGroupType:
        return soap_out_PointerToec2__DeleteSecurityGroupType(soap, tag, id, (struct ec2__DeleteSecurityGroupType *const*)ptr, "ec2:DeleteSecurityGroupType");
      case SOAP_TYPE_PointerToec2__CreateSecurityGroupResponseType:
        return soap_out_PointerToec2__CreateSecurityGroupResponseType(soap, tag, id, (struct ec2__CreateSecurityGroupResponseType *const*)ptr, "ec2:CreateSecurityGroupResponseType");
      case SOAP_TYPE_PointerToec2__CreateSecurityGroupType:
        return soap_out_PointerToec2__CreateSecurityGroupType(soap, tag, id, (struct ec2__CreateSecurityGroupType *const*)ptr, "ec2:CreateSecurityGroupType");
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseType:
        return soap_out_PointerToec2__DescribeImagesResponseType(soap, tag, id, (struct ec2__DescribeImagesResponseType *const*)ptr, "ec2:DescribeImagesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeImagesType:
        return soap_out_PointerToec2__DescribeImagesType(soap, tag, id, (struct ec2__DescribeImagesType *const*)ptr, "ec2:DescribeImagesType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesResponseType:
        return soap_out_PointerToec2__DescribeInstancesResponseType(soap, tag, id, (struct ec2__DescribeInstancesResponseType *const*)ptr, "ec2:DescribeInstancesResponseType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesType:
        return soap_out_PointerToec2__DescribeInstancesType(soap, tag, id, (struct ec2__DescribeInstancesType *const*)ptr, "ec2:DescribeInstancesType");
      case SOAP_TYPE_PointerToec2__RebootInstancesResponseType:
        return soap_out_PointerToec2__RebootInstancesResponseType(soap, tag, id, (struct ec2__RebootInstancesResponseType *const*)ptr, "ec2:RebootInstancesResponseType");
      case SOAP_TYPE_PointerToec2__RebootInstancesType:
        return soap_out_PointerToec2__RebootInstancesType(soap, tag, id, (struct ec2__RebootInstancesType *const*)ptr, "ec2:RebootInstancesType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseType:
        return soap_out_PointerToec2__TerminateInstancesResponseType(soap, tag, id, (struct ec2__TerminateInstancesResponseType *const*)ptr, "ec2:TerminateInstancesResponseType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesType:
        return soap_out_PointerToec2__TerminateInstancesType(soap, tag, id, (struct ec2__TerminateInstancesType *const*)ptr, "ec2:TerminateInstancesType");
      case SOAP_TYPE_PointerToec2__GetConsoleOutputResponseType:
        return soap_out_PointerToec2__GetConsoleOutputResponseType(soap, tag, id, (struct ec2__GetConsoleOutputResponseType *const*)ptr, "ec2:GetConsoleOutputResponseType");
      case SOAP_TYPE_PointerToec2__GetConsoleOutputType:
        return soap_out_PointerToec2__GetConsoleOutputType(soap, tag, id, (struct ec2__GetConsoleOutputType *const*)ptr, "ec2:GetConsoleOutputType");
      case SOAP_TYPE_PointerToec2__RunInstancesResponseType:
        return soap_out_PointerToec2__RunInstancesResponseType(soap, tag, id, (struct ec2__RunInstancesResponseType *const*)ptr, "ec2:RunInstancesResponseType");
      case SOAP_TYPE_PointerToec2__RunInstancesType:
        return soap_out_PointerToec2__RunInstancesType(soap, tag, id, (struct ec2__RunInstancesType *const*)ptr, "ec2:RunInstancesType");
      case SOAP_TYPE_PointerToec2__DeleteKeyPairResponseType:
        return soap_out_PointerToec2__DeleteKeyPairResponseType(soap, tag, id, (struct ec2__DeleteKeyPairResponseType *const*)ptr, "ec2:DeleteKeyPairResponseType");
      case SOAP_TYPE_PointerToec2__DeleteKeyPairType:
        return soap_out_PointerToec2__DeleteKeyPairType(soap, tag, id, (struct ec2__DeleteKeyPairType *const*)ptr, "ec2:DeleteKeyPairType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseType:
        return soap_out_PointerToec2__DescribeKeyPairsResponseType(soap, tag, id, (struct ec2__DescribeKeyPairsResponseType *const*)ptr, "ec2:DescribeKeyPairsResponseType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsType:
        return soap_out_PointerToec2__DescribeKeyPairsType(soap, tag, id, (struct ec2__DescribeKeyPairsType *const*)ptr, "ec2:DescribeKeyPairsType");
      case SOAP_TYPE_PointerToec2__CreateKeyPairResponseType:
        return soap_out_PointerToec2__CreateKeyPairResponseType(soap, tag, id, (struct ec2__CreateKeyPairResponseType *const*)ptr, "ec2:CreateKeyPairResponseType");
      case SOAP_TYPE_PointerToec2__CreateKeyPairType:
        return soap_out_PointerToec2__CreateKeyPairType(soap, tag, id, (struct ec2__CreateKeyPairType *const*)ptr, "ec2:CreateKeyPairType");
      case SOAP_TYPE_PointerToec2__DeregisterImageResponseType:
        return soap_out_PointerToec2__DeregisterImageResponseType(soap, tag, id, (struct ec2__DeregisterImageResponseType *const*)ptr, "ec2:DeregisterImageResponseType");
      case SOAP_TYPE_PointerToec2__DeregisterImageType:
        return soap_out_PointerToec2__DeregisterImageType(soap, tag, id, (struct ec2__DeregisterImageType *const*)ptr, "ec2:DeregisterImageType");
      case SOAP_TYPE_PointerToec2__RegisterImageResponseType:
        return soap_out_PointerToec2__RegisterImageResponseType(soap, tag, id, (struct ec2__RegisterImageResponseType *const*)ptr, "ec2:RegisterImageResponseType");
      case SOAP_TYPE_PointerToec2__RegisterImageType:
        return soap_out_PointerToec2__RegisterImageType(soap, tag, id, (struct ec2__RegisterImageType *const*)ptr, "ec2:RegisterImageType");
      case SOAP_TYPE_PointerToec2__RegionItemType:
        return soap_out_PointerToec2__RegionItemType(soap, tag, id, (struct ec2__RegionItemType *const*)ptr, "ec2:RegionItemType");
      case SOAP_TYPE_PointerToec2__RegionSetType:
        return soap_out_PointerToec2__RegionSetType(soap, tag, id, (struct ec2__RegionSetType *const*)ptr, "ec2:RegionSetType");
      case SOAP_TYPE_PointerToec2__DescribeRegionsSetItemType:
        return soap_out_PointerToec2__DescribeRegionsSetItemType(soap, tag, id, (struct ec2__DescribeRegionsSetItemType *const*)ptr, "ec2:DescribeRegionsSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeRegionsSetType:
        return soap_out_PointerToec2__DescribeRegionsSetType(soap, tag, id, (struct ec2__DescribeRegionsSetType *const*)ptr, "ec2:DescribeRegionsSetType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTasksSetType:
        return soap_out_PointerToec2__BundleInstanceTasksSetType(soap, tag, id, (struct ec2__BundleInstanceTasksSetType *const*)ptr, "ec2:BundleInstanceTasksSetType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksItemType:
        return soap_out_PointerToec2__DescribeBundleTasksItemType(soap, tag, id, (struct ec2__DescribeBundleTasksItemType *const*)ptr, "ec2:DescribeBundleTasksItemType");
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksInfoType:
        return soap_out_PointerToec2__DescribeBundleTasksInfoType(soap, tag, id, (struct ec2__DescribeBundleTasksInfoType *const*)ptr, "ec2:DescribeBundleTasksInfoType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskErrorType:
        return soap_out_PointerToec2__BundleInstanceTaskErrorType(soap, tag, id, (struct ec2__BundleInstanceTaskErrorType *const*)ptr, "ec2:BundleInstanceTaskErrorType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskType:
        return soap_out_PointerToec2__BundleInstanceTaskType(soap, tag, id, (struct ec2__BundleInstanceTaskType *const*)ptr, "ec2:BundleInstanceTaskType");
      case SOAP_TYPE_PointerToec2__BundleInstanceS3StorageType:
        return soap_out_PointerToec2__BundleInstanceS3StorageType(soap, tag, id, (struct ec2__BundleInstanceS3StorageType *const*)ptr, "ec2:BundleInstanceS3StorageType");
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskStorageType:
        return soap_out_PointerToec2__BundleInstanceTaskStorageType(soap, tag, id, (struct ec2__BundleInstanceTaskStorageType *const*)ptr, "ec2:BundleInstanceTaskStorageType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetItemResponseType:
        return soap_out_PointerToec2__DescribeSnapshotsSetItemResponseType(soap, tag, id, (struct ec2__DescribeSnapshotsSetItemResponseType *const*)ptr, "ec2:DescribeSnapshotsSetItemResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetResponseType:
        return soap_out_PointerToec2__DescribeSnapshotsSetResponseType(soap, tag, id, (struct ec2__DescribeSnapshotsSetResponseType *const*)ptr, "ec2:DescribeSnapshotsSetResponseType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetItemType:
        return soap_out_PointerToec2__DescribeSnapshotsSetItemType(soap, tag, id, (struct ec2__DescribeSnapshotsSetItemType *const*)ptr, "ec2:DescribeSnapshotsSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetType:
        return soap_out_PointerToec2__DescribeSnapshotsSetType(soap, tag, id, (struct ec2__DescribeSnapshotsSetType *const*)ptr, "ec2:DescribeSnapshotsSetType");
      case SOAP_TYPE_PointerToxsd__boolean_:
        return soap_out_PointerToxsd__boolean_(soap, tag, id, (enum xsd__boolean_ *const*)ptr, "xsd:boolean");
      case SOAP_TYPE_PointerToec2__AttachmentSetItemResponseType:
        return soap_out_PointerToec2__AttachmentSetItemResponseType(soap, tag, id, (struct ec2__AttachmentSetItemResponseType *const*)ptr, "ec2:AttachmentSetItemResponseType");
      case SOAP_TYPE_PointerToec2__AttachmentSetResponseType:
        return soap_out_PointerToec2__AttachmentSetResponseType(soap, tag, id, (struct ec2__AttachmentSetResponseType *const*)ptr, "ec2:AttachmentSetResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetItemResponseType:
        return soap_out_PointerToec2__DescribeVolumesSetItemResponseType(soap, tag, id, (struct ec2__DescribeVolumesSetItemResponseType *const*)ptr, "ec2:DescribeVolumesSetItemResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetResponseType:
        return soap_out_PointerToec2__DescribeVolumesSetResponseType(soap, tag, id, (struct ec2__DescribeVolumesSetResponseType *const*)ptr, "ec2:DescribeVolumesSetResponseType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetItemType:
        return soap_out_PointerToec2__DescribeVolumesSetItemType(soap, tag, id, (struct ec2__DescribeVolumesSetItemType *const*)ptr, "ec2:DescribeVolumesSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetType:
        return soap_out_PointerToec2__DescribeVolumesSetType(soap, tag, id, (struct ec2__DescribeVolumesSetType *const*)ptr, "ec2:DescribeVolumesSetType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseItemType:
        return soap_out_PointerToec2__DescribeAddressesResponseItemType(soap, tag, id, (struct ec2__DescribeAddressesResponseItemType *const*)ptr, "ec2:DescribeAddressesResponseItemType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseInfoType:
        return soap_out_PointerToec2__DescribeAddressesResponseInfoType(soap, tag, id, (struct ec2__DescribeAddressesResponseInfoType *const*)ptr, "ec2:DescribeAddressesResponseInfoType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesItemType:
        return soap_out_PointerToec2__DescribeAddressesItemType(soap, tag, id, (struct ec2__DescribeAddressesItemType *const*)ptr, "ec2:DescribeAddressesItemType");
      case SOAP_TYPE_PointerToec2__DescribeAddressesInfoType:
        return soap_out_PointerToec2__DescribeAddressesInfoType(soap, tag, id, (struct ec2__DescribeAddressesInfoType *const*)ptr, "ec2:DescribeAddressesInfoType");
      case SOAP_TYPE_PointerToec2__AvailabilityZoneItemType:
        return soap_out_PointerToec2__AvailabilityZoneItemType(soap, tag, id, (struct ec2__AvailabilityZoneItemType *const*)ptr, "ec2:AvailabilityZoneItemType");
      case SOAP_TYPE_PointerToec2__AvailabilityZoneSetType:
        return soap_out_PointerToec2__AvailabilityZoneSetType(soap, tag, id, (struct ec2__AvailabilityZoneSetType *const*)ptr, "ec2:AvailabilityZoneSetType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesSetItemType:
        return soap_out_PointerToec2__DescribeAvailabilityZonesSetItemType(soap, tag, id, (struct ec2__DescribeAvailabilityZonesSetItemType *const*)ptr, "ec2:DescribeAvailabilityZonesSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesSetType:
        return soap_out_PointerToec2__DescribeAvailabilityZonesSetType(soap, tag, id, (struct ec2__DescribeAvailabilityZonesSetType *const*)ptr, "ec2:DescribeAvailabilityZonesSetType");
      case SOAP_TYPE_PointerToec2__ProductCodesSetItemType:
        return soap_out_PointerToec2__ProductCodesSetItemType(soap, tag, id, (struct ec2__ProductCodesSetItemType *const*)ptr, "ec2:ProductCodesSetItemType");
      case SOAP_TYPE_PointerToec2__NullableAttributeValueType:
        return soap_out_PointerToec2__NullableAttributeValueType(soap, tag, id, (struct ec2__NullableAttributeValueType *const*)ptr, "ec2:NullableAttributeValueType");
      case SOAP_TYPE_PointerToec2__EmptyElementType:
        return soap_out_PointerToec2__EmptyElementType(soap, tag, id, (struct ec2__EmptyElementType *const*)ptr, "ec2:EmptyElementType");
      case SOAP_TYPE_PointerToec2__ProductCodeItemType:
        return soap_out_PointerToec2__ProductCodeItemType(soap, tag, id, (struct ec2__ProductCodeItemType *const*)ptr, "ec2:ProductCodeItemType");
      case SOAP_TYPE_PointerToec2__LaunchPermissionItemType:
        return soap_out_PointerToec2__LaunchPermissionItemType(soap, tag, id, (struct ec2__LaunchPermissionItemType *const*)ptr, "ec2:LaunchPermissionItemType");
      case SOAP_TYPE_PointerToec2__LaunchPermissionListType:
        return soap_out_PointerToec2__LaunchPermissionListType(soap, tag, id, (struct ec2__LaunchPermissionListType *const*)ptr, "ec2:LaunchPermissionListType");
      case SOAP_TYPE_PointerToec2__ProductCodeListType:
        return soap_out_PointerToec2__ProductCodeListType(soap, tag, id, (struct ec2__ProductCodeListType *const*)ptr, "ec2:ProductCodeListType");
      case SOAP_TYPE_PointerToec2__LaunchPermissionOperationType:
        return soap_out_PointerToec2__LaunchPermissionOperationType(soap, tag, id, (struct ec2__LaunchPermissionOperationType *const*)ptr, "ec2:LaunchPermissionOperationType");
      case SOAP_TYPE_PointerToec2__IpPermissionSetType:
        return soap_out_PointerToec2__IpPermissionSetType(soap, tag, id, (struct ec2__IpPermissionSetType *const*)ptr, "ec2:IpPermissionSetType");
      case SOAP_TYPE_PointerToec2__SecurityGroupItemType:
        return soap_out_PointerToec2__SecurityGroupItemType(soap, tag, id, (struct ec2__SecurityGroupItemType *const*)ptr, "ec2:SecurityGroupItemType");
      case SOAP_TYPE_PointerToec2__UserIdGroupPairType:
        return soap_out_PointerToec2__UserIdGroupPairType(soap, tag, id, (struct ec2__UserIdGroupPairType *const*)ptr, "ec2:UserIdGroupPairType");
      case SOAP_TYPE_PointerToec2__IpRangeItemType:
        return soap_out_PointerToec2__IpRangeItemType(soap, tag, id, (struct ec2__IpRangeItemType *const*)ptr, "ec2:IpRangeItemType");
      case SOAP_TYPE_PointerToec2__IpRangeSetType:
        return soap_out_PointerToec2__IpRangeSetType(soap, tag, id, (struct ec2__IpRangeSetType *const*)ptr, "ec2:IpRangeSetType");
      case SOAP_TYPE_PointerToec2__UserIdGroupPairSetType:
        return soap_out_PointerToec2__UserIdGroupPairSetType(soap, tag, id, (struct ec2__UserIdGroupPairSetType *const*)ptr, "ec2:UserIdGroupPairSetType");
      case SOAP_TYPE_PointerToec2__IpPermissionType:
        return soap_out_PointerToec2__IpPermissionType(soap, tag, id, (struct ec2__IpPermissionType *const*)ptr, "ec2:IpPermissionType");
      case SOAP_TYPE_PointerToec2__SecurityGroupSetType:
        return soap_out_PointerToec2__SecurityGroupSetType(soap, tag, id, (struct ec2__SecurityGroupSetType *const*)ptr, "ec2:SecurityGroupSetType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsSetItemType:
        return soap_out_PointerToec2__DescribeSecurityGroupsSetItemType(soap, tag, id, (struct ec2__DescribeSecurityGroupsSetItemType *const*)ptr, "ec2:DescribeSecurityGroupsSetItemType");
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsSetType:
        return soap_out_PointerToec2__DescribeSecurityGroupsSetType(soap, tag, id, (struct ec2__DescribeSecurityGroupsSetType *const*)ptr, "ec2:DescribeSecurityGroupsSetType");
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseItemType:
        return soap_out_PointerToec2__DescribeImagesResponseItemType(soap, tag, id, (struct ec2__DescribeImagesResponseItemType *const*)ptr, "ec2:DescribeImagesResponseItemType");
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseInfoType:
        return soap_out_PointerToec2__DescribeImagesResponseInfoType(soap, tag, id, (struct ec2__DescribeImagesResponseInfoType *const*)ptr, "ec2:DescribeImagesResponseInfoType");
      case SOAP_TYPE_PointerToec2__DescribeImagesExecutableByType:
        return soap_out_PointerToec2__DescribeImagesExecutableByType(soap, tag, id, (struct ec2__DescribeImagesExecutableByType *const*)ptr, "ec2:DescribeImagesExecutableByType");
      case SOAP_TYPE_PointerToec2__DescribeImagesOwnerType:
        return soap_out_PointerToec2__DescribeImagesOwnerType(soap, tag, id, (struct ec2__DescribeImagesOwnerType *const*)ptr, "ec2:DescribeImagesOwnerType");
      case SOAP_TYPE_PointerToec2__DescribeImagesItemType:
        return soap_out_PointerToec2__DescribeImagesItemType(soap, tag, id, (struct ec2__DescribeImagesItemType *const*)ptr, "ec2:DescribeImagesItemType");
      case SOAP_TYPE_PointerToec2__DescribeImagesOwnersType:
        return soap_out_PointerToec2__DescribeImagesOwnersType(soap, tag, id, (struct ec2__DescribeImagesOwnersType *const*)ptr, "ec2:DescribeImagesOwnersType");
      case SOAP_TYPE_PointerToec2__DescribeImagesInfoType:
        return soap_out_PointerToec2__DescribeImagesInfoType(soap, tag, id, (struct ec2__DescribeImagesInfoType *const*)ptr, "ec2:DescribeImagesInfoType");
      case SOAP_TYPE_PointerToec2__DescribeImagesExecutableBySetType:
        return soap_out_PointerToec2__DescribeImagesExecutableBySetType(soap, tag, id, (struct ec2__DescribeImagesExecutableBySetType *const*)ptr, "ec2:DescribeImagesExecutableBySetType");
      case SOAP_TYPE_PointerToec2__ReservationInfoType:
        return soap_out_PointerToec2__ReservationInfoType(soap, tag, id, (struct ec2__ReservationInfoType *const*)ptr, "ec2:ReservationInfoType");
      case SOAP_TYPE_PointerToec2__ReservationSetType:
        return soap_out_PointerToec2__ReservationSetType(soap, tag, id, (struct ec2__ReservationSetType *const*)ptr, "ec2:ReservationSetType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesItemType:
        return soap_out_PointerToec2__DescribeInstancesItemType(soap, tag, id, (struct ec2__DescribeInstancesItemType *const*)ptr, "ec2:DescribeInstancesItemType");
      case SOAP_TYPE_PointerToec2__DescribeInstancesInfoType:
        return soap_out_PointerToec2__DescribeInstancesInfoType(soap, tag, id, (struct ec2__DescribeInstancesInfoType *const*)ptr, "ec2:DescribeInstancesInfoType");
      case SOAP_TYPE_PointerToec2__RebootInstancesItemType:
        return soap_out_PointerToec2__RebootInstancesItemType(soap, tag, id, (struct ec2__RebootInstancesItemType *const*)ptr, "ec2:RebootInstancesItemType");
      case SOAP_TYPE_PointerToec2__RebootInstancesInfoType:
        return soap_out_PointerToec2__RebootInstancesInfoType(soap, tag, id, (struct ec2__RebootInstancesInfoType *const*)ptr, "ec2:RebootInstancesInfoType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseItemType:
        return soap_out_PointerToec2__TerminateInstancesResponseItemType(soap, tag, id, (struct ec2__TerminateInstancesResponseItemType *const*)ptr, "ec2:TerminateInstancesResponseItemType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseInfoType:
        return soap_out_PointerToec2__TerminateInstancesResponseInfoType(soap, tag, id, (struct ec2__TerminateInstancesResponseInfoType *const*)ptr, "ec2:TerminateInstancesResponseInfoType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesItemType:
        return soap_out_PointerToec2__TerminateInstancesItemType(soap, tag, id, (struct ec2__TerminateInstancesItemType *const*)ptr, "ec2:TerminateInstancesItemType");
      case SOAP_TYPE_PointerToec2__TerminateInstancesInfoType:
        return soap_out_PointerToec2__TerminateInstancesInfoType(soap, tag, id, (struct ec2__TerminateInstancesInfoType *const*)ptr, "ec2:TerminateInstancesInfoType");
      case SOAP_TYPE_PointerToec2__PlacementResponseType:
        return soap_out_PointerToec2__PlacementResponseType(soap, tag, id, (struct ec2__PlacementResponseType *const*)ptr, "ec2:PlacementResponseType");
      case SOAP_TYPE_PointerToec2__ProductCodesSetType:
        return soap_out_PointerToec2__ProductCodesSetType(soap, tag, id, (struct ec2__ProductCodesSetType *const*)ptr, "ec2:ProductCodesSetType");
      case SOAP_TYPE_PointerToec2__InstanceStateType:
        return soap_out_PointerToec2__InstanceStateType(soap, tag, id, (struct ec2__InstanceStateType *const*)ptr, "ec2:InstanceStateType");
      case SOAP_TYPE_PointerToec2__RunningInstancesItemType:
        return soap_out_PointerToec2__RunningInstancesItemType(soap, tag, id, (struct ec2__RunningInstancesItemType *const*)ptr, "ec2:RunningInstancesItemType");
      case SOAP_TYPE_PointerToec2__RunningInstancesSetType:
        return soap_out_PointerToec2__RunningInstancesSetType(soap, tag, id, (struct ec2__RunningInstancesSetType *const*)ptr, "ec2:RunningInstancesSetType");
      case SOAP_TYPE_PointerToec2__BlockDeviceMappingItemType:
        return soap_out_PointerToec2__BlockDeviceMappingItemType(soap, tag, id, (struct ec2__BlockDeviceMappingItemType *const*)ptr, "ec2:BlockDeviceMappingItemType");
      case SOAP_TYPE_PointerToec2__GroupItemType:
        return soap_out_PointerToec2__GroupItemType(soap, tag, id, (struct ec2__GroupItemType *const*)ptr, "ec2:GroupItemType");
      case SOAP_TYPE_PointerToec2__BlockDeviceMappingType:
        return soap_out_PointerToec2__BlockDeviceMappingType(soap, tag, id, (struct ec2__BlockDeviceMappingType *const*)ptr, "ec2:BlockDeviceMappingType");
      case SOAP_TYPE_PointerToec2__PlacementRequestType:
        return soap_out_PointerToec2__PlacementRequestType(soap, tag, id, (struct ec2__PlacementRequestType *const*)ptr, "ec2:PlacementRequestType");
      case SOAP_TYPE_PointerToec2__UserDataType:
        return soap_out_PointerToec2__UserDataType(soap, tag, id, (struct ec2__UserDataType *const*)ptr, "ec2:UserDataType");
      case SOAP_TYPE_PointerToec2__GroupSetType:
        return soap_out_PointerToec2__GroupSetType(soap, tag, id, (struct ec2__GroupSetType *const*)ptr, "ec2:GroupSetType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseItemType:
        return soap_out_PointerToec2__DescribeKeyPairsResponseItemType(soap, tag, id, (struct ec2__DescribeKeyPairsResponseItemType *const*)ptr, "ec2:DescribeKeyPairsResponseItemType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseInfoType:
        return soap_out_PointerToec2__DescribeKeyPairsResponseInfoType(soap, tag, id, (struct ec2__DescribeKeyPairsResponseInfoType *const*)ptr, "ec2:DescribeKeyPairsResponseInfoType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsItemType:
        return soap_out_PointerToec2__DescribeKeyPairsItemType(soap, tag, id, (struct ec2__DescribeKeyPairsItemType *const*)ptr, "ec2:DescribeKeyPairsItemType");
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsInfoType:
        return soap_out_PointerToec2__DescribeKeyPairsInfoType(soap, tag, id, (struct ec2__DescribeKeyPairsInfoType *const*)ptr, "ec2:DescribeKeyPairsInfoType");
      case SOAP_TYPE_PointerTo_wsse__Security:
        return soap_out_PointerTo_wsse__Security(soap, tag, id, (struct _wsse__Security *const*)ptr, "wsse:Security");
      case SOAP_TYPE_PointerTods__SignatureType:
        return soap_out_PointerTods__SignatureType(soap, tag, id, (struct ds__SignatureType *const*)ptr, "ds:SignatureType");
      case SOAP_TYPE_PointerTo_wsse__BinarySecurityToken:
        return soap_out_PointerTo_wsse__BinarySecurityToken(soap, tag, id, (struct _wsse__BinarySecurityToken *const*)ptr, "wsse:BinarySecurityToken");
      case SOAP_TYPE_PointerTo_wsse__UsernameToken:
        return soap_out_PointerTo_wsse__UsernameToken(soap, tag, id, (struct _wsse__UsernameToken *const*)ptr, "wsse:UsernameToken");
      case SOAP_TYPE_PointerTo_wsu__Timestamp:
        return soap_out_PointerTo_wsu__Timestamp(soap, tag, id, (struct _wsu__Timestamp *const*)ptr, "wsu:Timestamp");
      case SOAP_TYPE_PointerTods__X509IssuerSerialType:
        return soap_out_PointerTods__X509IssuerSerialType(soap, tag, id, (struct ds__X509IssuerSerialType *const*)ptr, "ds:X509IssuerSerialType");
      case SOAP_TYPE_PointerTods__RSAKeyValueType:
        return soap_out_PointerTods__RSAKeyValueType(soap, tag, id, (struct ds__RSAKeyValueType *const*)ptr, "ds:RSAKeyValueType");
      case SOAP_TYPE_PointerTods__DSAKeyValueType:
        return soap_out_PointerTods__DSAKeyValueType(soap, tag, id, (struct ds__DSAKeyValueType *const*)ptr, "ds:DSAKeyValueType");
      case SOAP_TYPE_PointerTods__TransformType:
        return soap_out_PointerTods__TransformType(soap, tag, id, (struct ds__TransformType *const*)ptr, "ds:TransformType");
      case SOAP_TYPE_PointerTods__DigestMethodType:
        return soap_out_PointerTods__DigestMethodType(soap, tag, id, (struct ds__DigestMethodType *const*)ptr, "ds:DigestMethodType");
      case SOAP_TYPE_PointerTods__TransformsType:
        return soap_out_PointerTods__TransformsType(soap, tag, id, (struct ds__TransformsType *const*)ptr, "ds:TransformsType");
      case SOAP_TYPE_PointerToint:
        return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
      case SOAP_TYPE_PointerToPointerTods__ReferenceType:
        return soap_out_PointerToPointerTods__ReferenceType(soap, tag, id, (struct ds__ReferenceType **const*)ptr, "ds:ReferenceType");
      case SOAP_TYPE_PointerTods__ReferenceType:
        return soap_out_PointerTods__ReferenceType(soap, tag, id, (struct ds__ReferenceType *const*)ptr, "ds:ReferenceType");
      case SOAP_TYPE_PointerTods__SignatureMethodType:
        return soap_out_PointerTods__SignatureMethodType(soap, tag, id, (struct ds__SignatureMethodType *const*)ptr, "ds:SignatureMethodType");
      case SOAP_TYPE_PointerTods__CanonicalizationMethodType:
        return soap_out_PointerTods__CanonicalizationMethodType(soap, tag, id, (struct ds__CanonicalizationMethodType *const*)ptr, "ds:CanonicalizationMethodType");
      case SOAP_TYPE_PointerTo_wsse__SecurityTokenReference:
        return soap_out_PointerTo_wsse__SecurityTokenReference(soap, tag, id, (struct _wsse__SecurityTokenReference *const*)ptr, "wsse:SecurityTokenReference");
      case SOAP_TYPE_PointerTods__X509DataType:
        return soap_out_PointerTods__X509DataType(soap, tag, id, (struct ds__X509DataType *const*)ptr, "ds:X509DataType");
      case SOAP_TYPE_PointerTods__RetrievalMethodType:
        return soap_out_PointerTods__RetrievalMethodType(soap, tag, id, (struct ds__RetrievalMethodType *const*)ptr, "ds:RetrievalMethodType");
      case SOAP_TYPE_PointerTods__KeyValueType:
        return soap_out_PointerTods__KeyValueType(soap, tag, id, (struct ds__KeyValueType *const*)ptr, "ds:KeyValueType");
      case SOAP_TYPE_PointerTo_c14n__InclusiveNamespaces:
        return soap_out_PointerTo_c14n__InclusiveNamespaces(soap, tag, id, (struct _c14n__InclusiveNamespaces *const*)ptr, "c14n:InclusiveNamespaces");
      case SOAP_TYPE_PointerTods__KeyInfoType:
        return soap_out_PointerTods__KeyInfoType(soap, tag, id, (struct ds__KeyInfoType *const*)ptr, "ds:KeyInfoType");
      case SOAP_TYPE_PointerTods__SignedInfoType:
        return soap_out_PointerTods__SignedInfoType(soap, tag, id, (struct ds__SignedInfoType *const*)ptr, "ds:SignedInfoType");
      case SOAP_TYPE_PointerTo_wsse__Embedded:
        return soap_out_PointerTo_wsse__Embedded(soap, tag, id, (struct _wsse__Embedded *const*)ptr, "wsse:Embedded");
      case SOAP_TYPE_PointerTo_wsse__KeyIdentifier:
        return soap_out_PointerTo_wsse__KeyIdentifier(soap, tag, id, (struct _wsse__KeyIdentifier *const*)ptr, "wsse:KeyIdentifier");
      case SOAP_TYPE_PointerTo_wsse__Reference:
        return soap_out_PointerTo_wsse__Reference(soap, tag, id, (struct _wsse__Reference *const*)ptr, "wsse:Reference");
      case SOAP_TYPE_PointerTo_wsse__Password:
        return soap_out_PointerTo_wsse__Password(soap, tag, id, (struct _wsse__Password *const*)ptr, "wsse:Password");
      case SOAP_TYPE__QName:
        return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
      case SOAP_TYPE_string:
        return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
      }
    return SOAP_OK;
  }
#endif

#ifndef WITH_NOIDREF
  SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
  {
    (void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
    switch (type)
      {
      case SOAP_TYPE___ec2__DescribeRegions:
        soap_serialize___ec2__DescribeRegions(soap, (const struct __ec2__DescribeRegions *)ptr);
        break;
      case SOAP_TYPE___ec2__CancelBundleTask:
        soap_serialize___ec2__CancelBundleTask(soap, (const struct __ec2__CancelBundleTask *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeBundleTasks:
        soap_serialize___ec2__DescribeBundleTasks(soap, (const struct __ec2__DescribeBundleTasks *)ptr);
        break;
      case SOAP_TYPE___ec2__BundleInstance:
        soap_serialize___ec2__BundleInstance(soap, (const struct __ec2__BundleInstance *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeSnapshots:
        soap_serialize___ec2__DescribeSnapshots(soap, (const struct __ec2__DescribeSnapshots *)ptr);
        break;
      case SOAP_TYPE___ec2__DeleteSnapshot:
        soap_serialize___ec2__DeleteSnapshot(soap, (const struct __ec2__DeleteSnapshot *)ptr);
        break;
      case SOAP_TYPE___ec2__CreateSnapshot:
        soap_serialize___ec2__CreateSnapshot(soap, (const struct __ec2__CreateSnapshot *)ptr);
        break;
      case SOAP_TYPE___ec2__DetachVolume:
        soap_serialize___ec2__DetachVolume(soap, (const struct __ec2__DetachVolume *)ptr);
        break;
      case SOAP_TYPE___ec2__AttachVolume:
        soap_serialize___ec2__AttachVolume(soap, (const struct __ec2__AttachVolume *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeVolumes:
        soap_serialize___ec2__DescribeVolumes(soap, (const struct __ec2__DescribeVolumes *)ptr);
        break;
      case SOAP_TYPE___ec2__DeleteVolume:
        soap_serialize___ec2__DeleteVolume(soap, (const struct __ec2__DeleteVolume *)ptr);
        break;
      case SOAP_TYPE___ec2__CreateVolume:
        soap_serialize___ec2__CreateVolume(soap, (const struct __ec2__CreateVolume *)ptr);
        break;
      case SOAP_TYPE___ec2__DisassociateAddress:
        soap_serialize___ec2__DisassociateAddress(soap, (const struct __ec2__DisassociateAddress *)ptr);
        break;
      case SOAP_TYPE___ec2__AssociateAddress:
        soap_serialize___ec2__AssociateAddress(soap, (const struct __ec2__AssociateAddress *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeAddresses:
        soap_serialize___ec2__DescribeAddresses(soap, (const struct __ec2__DescribeAddresses *)ptr);
        break;
      case SOAP_TYPE___ec2__ReleaseAddress:
        soap_serialize___ec2__ReleaseAddress(soap, (const struct __ec2__ReleaseAddress *)ptr);
        break;
      case SOAP_TYPE___ec2__AllocateAddress:
        soap_serialize___ec2__AllocateAddress(soap, (const struct __ec2__AllocateAddress *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeAvailabilityZones:
        soap_serialize___ec2__DescribeAvailabilityZones(soap, (const struct __ec2__DescribeAvailabilityZones *)ptr);
        break;
      case SOAP_TYPE___ec2__ConfirmProductInstance:
        soap_serialize___ec2__ConfirmProductInstance(soap, (const struct __ec2__ConfirmProductInstance *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeImageAttribute:
        soap_serialize___ec2__DescribeImageAttribute(soap, (const struct __ec2__DescribeImageAttribute *)ptr);
        break;
      case SOAP_TYPE___ec2__ResetImageAttribute:
        soap_serialize___ec2__ResetImageAttribute(soap, (const struct __ec2__ResetImageAttribute *)ptr);
        break;
      case SOAP_TYPE___ec2__ModifyImageAttribute:
        soap_serialize___ec2__ModifyImageAttribute(soap, (const struct __ec2__ModifyImageAttribute *)ptr);
        break;
      case SOAP_TYPE___ec2__RevokeSecurityGroupIngress:
        soap_serialize___ec2__RevokeSecurityGroupIngress(soap, (const struct __ec2__RevokeSecurityGroupIngress *)ptr);
        break;
      case SOAP_TYPE___ec2__AuthorizeSecurityGroupIngress:
        soap_serialize___ec2__AuthorizeSecurityGroupIngress(soap, (const struct __ec2__AuthorizeSecurityGroupIngress *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeSecurityGroups:
        soap_serialize___ec2__DescribeSecurityGroups(soap, (const struct __ec2__DescribeSecurityGroups *)ptr);
        break;
      case SOAP_TYPE___ec2__DeleteSecurityGroup:
        soap_serialize___ec2__DeleteSecurityGroup(soap, (const struct __ec2__DeleteSecurityGroup *)ptr);
        break;
      case SOAP_TYPE___ec2__CreateSecurityGroup:
        soap_serialize___ec2__CreateSecurityGroup(soap, (const struct __ec2__CreateSecurityGroup *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeImages:
        soap_serialize___ec2__DescribeImages(soap, (const struct __ec2__DescribeImages *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeInstances:
        soap_serialize___ec2__DescribeInstances(soap, (const struct __ec2__DescribeInstances *)ptr);
        break;
      case SOAP_TYPE___ec2__RebootInstances:
        soap_serialize___ec2__RebootInstances(soap, (const struct __ec2__RebootInstances *)ptr);
        break;
      case SOAP_TYPE___ec2__TerminateInstances:
        soap_serialize___ec2__TerminateInstances(soap, (const struct __ec2__TerminateInstances *)ptr);
        break;
      case SOAP_TYPE___ec2__GetConsoleOutput:
        soap_serialize___ec2__GetConsoleOutput(soap, (const struct __ec2__GetConsoleOutput *)ptr);
        break;
      case SOAP_TYPE___ec2__RunInstances:
        soap_serialize___ec2__RunInstances(soap, (const struct __ec2__RunInstances *)ptr);
        break;
      case SOAP_TYPE___ec2__DeleteKeyPair:
        soap_serialize___ec2__DeleteKeyPair(soap, (const struct __ec2__DeleteKeyPair *)ptr);
        break;
      case SOAP_TYPE___ec2__DescribeKeyPairs:
        soap_serialize___ec2__DescribeKeyPairs(soap, (const struct __ec2__DescribeKeyPairs *)ptr);
        break;
      case SOAP_TYPE___ec2__CreateKeyPair:
        soap_serialize___ec2__CreateKeyPair(soap, (const struct __ec2__CreateKeyPair *)ptr);
        break;
      case SOAP_TYPE___ec2__DeregisterImage:
        soap_serialize___ec2__DeregisterImage(soap, (const struct __ec2__DeregisterImage *)ptr);
        break;
      case SOAP_TYPE___ec2__RegisterImage:
        soap_serialize___ec2__RegisterImage(soap, (const struct __ec2__RegisterImage *)ptr);
        break;
      case SOAP_TYPE_ec2__RegionItemType:
        soap_serialize_ec2__RegionItemType(soap, (const struct ec2__RegionItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__RegionSetType:
        soap_serialize_ec2__RegionSetType(soap, (const struct ec2__RegionSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeRegionsResponseType:
        soap_serialize_ec2__DescribeRegionsResponseType(soap, (const struct ec2__DescribeRegionsResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeRegionsSetItemType:
        soap_serialize_ec2__DescribeRegionsSetItemType(soap, (const struct ec2__DescribeRegionsSetItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeRegionsSetType:
        soap_serialize_ec2__DescribeRegionsSetType(soap, (const struct ec2__DescribeRegionsSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeRegionsType:
        soap_serialize_ec2__DescribeRegionsType(soap, (const struct ec2__DescribeRegionsType *)ptr);
        break;
      case SOAP_TYPE_ec2__CancelBundleTaskResponseType:
        soap_serialize_ec2__CancelBundleTaskResponseType(soap, (const struct ec2__CancelBundleTaskResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__CancelBundleTaskType:
        soap_serialize_ec2__CancelBundleTaskType(soap, (const struct ec2__CancelBundleTaskType *)ptr);
        break;
      case SOAP_TYPE_ec2__BundleInstanceTasksSetType:
        soap_serialize_ec2__BundleInstanceTasksSetType(soap, (const struct ec2__BundleInstanceTasksSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeBundleTasksResponseType:
        soap_serialize_ec2__DescribeBundleTasksResponseType(soap, (const struct ec2__DescribeBundleTasksResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeBundleTasksItemType:
        soap_serialize_ec2__DescribeBundleTasksItemType(soap, (const struct ec2__DescribeBundleTasksItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeBundleTasksInfoType:
        soap_serialize_ec2__DescribeBundleTasksInfoType(soap, (const struct ec2__DescribeBundleTasksInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeBundleTasksType:
        soap_serialize_ec2__DescribeBundleTasksType(soap, (const struct ec2__DescribeBundleTasksType *)ptr);
        break;
      case SOAP_TYPE_ec2__BundleInstanceTaskErrorType:
        soap_serialize_ec2__BundleInstanceTaskErrorType(soap, (const struct ec2__BundleInstanceTaskErrorType *)ptr);
        break;
      case SOAP_TYPE_ec2__BundleInstanceTaskType:
        soap_serialize_ec2__BundleInstanceTaskType(soap, (const struct ec2__BundleInstanceTaskType *)ptr);
        break;
      case SOAP_TYPE_ec2__BundleInstanceResponseType:
        soap_serialize_ec2__BundleInstanceResponseType(soap, (const struct ec2__BundleInstanceResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__BundleInstanceS3StorageType:
        soap_serialize_ec2__BundleInstanceS3StorageType(soap, (const struct ec2__BundleInstanceS3StorageType *)ptr);
        break;
      case SOAP_TYPE_ec2__BundleInstanceTaskStorageType:
        soap_serialize_ec2__BundleInstanceTaskStorageType(soap, (const struct ec2__BundleInstanceTaskStorageType *)ptr);
        break;
      case SOAP_TYPE_ec2__BundleInstanceType:
        soap_serialize_ec2__BundleInstanceType(soap, (const struct ec2__BundleInstanceType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType:
        soap_serialize_ec2__DescribeSnapshotsSetItemResponseType(soap, (const struct ec2__DescribeSnapshotsSetItemResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType:
        soap_serialize_ec2__DescribeSnapshotsSetResponseType(soap, (const struct ec2__DescribeSnapshotsSetResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSnapshotsResponseType:
        soap_serialize_ec2__DescribeSnapshotsResponseType(soap, (const struct ec2__DescribeSnapshotsResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSnapshotsSetItemType:
        soap_serialize_ec2__DescribeSnapshotsSetItemType(soap, (const struct ec2__DescribeSnapshotsSetItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSnapshotsSetType:
        soap_serialize_ec2__DescribeSnapshotsSetType(soap, (const struct ec2__DescribeSnapshotsSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSnapshotsType:
        soap_serialize_ec2__DescribeSnapshotsType(soap, (const struct ec2__DescribeSnapshotsType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteSnapshotResponseType:
        soap_serialize_ec2__DeleteSnapshotResponseType(soap, (const struct ec2__DeleteSnapshotResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteSnapshotType:
        soap_serialize_ec2__DeleteSnapshotType(soap, (const struct ec2__DeleteSnapshotType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateSnapshotResponseType:
        soap_serialize_ec2__CreateSnapshotResponseType(soap, (const struct ec2__CreateSnapshotResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateSnapshotType:
        soap_serialize_ec2__CreateSnapshotType(soap, (const struct ec2__CreateSnapshotType *)ptr);
        break;
      case SOAP_TYPE_ec2__DetachVolumeResponseType:
        soap_serialize_ec2__DetachVolumeResponseType(soap, (const struct ec2__DetachVolumeResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DetachVolumeType:
        soap_serialize_ec2__DetachVolumeType(soap, (const struct ec2__DetachVolumeType *)ptr);
        break;
      case SOAP_TYPE_ec2__AttachVolumeResponseType:
        soap_serialize_ec2__AttachVolumeResponseType(soap, (const struct ec2__AttachVolumeResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__AttachVolumeType:
        soap_serialize_ec2__AttachVolumeType(soap, (const struct ec2__AttachVolumeType *)ptr);
        break;
      case SOAP_TYPE_ec2__AttachmentSetItemResponseType:
        soap_serialize_ec2__AttachmentSetItemResponseType(soap, (const struct ec2__AttachmentSetItemResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__AttachmentSetResponseType:
        soap_serialize_ec2__AttachmentSetResponseType(soap, (const struct ec2__AttachmentSetResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType:
        soap_serialize_ec2__DescribeVolumesSetItemResponseType(soap, (const struct ec2__DescribeVolumesSetItemResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeVolumesSetResponseType:
        soap_serialize_ec2__DescribeVolumesSetResponseType(soap, (const struct ec2__DescribeVolumesSetResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeVolumesResponseType:
        soap_serialize_ec2__DescribeVolumesResponseType(soap, (const struct ec2__DescribeVolumesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeVolumesSetItemType:
        soap_serialize_ec2__DescribeVolumesSetItemType(soap, (const struct ec2__DescribeVolumesSetItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeVolumesSetType:
        soap_serialize_ec2__DescribeVolumesSetType(soap, (const struct ec2__DescribeVolumesSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeVolumesType:
        soap_serialize_ec2__DescribeVolumesType(soap, (const struct ec2__DescribeVolumesType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteVolumeResponseType:
        soap_serialize_ec2__DeleteVolumeResponseType(soap, (const struct ec2__DeleteVolumeResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteVolumeType:
        soap_serialize_ec2__DeleteVolumeType(soap, (const struct ec2__DeleteVolumeType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateVolumeResponseType:
        soap_serialize_ec2__CreateVolumeResponseType(soap, (const struct ec2__CreateVolumeResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateVolumeType:
        soap_serialize_ec2__CreateVolumeType(soap, (const struct ec2__CreateVolumeType *)ptr);
        break;
      case SOAP_TYPE_ec2__DisassociateAddressResponseType:
        soap_serialize_ec2__DisassociateAddressResponseType(soap, (const struct ec2__DisassociateAddressResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DisassociateAddressType:
        soap_serialize_ec2__DisassociateAddressType(soap, (const struct ec2__DisassociateAddressType *)ptr);
        break;
      case SOAP_TYPE_ec2__AssociateAddressResponseType:
        soap_serialize_ec2__AssociateAddressResponseType(soap, (const struct ec2__AssociateAddressResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__AssociateAddressType:
        soap_serialize_ec2__AssociateAddressType(soap, (const struct ec2__AssociateAddressType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAddressesResponseItemType:
        soap_serialize_ec2__DescribeAddressesResponseItemType(soap, (const struct ec2__DescribeAddressesResponseItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAddressesResponseInfoType:
        soap_serialize_ec2__DescribeAddressesResponseInfoType(soap, (const struct ec2__DescribeAddressesResponseInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAddressesResponseType:
        soap_serialize_ec2__DescribeAddressesResponseType(soap, (const struct ec2__DescribeAddressesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAddressesItemType:
        soap_serialize_ec2__DescribeAddressesItemType(soap, (const struct ec2__DescribeAddressesItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAddressesInfoType:
        soap_serialize_ec2__DescribeAddressesInfoType(soap, (const struct ec2__DescribeAddressesInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAddressesType:
        soap_serialize_ec2__DescribeAddressesType(soap, (const struct ec2__DescribeAddressesType *)ptr);
        break;
      case SOAP_TYPE_ec2__ReleaseAddressResponseType:
        soap_serialize_ec2__ReleaseAddressResponseType(soap, (const struct ec2__ReleaseAddressResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__ReleaseAddressType:
        soap_serialize_ec2__ReleaseAddressType(soap, (const struct ec2__ReleaseAddressType *)ptr);
        break;
      case SOAP_TYPE_ec2__AllocateAddressResponseType:
        soap_serialize_ec2__AllocateAddressResponseType(soap, (const struct ec2__AllocateAddressResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__AllocateAddressType:
        soap_serialize_ec2__AllocateAddressType(soap, (const struct ec2__AllocateAddressType *)ptr);
        break;
      case SOAP_TYPE_ec2__AvailabilityZoneItemType:
        soap_serialize_ec2__AvailabilityZoneItemType(soap, (const struct ec2__AvailabilityZoneItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__AvailabilityZoneSetType:
        soap_serialize_ec2__AvailabilityZoneSetType(soap, (const struct ec2__AvailabilityZoneSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType:
        soap_serialize_ec2__DescribeAvailabilityZonesResponseType(soap, (const struct ec2__DescribeAvailabilityZonesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType:
        soap_serialize_ec2__DescribeAvailabilityZonesSetItemType(soap, (const struct ec2__DescribeAvailabilityZonesSetItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType:
        soap_serialize_ec2__DescribeAvailabilityZonesSetType(soap, (const struct ec2__DescribeAvailabilityZonesSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeAvailabilityZonesType:
        soap_serialize_ec2__DescribeAvailabilityZonesType(soap, (const struct ec2__DescribeAvailabilityZonesType *)ptr);
        break;
      case SOAP_TYPE_ec2__ConfirmProductInstanceResponseType:
        soap_serialize_ec2__ConfirmProductInstanceResponseType(soap, (const struct ec2__ConfirmProductInstanceResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__ProductCodesSetItemType:
        soap_serialize_ec2__ProductCodesSetItemType(soap, (const struct ec2__ProductCodesSetItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__ConfirmProductInstanceType:
        soap_serialize_ec2__ConfirmProductInstanceType(soap, (const struct ec2__ConfirmProductInstanceType *)ptr);
        break;
      case SOAP_TYPE_ec2__AttributeValueType:
        soap_serialize_ec2__AttributeValueType(soap, (const struct ec2__AttributeValueType *)ptr);
        break;
      case SOAP_TYPE_ec2__NullableAttributeValueType:
        soap_serialize_ec2__NullableAttributeValueType(soap, (const struct ec2__NullableAttributeValueType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImageAttributeResponseType:
        soap_serialize_ec2__DescribeImageAttributeResponseType(soap, (const struct ec2__DescribeImageAttributeResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImageAttributeType:
        soap_serialize_ec2__DescribeImageAttributeType(soap, (const struct ec2__DescribeImageAttributeType *)ptr);
        break;
      case SOAP_TYPE_ec2__ResetImageAttributeResponseType:
        soap_serialize_ec2__ResetImageAttributeResponseType(soap, (const struct ec2__ResetImageAttributeResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__EmptyElementType:
        soap_serialize_ec2__EmptyElementType(soap, (const struct ec2__EmptyElementType *)ptr);
        break;
      case SOAP_TYPE_ec2__ResetImageAttributeType:
        soap_serialize_ec2__ResetImageAttributeType(soap, (const struct ec2__ResetImageAttributeType *)ptr);
        break;
      case SOAP_TYPE_ec2__ModifyImageAttributeResponseType:
        soap_serialize_ec2__ModifyImageAttributeResponseType(soap, (const struct ec2__ModifyImageAttributeResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__ProductCodeItemType:
        soap_serialize_ec2__ProductCodeItemType(soap, (const struct ec2__ProductCodeItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__LaunchPermissionItemType:
        soap_serialize_ec2__LaunchPermissionItemType(soap, (const struct ec2__LaunchPermissionItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__LaunchPermissionListType:
        soap_serialize_ec2__LaunchPermissionListType(soap, (const struct ec2__LaunchPermissionListType *)ptr);
        break;
      case SOAP_TYPE_ec2__ProductCodeListType:
        soap_serialize_ec2__ProductCodeListType(soap, (const struct ec2__ProductCodeListType *)ptr);
        break;
      case SOAP_TYPE_ec2__LaunchPermissionOperationType:
        soap_serialize_ec2__LaunchPermissionOperationType(soap, (const struct ec2__LaunchPermissionOperationType *)ptr);
        break;
      case SOAP_TYPE_ec2__ModifyImageAttributeType:
        soap_serialize_ec2__ModifyImageAttributeType(soap, (const struct ec2__ModifyImageAttributeType *)ptr);
        break;
      case SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType:
        soap_serialize_ec2__RevokeSecurityGroupIngressResponseType(soap, (const struct ec2__RevokeSecurityGroupIngressResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__RevokeSecurityGroupIngressType:
        soap_serialize_ec2__RevokeSecurityGroupIngressType(soap, (const struct ec2__RevokeSecurityGroupIngressType *)ptr);
        break;
      case SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType:
        soap_serialize_ec2__AuthorizeSecurityGroupIngressResponseType(soap, (const struct ec2__AuthorizeSecurityGroupIngressResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType:
        soap_serialize_ec2__AuthorizeSecurityGroupIngressType(soap, (const struct ec2__AuthorizeSecurityGroupIngressType *)ptr);
        break;
      case SOAP_TYPE_ec2__SecurityGroupItemType:
        soap_serialize_ec2__SecurityGroupItemType(soap, (const struct ec2__SecurityGroupItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__UserIdGroupPairType:
        soap_serialize_ec2__UserIdGroupPairType(soap, (const struct ec2__UserIdGroupPairType *)ptr);
        break;
      case SOAP_TYPE_ec2__IpRangeItemType:
        soap_serialize_ec2__IpRangeItemType(soap, (const struct ec2__IpRangeItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__IpRangeSetType:
        soap_serialize_ec2__IpRangeSetType(soap, (const struct ec2__IpRangeSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__UserIdGroupPairSetType:
        soap_serialize_ec2__UserIdGroupPairSetType(soap, (const struct ec2__UserIdGroupPairSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__IpPermissionType:
        soap_serialize_ec2__IpPermissionType(soap, (const struct ec2__IpPermissionType *)ptr);
        break;
      case SOAP_TYPE_ec2__IpPermissionSetType:
        soap_serialize_ec2__IpPermissionSetType(soap, (const struct ec2__IpPermissionSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__SecurityGroupSetType:
        soap_serialize_ec2__SecurityGroupSetType(soap, (const struct ec2__SecurityGroupSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType:
        soap_serialize_ec2__DescribeSecurityGroupsResponseType(soap, (const struct ec2__DescribeSecurityGroupsResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType:
        soap_serialize_ec2__DescribeSecurityGroupsSetItemType(soap, (const struct ec2__DescribeSecurityGroupsSetItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSecurityGroupsSetType:
        soap_serialize_ec2__DescribeSecurityGroupsSetType(soap, (const struct ec2__DescribeSecurityGroupsSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeSecurityGroupsType:
        soap_serialize_ec2__DescribeSecurityGroupsType(soap, (const struct ec2__DescribeSecurityGroupsType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteSecurityGroupResponseType:
        soap_serialize_ec2__DeleteSecurityGroupResponseType(soap, (const struct ec2__DeleteSecurityGroupResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteSecurityGroupType:
        soap_serialize_ec2__DeleteSecurityGroupType(soap, (const struct ec2__DeleteSecurityGroupType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateSecurityGroupResponseType:
        soap_serialize_ec2__CreateSecurityGroupResponseType(soap, (const struct ec2__CreateSecurityGroupResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateSecurityGroupType:
        soap_serialize_ec2__CreateSecurityGroupType(soap, (const struct ec2__CreateSecurityGroupType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesResponseItemType:
        soap_serialize_ec2__DescribeImagesResponseItemType(soap, (const struct ec2__DescribeImagesResponseItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesResponseInfoType:
        soap_serialize_ec2__DescribeImagesResponseInfoType(soap, (const struct ec2__DescribeImagesResponseInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesResponseType:
        soap_serialize_ec2__DescribeImagesResponseType(soap, (const struct ec2__DescribeImagesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesExecutableByType:
        soap_serialize_ec2__DescribeImagesExecutableByType(soap, (const struct ec2__DescribeImagesExecutableByType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesOwnerType:
        soap_serialize_ec2__DescribeImagesOwnerType(soap, (const struct ec2__DescribeImagesOwnerType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesItemType:
        soap_serialize_ec2__DescribeImagesItemType(soap, (const struct ec2__DescribeImagesItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesOwnersType:
        soap_serialize_ec2__DescribeImagesOwnersType(soap, (const struct ec2__DescribeImagesOwnersType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesInfoType:
        soap_serialize_ec2__DescribeImagesInfoType(soap, (const struct ec2__DescribeImagesInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesExecutableBySetType:
        soap_serialize_ec2__DescribeImagesExecutableBySetType(soap, (const struct ec2__DescribeImagesExecutableBySetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeImagesType:
        soap_serialize_ec2__DescribeImagesType(soap, (const struct ec2__DescribeImagesType *)ptr);
        break;
      case SOAP_TYPE_ec2__ReservationSetType:
        soap_serialize_ec2__ReservationSetType(soap, (const struct ec2__ReservationSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeInstancesResponseType:
        soap_serialize_ec2__DescribeInstancesResponseType(soap, (const struct ec2__DescribeInstancesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeInstancesItemType:
        soap_serialize_ec2__DescribeInstancesItemType(soap, (const struct ec2__DescribeInstancesItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeInstancesInfoType:
        soap_serialize_ec2__DescribeInstancesInfoType(soap, (const struct ec2__DescribeInstancesInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeInstancesType:
        soap_serialize_ec2__DescribeInstancesType(soap, (const struct ec2__DescribeInstancesType *)ptr);
        break;
      case SOAP_TYPE_ec2__RebootInstancesResponseType:
        soap_serialize_ec2__RebootInstancesResponseType(soap, (const struct ec2__RebootInstancesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__RebootInstancesItemType:
        soap_serialize_ec2__RebootInstancesItemType(soap, (const struct ec2__RebootInstancesItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__RebootInstancesInfoType:
        soap_serialize_ec2__RebootInstancesInfoType(soap, (const struct ec2__RebootInstancesInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__RebootInstancesType:
        soap_serialize_ec2__RebootInstancesType(soap, (const struct ec2__RebootInstancesType *)ptr);
        break;
      case SOAP_TYPE_ec2__TerminateInstancesResponseItemType:
        soap_serialize_ec2__TerminateInstancesResponseItemType(soap, (const struct ec2__TerminateInstancesResponseItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__TerminateInstancesResponseInfoType:
        soap_serialize_ec2__TerminateInstancesResponseInfoType(soap, (const struct ec2__TerminateInstancesResponseInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__TerminateInstancesResponseType:
        soap_serialize_ec2__TerminateInstancesResponseType(soap, (const struct ec2__TerminateInstancesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__TerminateInstancesItemType:
        soap_serialize_ec2__TerminateInstancesItemType(soap, (const struct ec2__TerminateInstancesItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__TerminateInstancesInfoType:
        soap_serialize_ec2__TerminateInstancesInfoType(soap, (const struct ec2__TerminateInstancesInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__TerminateInstancesType:
        soap_serialize_ec2__TerminateInstancesType(soap, (const struct ec2__TerminateInstancesType *)ptr);
        break;
      case SOAP_TYPE_ec2__GetConsoleOutputResponseType:
        soap_serialize_ec2__GetConsoleOutputResponseType(soap, (const struct ec2__GetConsoleOutputResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__GetConsoleOutputType:
        soap_serialize_ec2__GetConsoleOutputType(soap, (const struct ec2__GetConsoleOutputType *)ptr);
        break;
      case SOAP_TYPE_ec2__PlacementResponseType:
        soap_serialize_ec2__PlacementResponseType(soap, (const struct ec2__PlacementResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__ProductCodesSetType:
        soap_serialize_ec2__ProductCodesSetType(soap, (const struct ec2__ProductCodesSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__InstanceStateType:
        soap_serialize_ec2__InstanceStateType(soap, (const struct ec2__InstanceStateType *)ptr);
        break;
      case SOAP_TYPE_ec2__RunningInstancesItemType:
        soap_serialize_ec2__RunningInstancesItemType(soap, (const struct ec2__RunningInstancesItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__ReservationInfoType:
        soap_serialize_ec2__ReservationInfoType(soap, (const struct ec2__ReservationInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__RunningInstancesSetType:
        soap_serialize_ec2__RunningInstancesSetType(soap, (const struct ec2__RunningInstancesSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__RunInstancesResponseType:
        soap_serialize_ec2__RunInstancesResponseType(soap, (const struct ec2__RunInstancesResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__BlockDeviceMappingItemType:
        soap_serialize_ec2__BlockDeviceMappingItemType(soap, (const struct ec2__BlockDeviceMappingItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__GroupItemType:
        soap_serialize_ec2__GroupItemType(soap, (const struct ec2__GroupItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__BlockDeviceMappingType:
        soap_serialize_ec2__BlockDeviceMappingType(soap, (const struct ec2__BlockDeviceMappingType *)ptr);
        break;
      case SOAP_TYPE_ec2__PlacementRequestType:
        soap_serialize_ec2__PlacementRequestType(soap, (const struct ec2__PlacementRequestType *)ptr);
        break;
      case SOAP_TYPE_ec2__UserDataType:
        soap_serialize_ec2__UserDataType(soap, (const struct ec2__UserDataType *)ptr);
        break;
      case SOAP_TYPE_ec2__GroupSetType:
        soap_serialize_ec2__GroupSetType(soap, (const struct ec2__GroupSetType *)ptr);
        break;
      case SOAP_TYPE_ec2__RunInstancesType:
        soap_serialize_ec2__RunInstancesType(soap, (const struct ec2__RunInstancesType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseItemType:
        soap_serialize_ec2__DescribeKeyPairsResponseItemType(soap, (const struct ec2__DescribeKeyPairsResponseItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseInfoType:
        soap_serialize_ec2__DescribeKeyPairsResponseInfoType(soap, (const struct ec2__DescribeKeyPairsResponseInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeKeyPairsResponseType:
        soap_serialize_ec2__DescribeKeyPairsResponseType(soap, (const struct ec2__DescribeKeyPairsResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeKeyPairsItemType:
        soap_serialize_ec2__DescribeKeyPairsItemType(soap, (const struct ec2__DescribeKeyPairsItemType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeKeyPairsInfoType:
        soap_serialize_ec2__DescribeKeyPairsInfoType(soap, (const struct ec2__DescribeKeyPairsInfoType *)ptr);
        break;
      case SOAP_TYPE_ec2__DescribeKeyPairsType:
        soap_serialize_ec2__DescribeKeyPairsType(soap, (const struct ec2__DescribeKeyPairsType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteKeyPairResponseType:
        soap_serialize_ec2__DeleteKeyPairResponseType(soap, (const struct ec2__DeleteKeyPairResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeleteKeyPairType:
        soap_serialize_ec2__DeleteKeyPairType(soap, (const struct ec2__DeleteKeyPairType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateKeyPairResponseType:
        soap_serialize_ec2__CreateKeyPairResponseType(soap, (const struct ec2__CreateKeyPairResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__CreateKeyPairType:
        soap_serialize_ec2__CreateKeyPairType(soap, (const struct ec2__CreateKeyPairType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeregisterImageResponseType:
        soap_serialize_ec2__DeregisterImageResponseType(soap, (const struct ec2__DeregisterImageResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__DeregisterImageType:
        soap_serialize_ec2__DeregisterImageType(soap, (const struct ec2__DeregisterImageType *)ptr);
        break;
      case SOAP_TYPE_ec2__RegisterImageResponseType:
        soap_serialize_ec2__RegisterImageResponseType(soap, (const struct ec2__RegisterImageResponseType *)ptr);
        break;
      case SOAP_TYPE_ec2__RegisterImageType:
        soap_serialize_ec2__RegisterImageType(soap, (const struct ec2__RegisterImageType *)ptr);
        break;
      case SOAP_TYPE__wsse__Security:
        soap_serialize__wsse__Security(soap, (const struct _wsse__Security *)ptr);
        break;
      case SOAP_TYPE_ds__RSAKeyValueType:
        soap_serialize_ds__RSAKeyValueType(soap, (const struct ds__RSAKeyValueType *)ptr);
        break;
      case SOAP_TYPE_ds__DSAKeyValueType:
        soap_serialize_ds__DSAKeyValueType(soap, (const struct ds__DSAKeyValueType *)ptr);
        break;
      case SOAP_TYPE_ds__X509IssuerSerialType:
        soap_serialize_ds__X509IssuerSerialType(soap, (const struct ds__X509IssuerSerialType *)ptr);
        break;
      case SOAP_TYPE_ds__X509DataType:
        soap_serialize_ds__X509DataType(soap, (const struct ds__X509DataType *)ptr);
        break;
      case SOAP_TYPE_ds__RetrievalMethodType:
        soap_serialize_ds__RetrievalMethodType(soap, (const struct ds__RetrievalMethodType *)ptr);
        break;
      case SOAP_TYPE_ds__KeyValueType:
        soap_serialize_ds__KeyValueType(soap, (const struct ds__KeyValueType *)ptr);
        break;
      case SOAP_TYPE_ds__DigestMethodType:
        soap_serialize_ds__DigestMethodType(soap, (const struct ds__DigestMethodType *)ptr);
        break;
      case SOAP_TYPE_ds__TransformType:
        soap_serialize_ds__TransformType(soap, (const struct ds__TransformType *)ptr);
        break;
      case SOAP_TYPE__c14n__InclusiveNamespaces:
        soap_serialize__c14n__InclusiveNamespaces(soap, (const struct _c14n__InclusiveNamespaces *)ptr);
        break;
      case SOAP_TYPE_ds__TransformsType:
        soap_serialize_ds__TransformsType(soap, (const struct ds__TransformsType *)ptr);
        break;
      case SOAP_TYPE_ds__ReferenceType:
        soap_serialize_ds__ReferenceType(soap, (const struct ds__ReferenceType *)ptr);
        break;
      case SOAP_TYPE_ds__SignatureMethodType:
        soap_serialize_ds__SignatureMethodType(soap, (const struct ds__SignatureMethodType *)ptr);
        break;
      case SOAP_TYPE_ds__CanonicalizationMethodType:
        soap_serialize_ds__CanonicalizationMethodType(soap, (const struct ds__CanonicalizationMethodType *)ptr);
        break;
      case SOAP_TYPE_ds__KeyInfoType:
        soap_serialize_ds__KeyInfoType(soap, (const struct ds__KeyInfoType *)ptr);
        break;
      case SOAP_TYPE_ds__SignedInfoType:
        soap_serialize_ds__SignedInfoType(soap, (const struct ds__SignedInfoType *)ptr);
        break;
      case SOAP_TYPE_ds__SignatureType:
        soap_serialize_ds__SignatureType(soap, (const struct ds__SignatureType *)ptr);
        break;
      case SOAP_TYPE__wsse__SecurityTokenReference:
        soap_serialize__wsse__SecurityTokenReference(soap, (const struct _wsse__SecurityTokenReference *)ptr);
        break;
      case SOAP_TYPE__wsse__KeyIdentifier:
        soap_serialize__wsse__KeyIdentifier(soap, (const struct _wsse__KeyIdentifier *)ptr);
        break;
      case SOAP_TYPE__wsse__Embedded:
        soap_serialize__wsse__Embedded(soap, (const struct _wsse__Embedded *)ptr);
        break;
      case SOAP_TYPE__wsse__Reference:
        soap_serialize__wsse__Reference(soap, (const struct _wsse__Reference *)ptr);
        break;
      case SOAP_TYPE__wsse__BinarySecurityToken:
        soap_serialize__wsse__BinarySecurityToken(soap, (const struct _wsse__BinarySecurityToken *)ptr);
        break;
      case SOAP_TYPE__wsse__Password:
        soap_serialize__wsse__Password(soap, (const struct _wsse__Password *)ptr);
        break;
      case SOAP_TYPE__wsse__UsernameToken:
        soap_serialize__wsse__UsernameToken(soap, (const struct _wsse__UsernameToken *)ptr);
        break;
      case SOAP_TYPE__wsu__Timestamp:
        soap_serialize__wsu__Timestamp(soap, (const struct _wsu__Timestamp *)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeRegionsResponseType:
        soap_serialize_PointerToec2__DescribeRegionsResponseType(soap, (struct ec2__DescribeRegionsResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeRegionsType:
        soap_serialize_PointerToec2__DescribeRegionsType(soap, (struct ec2__DescribeRegionsType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CancelBundleTaskResponseType:
        soap_serialize_PointerToec2__CancelBundleTaskResponseType(soap, (struct ec2__CancelBundleTaskResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CancelBundleTaskType:
        soap_serialize_PointerToec2__CancelBundleTaskType(soap, (struct ec2__CancelBundleTaskType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksResponseType:
        soap_serialize_PointerToec2__DescribeBundleTasksResponseType(soap, (struct ec2__DescribeBundleTasksResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksType:
        soap_serialize_PointerToec2__DescribeBundleTasksType(soap, (struct ec2__DescribeBundleTasksType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BundleInstanceResponseType:
        soap_serialize_PointerToec2__BundleInstanceResponseType(soap, (struct ec2__BundleInstanceResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BundleInstanceType:
        soap_serialize_PointerToec2__BundleInstanceType(soap, (struct ec2__BundleInstanceType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsResponseType:
        soap_serialize_PointerToec2__DescribeSnapshotsResponseType(soap, (struct ec2__DescribeSnapshotsResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsType:
        soap_serialize_PointerToec2__DescribeSnapshotsType(soap, (struct ec2__DescribeSnapshotsType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteSnapshotResponseType:
        soap_serialize_PointerToec2__DeleteSnapshotResponseType(soap, (struct ec2__DeleteSnapshotResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteSnapshotType:
        soap_serialize_PointerToec2__DeleteSnapshotType(soap, (struct ec2__DeleteSnapshotType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateSnapshotResponseType:
        soap_serialize_PointerToec2__CreateSnapshotResponseType(soap, (struct ec2__CreateSnapshotResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateSnapshotType:
        soap_serialize_PointerToec2__CreateSnapshotType(soap, (struct ec2__CreateSnapshotType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DetachVolumeResponseType:
        soap_serialize_PointerToec2__DetachVolumeResponseType(soap, (struct ec2__DetachVolumeResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DetachVolumeType:
        soap_serialize_PointerToec2__DetachVolumeType(soap, (struct ec2__DetachVolumeType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AttachVolumeResponseType:
        soap_serialize_PointerToec2__AttachVolumeResponseType(soap, (struct ec2__AttachVolumeResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AttachVolumeType:
        soap_serialize_PointerToec2__AttachVolumeType(soap, (struct ec2__AttachVolumeType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeVolumesResponseType:
        soap_serialize_PointerToec2__DescribeVolumesResponseType(soap, (struct ec2__DescribeVolumesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeVolumesType:
        soap_serialize_PointerToec2__DescribeVolumesType(soap, (struct ec2__DescribeVolumesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteVolumeResponseType:
        soap_serialize_PointerToec2__DeleteVolumeResponseType(soap, (struct ec2__DeleteVolumeResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteVolumeType:
        soap_serialize_PointerToec2__DeleteVolumeType(soap, (struct ec2__DeleteVolumeType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateVolumeResponseType:
        soap_serialize_PointerToec2__CreateVolumeResponseType(soap, (struct ec2__CreateVolumeResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateVolumeType:
        soap_serialize_PointerToec2__CreateVolumeType(soap, (struct ec2__CreateVolumeType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DisassociateAddressResponseType:
        soap_serialize_PointerToec2__DisassociateAddressResponseType(soap, (struct ec2__DisassociateAddressResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DisassociateAddressType:
        soap_serialize_PointerToec2__DisassociateAddressType(soap, (struct ec2__DisassociateAddressType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AssociateAddressResponseType:
        soap_serialize_PointerToec2__AssociateAddressResponseType(soap, (struct ec2__AssociateAddressResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AssociateAddressType:
        soap_serialize_PointerToec2__AssociateAddressType(soap, (struct ec2__AssociateAddressType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseType:
        soap_serialize_PointerToec2__DescribeAddressesResponseType(soap, (struct ec2__DescribeAddressesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAddressesType:
        soap_serialize_PointerToec2__DescribeAddressesType(soap, (struct ec2__DescribeAddressesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ReleaseAddressResponseType:
        soap_serialize_PointerToec2__ReleaseAddressResponseType(soap, (struct ec2__ReleaseAddressResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ReleaseAddressType:
        soap_serialize_PointerToec2__ReleaseAddressType(soap, (struct ec2__ReleaseAddressType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AllocateAddressResponseType:
        soap_serialize_PointerToec2__AllocateAddressResponseType(soap, (struct ec2__AllocateAddressResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AllocateAddressType:
        soap_serialize_PointerToec2__AllocateAddressType(soap, (struct ec2__AllocateAddressType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesResponseType:
        soap_serialize_PointerToec2__DescribeAvailabilityZonesResponseType(soap, (struct ec2__DescribeAvailabilityZonesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesType:
        soap_serialize_PointerToec2__DescribeAvailabilityZonesType(soap, (struct ec2__DescribeAvailabilityZonesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ConfirmProductInstanceResponseType:
        soap_serialize_PointerToec2__ConfirmProductInstanceResponseType(soap, (struct ec2__ConfirmProductInstanceResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ConfirmProductInstanceType:
        soap_serialize_PointerToec2__ConfirmProductInstanceType(soap, (struct ec2__ConfirmProductInstanceType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImageAttributeResponseType:
        soap_serialize_PointerToec2__DescribeImageAttributeResponseType(soap, (struct ec2__DescribeImageAttributeResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImageAttributeType:
        soap_serialize_PointerToec2__DescribeImageAttributeType(soap, (struct ec2__DescribeImageAttributeType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ResetImageAttributeResponseType:
        soap_serialize_PointerToec2__ResetImageAttributeResponseType(soap, (struct ec2__ResetImageAttributeResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ResetImageAttributeType:
        soap_serialize_PointerToec2__ResetImageAttributeType(soap, (struct ec2__ResetImageAttributeType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ModifyImageAttributeResponseType:
        soap_serialize_PointerToec2__ModifyImageAttributeResponseType(soap, (struct ec2__ModifyImageAttributeResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ModifyImageAttributeType:
        soap_serialize_PointerToec2__ModifyImageAttributeType(soap, (struct ec2__ModifyImageAttributeType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RevokeSecurityGroupIngressResponseType:
        soap_serialize_PointerToec2__RevokeSecurityGroupIngressResponseType(soap, (struct ec2__RevokeSecurityGroupIngressResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RevokeSecurityGroupIngressType:
        soap_serialize_PointerToec2__RevokeSecurityGroupIngressType(soap, (struct ec2__RevokeSecurityGroupIngressType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AuthorizeSecurityGroupIngressResponseType:
        soap_serialize_PointerToec2__AuthorizeSecurityGroupIngressResponseType(soap, (struct ec2__AuthorizeSecurityGroupIngressResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AuthorizeSecurityGroupIngressType:
        soap_serialize_PointerToec2__AuthorizeSecurityGroupIngressType(soap, (struct ec2__AuthorizeSecurityGroupIngressType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsResponseType:
        soap_serialize_PointerToec2__DescribeSecurityGroupsResponseType(soap, (struct ec2__DescribeSecurityGroupsResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsType:
        soap_serialize_PointerToec2__DescribeSecurityGroupsType(soap, (struct ec2__DescribeSecurityGroupsType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteSecurityGroupResponseType:
        soap_serialize_PointerToec2__DeleteSecurityGroupResponseType(soap, (struct ec2__DeleteSecurityGroupResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteSecurityGroupType:
        soap_serialize_PointerToec2__DeleteSecurityGroupType(soap, (struct ec2__DeleteSecurityGroupType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateSecurityGroupResponseType:
        soap_serialize_PointerToec2__CreateSecurityGroupResponseType(soap, (struct ec2__CreateSecurityGroupResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateSecurityGroupType:
        soap_serialize_PointerToec2__CreateSecurityGroupType(soap, (struct ec2__CreateSecurityGroupType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseType:
        soap_serialize_PointerToec2__DescribeImagesResponseType(soap, (struct ec2__DescribeImagesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesType:
        soap_serialize_PointerToec2__DescribeImagesType(soap, (struct ec2__DescribeImagesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeInstancesResponseType:
        soap_serialize_PointerToec2__DescribeInstancesResponseType(soap, (struct ec2__DescribeInstancesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeInstancesType:
        soap_serialize_PointerToec2__DescribeInstancesType(soap, (struct ec2__DescribeInstancesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RebootInstancesResponseType:
        soap_serialize_PointerToec2__RebootInstancesResponseType(soap, (struct ec2__RebootInstancesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RebootInstancesType:
        soap_serialize_PointerToec2__RebootInstancesType(soap, (struct ec2__RebootInstancesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseType:
        soap_serialize_PointerToec2__TerminateInstancesResponseType(soap, (struct ec2__TerminateInstancesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__TerminateInstancesType:
        soap_serialize_PointerToec2__TerminateInstancesType(soap, (struct ec2__TerminateInstancesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__GetConsoleOutputResponseType:
        soap_serialize_PointerToec2__GetConsoleOutputResponseType(soap, (struct ec2__GetConsoleOutputResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__GetConsoleOutputType:
        soap_serialize_PointerToec2__GetConsoleOutputType(soap, (struct ec2__GetConsoleOutputType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RunInstancesResponseType:
        soap_serialize_PointerToec2__RunInstancesResponseType(soap, (struct ec2__RunInstancesResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RunInstancesType:
        soap_serialize_PointerToec2__RunInstancesType(soap, (struct ec2__RunInstancesType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteKeyPairResponseType:
        soap_serialize_PointerToec2__DeleteKeyPairResponseType(soap, (struct ec2__DeleteKeyPairResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeleteKeyPairType:
        soap_serialize_PointerToec2__DeleteKeyPairType(soap, (struct ec2__DeleteKeyPairType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseType:
        soap_serialize_PointerToec2__DescribeKeyPairsResponseType(soap, (struct ec2__DescribeKeyPairsResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsType:
        soap_serialize_PointerToec2__DescribeKeyPairsType(soap, (struct ec2__DescribeKeyPairsType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateKeyPairResponseType:
        soap_serialize_PointerToec2__CreateKeyPairResponseType(soap, (struct ec2__CreateKeyPairResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__CreateKeyPairType:
        soap_serialize_PointerToec2__CreateKeyPairType(soap, (struct ec2__CreateKeyPairType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeregisterImageResponseType:
        soap_serialize_PointerToec2__DeregisterImageResponseType(soap, (struct ec2__DeregisterImageResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DeregisterImageType:
        soap_serialize_PointerToec2__DeregisterImageType(soap, (struct ec2__DeregisterImageType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RegisterImageResponseType:
        soap_serialize_PointerToec2__RegisterImageResponseType(soap, (struct ec2__RegisterImageResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RegisterImageType:
        soap_serialize_PointerToec2__RegisterImageType(soap, (struct ec2__RegisterImageType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RegionItemType:
        soap_serialize_PointerToec2__RegionItemType(soap, (struct ec2__RegionItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RegionSetType:
        soap_serialize_PointerToec2__RegionSetType(soap, (struct ec2__RegionSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeRegionsSetItemType:
        soap_serialize_PointerToec2__DescribeRegionsSetItemType(soap, (struct ec2__DescribeRegionsSetItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeRegionsSetType:
        soap_serialize_PointerToec2__DescribeRegionsSetType(soap, (struct ec2__DescribeRegionsSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BundleInstanceTasksSetType:
        soap_serialize_PointerToec2__BundleInstanceTasksSetType(soap, (struct ec2__BundleInstanceTasksSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksItemType:
        soap_serialize_PointerToec2__DescribeBundleTasksItemType(soap, (struct ec2__DescribeBundleTasksItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeBundleTasksInfoType:
        soap_serialize_PointerToec2__DescribeBundleTasksInfoType(soap, (struct ec2__DescribeBundleTasksInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskErrorType:
        soap_serialize_PointerToec2__BundleInstanceTaskErrorType(soap, (struct ec2__BundleInstanceTaskErrorType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskType:
        soap_serialize_PointerToec2__BundleInstanceTaskType(soap, (struct ec2__BundleInstanceTaskType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BundleInstanceS3StorageType:
        soap_serialize_PointerToec2__BundleInstanceS3StorageType(soap, (struct ec2__BundleInstanceS3StorageType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BundleInstanceTaskStorageType:
        soap_serialize_PointerToec2__BundleInstanceTaskStorageType(soap, (struct ec2__BundleInstanceTaskStorageType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetItemResponseType:
        soap_serialize_PointerToec2__DescribeSnapshotsSetItemResponseType(soap, (struct ec2__DescribeSnapshotsSetItemResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetResponseType:
        soap_serialize_PointerToec2__DescribeSnapshotsSetResponseType(soap, (struct ec2__DescribeSnapshotsSetResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetItemType:
        soap_serialize_PointerToec2__DescribeSnapshotsSetItemType(soap, (struct ec2__DescribeSnapshotsSetItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSnapshotsSetType:
        soap_serialize_PointerToec2__DescribeSnapshotsSetType(soap, (struct ec2__DescribeSnapshotsSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToxsd__boolean_:
        soap_serialize_PointerToxsd__boolean_(soap, (enum xsd__boolean_ *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AttachmentSetItemResponseType:
        soap_serialize_PointerToec2__AttachmentSetItemResponseType(soap, (struct ec2__AttachmentSetItemResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AttachmentSetResponseType:
        soap_serialize_PointerToec2__AttachmentSetResponseType(soap, (struct ec2__AttachmentSetResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetItemResponseType:
        soap_serialize_PointerToec2__DescribeVolumesSetItemResponseType(soap, (struct ec2__DescribeVolumesSetItemResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetResponseType:
        soap_serialize_PointerToec2__DescribeVolumesSetResponseType(soap, (struct ec2__DescribeVolumesSetResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetItemType:
        soap_serialize_PointerToec2__DescribeVolumesSetItemType(soap, (struct ec2__DescribeVolumesSetItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeVolumesSetType:
        soap_serialize_PointerToec2__DescribeVolumesSetType(soap, (struct ec2__DescribeVolumesSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseItemType:
        soap_serialize_PointerToec2__DescribeAddressesResponseItemType(soap, (struct ec2__DescribeAddressesResponseItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAddressesResponseInfoType:
        soap_serialize_PointerToec2__DescribeAddressesResponseInfoType(soap, (struct ec2__DescribeAddressesResponseInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAddressesItemType:
        soap_serialize_PointerToec2__DescribeAddressesItemType(soap, (struct ec2__DescribeAddressesItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAddressesInfoType:
        soap_serialize_PointerToec2__DescribeAddressesInfoType(soap, (struct ec2__DescribeAddressesInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AvailabilityZoneItemType:
        soap_serialize_PointerToec2__AvailabilityZoneItemType(soap, (struct ec2__AvailabilityZoneItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__AvailabilityZoneSetType:
        soap_serialize_PointerToec2__AvailabilityZoneSetType(soap, (struct ec2__AvailabilityZoneSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesSetItemType:
        soap_serialize_PointerToec2__DescribeAvailabilityZonesSetItemType(soap, (struct ec2__DescribeAvailabilityZonesSetItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeAvailabilityZonesSetType:
        soap_serialize_PointerToec2__DescribeAvailabilityZonesSetType(soap, (struct ec2__DescribeAvailabilityZonesSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ProductCodesSetItemType:
        soap_serialize_PointerToec2__ProductCodesSetItemType(soap, (struct ec2__ProductCodesSetItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__NullableAttributeValueType:
        soap_serialize_PointerToec2__NullableAttributeValueType(soap, (struct ec2__NullableAttributeValueType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__EmptyElementType:
        soap_serialize_PointerToec2__EmptyElementType(soap, (struct ec2__EmptyElementType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ProductCodeItemType:
        soap_serialize_PointerToec2__ProductCodeItemType(soap, (struct ec2__ProductCodeItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__LaunchPermissionItemType:
        soap_serialize_PointerToec2__LaunchPermissionItemType(soap, (struct ec2__LaunchPermissionItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__LaunchPermissionListType:
        soap_serialize_PointerToec2__LaunchPermissionListType(soap, (struct ec2__LaunchPermissionListType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ProductCodeListType:
        soap_serialize_PointerToec2__ProductCodeListType(soap, (struct ec2__ProductCodeListType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__LaunchPermissionOperationType:
        soap_serialize_PointerToec2__LaunchPermissionOperationType(soap, (struct ec2__LaunchPermissionOperationType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__IpPermissionSetType:
        soap_serialize_PointerToec2__IpPermissionSetType(soap, (struct ec2__IpPermissionSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__SecurityGroupItemType:
        soap_serialize_PointerToec2__SecurityGroupItemType(soap, (struct ec2__SecurityGroupItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__UserIdGroupPairType:
        soap_serialize_PointerToec2__UserIdGroupPairType(soap, (struct ec2__UserIdGroupPairType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__IpRangeItemType:
        soap_serialize_PointerToec2__IpRangeItemType(soap, (struct ec2__IpRangeItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__IpRangeSetType:
        soap_serialize_PointerToec2__IpRangeSetType(soap, (struct ec2__IpRangeSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__UserIdGroupPairSetType:
        soap_serialize_PointerToec2__UserIdGroupPairSetType(soap, (struct ec2__UserIdGroupPairSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__IpPermissionType:
        soap_serialize_PointerToec2__IpPermissionType(soap, (struct ec2__IpPermissionType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__SecurityGroupSetType:
        soap_serialize_PointerToec2__SecurityGroupSetType(soap, (struct ec2__SecurityGroupSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsSetItemType:
        soap_serialize_PointerToec2__DescribeSecurityGroupsSetItemType(soap, (struct ec2__DescribeSecurityGroupsSetItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeSecurityGroupsSetType:
        soap_serialize_PointerToec2__DescribeSecurityGroupsSetType(soap, (struct ec2__DescribeSecurityGroupsSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseItemType:
        soap_serialize_PointerToec2__DescribeImagesResponseItemType(soap, (struct ec2__DescribeImagesResponseItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesResponseInfoType:
        soap_serialize_PointerToec2__DescribeImagesResponseInfoType(soap, (struct ec2__DescribeImagesResponseInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesExecutableByType:
        soap_serialize_PointerToec2__DescribeImagesExecutableByType(soap, (struct ec2__DescribeImagesExecutableByType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesOwnerType:
        soap_serialize_PointerToec2__DescribeImagesOwnerType(soap, (struct ec2__DescribeImagesOwnerType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesItemType:
        soap_serialize_PointerToec2__DescribeImagesItemType(soap, (struct ec2__DescribeImagesItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesOwnersType:
        soap_serialize_PointerToec2__DescribeImagesOwnersType(soap, (struct ec2__DescribeImagesOwnersType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesInfoType:
        soap_serialize_PointerToec2__DescribeImagesInfoType(soap, (struct ec2__DescribeImagesInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeImagesExecutableBySetType:
        soap_serialize_PointerToec2__DescribeImagesExecutableBySetType(soap, (struct ec2__DescribeImagesExecutableBySetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ReservationInfoType:
        soap_serialize_PointerToec2__ReservationInfoType(soap, (struct ec2__ReservationInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ReservationSetType:
        soap_serialize_PointerToec2__ReservationSetType(soap, (struct ec2__ReservationSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeInstancesItemType:
        soap_serialize_PointerToec2__DescribeInstancesItemType(soap, (struct ec2__DescribeInstancesItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeInstancesInfoType:
        soap_serialize_PointerToec2__DescribeInstancesInfoType(soap, (struct ec2__DescribeInstancesInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RebootInstancesItemType:
        soap_serialize_PointerToec2__RebootInstancesItemType(soap, (struct ec2__RebootInstancesItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RebootInstancesInfoType:
        soap_serialize_PointerToec2__RebootInstancesInfoType(soap, (struct ec2__RebootInstancesInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseItemType:
        soap_serialize_PointerToec2__TerminateInstancesResponseItemType(soap, (struct ec2__TerminateInstancesResponseItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__TerminateInstancesResponseInfoType:
        soap_serialize_PointerToec2__TerminateInstancesResponseInfoType(soap, (struct ec2__TerminateInstancesResponseInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__TerminateInstancesItemType:
        soap_serialize_PointerToec2__TerminateInstancesItemType(soap, (struct ec2__TerminateInstancesItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__TerminateInstancesInfoType:
        soap_serialize_PointerToec2__TerminateInstancesInfoType(soap, (struct ec2__TerminateInstancesInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__PlacementResponseType:
        soap_serialize_PointerToec2__PlacementResponseType(soap, (struct ec2__PlacementResponseType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__ProductCodesSetType:
        soap_serialize_PointerToec2__ProductCodesSetType(soap, (struct ec2__ProductCodesSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__InstanceStateType:
        soap_serialize_PointerToec2__InstanceStateType(soap, (struct ec2__InstanceStateType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RunningInstancesItemType:
        soap_serialize_PointerToec2__RunningInstancesItemType(soap, (struct ec2__RunningInstancesItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__RunningInstancesSetType:
        soap_serialize_PointerToec2__RunningInstancesSetType(soap, (struct ec2__RunningInstancesSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BlockDeviceMappingItemType:
        soap_serialize_PointerToec2__BlockDeviceMappingItemType(soap, (struct ec2__BlockDeviceMappingItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__GroupItemType:
        soap_serialize_PointerToec2__GroupItemType(soap, (struct ec2__GroupItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__BlockDeviceMappingType:
        soap_serialize_PointerToec2__BlockDeviceMappingType(soap, (struct ec2__BlockDeviceMappingType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__PlacementRequestType:
        soap_serialize_PointerToec2__PlacementRequestType(soap, (struct ec2__PlacementRequestType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__UserDataType:
        soap_serialize_PointerToec2__UserDataType(soap, (struct ec2__UserDataType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__GroupSetType:
        soap_serialize_PointerToec2__GroupSetType(soap, (struct ec2__GroupSetType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseItemType:
        soap_serialize_PointerToec2__DescribeKeyPairsResponseItemType(soap, (struct ec2__DescribeKeyPairsResponseItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsResponseInfoType:
        soap_serialize_PointerToec2__DescribeKeyPairsResponseInfoType(soap, (struct ec2__DescribeKeyPairsResponseInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsItemType:
        soap_serialize_PointerToec2__DescribeKeyPairsItemType(soap, (struct ec2__DescribeKeyPairsItemType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToec2__DescribeKeyPairsInfoType:
        soap_serialize_PointerToec2__DescribeKeyPairsInfoType(soap, (struct ec2__DescribeKeyPairsInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__Security:
        soap_serialize_PointerTo_wsse__Security(soap, (struct _wsse__Security *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__SignatureType:
        soap_serialize_PointerTods__SignatureType(soap, (struct ds__SignatureType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__BinarySecurityToken:
        soap_serialize_PointerTo_wsse__BinarySecurityToken(soap, (struct _wsse__BinarySecurityToken *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__UsernameToken:
        soap_serialize_PointerTo_wsse__UsernameToken(soap, (struct _wsse__UsernameToken *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsu__Timestamp:
        soap_serialize_PointerTo_wsu__Timestamp(soap, (struct _wsu__Timestamp *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__X509IssuerSerialType:
        soap_serialize_PointerTods__X509IssuerSerialType(soap, (struct ds__X509IssuerSerialType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__RSAKeyValueType:
        soap_serialize_PointerTods__RSAKeyValueType(soap, (struct ds__RSAKeyValueType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__DSAKeyValueType:
        soap_serialize_PointerTods__DSAKeyValueType(soap, (struct ds__DSAKeyValueType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__TransformType:
        soap_serialize_PointerTods__TransformType(soap, (struct ds__TransformType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__DigestMethodType:
        soap_serialize_PointerTods__DigestMethodType(soap, (struct ds__DigestMethodType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__TransformsType:
        soap_serialize_PointerTods__TransformsType(soap, (struct ds__TransformsType *const*)ptr);
        break;
      case SOAP_TYPE_PointerToint:
        soap_serialize_PointerToint(soap, (int *const*)ptr);
        break;
      case SOAP_TYPE_PointerToPointerTods__ReferenceType:
        soap_serialize_PointerToPointerTods__ReferenceType(soap, (struct ds__ReferenceType **const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__ReferenceType:
        soap_serialize_PointerTods__ReferenceType(soap, (struct ds__ReferenceType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__SignatureMethodType:
        soap_serialize_PointerTods__SignatureMethodType(soap, (struct ds__SignatureMethodType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__CanonicalizationMethodType:
        soap_serialize_PointerTods__CanonicalizationMethodType(soap, (struct ds__CanonicalizationMethodType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__SecurityTokenReference:
        soap_serialize_PointerTo_wsse__SecurityTokenReference(soap, (struct _wsse__SecurityTokenReference *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__X509DataType:
        soap_serialize_PointerTods__X509DataType(soap, (struct ds__X509DataType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__RetrievalMethodType:
        soap_serialize_PointerTods__RetrievalMethodType(soap, (struct ds__RetrievalMethodType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__KeyValueType:
        soap_serialize_PointerTods__KeyValueType(soap, (struct ds__KeyValueType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_c14n__InclusiveNamespaces:
        soap_serialize_PointerTo_c14n__InclusiveNamespaces(soap, (struct _c14n__InclusiveNamespaces *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__KeyInfoType:
        soap_serialize_PointerTods__KeyInfoType(soap, (struct ds__KeyInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTods__SignedInfoType:
        soap_serialize_PointerTods__SignedInfoType(soap, (struct ds__SignedInfoType *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__Embedded:
        soap_serialize_PointerTo_wsse__Embedded(soap, (struct _wsse__Embedded *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__KeyIdentifier:
        soap_serialize_PointerTo_wsse__KeyIdentifier(soap, (struct _wsse__KeyIdentifier *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__Reference:
        soap_serialize_PointerTo_wsse__Reference(soap, (struct _wsse__Reference *const*)ptr);
        break;
      case SOAP_TYPE_PointerTo_wsse__Password:
        soap_serialize_PointerTo_wsse__Password(soap, (struct _wsse__Password *const*)ptr);
        break;
      case SOAP_TYPE__QName:
        soap_serialize_string(soap, (char*const*)&ptr);
        break;
      case SOAP_TYPE_string:
        soap_serialize_string(soap, (char*const*)&ptr);
        break;
      }
  }
#endif

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
  {
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
    *a = SOAP_DEFAULT_byte;
#else
    *a = (char)0;
#endif
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
  {
    return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
  }

  SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
  {       char *p;
    p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
    return p;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
    if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
  {
    if ((p = soap_in_byte(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
  {
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
    *a = SOAP_DEFAULT_int;
#else
    *a = (int)0;
#endif
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
  {
    return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
  }

  SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
  {       int *p;
    p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
    return p;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
    if (soap_out_int(soap, tag?tag:"int", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
  {
    if ((p = soap_in_int(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
  {
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
    *a = SOAP_DEFAULT_time;
#else
    *a = (time_t)0;
#endif
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
  {
    return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
  }

  SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
  {       time_t *p;
    p = soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
    return p;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
    if (soap_out_time(soap, tag?tag:"dateTime", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
  {
    if ((p = soap_in_time(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean_(struct soap *soap, enum xsd__boolean_ *a)
  {
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xsd__boolean_
    *a = SOAP_DEFAULT_xsd__boolean_;
#else
    *a = (enum xsd__boolean_)0;
#endif
  }

  static const struct soap_code_map soap_codes_xsd__boolean_[] =
    {       { (long)_false, "false" },
            { (long)_true, "true" },
            { 0, NULL }
    };

  SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean_2s(struct soap *soap, enum xsd__boolean_ n)
  {       const char *s = soap_code_str(soap_codes_xsd__boolean_, (long)n);
    if (s)
      return s;
    return soap_long2s(soap, (long)n);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean_(struct soap *soap, const char *tag, int id, const enum xsd__boolean_ *a, const char *type)
  {       if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean_), type) || soap_send(soap, soap_xsd__boolean_2s(soap, *a)))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean_(struct soap *soap, const char *s, enum xsd__boolean_ *a)
  {
    const struct soap_code_map *map;
    if (!s)
      return soap->error;
    map = soap_code(soap_codes_xsd__boolean_, s);
    if (map)
      *a = (enum xsd__boolean_)map->code;
    else
      {       long n;
        if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
          return soap->error = SOAP_TYPE;
        *a = (enum xsd__boolean_)n;
      }
    return SOAP_OK;
  }

  SOAP_FMAC3 enum xsd__boolean_ * SOAP_FMAC4 soap_in_xsd__boolean_(struct soap *soap, const char *tag, enum xsd__boolean_ *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (enum xsd__boolean_ *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean_, sizeof(enum xsd__boolean_), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    if (soap->body && !*soap->href)
      {       if (!a || soap_s2xsd__boolean_(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (enum xsd__boolean_ *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__boolean_, 0, sizeof(enum xsd__boolean_), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean_(struct soap *soap, const enum xsd__boolean_ *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean_);
    if (soap_out_xsd__boolean_(soap, tag?tag:"xsd:boolean", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 enum xsd__boolean_ * SOAP_FMAC4 soap_get_xsd__boolean_(struct soap *soap, enum xsd__boolean_ *p, const char *tag, const char *type)
  {
    if ((p = soap_in_xsd__boolean_(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *a)
  {
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsse__FaultcodeEnum
    *a = SOAP_DEFAULT_wsse__FaultcodeEnum;
#else
    *a = (enum wsse__FaultcodeEnum)0;
#endif
  }

  static const struct soap_code_map soap_codes_wsse__FaultcodeEnum[] =
    {       { (long)wsse__UnsupportedSecurityToken, "wsse:UnsupportedSecurityToken" },
            { (long)wsse__UnsupportedAlgorithm, "wsse:UnsupportedAlgorithm" },
            { (long)wsse__InvalidSecurity, "wsse:InvalidSecurity" },
            { (long)wsse__InvalidSecurityToken, "wsse:InvalidSecurityToken" },
            { (long)wsse__FailedAuthentication, "wsse:FailedAuthentication" },
            { (long)wsse__FailedCheck, "wsse:FailedCheck" },
            { (long)wsse__SecurityTokenUnavailable, "wsse:SecurityTokenUnavailable" },
            { 0, NULL }
    };

  SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsse__FaultcodeEnum2s(struct soap *soap, enum wsse__FaultcodeEnum n)
  {       const char *s = soap_code_str(soap_codes_wsse__FaultcodeEnum, (long)n);
    if (s)
      return s;
    return soap_long2s(soap, (long)n);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__FaultcodeEnum(struct soap *soap, const char *tag, int id, const enum wsse__FaultcodeEnum *a, const char *type)
  {       if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsse__FaultcodeEnum), type) || soap_send(soap, soap_wsse__FaultcodeEnum2s(soap, *a)))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsse__FaultcodeEnum(struct soap *soap, const char *s, enum wsse__FaultcodeEnum *a)
  {
    const struct soap_code_map *map;
    char *t;
    if (!s)
      return soap->error;
    soap_s2QName(soap, s, &t, -1, -1);
    map = soap_code(soap_codes_wsse__FaultcodeEnum, t);
    if (map)
      *a = (enum wsse__FaultcodeEnum)map->code;
    else
      {       long n;
        if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 6)))
          return soap->error = SOAP_TYPE;
        *a = (enum wsse__FaultcodeEnum)n;
      }
    return SOAP_OK;
  }

  SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_in_wsse__FaultcodeEnum(struct soap *soap, const char *tag, enum wsse__FaultcodeEnum *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (enum wsse__FaultcodeEnum *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__FaultcodeEnum, sizeof(enum wsse__FaultcodeEnum), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    if (soap->body && !*soap->href)
      {       if (!a || soap_s2wsse__FaultcodeEnum(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (enum wsse__FaultcodeEnum *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsse__FaultcodeEnum, 0, sizeof(enum wsse__FaultcodeEnum), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__FaultcodeEnum(struct soap *soap, const enum wsse__FaultcodeEnum *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__FaultcodeEnum);
    if (soap_out_wsse__FaultcodeEnum(soap, tag?tag:"wsse:FaultcodeEnum", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_get_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *p, const char *tag, const char *type)
  {
    if ((p = soap_in_wsse__FaultcodeEnum(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *a)
  {
    (void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsu__tTimestampFault
    *a = SOAP_DEFAULT_wsu__tTimestampFault;
#else
    *a = (enum wsu__tTimestampFault)0;
#endif
  }

  static const struct soap_code_map soap_codes_wsu__tTimestampFault[] =
    {       { (long)wsu__MessageExpired, "wsu:MessageExpired" },
            { 0, NULL }
    };

  SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsu__tTimestampFault2s(struct soap *soap, enum wsu__tTimestampFault n)
  {       const char *s = soap_code_str(soap_codes_wsu__tTimestampFault, (long)n);
    if (s)
      return s;
    return soap_long2s(soap, (long)n);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsu__tTimestampFault(struct soap *soap, const char *tag, int id, const enum wsu__tTimestampFault *a, const char *type)
  {       if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsu__tTimestampFault), type) || soap_send(soap, soap_wsu__tTimestampFault2s(soap, *a)))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsu__tTimestampFault(struct soap *soap, const char *s, enum wsu__tTimestampFault *a)
  {
    const struct soap_code_map *map;
    char *t;
    if (!s)
      return soap->error;
    soap_s2QName(soap, s, &t, -1, -1);
    map = soap_code(soap_codes_wsu__tTimestampFault, t);
    if (map)
      *a = (enum wsu__tTimestampFault)map->code;
    else
      {       long n;
        if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
          return soap->error = SOAP_TYPE;
        *a = (enum wsu__tTimestampFault)n;
      }
    return SOAP_OK;
  }

  SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_in_wsu__tTimestampFault(struct soap *soap, const char *tag, enum wsu__tTimestampFault *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (enum wsu__tTimestampFault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsu__tTimestampFault, sizeof(enum wsu__tTimestampFault), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    if (soap->body && !*soap->href)
      {       if (!a || soap_s2wsu__tTimestampFault(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (enum wsu__tTimestampFault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsu__tTimestampFault, 0, sizeof(enum wsu__tTimestampFault), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsu__tTimestampFault(struct soap *soap, const enum wsu__tTimestampFault *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsu__tTimestampFault);
    if (soap_out_wsu__tTimestampFault(soap, tag?tag:"wsu:tTimestampFault", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_get_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *p, const char *tag, const char *type)
  {
    if ((p = soap_in_wsu__tTimestampFault(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

#ifndef WITH_NOGLOBAL

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default__QName(soap, &a->faultcode);
    soap_default_string(soap, &a->faultstring);
    soap_default_string(soap, &a->faultactor);
    a->detail = NULL;
    a->SOAP_ENV__Code = NULL;
    a->SOAP_ENV__Reason = NULL;
    soap_default_string(soap, &a->SOAP_ENV__Node);
    soap_default_string(soap, &a->SOAP_ENV__Role);
    a->SOAP_ENV__Detail = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__QName(soap, &a->faultcode);
    soap_serialize_string(soap, &a->faultstring);
    soap_serialize_string(soap, &a->faultactor);
    soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
    soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
    soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
    soap_serialize_string(soap, &a->SOAP_ENV__Node);
    soap_serialize_string(soap, &a->SOAP_ENV__Role);
    soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
  {
    const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
      return soap->error;
    if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
      return soap->error;
    if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
      return soap->error;
    if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
      return soap->error;
    if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
      return soap->error;
    if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
      return soap->error;
    if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
      return soap->error;
    if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
      return soap->error;
    if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
      return soap->error;
    if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
  {
    size_t soap_flag_faultcode = 1;
    size_t soap_flag_faultstring = 1;
    size_t soap_flag_faultactor = 1;
    size_t soap_flag_detail = 1;
    size_t soap_flag_SOAP_ENV__Code = 1;
    size_t soap_flag_SOAP_ENV__Reason = 1;
    size_t soap_flag_SOAP_ENV__Node = 1;
    size_t soap_flag_SOAP_ENV__Role = 1;
    size_t soap_flag_SOAP_ENV__Detail = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_SOAP_ENV__Fault(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
                {       soap_flag_faultcode--;
                  continue;
                }
            if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
                {       soap_flag_faultstring--;
                  continue;
                }
            if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
                {       soap_flag_faultactor--;
                  continue;
                }
            if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
                {       soap_flag_detail--;
                  continue;
                }
            if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
                {       soap_flag_SOAP_ENV__Code--;
                  continue;
                }
            if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
                {       soap_flag_SOAP_ENV__Reason--;
                  continue;
                }
            if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
                {       soap_flag_SOAP_ENV__Node--;
                  continue;
                }
            if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
                {       soap_flag_SOAP_ENV__Role--;
                  continue;
                }
            if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
                {       soap_flag_SOAP_ENV__Detail--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
    if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
  {
    if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

#endif

#ifndef WITH_NOGLOBAL

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->SOAP_ENV__Text);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->SOAP_ENV__Text);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
      return soap->error;
    if (soap->lang)
      soap_set_attr(soap, "xml:lang", soap->lang);
    if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
  {
    size_t soap_flag_SOAP_ENV__Text = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_SOAP_ENV__Reason(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
                {       soap_flag_SOAP_ENV__Text--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
    if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
  {
    if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

#endif

#ifndef WITH_NOGLOBAL

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__type = 0;
    a->fault = NULL;
    a->__any = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_markelement(soap, a->fault, a->__type);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
      return soap->error;
    if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
      return soap->error;
    soap_outliteral(soap, "-any", &a->__any, NULL);
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
  {
    size_t soap_flag_fault = 1;
    size_t soap_flag___any = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_SOAP_ENV__Detail(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
              if ((a->fault = soap_getelement(soap, &a->__type)))
                {       soap_flag_fault = 0;
                  continue;
                }
            if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_inliteral(soap, "-any", &a->__any))
                {       soap_flag___any--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
    if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
  {
    if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

#endif

#ifndef WITH_NOGLOBAL

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default__QName(soap, &a->SOAP_ENV__Value);
    a->SOAP_ENV__Subcode = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__QName(soap, &a->SOAP_ENV__Value);
    soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
  {
    const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
      return soap->error;
    if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
      return soap->error;
    if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
  {
    size_t soap_flag_SOAP_ENV__Value = 1;
    size_t soap_flag_SOAP_ENV__Subcode = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_SOAP_ENV__Code(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
                {       soap_flag_SOAP_ENV__Value--;
                  continue;
                }
            if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
                {       soap_flag_SOAP_ENV__Subcode--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
    if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
  {
    if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

#endif

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeRegions(struct soap *soap, struct __ec2__DescribeRegions *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeRegions = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeRegions(struct soap *soap, const struct __ec2__DescribeRegions *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeRegionsType(soap, &a->ec2__DescribeRegions);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeRegions(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeRegions *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeRegionsType(soap, "ec2:DescribeRegions", -1, &a->ec2__DescribeRegions, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeRegions * SOAP_FMAC4 soap_in___ec2__DescribeRegions(struct soap *soap, const char *tag, struct __ec2__DescribeRegions *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeRegions = 1;
    short soap_flag;
    a = (struct __ec2__DescribeRegions *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeRegions, sizeof(struct __ec2__DescribeRegions), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeRegions(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeRegions && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeRegionsType(soap, "ec2:DescribeRegions", &a->ec2__DescribeRegions, "ec2:DescribeRegionsType"))
            {       soap_flag_ec2__DescribeRegions--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeRegions(struct soap *soap, const struct __ec2__DescribeRegions *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeRegions(soap, tag?tag:"-ec2:DescribeRegions", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeRegions * SOAP_FMAC4 soap_get___ec2__DescribeRegions(struct soap *soap, struct __ec2__DescribeRegions *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeRegions(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__CancelBundleTask(struct soap *soap, struct __ec2__CancelBundleTask *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__CancelBundleTask = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__CancelBundleTask(struct soap *soap, const struct __ec2__CancelBundleTask *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__CancelBundleTaskType(soap, &a->ec2__CancelBundleTask);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__CancelBundleTask(struct soap *soap, const char *tag, int id, const struct __ec2__CancelBundleTask *a, const char *type)
  {
    if (soap_out_PointerToec2__CancelBundleTaskType(soap, "ec2:CancelBundleTask", -1, &a->ec2__CancelBundleTask, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CancelBundleTask * SOAP_FMAC4 soap_in___ec2__CancelBundleTask(struct soap *soap, const char *tag, struct __ec2__CancelBundleTask *a, const char *type)
  {
    size_t soap_flag_ec2__CancelBundleTask = 1;
    short soap_flag;
    a = (struct __ec2__CancelBundleTask *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__CancelBundleTask, sizeof(struct __ec2__CancelBundleTask), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__CancelBundleTask(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__CancelBundleTask && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__CancelBundleTaskType(soap, "ec2:CancelBundleTask", &a->ec2__CancelBundleTask, "ec2:CancelBundleTaskType"))
            {       soap_flag_ec2__CancelBundleTask--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__CancelBundleTask(struct soap *soap, const struct __ec2__CancelBundleTask *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__CancelBundleTask(soap, tag?tag:"-ec2:CancelBundleTask", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CancelBundleTask * SOAP_FMAC4 soap_get___ec2__CancelBundleTask(struct soap *soap, struct __ec2__CancelBundleTask *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__CancelBundleTask(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeBundleTasks(struct soap *soap, struct __ec2__DescribeBundleTasks *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeBundleTasks = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeBundleTasks(struct soap *soap, const struct __ec2__DescribeBundleTasks *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeBundleTasksType(soap, &a->ec2__DescribeBundleTasks);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeBundleTasks(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeBundleTasks *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeBundleTasksType(soap, "ec2:DescribeBundleTasks", -1, &a->ec2__DescribeBundleTasks, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeBundleTasks * SOAP_FMAC4 soap_in___ec2__DescribeBundleTasks(struct soap *soap, const char *tag, struct __ec2__DescribeBundleTasks *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeBundleTasks = 1;
    short soap_flag;
    a = (struct __ec2__DescribeBundleTasks *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeBundleTasks, sizeof(struct __ec2__DescribeBundleTasks), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeBundleTasks(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeBundleTasks && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeBundleTasksType(soap, "ec2:DescribeBundleTasks", &a->ec2__DescribeBundleTasks, "ec2:DescribeBundleTasksType"))
            {       soap_flag_ec2__DescribeBundleTasks--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeBundleTasks(struct soap *soap, const struct __ec2__DescribeBundleTasks *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeBundleTasks(soap, tag?tag:"-ec2:DescribeBundleTasks", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeBundleTasks * SOAP_FMAC4 soap_get___ec2__DescribeBundleTasks(struct soap *soap, struct __ec2__DescribeBundleTasks *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeBundleTasks(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__BundleInstance(struct soap *soap, struct __ec2__BundleInstance *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__BundleInstance = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__BundleInstance(struct soap *soap, const struct __ec2__BundleInstance *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__BundleInstanceType(soap, &a->ec2__BundleInstance);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__BundleInstance(struct soap *soap, const char *tag, int id, const struct __ec2__BundleInstance *a, const char *type)
  {
    if (soap_out_PointerToec2__BundleInstanceType(soap, "ec2:BundleInstance", -1, &a->ec2__BundleInstance, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__BundleInstance * SOAP_FMAC4 soap_in___ec2__BundleInstance(struct soap *soap, const char *tag, struct __ec2__BundleInstance *a, const char *type)
  {
    size_t soap_flag_ec2__BundleInstance = 1;
    short soap_flag;
    a = (struct __ec2__BundleInstance *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__BundleInstance, sizeof(struct __ec2__BundleInstance), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__BundleInstance(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__BundleInstance && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__BundleInstanceType(soap, "ec2:BundleInstance", &a->ec2__BundleInstance, "ec2:BundleInstanceType"))
            {       soap_flag_ec2__BundleInstance--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__BundleInstance(struct soap *soap, const struct __ec2__BundleInstance *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__BundleInstance(soap, tag?tag:"-ec2:BundleInstance", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__BundleInstance * SOAP_FMAC4 soap_get___ec2__BundleInstance(struct soap *soap, struct __ec2__BundleInstance *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__BundleInstance(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeSnapshots(struct soap *soap, struct __ec2__DescribeSnapshots *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeSnapshots = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeSnapshots(struct soap *soap, const struct __ec2__DescribeSnapshots *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeSnapshotsType(soap, &a->ec2__DescribeSnapshots);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeSnapshots(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeSnapshots *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeSnapshotsType(soap, "ec2:DescribeSnapshots", -1, &a->ec2__DescribeSnapshots, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeSnapshots * SOAP_FMAC4 soap_in___ec2__DescribeSnapshots(struct soap *soap, const char *tag, struct __ec2__DescribeSnapshots *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeSnapshots = 1;
    short soap_flag;
    a = (struct __ec2__DescribeSnapshots *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeSnapshots, sizeof(struct __ec2__DescribeSnapshots), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeSnapshots(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeSnapshots && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeSnapshotsType(soap, "ec2:DescribeSnapshots", &a->ec2__DescribeSnapshots, "ec2:DescribeSnapshotsType"))
            {       soap_flag_ec2__DescribeSnapshots--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeSnapshots(struct soap *soap, const struct __ec2__DescribeSnapshots *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeSnapshots(soap, tag?tag:"-ec2:DescribeSnapshots", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeSnapshots * SOAP_FMAC4 soap_get___ec2__DescribeSnapshots(struct soap *soap, struct __ec2__DescribeSnapshots *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeSnapshots(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DeleteSnapshot(struct soap *soap, struct __ec2__DeleteSnapshot *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DeleteSnapshot = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DeleteSnapshot(struct soap *soap, const struct __ec2__DeleteSnapshot *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DeleteSnapshotType(soap, &a->ec2__DeleteSnapshot);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DeleteSnapshot(struct soap *soap, const char *tag, int id, const struct __ec2__DeleteSnapshot *a, const char *type)
  {
    if (soap_out_PointerToec2__DeleteSnapshotType(soap, "ec2:DeleteSnapshot", -1, &a->ec2__DeleteSnapshot, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteSnapshot * SOAP_FMAC4 soap_in___ec2__DeleteSnapshot(struct soap *soap, const char *tag, struct __ec2__DeleteSnapshot *a, const char *type)
  {
    size_t soap_flag_ec2__DeleteSnapshot = 1;
    short soap_flag;
    a = (struct __ec2__DeleteSnapshot *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DeleteSnapshot, sizeof(struct __ec2__DeleteSnapshot), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DeleteSnapshot(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DeleteSnapshot && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DeleteSnapshotType(soap, "ec2:DeleteSnapshot", &a->ec2__DeleteSnapshot, "ec2:DeleteSnapshotType"))
            {       soap_flag_ec2__DeleteSnapshot--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DeleteSnapshot(struct soap *soap, const struct __ec2__DeleteSnapshot *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DeleteSnapshot(soap, tag?tag:"-ec2:DeleteSnapshot", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteSnapshot * SOAP_FMAC4 soap_get___ec2__DeleteSnapshot(struct soap *soap, struct __ec2__DeleteSnapshot *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DeleteSnapshot(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__CreateSnapshot(struct soap *soap, struct __ec2__CreateSnapshot *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__CreateSnapshot = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__CreateSnapshot(struct soap *soap, const struct __ec2__CreateSnapshot *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__CreateSnapshotType(soap, &a->ec2__CreateSnapshot);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__CreateSnapshot(struct soap *soap, const char *tag, int id, const struct __ec2__CreateSnapshot *a, const char *type)
  {
    if (soap_out_PointerToec2__CreateSnapshotType(soap, "ec2:CreateSnapshot", -1, &a->ec2__CreateSnapshot, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateSnapshot * SOAP_FMAC4 soap_in___ec2__CreateSnapshot(struct soap *soap, const char *tag, struct __ec2__CreateSnapshot *a, const char *type)
  {
    size_t soap_flag_ec2__CreateSnapshot = 1;
    short soap_flag;
    a = (struct __ec2__CreateSnapshot *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__CreateSnapshot, sizeof(struct __ec2__CreateSnapshot), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__CreateSnapshot(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__CreateSnapshot && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__CreateSnapshotType(soap, "ec2:CreateSnapshot", &a->ec2__CreateSnapshot, "ec2:CreateSnapshotType"))
            {       soap_flag_ec2__CreateSnapshot--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__CreateSnapshot(struct soap *soap, const struct __ec2__CreateSnapshot *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__CreateSnapshot(soap, tag?tag:"-ec2:CreateSnapshot", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateSnapshot * SOAP_FMAC4 soap_get___ec2__CreateSnapshot(struct soap *soap, struct __ec2__CreateSnapshot *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__CreateSnapshot(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DetachVolume(struct soap *soap, struct __ec2__DetachVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DetachVolume = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DetachVolume(struct soap *soap, const struct __ec2__DetachVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DetachVolumeType(soap, &a->ec2__DetachVolume);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DetachVolume(struct soap *soap, const char *tag, int id, const struct __ec2__DetachVolume *a, const char *type)
  {
    if (soap_out_PointerToec2__DetachVolumeType(soap, "ec2:DetachVolume", -1, &a->ec2__DetachVolume, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DetachVolume * SOAP_FMAC4 soap_in___ec2__DetachVolume(struct soap *soap, const char *tag, struct __ec2__DetachVolume *a, const char *type)
  {
    size_t soap_flag_ec2__DetachVolume = 1;
    short soap_flag;
    a = (struct __ec2__DetachVolume *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DetachVolume, sizeof(struct __ec2__DetachVolume), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DetachVolume(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DetachVolume && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DetachVolumeType(soap, "ec2:DetachVolume", &a->ec2__DetachVolume, "ec2:DetachVolumeType"))
            {       soap_flag_ec2__DetachVolume--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DetachVolume(struct soap *soap, const struct __ec2__DetachVolume *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DetachVolume(soap, tag?tag:"-ec2:DetachVolume", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DetachVolume * SOAP_FMAC4 soap_get___ec2__DetachVolume(struct soap *soap, struct __ec2__DetachVolume *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DetachVolume(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__AttachVolume(struct soap *soap, struct __ec2__AttachVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__AttachVolume = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__AttachVolume(struct soap *soap, const struct __ec2__AttachVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__AttachVolumeType(soap, &a->ec2__AttachVolume);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__AttachVolume(struct soap *soap, const char *tag, int id, const struct __ec2__AttachVolume *a, const char *type)
  {
    if (soap_out_PointerToec2__AttachVolumeType(soap, "ec2:AttachVolume", -1, &a->ec2__AttachVolume, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AttachVolume * SOAP_FMAC4 soap_in___ec2__AttachVolume(struct soap *soap, const char *tag, struct __ec2__AttachVolume *a, const char *type)
  {
    size_t soap_flag_ec2__AttachVolume = 1;
    short soap_flag;
    a = (struct __ec2__AttachVolume *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__AttachVolume, sizeof(struct __ec2__AttachVolume), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__AttachVolume(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__AttachVolume && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__AttachVolumeType(soap, "ec2:AttachVolume", &a->ec2__AttachVolume, "ec2:AttachVolumeType"))
            {       soap_flag_ec2__AttachVolume--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__AttachVolume(struct soap *soap, const struct __ec2__AttachVolume *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__AttachVolume(soap, tag?tag:"-ec2:AttachVolume", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AttachVolume * SOAP_FMAC4 soap_get___ec2__AttachVolume(struct soap *soap, struct __ec2__AttachVolume *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__AttachVolume(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeVolumes(struct soap *soap, struct __ec2__DescribeVolumes *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeVolumes = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeVolumes(struct soap *soap, const struct __ec2__DescribeVolumes *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeVolumesType(soap, &a->ec2__DescribeVolumes);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeVolumes(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeVolumes *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeVolumesType(soap, "ec2:DescribeVolumes", -1, &a->ec2__DescribeVolumes, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeVolumes * SOAP_FMAC4 soap_in___ec2__DescribeVolumes(struct soap *soap, const char *tag, struct __ec2__DescribeVolumes *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeVolumes = 1;
    short soap_flag;
    a = (struct __ec2__DescribeVolumes *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeVolumes, sizeof(struct __ec2__DescribeVolumes), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeVolumes(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeVolumes && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeVolumesType(soap, "ec2:DescribeVolumes", &a->ec2__DescribeVolumes, "ec2:DescribeVolumesType"))
            {       soap_flag_ec2__DescribeVolumes--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeVolumes(struct soap *soap, const struct __ec2__DescribeVolumes *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeVolumes(soap, tag?tag:"-ec2:DescribeVolumes", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeVolumes * SOAP_FMAC4 soap_get___ec2__DescribeVolumes(struct soap *soap, struct __ec2__DescribeVolumes *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeVolumes(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DeleteVolume(struct soap *soap, struct __ec2__DeleteVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DeleteVolume = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DeleteVolume(struct soap *soap, const struct __ec2__DeleteVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DeleteVolumeType(soap, &a->ec2__DeleteVolume);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DeleteVolume(struct soap *soap, const char *tag, int id, const struct __ec2__DeleteVolume *a, const char *type)
  {
    if (soap_out_PointerToec2__DeleteVolumeType(soap, "ec2:DeleteVolume", -1, &a->ec2__DeleteVolume, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteVolume * SOAP_FMAC4 soap_in___ec2__DeleteVolume(struct soap *soap, const char *tag, struct __ec2__DeleteVolume *a, const char *type)
  {
    size_t soap_flag_ec2__DeleteVolume = 1;
    short soap_flag;
    a = (struct __ec2__DeleteVolume *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DeleteVolume, sizeof(struct __ec2__DeleteVolume), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DeleteVolume(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DeleteVolume && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DeleteVolumeType(soap, "ec2:DeleteVolume", &a->ec2__DeleteVolume, "ec2:DeleteVolumeType"))
            {       soap_flag_ec2__DeleteVolume--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DeleteVolume(struct soap *soap, const struct __ec2__DeleteVolume *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DeleteVolume(soap, tag?tag:"-ec2:DeleteVolume", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteVolume * SOAP_FMAC4 soap_get___ec2__DeleteVolume(struct soap *soap, struct __ec2__DeleteVolume *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DeleteVolume(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__CreateVolume(struct soap *soap, struct __ec2__CreateVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__CreateVolume = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__CreateVolume(struct soap *soap, const struct __ec2__CreateVolume *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__CreateVolumeType(soap, &a->ec2__CreateVolume);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__CreateVolume(struct soap *soap, const char *tag, int id, const struct __ec2__CreateVolume *a, const char *type)
  {
    if (soap_out_PointerToec2__CreateVolumeType(soap, "ec2:CreateVolume", -1, &a->ec2__CreateVolume, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateVolume * SOAP_FMAC4 soap_in___ec2__CreateVolume(struct soap *soap, const char *tag, struct __ec2__CreateVolume *a, const char *type)
  {
    size_t soap_flag_ec2__CreateVolume = 1;
    short soap_flag;
    a = (struct __ec2__CreateVolume *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__CreateVolume, sizeof(struct __ec2__CreateVolume), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__CreateVolume(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__CreateVolume && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__CreateVolumeType(soap, "ec2:CreateVolume", &a->ec2__CreateVolume, "ec2:CreateVolumeType"))
            {       soap_flag_ec2__CreateVolume--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__CreateVolume(struct soap *soap, const struct __ec2__CreateVolume *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__CreateVolume(soap, tag?tag:"-ec2:CreateVolume", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateVolume * SOAP_FMAC4 soap_get___ec2__CreateVolume(struct soap *soap, struct __ec2__CreateVolume *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__CreateVolume(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DisassociateAddress(struct soap *soap, struct __ec2__DisassociateAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DisassociateAddress = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DisassociateAddress(struct soap *soap, const struct __ec2__DisassociateAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DisassociateAddressType(soap, &a->ec2__DisassociateAddress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DisassociateAddress(struct soap *soap, const char *tag, int id, const struct __ec2__DisassociateAddress *a, const char *type)
  {
    if (soap_out_PointerToec2__DisassociateAddressType(soap, "ec2:DisassociateAddress", -1, &a->ec2__DisassociateAddress, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DisassociateAddress * SOAP_FMAC4 soap_in___ec2__DisassociateAddress(struct soap *soap, const char *tag, struct __ec2__DisassociateAddress *a, const char *type)
  {
    size_t soap_flag_ec2__DisassociateAddress = 1;
    short soap_flag;
    a = (struct __ec2__DisassociateAddress *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DisassociateAddress, sizeof(struct __ec2__DisassociateAddress), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DisassociateAddress(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DisassociateAddress && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DisassociateAddressType(soap, "ec2:DisassociateAddress", &a->ec2__DisassociateAddress, "ec2:DisassociateAddressType"))
            {       soap_flag_ec2__DisassociateAddress--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DisassociateAddress(struct soap *soap, const struct __ec2__DisassociateAddress *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DisassociateAddress(soap, tag?tag:"-ec2:DisassociateAddress", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DisassociateAddress * SOAP_FMAC4 soap_get___ec2__DisassociateAddress(struct soap *soap, struct __ec2__DisassociateAddress *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DisassociateAddress(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__AssociateAddress(struct soap *soap, struct __ec2__AssociateAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__AssociateAddress = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__AssociateAddress(struct soap *soap, const struct __ec2__AssociateAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__AssociateAddressType(soap, &a->ec2__AssociateAddress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__AssociateAddress(struct soap *soap, const char *tag, int id, const struct __ec2__AssociateAddress *a, const char *type)
  {
    if (soap_out_PointerToec2__AssociateAddressType(soap, "ec2:AssociateAddress", -1, &a->ec2__AssociateAddress, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AssociateAddress * SOAP_FMAC4 soap_in___ec2__AssociateAddress(struct soap *soap, const char *tag, struct __ec2__AssociateAddress *a, const char *type)
  {
    size_t soap_flag_ec2__AssociateAddress = 1;
    short soap_flag;
    a = (struct __ec2__AssociateAddress *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__AssociateAddress, sizeof(struct __ec2__AssociateAddress), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__AssociateAddress(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__AssociateAddress && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__AssociateAddressType(soap, "ec2:AssociateAddress", &a->ec2__AssociateAddress, "ec2:AssociateAddressType"))
            {       soap_flag_ec2__AssociateAddress--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__AssociateAddress(struct soap *soap, const struct __ec2__AssociateAddress *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__AssociateAddress(soap, tag?tag:"-ec2:AssociateAddress", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AssociateAddress * SOAP_FMAC4 soap_get___ec2__AssociateAddress(struct soap *soap, struct __ec2__AssociateAddress *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__AssociateAddress(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeAddresses(struct soap *soap, struct __ec2__DescribeAddresses *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeAddresses = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeAddresses(struct soap *soap, const struct __ec2__DescribeAddresses *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeAddressesType(soap, &a->ec2__DescribeAddresses);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeAddresses(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeAddresses *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeAddressesType(soap, "ec2:DescribeAddresses", -1, &a->ec2__DescribeAddresses, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeAddresses * SOAP_FMAC4 soap_in___ec2__DescribeAddresses(struct soap *soap, const char *tag, struct __ec2__DescribeAddresses *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeAddresses = 1;
    short soap_flag;
    a = (struct __ec2__DescribeAddresses *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeAddresses, sizeof(struct __ec2__DescribeAddresses), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeAddresses(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeAddresses && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeAddressesType(soap, "ec2:DescribeAddresses", &a->ec2__DescribeAddresses, "ec2:DescribeAddressesType"))
            {       soap_flag_ec2__DescribeAddresses--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeAddresses(struct soap *soap, const struct __ec2__DescribeAddresses *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeAddresses(soap, tag?tag:"-ec2:DescribeAddresses", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeAddresses * SOAP_FMAC4 soap_get___ec2__DescribeAddresses(struct soap *soap, struct __ec2__DescribeAddresses *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeAddresses(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__ReleaseAddress(struct soap *soap, struct __ec2__ReleaseAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__ReleaseAddress = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__ReleaseAddress(struct soap *soap, const struct __ec2__ReleaseAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__ReleaseAddressType(soap, &a->ec2__ReleaseAddress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__ReleaseAddress(struct soap *soap, const char *tag, int id, const struct __ec2__ReleaseAddress *a, const char *type)
  {
    if (soap_out_PointerToec2__ReleaseAddressType(soap, "ec2:ReleaseAddress", -1, &a->ec2__ReleaseAddress, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ReleaseAddress * SOAP_FMAC4 soap_in___ec2__ReleaseAddress(struct soap *soap, const char *tag, struct __ec2__ReleaseAddress *a, const char *type)
  {
    size_t soap_flag_ec2__ReleaseAddress = 1;
    short soap_flag;
    a = (struct __ec2__ReleaseAddress *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__ReleaseAddress, sizeof(struct __ec2__ReleaseAddress), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__ReleaseAddress(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__ReleaseAddress && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__ReleaseAddressType(soap, "ec2:ReleaseAddress", &a->ec2__ReleaseAddress, "ec2:ReleaseAddressType"))
            {       soap_flag_ec2__ReleaseAddress--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__ReleaseAddress(struct soap *soap, const struct __ec2__ReleaseAddress *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__ReleaseAddress(soap, tag?tag:"-ec2:ReleaseAddress", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ReleaseAddress * SOAP_FMAC4 soap_get___ec2__ReleaseAddress(struct soap *soap, struct __ec2__ReleaseAddress *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__ReleaseAddress(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__AllocateAddress(struct soap *soap, struct __ec2__AllocateAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__AllocateAddress = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__AllocateAddress(struct soap *soap, const struct __ec2__AllocateAddress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__AllocateAddressType(soap, &a->ec2__AllocateAddress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__AllocateAddress(struct soap *soap, const char *tag, int id, const struct __ec2__AllocateAddress *a, const char *type)
  {
    if (soap_out_PointerToec2__AllocateAddressType(soap, "ec2:AllocateAddress", -1, &a->ec2__AllocateAddress, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AllocateAddress * SOAP_FMAC4 soap_in___ec2__AllocateAddress(struct soap *soap, const char *tag, struct __ec2__AllocateAddress *a, const char *type)
  {
    size_t soap_flag_ec2__AllocateAddress = 1;
    short soap_flag;
    a = (struct __ec2__AllocateAddress *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__AllocateAddress, sizeof(struct __ec2__AllocateAddress), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__AllocateAddress(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__AllocateAddress && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__AllocateAddressType(soap, "ec2:AllocateAddress", &a->ec2__AllocateAddress, "ec2:AllocateAddressType"))
            {       soap_flag_ec2__AllocateAddress--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__AllocateAddress(struct soap *soap, const struct __ec2__AllocateAddress *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__AllocateAddress(soap, tag?tag:"-ec2:AllocateAddress", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AllocateAddress * SOAP_FMAC4 soap_get___ec2__AllocateAddress(struct soap *soap, struct __ec2__AllocateAddress *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__AllocateAddress(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeAvailabilityZones(struct soap *soap, struct __ec2__DescribeAvailabilityZones *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeAvailabilityZones = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeAvailabilityZones(struct soap *soap, const struct __ec2__DescribeAvailabilityZones *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeAvailabilityZonesType(soap, &a->ec2__DescribeAvailabilityZones);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeAvailabilityZones(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeAvailabilityZones *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeAvailabilityZonesType(soap, "ec2:DescribeAvailabilityZones", -1, &a->ec2__DescribeAvailabilityZones, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeAvailabilityZones * SOAP_FMAC4 soap_in___ec2__DescribeAvailabilityZones(struct soap *soap, const char *tag, struct __ec2__DescribeAvailabilityZones *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeAvailabilityZones = 1;
    short soap_flag;
    a = (struct __ec2__DescribeAvailabilityZones *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeAvailabilityZones, sizeof(struct __ec2__DescribeAvailabilityZones), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeAvailabilityZones(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeAvailabilityZones && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeAvailabilityZonesType(soap, "ec2:DescribeAvailabilityZones", &a->ec2__DescribeAvailabilityZones, "ec2:DescribeAvailabilityZonesType"))
            {       soap_flag_ec2__DescribeAvailabilityZones--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeAvailabilityZones(struct soap *soap, const struct __ec2__DescribeAvailabilityZones *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeAvailabilityZones(soap, tag?tag:"-ec2:DescribeAvailabilityZones", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeAvailabilityZones * SOAP_FMAC4 soap_get___ec2__DescribeAvailabilityZones(struct soap *soap, struct __ec2__DescribeAvailabilityZones *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeAvailabilityZones(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__ConfirmProductInstance(struct soap *soap, struct __ec2__ConfirmProductInstance *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__ConfirmProductInstance = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__ConfirmProductInstance(struct soap *soap, const struct __ec2__ConfirmProductInstance *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__ConfirmProductInstanceType(soap, &a->ec2__ConfirmProductInstance);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__ConfirmProductInstance(struct soap *soap, const char *tag, int id, const struct __ec2__ConfirmProductInstance *a, const char *type)
  {
    if (soap_out_PointerToec2__ConfirmProductInstanceType(soap, "ec2:ConfirmProductInstance", -1, &a->ec2__ConfirmProductInstance, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ConfirmProductInstance * SOAP_FMAC4 soap_in___ec2__ConfirmProductInstance(struct soap *soap, const char *tag, struct __ec2__ConfirmProductInstance *a, const char *type)
  {
    size_t soap_flag_ec2__ConfirmProductInstance = 1;
    short soap_flag;
    a = (struct __ec2__ConfirmProductInstance *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__ConfirmProductInstance, sizeof(struct __ec2__ConfirmProductInstance), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__ConfirmProductInstance(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__ConfirmProductInstance && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__ConfirmProductInstanceType(soap, "ec2:ConfirmProductInstance", &a->ec2__ConfirmProductInstance, "ec2:ConfirmProductInstanceType"))
            {       soap_flag_ec2__ConfirmProductInstance--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__ConfirmProductInstance(struct soap *soap, const struct __ec2__ConfirmProductInstance *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__ConfirmProductInstance(soap, tag?tag:"-ec2:ConfirmProductInstance", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ConfirmProductInstance * SOAP_FMAC4 soap_get___ec2__ConfirmProductInstance(struct soap *soap, struct __ec2__ConfirmProductInstance *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__ConfirmProductInstance(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeImageAttribute(struct soap *soap, struct __ec2__DescribeImageAttribute *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeImageAttribute = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeImageAttribute(struct soap *soap, const struct __ec2__DescribeImageAttribute *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeImageAttributeType(soap, &a->ec2__DescribeImageAttribute);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeImageAttribute(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeImageAttribute *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeImageAttributeType(soap, "ec2:DescribeImageAttribute", -1, &a->ec2__DescribeImageAttribute, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeImageAttribute * SOAP_FMAC4 soap_in___ec2__DescribeImageAttribute(struct soap *soap, const char *tag, struct __ec2__DescribeImageAttribute *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeImageAttribute = 1;
    short soap_flag;
    a = (struct __ec2__DescribeImageAttribute *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeImageAttribute, sizeof(struct __ec2__DescribeImageAttribute), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeImageAttribute(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeImageAttribute && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeImageAttributeType(soap, "ec2:DescribeImageAttribute", &a->ec2__DescribeImageAttribute, "ec2:DescribeImageAttributeType"))
            {       soap_flag_ec2__DescribeImageAttribute--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeImageAttribute(struct soap *soap, const struct __ec2__DescribeImageAttribute *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeImageAttribute(soap, tag?tag:"-ec2:DescribeImageAttribute", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeImageAttribute * SOAP_FMAC4 soap_get___ec2__DescribeImageAttribute(struct soap *soap, struct __ec2__DescribeImageAttribute *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeImageAttribute(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__ResetImageAttribute(struct soap *soap, struct __ec2__ResetImageAttribute *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__ResetImageAttribute = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__ResetImageAttribute(struct soap *soap, const struct __ec2__ResetImageAttribute *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__ResetImageAttributeType(soap, &a->ec2__ResetImageAttribute);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__ResetImageAttribute(struct soap *soap, const char *tag, int id, const struct __ec2__ResetImageAttribute *a, const char *type)
  {
    if (soap_out_PointerToec2__ResetImageAttributeType(soap, "ec2:ResetImageAttribute", -1, &a->ec2__ResetImageAttribute, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ResetImageAttribute * SOAP_FMAC4 soap_in___ec2__ResetImageAttribute(struct soap *soap, const char *tag, struct __ec2__ResetImageAttribute *a, const char *type)
  {
    size_t soap_flag_ec2__ResetImageAttribute = 1;
    short soap_flag;
    a = (struct __ec2__ResetImageAttribute *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__ResetImageAttribute, sizeof(struct __ec2__ResetImageAttribute), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__ResetImageAttribute(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__ResetImageAttribute && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__ResetImageAttributeType(soap, "ec2:ResetImageAttribute", &a->ec2__ResetImageAttribute, "ec2:ResetImageAttributeType"))
            {       soap_flag_ec2__ResetImageAttribute--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__ResetImageAttribute(struct soap *soap, const struct __ec2__ResetImageAttribute *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__ResetImageAttribute(soap, tag?tag:"-ec2:ResetImageAttribute", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ResetImageAttribute * SOAP_FMAC4 soap_get___ec2__ResetImageAttribute(struct soap *soap, struct __ec2__ResetImageAttribute *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__ResetImageAttribute(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__ModifyImageAttribute(struct soap *soap, struct __ec2__ModifyImageAttribute *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__ModifyImageAttribute = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__ModifyImageAttribute(struct soap *soap, const struct __ec2__ModifyImageAttribute *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__ModifyImageAttributeType(soap, &a->ec2__ModifyImageAttribute);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__ModifyImageAttribute(struct soap *soap, const char *tag, int id, const struct __ec2__ModifyImageAttribute *a, const char *type)
  {
    if (soap_out_PointerToec2__ModifyImageAttributeType(soap, "ec2:ModifyImageAttribute", -1, &a->ec2__ModifyImageAttribute, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ModifyImageAttribute * SOAP_FMAC4 soap_in___ec2__ModifyImageAttribute(struct soap *soap, const char *tag, struct __ec2__ModifyImageAttribute *a, const char *type)
  {
    size_t soap_flag_ec2__ModifyImageAttribute = 1;
    short soap_flag;
    a = (struct __ec2__ModifyImageAttribute *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__ModifyImageAttribute, sizeof(struct __ec2__ModifyImageAttribute), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__ModifyImageAttribute(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__ModifyImageAttribute && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__ModifyImageAttributeType(soap, "ec2:ModifyImageAttribute", &a->ec2__ModifyImageAttribute, "ec2:ModifyImageAttributeType"))
            {       soap_flag_ec2__ModifyImageAttribute--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__ModifyImageAttribute(struct soap *soap, const struct __ec2__ModifyImageAttribute *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__ModifyImageAttribute(soap, tag?tag:"-ec2:ModifyImageAttribute", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__ModifyImageAttribute * SOAP_FMAC4 soap_get___ec2__ModifyImageAttribute(struct soap *soap, struct __ec2__ModifyImageAttribute *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__ModifyImageAttribute(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__RevokeSecurityGroupIngress(struct soap *soap, struct __ec2__RevokeSecurityGroupIngress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__RevokeSecurityGroupIngress = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__RevokeSecurityGroupIngress(struct soap *soap, const struct __ec2__RevokeSecurityGroupIngress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__RevokeSecurityGroupIngressType(soap, &a->ec2__RevokeSecurityGroupIngress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__RevokeSecurityGroupIngress(struct soap *soap, const char *tag, int id, const struct __ec2__RevokeSecurityGroupIngress *a, const char *type)
  {
    if (soap_out_PointerToec2__RevokeSecurityGroupIngressType(soap, "ec2:RevokeSecurityGroupIngress", -1, &a->ec2__RevokeSecurityGroupIngress, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RevokeSecurityGroupIngress * SOAP_FMAC4 soap_in___ec2__RevokeSecurityGroupIngress(struct soap *soap, const char *tag, struct __ec2__RevokeSecurityGroupIngress *a, const char *type)
  {
    size_t soap_flag_ec2__RevokeSecurityGroupIngress = 1;
    short soap_flag;
    a = (struct __ec2__RevokeSecurityGroupIngress *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__RevokeSecurityGroupIngress, sizeof(struct __ec2__RevokeSecurityGroupIngress), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__RevokeSecurityGroupIngress(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__RevokeSecurityGroupIngress && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__RevokeSecurityGroupIngressType(soap, "ec2:RevokeSecurityGroupIngress", &a->ec2__RevokeSecurityGroupIngress, "ec2:RevokeSecurityGroupIngressType"))
            {       soap_flag_ec2__RevokeSecurityGroupIngress--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__RevokeSecurityGroupIngress(struct soap *soap, const struct __ec2__RevokeSecurityGroupIngress *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__RevokeSecurityGroupIngress(soap, tag?tag:"-ec2:RevokeSecurityGroupIngress", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RevokeSecurityGroupIngress * SOAP_FMAC4 soap_get___ec2__RevokeSecurityGroupIngress(struct soap *soap, struct __ec2__RevokeSecurityGroupIngress *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__RevokeSecurityGroupIngress(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__AuthorizeSecurityGroupIngress(struct soap *soap, struct __ec2__AuthorizeSecurityGroupIngress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__AuthorizeSecurityGroupIngress = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__AuthorizeSecurityGroupIngress(struct soap *soap, const struct __ec2__AuthorizeSecurityGroupIngress *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__AuthorizeSecurityGroupIngressType(soap, &a->ec2__AuthorizeSecurityGroupIngress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__AuthorizeSecurityGroupIngress(struct soap *soap, const char *tag, int id, const struct __ec2__AuthorizeSecurityGroupIngress *a, const char *type)
  {
    if (soap_out_PointerToec2__AuthorizeSecurityGroupIngressType(soap, "ec2:AuthorizeSecurityGroupIngress", -1, &a->ec2__AuthorizeSecurityGroupIngress, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AuthorizeSecurityGroupIngress * SOAP_FMAC4 soap_in___ec2__AuthorizeSecurityGroupIngress(struct soap *soap, const char *tag, struct __ec2__AuthorizeSecurityGroupIngress *a, const char *type)
  {
    size_t soap_flag_ec2__AuthorizeSecurityGroupIngress = 1;
    short soap_flag;
    a = (struct __ec2__AuthorizeSecurityGroupIngress *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__AuthorizeSecurityGroupIngress, sizeof(struct __ec2__AuthorizeSecurityGroupIngress), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__AuthorizeSecurityGroupIngress(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__AuthorizeSecurityGroupIngress && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__AuthorizeSecurityGroupIngressType(soap, "ec2:AuthorizeSecurityGroupIngress", &a->ec2__AuthorizeSecurityGroupIngress, "ec2:AuthorizeSecurityGroupIngressType"))
            {       soap_flag_ec2__AuthorizeSecurityGroupIngress--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__AuthorizeSecurityGroupIngress(struct soap *soap, const struct __ec2__AuthorizeSecurityGroupIngress *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__AuthorizeSecurityGroupIngress(soap, tag?tag:"-ec2:AuthorizeSecurityGroupIngress", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__AuthorizeSecurityGroupIngress * SOAP_FMAC4 soap_get___ec2__AuthorizeSecurityGroupIngress(struct soap *soap, struct __ec2__AuthorizeSecurityGroupIngress *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__AuthorizeSecurityGroupIngress(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeSecurityGroups(struct soap *soap, struct __ec2__DescribeSecurityGroups *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeSecurityGroups = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeSecurityGroups(struct soap *soap, const struct __ec2__DescribeSecurityGroups *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeSecurityGroupsType(soap, &a->ec2__DescribeSecurityGroups);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeSecurityGroups(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeSecurityGroups *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeSecurityGroupsType(soap, "ec2:DescribeSecurityGroups", -1, &a->ec2__DescribeSecurityGroups, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeSecurityGroups * SOAP_FMAC4 soap_in___ec2__DescribeSecurityGroups(struct soap *soap, const char *tag, struct __ec2__DescribeSecurityGroups *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeSecurityGroups = 1;
    short soap_flag;
    a = (struct __ec2__DescribeSecurityGroups *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeSecurityGroups, sizeof(struct __ec2__DescribeSecurityGroups), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeSecurityGroups(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeSecurityGroups && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeSecurityGroupsType(soap, "ec2:DescribeSecurityGroups", &a->ec2__DescribeSecurityGroups, "ec2:DescribeSecurityGroupsType"))
            {       soap_flag_ec2__DescribeSecurityGroups--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeSecurityGroups(struct soap *soap, const struct __ec2__DescribeSecurityGroups *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeSecurityGroups(soap, tag?tag:"-ec2:DescribeSecurityGroups", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeSecurityGroups * SOAP_FMAC4 soap_get___ec2__DescribeSecurityGroups(struct soap *soap, struct __ec2__DescribeSecurityGroups *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeSecurityGroups(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DeleteSecurityGroup(struct soap *soap, struct __ec2__DeleteSecurityGroup *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DeleteSecurityGroup = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DeleteSecurityGroup(struct soap *soap, const struct __ec2__DeleteSecurityGroup *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DeleteSecurityGroupType(soap, &a->ec2__DeleteSecurityGroup);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DeleteSecurityGroup(struct soap *soap, const char *tag, int id, const struct __ec2__DeleteSecurityGroup *a, const char *type)
  {
    if (soap_out_PointerToec2__DeleteSecurityGroupType(soap, "ec2:DeleteSecurityGroup", -1, &a->ec2__DeleteSecurityGroup, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteSecurityGroup * SOAP_FMAC4 soap_in___ec2__DeleteSecurityGroup(struct soap *soap, const char *tag, struct __ec2__DeleteSecurityGroup *a, const char *type)
  {
    size_t soap_flag_ec2__DeleteSecurityGroup = 1;
    short soap_flag;
    a = (struct __ec2__DeleteSecurityGroup *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DeleteSecurityGroup, sizeof(struct __ec2__DeleteSecurityGroup), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DeleteSecurityGroup(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DeleteSecurityGroup && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DeleteSecurityGroupType(soap, "ec2:DeleteSecurityGroup", &a->ec2__DeleteSecurityGroup, "ec2:DeleteSecurityGroupType"))
            {       soap_flag_ec2__DeleteSecurityGroup--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DeleteSecurityGroup(struct soap *soap, const struct __ec2__DeleteSecurityGroup *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DeleteSecurityGroup(soap, tag?tag:"-ec2:DeleteSecurityGroup", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteSecurityGroup * SOAP_FMAC4 soap_get___ec2__DeleteSecurityGroup(struct soap *soap, struct __ec2__DeleteSecurityGroup *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DeleteSecurityGroup(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__CreateSecurityGroup(struct soap *soap, struct __ec2__CreateSecurityGroup *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__CreateSecurityGroup = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__CreateSecurityGroup(struct soap *soap, const struct __ec2__CreateSecurityGroup *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__CreateSecurityGroupType(soap, &a->ec2__CreateSecurityGroup);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__CreateSecurityGroup(struct soap *soap, const char *tag, int id, const struct __ec2__CreateSecurityGroup *a, const char *type)
  {
    if (soap_out_PointerToec2__CreateSecurityGroupType(soap, "ec2:CreateSecurityGroup", -1, &a->ec2__CreateSecurityGroup, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateSecurityGroup * SOAP_FMAC4 soap_in___ec2__CreateSecurityGroup(struct soap *soap, const char *tag, struct __ec2__CreateSecurityGroup *a, const char *type)
  {
    size_t soap_flag_ec2__CreateSecurityGroup = 1;
    short soap_flag;
    a = (struct __ec2__CreateSecurityGroup *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__CreateSecurityGroup, sizeof(struct __ec2__CreateSecurityGroup), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__CreateSecurityGroup(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__CreateSecurityGroup && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__CreateSecurityGroupType(soap, "ec2:CreateSecurityGroup", &a->ec2__CreateSecurityGroup, "ec2:CreateSecurityGroupType"))
            {       soap_flag_ec2__CreateSecurityGroup--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__CreateSecurityGroup(struct soap *soap, const struct __ec2__CreateSecurityGroup *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__CreateSecurityGroup(soap, tag?tag:"-ec2:CreateSecurityGroup", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateSecurityGroup * SOAP_FMAC4 soap_get___ec2__CreateSecurityGroup(struct soap *soap, struct __ec2__CreateSecurityGroup *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__CreateSecurityGroup(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeImages(struct soap *soap, struct __ec2__DescribeImages *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeImages = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeImages(struct soap *soap, const struct __ec2__DescribeImages *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeImagesType(soap, &a->ec2__DescribeImages);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeImages(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeImages *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeImagesType(soap, "ec2:DescribeImages", -1, &a->ec2__DescribeImages, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeImages * SOAP_FMAC4 soap_in___ec2__DescribeImages(struct soap *soap, const char *tag, struct __ec2__DescribeImages *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeImages = 1;
    short soap_flag;
    a = (struct __ec2__DescribeImages *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeImages, sizeof(struct __ec2__DescribeImages), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeImages(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeImages && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeImagesType(soap, "ec2:DescribeImages", &a->ec2__DescribeImages, "ec2:DescribeImagesType"))
            {       soap_flag_ec2__DescribeImages--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeImages(struct soap *soap, const struct __ec2__DescribeImages *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeImages(soap, tag?tag:"-ec2:DescribeImages", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeImages * SOAP_FMAC4 soap_get___ec2__DescribeImages(struct soap *soap, struct __ec2__DescribeImages *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeImages(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeInstances(struct soap *soap, struct __ec2__DescribeInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeInstances = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeInstances(struct soap *soap, const struct __ec2__DescribeInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeInstancesType(soap, &a->ec2__DescribeInstances);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeInstances(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeInstances *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeInstancesType(soap, "ec2:DescribeInstances", -1, &a->ec2__DescribeInstances, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeInstances * SOAP_FMAC4 soap_in___ec2__DescribeInstances(struct soap *soap, const char *tag, struct __ec2__DescribeInstances *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeInstances = 1;
    short soap_flag;
    a = (struct __ec2__DescribeInstances *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeInstances, sizeof(struct __ec2__DescribeInstances), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeInstances(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeInstances && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeInstancesType(soap, "ec2:DescribeInstances", &a->ec2__DescribeInstances, "ec2:DescribeInstancesType"))
            {       soap_flag_ec2__DescribeInstances--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeInstances(struct soap *soap, const struct __ec2__DescribeInstances *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeInstances(soap, tag?tag:"-ec2:DescribeInstances", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeInstances * SOAP_FMAC4 soap_get___ec2__DescribeInstances(struct soap *soap, struct __ec2__DescribeInstances *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeInstances(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__RebootInstances(struct soap *soap, struct __ec2__RebootInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__RebootInstances = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__RebootInstances(struct soap *soap, const struct __ec2__RebootInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__RebootInstancesType(soap, &a->ec2__RebootInstances);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__RebootInstances(struct soap *soap, const char *tag, int id, const struct __ec2__RebootInstances *a, const char *type)
  {
    if (soap_out_PointerToec2__RebootInstancesType(soap, "ec2:RebootInstances", -1, &a->ec2__RebootInstances, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RebootInstances * SOAP_FMAC4 soap_in___ec2__RebootInstances(struct soap *soap, const char *tag, struct __ec2__RebootInstances *a, const char *type)
  {
    size_t soap_flag_ec2__RebootInstances = 1;
    short soap_flag;
    a = (struct __ec2__RebootInstances *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__RebootInstances, sizeof(struct __ec2__RebootInstances), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__RebootInstances(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__RebootInstances && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__RebootInstancesType(soap, "ec2:RebootInstances", &a->ec2__RebootInstances, "ec2:RebootInstancesType"))
            {       soap_flag_ec2__RebootInstances--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__RebootInstances(struct soap *soap, const struct __ec2__RebootInstances *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__RebootInstances(soap, tag?tag:"-ec2:RebootInstances", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RebootInstances * SOAP_FMAC4 soap_get___ec2__RebootInstances(struct soap *soap, struct __ec2__RebootInstances *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__RebootInstances(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__TerminateInstances(struct soap *soap, struct __ec2__TerminateInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__TerminateInstances = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__TerminateInstances(struct soap *soap, const struct __ec2__TerminateInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__TerminateInstancesType(soap, &a->ec2__TerminateInstances);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__TerminateInstances(struct soap *soap, const char *tag, int id, const struct __ec2__TerminateInstances *a, const char *type)
  {
    if (soap_out_PointerToec2__TerminateInstancesType(soap, "ec2:TerminateInstances", -1, &a->ec2__TerminateInstances, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__TerminateInstances * SOAP_FMAC4 soap_in___ec2__TerminateInstances(struct soap *soap, const char *tag, struct __ec2__TerminateInstances *a, const char *type)
  {
    size_t soap_flag_ec2__TerminateInstances = 1;
    short soap_flag;
    a = (struct __ec2__TerminateInstances *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__TerminateInstances, sizeof(struct __ec2__TerminateInstances), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__TerminateInstances(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__TerminateInstances && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__TerminateInstancesType(soap, "ec2:TerminateInstances", &a->ec2__TerminateInstances, "ec2:TerminateInstancesType"))
            {       soap_flag_ec2__TerminateInstances--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__TerminateInstances(struct soap *soap, const struct __ec2__TerminateInstances *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__TerminateInstances(soap, tag?tag:"-ec2:TerminateInstances", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__TerminateInstances * SOAP_FMAC4 soap_get___ec2__TerminateInstances(struct soap *soap, struct __ec2__TerminateInstances *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__TerminateInstances(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__GetConsoleOutput(struct soap *soap, struct __ec2__GetConsoleOutput *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__GetConsoleOutput = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__GetConsoleOutput(struct soap *soap, const struct __ec2__GetConsoleOutput *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__GetConsoleOutputType(soap, &a->ec2__GetConsoleOutput);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__GetConsoleOutput(struct soap *soap, const char *tag, int id, const struct __ec2__GetConsoleOutput *a, const char *type)
  {
    if (soap_out_PointerToec2__GetConsoleOutputType(soap, "ec2:GetConsoleOutput", -1, &a->ec2__GetConsoleOutput, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__GetConsoleOutput * SOAP_FMAC4 soap_in___ec2__GetConsoleOutput(struct soap *soap, const char *tag, struct __ec2__GetConsoleOutput *a, const char *type)
  {
    size_t soap_flag_ec2__GetConsoleOutput = 1;
    short soap_flag;
    a = (struct __ec2__GetConsoleOutput *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__GetConsoleOutput, sizeof(struct __ec2__GetConsoleOutput), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__GetConsoleOutput(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__GetConsoleOutput && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__GetConsoleOutputType(soap, "ec2:GetConsoleOutput", &a->ec2__GetConsoleOutput, "ec2:GetConsoleOutputType"))
            {       soap_flag_ec2__GetConsoleOutput--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__GetConsoleOutput(struct soap *soap, const struct __ec2__GetConsoleOutput *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__GetConsoleOutput(soap, tag?tag:"-ec2:GetConsoleOutput", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__GetConsoleOutput * SOAP_FMAC4 soap_get___ec2__GetConsoleOutput(struct soap *soap, struct __ec2__GetConsoleOutput *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__GetConsoleOutput(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__RunInstances(struct soap *soap, struct __ec2__RunInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__RunInstances = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__RunInstances(struct soap *soap, const struct __ec2__RunInstances *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__RunInstancesType(soap, &a->ec2__RunInstances);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__RunInstances(struct soap *soap, const char *tag, int id, const struct __ec2__RunInstances *a, const char *type)
  {
    if (soap_out_PointerToec2__RunInstancesType(soap, "ec2:RunInstances", -1, &a->ec2__RunInstances, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RunInstances * SOAP_FMAC4 soap_in___ec2__RunInstances(struct soap *soap, const char *tag, struct __ec2__RunInstances *a, const char *type)
  {
    size_t soap_flag_ec2__RunInstances = 1;
    short soap_flag;
    a = (struct __ec2__RunInstances *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__RunInstances, sizeof(struct __ec2__RunInstances), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__RunInstances(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__RunInstances && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__RunInstancesType(soap, "ec2:RunInstances", &a->ec2__RunInstances, "ec2:RunInstancesType"))
            {       soap_flag_ec2__RunInstances--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__RunInstances(struct soap *soap, const struct __ec2__RunInstances *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__RunInstances(soap, tag?tag:"-ec2:RunInstances", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RunInstances * SOAP_FMAC4 soap_get___ec2__RunInstances(struct soap *soap, struct __ec2__RunInstances *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__RunInstances(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DeleteKeyPair(struct soap *soap, struct __ec2__DeleteKeyPair *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DeleteKeyPair = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DeleteKeyPair(struct soap *soap, const struct __ec2__DeleteKeyPair *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DeleteKeyPairType(soap, &a->ec2__DeleteKeyPair);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DeleteKeyPair(struct soap *soap, const char *tag, int id, const struct __ec2__DeleteKeyPair *a, const char *type)
  {
    if (soap_out_PointerToec2__DeleteKeyPairType(soap, "ec2:DeleteKeyPair", -1, &a->ec2__DeleteKeyPair, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteKeyPair * SOAP_FMAC4 soap_in___ec2__DeleteKeyPair(struct soap *soap, const char *tag, struct __ec2__DeleteKeyPair *a, const char *type)
  {
    size_t soap_flag_ec2__DeleteKeyPair = 1;
    short soap_flag;
    a = (struct __ec2__DeleteKeyPair *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DeleteKeyPair, sizeof(struct __ec2__DeleteKeyPair), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DeleteKeyPair(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DeleteKeyPair && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DeleteKeyPairType(soap, "ec2:DeleteKeyPair", &a->ec2__DeleteKeyPair, "ec2:DeleteKeyPairType"))
            {       soap_flag_ec2__DeleteKeyPair--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DeleteKeyPair(struct soap *soap, const struct __ec2__DeleteKeyPair *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DeleteKeyPair(soap, tag?tag:"-ec2:DeleteKeyPair", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeleteKeyPair * SOAP_FMAC4 soap_get___ec2__DeleteKeyPair(struct soap *soap, struct __ec2__DeleteKeyPair *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DeleteKeyPair(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DescribeKeyPairs(struct soap *soap, struct __ec2__DescribeKeyPairs *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DescribeKeyPairs = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DescribeKeyPairs(struct soap *soap, const struct __ec2__DescribeKeyPairs *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeKeyPairsType(soap, &a->ec2__DescribeKeyPairs);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DescribeKeyPairs(struct soap *soap, const char *tag, int id, const struct __ec2__DescribeKeyPairs *a, const char *type)
  {
    if (soap_out_PointerToec2__DescribeKeyPairsType(soap, "ec2:DescribeKeyPairs", -1, &a->ec2__DescribeKeyPairs, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeKeyPairs * SOAP_FMAC4 soap_in___ec2__DescribeKeyPairs(struct soap *soap, const char *tag, struct __ec2__DescribeKeyPairs *a, const char *type)
  {
    size_t soap_flag_ec2__DescribeKeyPairs = 1;
    short soap_flag;
    a = (struct __ec2__DescribeKeyPairs *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DescribeKeyPairs, sizeof(struct __ec2__DescribeKeyPairs), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DescribeKeyPairs(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DescribeKeyPairs && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DescribeKeyPairsType(soap, "ec2:DescribeKeyPairs", &a->ec2__DescribeKeyPairs, "ec2:DescribeKeyPairsType"))
            {       soap_flag_ec2__DescribeKeyPairs--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DescribeKeyPairs(struct soap *soap, const struct __ec2__DescribeKeyPairs *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DescribeKeyPairs(soap, tag?tag:"-ec2:DescribeKeyPairs", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DescribeKeyPairs * SOAP_FMAC4 soap_get___ec2__DescribeKeyPairs(struct soap *soap, struct __ec2__DescribeKeyPairs *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DescribeKeyPairs(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__CreateKeyPair(struct soap *soap, struct __ec2__CreateKeyPair *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__CreateKeyPair = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__CreateKeyPair(struct soap *soap, const struct __ec2__CreateKeyPair *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__CreateKeyPairType(soap, &a->ec2__CreateKeyPair);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__CreateKeyPair(struct soap *soap, const char *tag, int id, const struct __ec2__CreateKeyPair *a, const char *type)
  {
    if (soap_out_PointerToec2__CreateKeyPairType(soap, "ec2:CreateKeyPair", -1, &a->ec2__CreateKeyPair, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateKeyPair * SOAP_FMAC4 soap_in___ec2__CreateKeyPair(struct soap *soap, const char *tag, struct __ec2__CreateKeyPair *a, const char *type)
  {
    size_t soap_flag_ec2__CreateKeyPair = 1;
    short soap_flag;
    a = (struct __ec2__CreateKeyPair *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__CreateKeyPair, sizeof(struct __ec2__CreateKeyPair), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__CreateKeyPair(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__CreateKeyPair && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__CreateKeyPairType(soap, "ec2:CreateKeyPair", &a->ec2__CreateKeyPair, "ec2:CreateKeyPairType"))
            {       soap_flag_ec2__CreateKeyPair--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__CreateKeyPair(struct soap *soap, const struct __ec2__CreateKeyPair *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__CreateKeyPair(soap, tag?tag:"-ec2:CreateKeyPair", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__CreateKeyPair * SOAP_FMAC4 soap_get___ec2__CreateKeyPair(struct soap *soap, struct __ec2__CreateKeyPair *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__CreateKeyPair(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__DeregisterImage(struct soap *soap, struct __ec2__DeregisterImage *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__DeregisterImage = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__DeregisterImage(struct soap *soap, const struct __ec2__DeregisterImage *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DeregisterImageType(soap, &a->ec2__DeregisterImage);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__DeregisterImage(struct soap *soap, const char *tag, int id, const struct __ec2__DeregisterImage *a, const char *type)
  {
    if (soap_out_PointerToec2__DeregisterImageType(soap, "ec2:DeregisterImage", -1, &a->ec2__DeregisterImage, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeregisterImage * SOAP_FMAC4 soap_in___ec2__DeregisterImage(struct soap *soap, const char *tag, struct __ec2__DeregisterImage *a, const char *type)
  {
    size_t soap_flag_ec2__DeregisterImage = 1;
    short soap_flag;
    a = (struct __ec2__DeregisterImage *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__DeregisterImage, sizeof(struct __ec2__DeregisterImage), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__DeregisterImage(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__DeregisterImage && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__DeregisterImageType(soap, "ec2:DeregisterImage", &a->ec2__DeregisterImage, "ec2:DeregisterImageType"))
            {       soap_flag_ec2__DeregisterImage--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__DeregisterImage(struct soap *soap, const struct __ec2__DeregisterImage *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__DeregisterImage(soap, tag?tag:"-ec2:DeregisterImage", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__DeregisterImage * SOAP_FMAC4 soap_get___ec2__DeregisterImage(struct soap *soap, struct __ec2__DeregisterImage *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__DeregisterImage(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default___ec2__RegisterImage(struct soap *soap, struct __ec2__RegisterImage *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->ec2__RegisterImage = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ec2__RegisterImage(struct soap *soap, const struct __ec2__RegisterImage *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__RegisterImageType(soap, &a->ec2__RegisterImage);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out___ec2__RegisterImage(struct soap *soap, const char *tag, int id, const struct __ec2__RegisterImage *a, const char *type)
  {
    if (soap_out_PointerToec2__RegisterImageType(soap, "ec2:RegisterImage", -1, &a->ec2__RegisterImage, ""))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RegisterImage * SOAP_FMAC4 soap_in___ec2__RegisterImage(struct soap *soap, const char *tag, struct __ec2__RegisterImage *a, const char *type)
  {
    size_t soap_flag_ec2__RegisterImage = 1;
    short soap_flag;
    a = (struct __ec2__RegisterImage *)soap_id_enter(soap, "", a, SOAP_TYPE___ec2__RegisterImage, sizeof(struct __ec2__RegisterImage), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default___ec2__RegisterImage(soap, a);
    for (soap_flag = 0;; soap_flag = 1)
      {       soap->error = SOAP_TAG_MISMATCH;
        if (soap_flag_ec2__RegisterImage && soap->error == SOAP_TAG_MISMATCH)
          if (soap_in_PointerToec2__RegisterImageType(soap, "ec2:RegisterImage", &a->ec2__RegisterImage, "ec2:RegisterImageType"))
            {       soap_flag_ec2__RegisterImage--;
              continue;
            }
        if (soap->error == SOAP_TAG_MISMATCH)
          if (soap_flag)
            {       soap->error = SOAP_OK;
              break;
            }
        if (soap->error == SOAP_NO_TAG)
          break;
        if (soap->error)
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put___ec2__RegisterImage(struct soap *soap, const struct __ec2__RegisterImage *a, const char *tag, const char *type)
  {
    register int id = 0;
    if (soap_out___ec2__RegisterImage(soap, tag?tag:"-ec2:RegisterImage", id, a, type))
      return soap->error;
    return SOAP_OK;
  }

  SOAP_FMAC3 struct __ec2__RegisterImage * SOAP_FMAC4 soap_get___ec2__RegisterImage(struct soap *soap, struct __ec2__RegisterImage *p, const char *tag, const char *type)
  {
    if ((p = soap_in___ec2__RegisterImage(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RegionItemType(struct soap *soap, struct ec2__RegionItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->regionName);
    soap_default_string(soap, &a->regionEndpoint);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RegionItemType(struct soap *soap, const struct ec2__RegionItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->regionName);
    soap_serialize_string(soap, &a->regionEndpoint);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RegionItemType(struct soap *soap, const char *tag, int id, const struct ec2__RegionItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RegionItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:regionName", -1, &a->regionName, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:regionEndpoint", -1, &a->regionEndpoint, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RegionItemType * SOAP_FMAC4 soap_in_ec2__RegionItemType(struct soap *soap, const char *tag, struct ec2__RegionItemType *a, const char *type)
  {
    size_t soap_flag_regionName = 1;
    size_t soap_flag_regionEndpoint = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RegionItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RegionItemType, sizeof(struct ec2__RegionItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RegionItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_regionName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:regionName", &a->regionName, "xsd:string"))
                {       soap_flag_regionName--;
                  continue;
                }
            if (soap_flag_regionEndpoint && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:regionEndpoint", &a->regionEndpoint, "xsd:string"))
                {       soap_flag_regionEndpoint--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RegionItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RegionItemType, 0, sizeof(struct ec2__RegionItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_regionName > 0 || soap_flag_regionEndpoint > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RegionItemType(struct soap *soap, const struct ec2__RegionItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RegionItemType);
    if (soap_out_ec2__RegionItemType(soap, tag?tag:"ec2:RegionItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RegionItemType * SOAP_FMAC4 soap_get_ec2__RegionItemType(struct soap *soap, struct ec2__RegionItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RegionItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RegionSetType(struct soap *soap, struct ec2__RegionSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RegionSetType(struct soap *soap, const struct ec2__RegionSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__RegionItemType);
            soap_serialize_ec2__RegionItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RegionSetType(struct soap *soap, const char *tag, int id, const struct ec2__RegionSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RegionSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__RegionItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RegionSetType * SOAP_FMAC4 soap_in_ec2__RegionSetType(struct soap *soap, const char *tag, struct ec2__RegionSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RegionSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RegionSetType, sizeof(struct ec2__RegionSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RegionSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__RegionItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__RegionItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__RegionItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__RegionItemType(soap, "ec2:item", a->item, "ec2:RegionItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__RegionItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RegionSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RegionSetType, 0, sizeof(struct ec2__RegionSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RegionSetType(struct soap *soap, const struct ec2__RegionSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RegionSetType);
    if (soap_out_ec2__RegionSetType(soap, tag?tag:"ec2:RegionSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RegionSetType * SOAP_FMAC4 soap_get_ec2__RegionSetType(struct soap *soap, struct ec2__RegionSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RegionSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeRegionsResponseType(struct soap *soap, struct ec2__DescribeRegionsResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->regionInfo = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeRegionsResponseType(struct soap *soap, const struct ec2__DescribeRegionsResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__RegionSetType(soap, &a->regionInfo);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeRegionsResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeRegionsResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeRegionsResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__RegionSetType(soap, "ec2:regionInfo", -1, &a->regionInfo, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsResponseType * SOAP_FMAC4 soap_in_ec2__DescribeRegionsResponseType(struct soap *soap, const char *tag, struct ec2__DescribeRegionsResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_regionInfo = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeRegionsResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeRegionsResponseType, sizeof(struct ec2__DescribeRegionsResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeRegionsResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_regionInfo && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__RegionSetType(soap, "ec2:regionInfo", &a->regionInfo, "ec2:RegionSetType"))
                {       soap_flag_regionInfo--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeRegionsResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeRegionsResponseType, 0, sizeof(struct ec2__DescribeRegionsResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_regionInfo > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeRegionsResponseType(struct soap *soap, const struct ec2__DescribeRegionsResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeRegionsResponseType);
    if (soap_out_ec2__DescribeRegionsResponseType(soap, tag?tag:"ec2:DescribeRegionsResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsResponseType * SOAP_FMAC4 soap_get_ec2__DescribeRegionsResponseType(struct soap *soap, struct ec2__DescribeRegionsResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeRegionsResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeRegionsSetItemType(struct soap *soap, struct ec2__DescribeRegionsSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->regionName);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeRegionsSetItemType(struct soap *soap, const struct ec2__DescribeRegionsSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->regionName);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeRegionsSetItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeRegionsSetItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeRegionsSetItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:regionName", -1, &a->regionName, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsSetItemType * SOAP_FMAC4 soap_in_ec2__DescribeRegionsSetItemType(struct soap *soap, const char *tag, struct ec2__DescribeRegionsSetItemType *a, const char *type)
  {
    size_t soap_flag_regionName = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeRegionsSetItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeRegionsSetItemType, sizeof(struct ec2__DescribeRegionsSetItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeRegionsSetItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_regionName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:regionName", &a->regionName, "xsd:string"))
                {       soap_flag_regionName--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeRegionsSetItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeRegionsSetItemType, 0, sizeof(struct ec2__DescribeRegionsSetItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_regionName > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeRegionsSetItemType(struct soap *soap, const struct ec2__DescribeRegionsSetItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeRegionsSetItemType);
    if (soap_out_ec2__DescribeRegionsSetItemType(soap, tag?tag:"ec2:DescribeRegionsSetItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsSetItemType * SOAP_FMAC4 soap_get_ec2__DescribeRegionsSetItemType(struct soap *soap, struct ec2__DescribeRegionsSetItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeRegionsSetItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeRegionsSetType(struct soap *soap, struct ec2__DescribeRegionsSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeRegionsSetType(struct soap *soap, const struct ec2__DescribeRegionsSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeRegionsSetItemType);
            soap_serialize_ec2__DescribeRegionsSetItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeRegionsSetType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeRegionsSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeRegionsSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeRegionsSetItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsSetType * SOAP_FMAC4 soap_in_ec2__DescribeRegionsSetType(struct soap *soap, const char *tag, struct ec2__DescribeRegionsSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeRegionsSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeRegionsSetType, sizeof(struct ec2__DescribeRegionsSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeRegionsSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeRegionsSetItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeRegionsSetItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeRegionsSetItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeRegionsSetItemType(soap, "ec2:item", a->item, "ec2:DescribeRegionsSetItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeRegionsSetItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeRegionsSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeRegionsSetType, 0, sizeof(struct ec2__DescribeRegionsSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeRegionsSetType(struct soap *soap, const struct ec2__DescribeRegionsSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeRegionsSetType);
    if (soap_out_ec2__DescribeRegionsSetType(soap, tag?tag:"ec2:DescribeRegionsSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsSetType * SOAP_FMAC4 soap_get_ec2__DescribeRegionsSetType(struct soap *soap, struct ec2__DescribeRegionsSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeRegionsSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeRegionsType(struct soap *soap, struct ec2__DescribeRegionsType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->regionSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeRegionsType(struct soap *soap, const struct ec2__DescribeRegionsType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeRegionsSetType(soap, &a->regionSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeRegionsType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeRegionsType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeRegionsType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeRegionsSetType(soap, "ec2:regionSet", -1, &a->regionSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsType * SOAP_FMAC4 soap_in_ec2__DescribeRegionsType(struct soap *soap, const char *tag, struct ec2__DescribeRegionsType *a, const char *type)
  {
    size_t soap_flag_regionSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeRegionsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeRegionsType, sizeof(struct ec2__DescribeRegionsType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeRegionsType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_regionSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeRegionsSetType(soap, "ec2:regionSet", &a->regionSet, "ec2:DescribeRegionsSetType"))
                {       soap_flag_regionSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeRegionsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeRegionsType, 0, sizeof(struct ec2__DescribeRegionsType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_regionSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeRegionsType(struct soap *soap, const struct ec2__DescribeRegionsType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeRegionsType);
    if (soap_out_ec2__DescribeRegionsType(soap, tag?tag:"ec2:DescribeRegionsType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeRegionsType * SOAP_FMAC4 soap_get_ec2__DescribeRegionsType(struct soap *soap, struct ec2__DescribeRegionsType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeRegionsType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CancelBundleTaskResponseType(struct soap *soap, struct ec2__CancelBundleTaskResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->bundleInstanceTask = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CancelBundleTaskResponseType(struct soap *soap, const struct ec2__CancelBundleTaskResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__BundleInstanceTaskType(soap, &a->bundleInstanceTask);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CancelBundleTaskResponseType(struct soap *soap, const char *tag, int id, const struct ec2__CancelBundleTaskResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CancelBundleTaskResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__BundleInstanceTaskType(soap, "ec2:bundleInstanceTask", -1, &a->bundleInstanceTask, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CancelBundleTaskResponseType * SOAP_FMAC4 soap_in_ec2__CancelBundleTaskResponseType(struct soap *soap, const char *tag, struct ec2__CancelBundleTaskResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_bundleInstanceTask = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CancelBundleTaskResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CancelBundleTaskResponseType, sizeof(struct ec2__CancelBundleTaskResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CancelBundleTaskResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_bundleInstanceTask && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__BundleInstanceTaskType(soap, "ec2:bundleInstanceTask", &a->bundleInstanceTask, "ec2:BundleInstanceTaskType"))
                {       soap_flag_bundleInstanceTask--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CancelBundleTaskResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CancelBundleTaskResponseType, 0, sizeof(struct ec2__CancelBundleTaskResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_bundleInstanceTask > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CancelBundleTaskResponseType(struct soap *soap, const struct ec2__CancelBundleTaskResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CancelBundleTaskResponseType);
    if (soap_out_ec2__CancelBundleTaskResponseType(soap, tag?tag:"ec2:CancelBundleTaskResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CancelBundleTaskResponseType * SOAP_FMAC4 soap_get_ec2__CancelBundleTaskResponseType(struct soap *soap, struct ec2__CancelBundleTaskResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CancelBundleTaskResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CancelBundleTaskType(struct soap *soap, struct ec2__CancelBundleTaskType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->bundleId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CancelBundleTaskType(struct soap *soap, const struct ec2__CancelBundleTaskType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->bundleId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CancelBundleTaskType(struct soap *soap, const char *tag, int id, const struct ec2__CancelBundleTaskType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CancelBundleTaskType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:bundleId", -1, &a->bundleId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CancelBundleTaskType * SOAP_FMAC4 soap_in_ec2__CancelBundleTaskType(struct soap *soap, const char *tag, struct ec2__CancelBundleTaskType *a, const char *type)
  {
    size_t soap_flag_bundleId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CancelBundleTaskType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CancelBundleTaskType, sizeof(struct ec2__CancelBundleTaskType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CancelBundleTaskType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_bundleId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:bundleId", &a->bundleId, "xsd:string"))
                {       soap_flag_bundleId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CancelBundleTaskType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CancelBundleTaskType, 0, sizeof(struct ec2__CancelBundleTaskType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_bundleId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CancelBundleTaskType(struct soap *soap, const struct ec2__CancelBundleTaskType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CancelBundleTaskType);
    if (soap_out_ec2__CancelBundleTaskType(soap, tag?tag:"ec2:CancelBundleTaskType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CancelBundleTaskType * SOAP_FMAC4 soap_get_ec2__CancelBundleTaskType(struct soap *soap, struct ec2__CancelBundleTaskType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CancelBundleTaskType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__BundleInstanceTasksSetType(struct soap *soap, struct ec2__BundleInstanceTasksSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__BundleInstanceTasksSetType(struct soap *soap, const struct ec2__BundleInstanceTasksSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__BundleInstanceTaskType);
            soap_serialize_ec2__BundleInstanceTaskType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__BundleInstanceTasksSetType(struct soap *soap, const char *tag, int id, const struct ec2__BundleInstanceTasksSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__BundleInstanceTasksSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__BundleInstanceTaskType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTasksSetType * SOAP_FMAC4 soap_in_ec2__BundleInstanceTasksSetType(struct soap *soap, const char *tag, struct ec2__BundleInstanceTasksSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__BundleInstanceTasksSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__BundleInstanceTasksSetType, sizeof(struct ec2__BundleInstanceTasksSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__BundleInstanceTasksSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__BundleInstanceTaskType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__BundleInstanceTaskType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__BundleInstanceTaskType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__BundleInstanceTaskType(soap, "ec2:item", a->item, "ec2:BundleInstanceTaskType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__BundleInstanceTaskType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__BundleInstanceTasksSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__BundleInstanceTasksSetType, 0, sizeof(struct ec2__BundleInstanceTasksSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__BundleInstanceTasksSetType(struct soap *soap, const struct ec2__BundleInstanceTasksSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__BundleInstanceTasksSetType);
    if (soap_out_ec2__BundleInstanceTasksSetType(soap, tag?tag:"ec2:BundleInstanceTasksSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTasksSetType * SOAP_FMAC4 soap_get_ec2__BundleInstanceTasksSetType(struct soap *soap, struct ec2__BundleInstanceTasksSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__BundleInstanceTasksSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeBundleTasksResponseType(struct soap *soap, struct ec2__DescribeBundleTasksResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->bundleInstanceTasksSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeBundleTasksResponseType(struct soap *soap, const struct ec2__DescribeBundleTasksResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__BundleInstanceTasksSetType(soap, &a->bundleInstanceTasksSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeBundleTasksResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeBundleTasksResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeBundleTasksResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__BundleInstanceTasksSetType(soap, "ec2:bundleInstanceTasksSet", -1, &a->bundleInstanceTasksSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksResponseType * SOAP_FMAC4 soap_in_ec2__DescribeBundleTasksResponseType(struct soap *soap, const char *tag, struct ec2__DescribeBundleTasksResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_bundleInstanceTasksSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeBundleTasksResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeBundleTasksResponseType, sizeof(struct ec2__DescribeBundleTasksResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeBundleTasksResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_bundleInstanceTasksSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__BundleInstanceTasksSetType(soap, "ec2:bundleInstanceTasksSet", &a->bundleInstanceTasksSet, "ec2:BundleInstanceTasksSetType"))
                {       soap_flag_bundleInstanceTasksSet--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeBundleTasksResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeBundleTasksResponseType, 0, sizeof(struct ec2__DescribeBundleTasksResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_bundleInstanceTasksSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeBundleTasksResponseType(struct soap *soap, const struct ec2__DescribeBundleTasksResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeBundleTasksResponseType);
    if (soap_out_ec2__DescribeBundleTasksResponseType(soap, tag?tag:"ec2:DescribeBundleTasksResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksResponseType * SOAP_FMAC4 soap_get_ec2__DescribeBundleTasksResponseType(struct soap *soap, struct ec2__DescribeBundleTasksResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeBundleTasksResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeBundleTasksItemType(struct soap *soap, struct ec2__DescribeBundleTasksItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->bundleId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeBundleTasksItemType(struct soap *soap, const struct ec2__DescribeBundleTasksItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->bundleId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeBundleTasksItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeBundleTasksItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeBundleTasksItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:bundleId", -1, &a->bundleId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksItemType * SOAP_FMAC4 soap_in_ec2__DescribeBundleTasksItemType(struct soap *soap, const char *tag, struct ec2__DescribeBundleTasksItemType *a, const char *type)
  {
    size_t soap_flag_bundleId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeBundleTasksItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeBundleTasksItemType, sizeof(struct ec2__DescribeBundleTasksItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeBundleTasksItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_bundleId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:bundleId", &a->bundleId, "xsd:string"))
                {       soap_flag_bundleId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeBundleTasksItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeBundleTasksItemType, 0, sizeof(struct ec2__DescribeBundleTasksItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_bundleId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeBundleTasksItemType(struct soap *soap, const struct ec2__DescribeBundleTasksItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeBundleTasksItemType);
    if (soap_out_ec2__DescribeBundleTasksItemType(soap, tag?tag:"ec2:DescribeBundleTasksItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksItemType * SOAP_FMAC4 soap_get_ec2__DescribeBundleTasksItemType(struct soap *soap, struct ec2__DescribeBundleTasksItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeBundleTasksItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeBundleTasksInfoType(struct soap *soap, struct ec2__DescribeBundleTasksInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeBundleTasksInfoType(struct soap *soap, const struct ec2__DescribeBundleTasksInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeBundleTasksItemType);
            soap_serialize_ec2__DescribeBundleTasksItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeBundleTasksInfoType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeBundleTasksInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeBundleTasksInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeBundleTasksItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksInfoType * SOAP_FMAC4 soap_in_ec2__DescribeBundleTasksInfoType(struct soap *soap, const char *tag, struct ec2__DescribeBundleTasksInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeBundleTasksInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeBundleTasksInfoType, sizeof(struct ec2__DescribeBundleTasksInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeBundleTasksInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeBundleTasksItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeBundleTasksItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeBundleTasksItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeBundleTasksItemType(soap, "ec2:item", a->item, "ec2:DescribeBundleTasksItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeBundleTasksItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeBundleTasksInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeBundleTasksInfoType, 0, sizeof(struct ec2__DescribeBundleTasksInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeBundleTasksInfoType(struct soap *soap, const struct ec2__DescribeBundleTasksInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeBundleTasksInfoType);
    if (soap_out_ec2__DescribeBundleTasksInfoType(soap, tag?tag:"ec2:DescribeBundleTasksInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksInfoType * SOAP_FMAC4 soap_get_ec2__DescribeBundleTasksInfoType(struct soap *soap, struct ec2__DescribeBundleTasksInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeBundleTasksInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeBundleTasksType(struct soap *soap, struct ec2__DescribeBundleTasksType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->bundlesSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeBundleTasksType(struct soap *soap, const struct ec2__DescribeBundleTasksType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeBundleTasksInfoType(soap, &a->bundlesSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeBundleTasksType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeBundleTasksType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeBundleTasksType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeBundleTasksInfoType(soap, "ec2:bundlesSet", -1, &a->bundlesSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksType * SOAP_FMAC4 soap_in_ec2__DescribeBundleTasksType(struct soap *soap, const char *tag, struct ec2__DescribeBundleTasksType *a, const char *type)
  {
    size_t soap_flag_bundlesSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeBundleTasksType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeBundleTasksType, sizeof(struct ec2__DescribeBundleTasksType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeBundleTasksType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_bundlesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeBundleTasksInfoType(soap, "ec2:bundlesSet", &a->bundlesSet, "ec2:DescribeBundleTasksInfoType"))
                {       soap_flag_bundlesSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeBundleTasksType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeBundleTasksType, 0, sizeof(struct ec2__DescribeBundleTasksType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_bundlesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeBundleTasksType(struct soap *soap, const struct ec2__DescribeBundleTasksType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeBundleTasksType);
    if (soap_out_ec2__DescribeBundleTasksType(soap, tag?tag:"ec2:DescribeBundleTasksType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeBundleTasksType * SOAP_FMAC4 soap_get_ec2__DescribeBundleTasksType(struct soap *soap, struct ec2__DescribeBundleTasksType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeBundleTasksType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__BundleInstanceTaskErrorType(struct soap *soap, struct ec2__BundleInstanceTaskErrorType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->code);
    soap_default_string(soap, &a->message);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__BundleInstanceTaskErrorType(struct soap *soap, const struct ec2__BundleInstanceTaskErrorType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->code);
    soap_serialize_string(soap, &a->message);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__BundleInstanceTaskErrorType(struct soap *soap, const char *tag, int id, const struct ec2__BundleInstanceTaskErrorType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__BundleInstanceTaskErrorType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:code", -1, &a->code, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:message", -1, &a->message, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTaskErrorType * SOAP_FMAC4 soap_in_ec2__BundleInstanceTaskErrorType(struct soap *soap, const char *tag, struct ec2__BundleInstanceTaskErrorType *a, const char *type)
  {
    size_t soap_flag_code = 1;
    size_t soap_flag_message = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__BundleInstanceTaskErrorType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__BundleInstanceTaskErrorType, sizeof(struct ec2__BundleInstanceTaskErrorType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__BundleInstanceTaskErrorType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_code && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:code", &a->code, "xsd:string"))
                {       soap_flag_code--;
                  continue;
                }
            if (soap_flag_message && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:message", &a->message, "xsd:string"))
                {       soap_flag_message--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__BundleInstanceTaskErrorType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__BundleInstanceTaskErrorType, 0, sizeof(struct ec2__BundleInstanceTaskErrorType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_code > 0 || soap_flag_message > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__BundleInstanceTaskErrorType(struct soap *soap, const struct ec2__BundleInstanceTaskErrorType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__BundleInstanceTaskErrorType);
    if (soap_out_ec2__BundleInstanceTaskErrorType(soap, tag?tag:"ec2:BundleInstanceTaskErrorType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTaskErrorType * SOAP_FMAC4 soap_get_ec2__BundleInstanceTaskErrorType(struct soap *soap, struct ec2__BundleInstanceTaskErrorType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__BundleInstanceTaskErrorType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__BundleInstanceTaskType(struct soap *soap, struct ec2__BundleInstanceTaskType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
    soap_default_string(soap, &a->bundleId);
    soap_default_string(soap, &a->state);
    soap_default_time(soap, &a->startTime);
    soap_default_time(soap, &a->updateTime);
    a->storage = NULL;
    soap_default_string(soap, &a->progress);
    a->error = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__BundleInstanceTaskType(struct soap *soap, const struct ec2__BundleInstanceTaskType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->bundleId);
    soap_serialize_string(soap, &a->state);
    soap_serialize_PointerToec2__BundleInstanceTaskStorageType(soap, &a->storage);
    soap_serialize_string(soap, &a->progress);
    soap_serialize_PointerToec2__BundleInstanceTaskErrorType(soap, &a->error);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__BundleInstanceTaskType(struct soap *soap, const char *tag, int id, const struct ec2__BundleInstanceTaskType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__BundleInstanceTaskType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:bundleId", -1, &a->bundleId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:state", -1, &a->state, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:startTime", -1, &a->startTime, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:updateTime", -1, &a->updateTime, ""))
      return soap->error;
    if (soap_out_PointerToec2__BundleInstanceTaskStorageType(soap, "ec2:storage", -1, &a->storage, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:progress", -1, &a->progress, ""))
      return soap->error;
    if (soap_out_PointerToec2__BundleInstanceTaskErrorType(soap, "ec2:error", -1, &a->error, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTaskType * SOAP_FMAC4 soap_in_ec2__BundleInstanceTaskType(struct soap *soap, const char *tag, struct ec2__BundleInstanceTaskType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_bundleId = 1;
    size_t soap_flag_state = 1;
    size_t soap_flag_startTime = 1;
    size_t soap_flag_updateTime = 1;
    size_t soap_flag_storage = 1;
    size_t soap_flag_progress = 1;
    size_t soap_flag_error = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__BundleInstanceTaskType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__BundleInstanceTaskType, sizeof(struct ec2__BundleInstanceTaskType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__BundleInstanceTaskType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_bundleId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:bundleId", &a->bundleId, "xsd:string"))
                {       soap_flag_bundleId--;
                  continue;
                }
            if (soap_flag_state && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:state", &a->state, "xsd:string"))
                {       soap_flag_state--;
                  continue;
                }
            if (soap_flag_startTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:startTime", &a->startTime, "xsd:dateTime"))
                {       soap_flag_startTime--;
                  continue;
                }
            if (soap_flag_updateTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:updateTime", &a->updateTime, "xsd:dateTime"))
                {       soap_flag_updateTime--;
                  continue;
                }
            if (soap_flag_storage && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__BundleInstanceTaskStorageType(soap, "ec2:storage", &a->storage, "ec2:BundleInstanceTaskStorageType"))
                {       soap_flag_storage--;
                  continue;
                }
            if (soap_flag_progress && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:progress", &a->progress, "xsd:string"))
                {       soap_flag_progress--;
                  continue;
                }
            if (soap_flag_error && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__BundleInstanceTaskErrorType(soap, "ec2:error", &a->error, "ec2:BundleInstanceTaskErrorType"))
                {       soap_flag_error--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__BundleInstanceTaskType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__BundleInstanceTaskType, 0, sizeof(struct ec2__BundleInstanceTaskType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0 || soap_flag_bundleId > 0 || soap_flag_state > 0 || soap_flag_startTime > 0 || soap_flag_updateTime > 0 || soap_flag_storage > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__BundleInstanceTaskType(struct soap *soap, const struct ec2__BundleInstanceTaskType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__BundleInstanceTaskType);
    if (soap_out_ec2__BundleInstanceTaskType(soap, tag?tag:"ec2:BundleInstanceTaskType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTaskType * SOAP_FMAC4 soap_get_ec2__BundleInstanceTaskType(struct soap *soap, struct ec2__BundleInstanceTaskType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__BundleInstanceTaskType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__BundleInstanceResponseType(struct soap *soap, struct ec2__BundleInstanceResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->bundleInstanceTask = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__BundleInstanceResponseType(struct soap *soap, const struct ec2__BundleInstanceResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__BundleInstanceTaskType(soap, &a->bundleInstanceTask);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__BundleInstanceResponseType(struct soap *soap, const char *tag, int id, const struct ec2__BundleInstanceResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__BundleInstanceResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__BundleInstanceTaskType(soap, "ec2:bundleInstanceTask", -1, &a->bundleInstanceTask, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceResponseType * SOAP_FMAC4 soap_in_ec2__BundleInstanceResponseType(struct soap *soap, const char *tag, struct ec2__BundleInstanceResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_bundleInstanceTask = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__BundleInstanceResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__BundleInstanceResponseType, sizeof(struct ec2__BundleInstanceResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__BundleInstanceResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_bundleInstanceTask && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__BundleInstanceTaskType(soap, "ec2:bundleInstanceTask", &a->bundleInstanceTask, "ec2:BundleInstanceTaskType"))
                {       soap_flag_bundleInstanceTask--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__BundleInstanceResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__BundleInstanceResponseType, 0, sizeof(struct ec2__BundleInstanceResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_bundleInstanceTask > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__BundleInstanceResponseType(struct soap *soap, const struct ec2__BundleInstanceResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__BundleInstanceResponseType);
    if (soap_out_ec2__BundleInstanceResponseType(soap, tag?tag:"ec2:BundleInstanceResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceResponseType * SOAP_FMAC4 soap_get_ec2__BundleInstanceResponseType(struct soap *soap, struct ec2__BundleInstanceResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__BundleInstanceResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__BundleInstanceS3StorageType(struct soap *soap, struct ec2__BundleInstanceS3StorageType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->bucket);
    soap_default_string(soap, &a->prefix);
    soap_default_string(soap, &a->awsAccessKeyId);
    soap_default_string(soap, &a->uploadPolicy);
    soap_default_string(soap, &a->uploadPolicySignature);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__BundleInstanceS3StorageType(struct soap *soap, const struct ec2__BundleInstanceS3StorageType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->bucket);
    soap_serialize_string(soap, &a->prefix);
    soap_serialize_string(soap, &a->awsAccessKeyId);
    soap_serialize_string(soap, &a->uploadPolicy);
    soap_serialize_string(soap, &a->uploadPolicySignature);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__BundleInstanceS3StorageType(struct soap *soap, const char *tag, int id, const struct ec2__BundleInstanceS3StorageType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__BundleInstanceS3StorageType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:bucket", -1, &a->bucket, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:prefix", -1, &a->prefix, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:awsAccessKeyId", -1, &a->awsAccessKeyId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:uploadPolicy", -1, &a->uploadPolicy, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:uploadPolicySignature", -1, &a->uploadPolicySignature, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceS3StorageType * SOAP_FMAC4 soap_in_ec2__BundleInstanceS3StorageType(struct soap *soap, const char *tag, struct ec2__BundleInstanceS3StorageType *a, const char *type)
  {
    size_t soap_flag_bucket = 1;
    size_t soap_flag_prefix = 1;
    size_t soap_flag_awsAccessKeyId = 1;
    size_t soap_flag_uploadPolicy = 1;
    size_t soap_flag_uploadPolicySignature = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__BundleInstanceS3StorageType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__BundleInstanceS3StorageType, sizeof(struct ec2__BundleInstanceS3StorageType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__BundleInstanceS3StorageType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_bucket && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:bucket", &a->bucket, "xsd:string"))
                {       soap_flag_bucket--;
                  continue;
                }
            if (soap_flag_prefix && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:prefix", &a->prefix, "xsd:string"))
                {       soap_flag_prefix--;
                  continue;
                }
            if (soap_flag_awsAccessKeyId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:awsAccessKeyId", &a->awsAccessKeyId, "xsd:string"))
                {       soap_flag_awsAccessKeyId--;
                  continue;
                }
            if (soap_flag_uploadPolicy && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:uploadPolicy", &a->uploadPolicy, "xsd:string"))
                {       soap_flag_uploadPolicy--;
                  continue;
                }
            if (soap_flag_uploadPolicySignature && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:uploadPolicySignature", &a->uploadPolicySignature, "xsd:string"))
                {       soap_flag_uploadPolicySignature--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__BundleInstanceS3StorageType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__BundleInstanceS3StorageType, 0, sizeof(struct ec2__BundleInstanceS3StorageType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_bucket > 0 || soap_flag_prefix > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__BundleInstanceS3StorageType(struct soap *soap, const struct ec2__BundleInstanceS3StorageType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__BundleInstanceS3StorageType);
    if (soap_out_ec2__BundleInstanceS3StorageType(soap, tag?tag:"ec2:BundleInstanceS3StorageType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceS3StorageType * SOAP_FMAC4 soap_get_ec2__BundleInstanceS3StorageType(struct soap *soap, struct ec2__BundleInstanceS3StorageType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__BundleInstanceS3StorageType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__BundleInstanceTaskStorageType(struct soap *soap, struct ec2__BundleInstanceTaskStorageType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->S3 = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__BundleInstanceTaskStorageType(struct soap *soap, const struct ec2__BundleInstanceTaskStorageType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__BundleInstanceS3StorageType(soap, &a->S3);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__BundleInstanceTaskStorageType(struct soap *soap, const char *tag, int id, const struct ec2__BundleInstanceTaskStorageType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__BundleInstanceTaskStorageType), type))
      return soap->error;
    if (soap_out_PointerToec2__BundleInstanceS3StorageType(soap, "ec2:S3", -1, &a->S3, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTaskStorageType * SOAP_FMAC4 soap_in_ec2__BundleInstanceTaskStorageType(struct soap *soap, const char *tag, struct ec2__BundleInstanceTaskStorageType *a, const char *type)
  {
    size_t soap_flag_S3 = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__BundleInstanceTaskStorageType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__BundleInstanceTaskStorageType, sizeof(struct ec2__BundleInstanceTaskStorageType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__BundleInstanceTaskStorageType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_S3 && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__BundleInstanceS3StorageType(soap, "ec2:S3", &a->S3, "ec2:BundleInstanceS3StorageType"))
                {       soap_flag_S3--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__BundleInstanceTaskStorageType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__BundleInstanceTaskStorageType, 0, sizeof(struct ec2__BundleInstanceTaskStorageType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_S3 > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__BundleInstanceTaskStorageType(struct soap *soap, const struct ec2__BundleInstanceTaskStorageType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__BundleInstanceTaskStorageType);
    if (soap_out_ec2__BundleInstanceTaskStorageType(soap, tag?tag:"ec2:BundleInstanceTaskStorageType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceTaskStorageType * SOAP_FMAC4 soap_get_ec2__BundleInstanceTaskStorageType(struct soap *soap, struct ec2__BundleInstanceTaskStorageType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__BundleInstanceTaskStorageType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__BundleInstanceType(struct soap *soap, struct ec2__BundleInstanceType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
    a->storage = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__BundleInstanceType(struct soap *soap, const struct ec2__BundleInstanceType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_PointerToec2__BundleInstanceTaskStorageType(soap, &a->storage);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__BundleInstanceType(struct soap *soap, const char *tag, int id, const struct ec2__BundleInstanceType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__BundleInstanceType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_PointerToec2__BundleInstanceTaskStorageType(soap, "ec2:storage", -1, &a->storage, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceType * SOAP_FMAC4 soap_in_ec2__BundleInstanceType(struct soap *soap, const char *tag, struct ec2__BundleInstanceType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_storage = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__BundleInstanceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__BundleInstanceType, sizeof(struct ec2__BundleInstanceType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__BundleInstanceType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_storage && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__BundleInstanceTaskStorageType(soap, "ec2:storage", &a->storage, "ec2:BundleInstanceTaskStorageType"))
                {       soap_flag_storage--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__BundleInstanceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__BundleInstanceType, 0, sizeof(struct ec2__BundleInstanceType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0 || soap_flag_storage > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__BundleInstanceType(struct soap *soap, const struct ec2__BundleInstanceType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__BundleInstanceType);
    if (soap_out_ec2__BundleInstanceType(soap, tag?tag:"ec2:BundleInstanceType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__BundleInstanceType * SOAP_FMAC4 soap_get_ec2__BundleInstanceType(struct soap *soap, struct ec2__BundleInstanceType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__BundleInstanceType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSnapshotsSetItemResponseType(struct soap *soap, struct ec2__DescribeSnapshotsSetItemResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->snapshotId);
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->status);
    soap_default_time(soap, &a->startTime);
    soap_default_string(soap, &a->progress);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSnapshotsSetItemResponseType(struct soap *soap, const struct ec2__DescribeSnapshotsSetItemResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->snapshotId);
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->status);
    soap_serialize_string(soap, &a->progress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSnapshotsSetItemResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSnapshotsSetItemResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:snapshotId", -1, &a->snapshotId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:status", -1, &a->status, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:startTime", -1, &a->startTime, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:progress", -1, &a->progress, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetItemResponseType * SOAP_FMAC4 soap_in_ec2__DescribeSnapshotsSetItemResponseType(struct soap *soap, const char *tag, struct ec2__DescribeSnapshotsSetItemResponseType *a, const char *type)
  {
    size_t soap_flag_snapshotId = 1;
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_status = 1;
    size_t soap_flag_startTime = 1;
    size_t soap_flag_progress = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSnapshotsSetItemResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType, sizeof(struct ec2__DescribeSnapshotsSetItemResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSnapshotsSetItemResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_snapshotId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:snapshotId", &a->snapshotId, "xsd:string"))
                {       soap_flag_snapshotId--;
                  continue;
                }
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:status", &a->status, "xsd:string"))
                {       soap_flag_status--;
                  continue;
                }
            if (soap_flag_startTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:startTime", &a->startTime, "xsd:dateTime"))
                {       soap_flag_startTime--;
                  continue;
                }
            if (soap_flag_progress && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:progress", &a->progress, "xsd:string"))
                {       soap_flag_progress--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSnapshotsSetItemResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType, 0, sizeof(struct ec2__DescribeSnapshotsSetItemResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_snapshotId > 0 || soap_flag_volumeId > 0 || soap_flag_status > 0 || soap_flag_startTime > 0 || soap_flag_progress > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSnapshotsSetItemResponseType(struct soap *soap, const struct ec2__DescribeSnapshotsSetItemResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType);
    if (soap_out_ec2__DescribeSnapshotsSetItemResponseType(soap, tag?tag:"ec2:DescribeSnapshotsSetItemResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetItemResponseType * SOAP_FMAC4 soap_get_ec2__DescribeSnapshotsSetItemResponseType(struct soap *soap, struct ec2__DescribeSnapshotsSetItemResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSnapshotsSetItemResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSnapshotsSetResponseType(struct soap *soap, struct ec2__DescribeSnapshotsSetResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSnapshotsSetResponseType(struct soap *soap, const struct ec2__DescribeSnapshotsSetResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeSnapshotsSetItemResponseType);
            soap_serialize_ec2__DescribeSnapshotsSetItemResponseType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSnapshotsSetResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSnapshotsSetResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeSnapshotsSetItemResponseType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetResponseType * SOAP_FMAC4 soap_in_ec2__DescribeSnapshotsSetResponseType(struct soap *soap, const char *tag, struct ec2__DescribeSnapshotsSetResponseType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSnapshotsSetResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType, sizeof(struct ec2__DescribeSnapshotsSetResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSnapshotsSetResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeSnapshotsSetItemResponseType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeSnapshotsSetItemResponseType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeSnapshotsSetItemResponseType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeSnapshotsSetItemResponseType(soap, "ec2:item", a->item, "ec2:DescribeSnapshotsSetItemResponseType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeSnapshotsSetItemResponseType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSnapshotsSetResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType, 0, sizeof(struct ec2__DescribeSnapshotsSetResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSnapshotsSetResponseType(struct soap *soap, const struct ec2__DescribeSnapshotsSetResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSnapshotsSetResponseType);
    if (soap_out_ec2__DescribeSnapshotsSetResponseType(soap, tag?tag:"ec2:DescribeSnapshotsSetResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetResponseType * SOAP_FMAC4 soap_get_ec2__DescribeSnapshotsSetResponseType(struct soap *soap, struct ec2__DescribeSnapshotsSetResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSnapshotsSetResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSnapshotsResponseType(struct soap *soap, struct ec2__DescribeSnapshotsResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->snapshotSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSnapshotsResponseType(struct soap *soap, const struct ec2__DescribeSnapshotsResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__DescribeSnapshotsSetResponseType(soap, &a->snapshotSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSnapshotsResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSnapshotsResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSnapshotsResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__DescribeSnapshotsSetResponseType(soap, "ec2:snapshotSet", -1, &a->snapshotSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsResponseType * SOAP_FMAC4 soap_in_ec2__DescribeSnapshotsResponseType(struct soap *soap, const char *tag, struct ec2__DescribeSnapshotsResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_snapshotSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSnapshotsResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSnapshotsResponseType, sizeof(struct ec2__DescribeSnapshotsResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSnapshotsResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_snapshotSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeSnapshotsSetResponseType(soap, "ec2:snapshotSet", &a->snapshotSet, "ec2:DescribeSnapshotsSetResponseType"))
                {       soap_flag_snapshotSet--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSnapshotsResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSnapshotsResponseType, 0, sizeof(struct ec2__DescribeSnapshotsResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_snapshotSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSnapshotsResponseType(struct soap *soap, const struct ec2__DescribeSnapshotsResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSnapshotsResponseType);
    if (soap_out_ec2__DescribeSnapshotsResponseType(soap, tag?tag:"ec2:DescribeSnapshotsResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsResponseType * SOAP_FMAC4 soap_get_ec2__DescribeSnapshotsResponseType(struct soap *soap, struct ec2__DescribeSnapshotsResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSnapshotsResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSnapshotsSetItemType(struct soap *soap, struct ec2__DescribeSnapshotsSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->snapshotId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSnapshotsSetItemType(struct soap *soap, const struct ec2__DescribeSnapshotsSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->snapshotId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSnapshotsSetItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSnapshotsSetItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:snapshotId", -1, &a->snapshotId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetItemType * SOAP_FMAC4 soap_in_ec2__DescribeSnapshotsSetItemType(struct soap *soap, const char *tag, struct ec2__DescribeSnapshotsSetItemType *a, const char *type)
  {
    size_t soap_flag_snapshotId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSnapshotsSetItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetItemType, sizeof(struct ec2__DescribeSnapshotsSetItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSnapshotsSetItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_snapshotId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:snapshotId", &a->snapshotId, "xsd:string"))
                {       soap_flag_snapshotId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSnapshotsSetItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSnapshotsSetItemType, 0, sizeof(struct ec2__DescribeSnapshotsSetItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_snapshotId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSnapshotsSetItemType(struct soap *soap, const struct ec2__DescribeSnapshotsSetItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSnapshotsSetItemType);
    if (soap_out_ec2__DescribeSnapshotsSetItemType(soap, tag?tag:"ec2:DescribeSnapshotsSetItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetItemType * SOAP_FMAC4 soap_get_ec2__DescribeSnapshotsSetItemType(struct soap *soap, struct ec2__DescribeSnapshotsSetItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSnapshotsSetItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSnapshotsSetType(struct soap *soap, struct ec2__DescribeSnapshotsSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSnapshotsSetType(struct soap *soap, const struct ec2__DescribeSnapshotsSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeSnapshotsSetItemType);
            soap_serialize_ec2__DescribeSnapshotsSetItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSnapshotsSetType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSnapshotsSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeSnapshotsSetItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetType * SOAP_FMAC4 soap_in_ec2__DescribeSnapshotsSetType(struct soap *soap, const char *tag, struct ec2__DescribeSnapshotsSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSnapshotsSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSnapshotsSetType, sizeof(struct ec2__DescribeSnapshotsSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSnapshotsSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeSnapshotsSetItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeSnapshotsSetItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeSnapshotsSetItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeSnapshotsSetItemType(soap, "ec2:item", a->item, "ec2:DescribeSnapshotsSetItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeSnapshotsSetItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSnapshotsSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSnapshotsSetType, 0, sizeof(struct ec2__DescribeSnapshotsSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSnapshotsSetType(struct soap *soap, const struct ec2__DescribeSnapshotsSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSnapshotsSetType);
    if (soap_out_ec2__DescribeSnapshotsSetType(soap, tag?tag:"ec2:DescribeSnapshotsSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsSetType * SOAP_FMAC4 soap_get_ec2__DescribeSnapshotsSetType(struct soap *soap, struct ec2__DescribeSnapshotsSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSnapshotsSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSnapshotsType(struct soap *soap, struct ec2__DescribeSnapshotsType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->snapshotSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSnapshotsType(struct soap *soap, const struct ec2__DescribeSnapshotsType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeSnapshotsSetType(soap, &a->snapshotSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSnapshotsType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSnapshotsType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSnapshotsType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeSnapshotsSetType(soap, "ec2:snapshotSet", -1, &a->snapshotSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsType * SOAP_FMAC4 soap_in_ec2__DescribeSnapshotsType(struct soap *soap, const char *tag, struct ec2__DescribeSnapshotsType *a, const char *type)
  {
    size_t soap_flag_snapshotSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSnapshotsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSnapshotsType, sizeof(struct ec2__DescribeSnapshotsType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSnapshotsType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_snapshotSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeSnapshotsSetType(soap, "ec2:snapshotSet", &a->snapshotSet, "ec2:DescribeSnapshotsSetType"))
                {       soap_flag_snapshotSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSnapshotsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSnapshotsType, 0, sizeof(struct ec2__DescribeSnapshotsType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_snapshotSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSnapshotsType(struct soap *soap, const struct ec2__DescribeSnapshotsType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSnapshotsType);
    if (soap_out_ec2__DescribeSnapshotsType(soap, tag?tag:"ec2:DescribeSnapshotsType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSnapshotsType * SOAP_FMAC4 soap_get_ec2__DescribeSnapshotsType(struct soap *soap, struct ec2__DescribeSnapshotsType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSnapshotsType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DeleteSnapshotResponseType(struct soap *soap, struct ec2__DeleteSnapshotResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DeleteSnapshotResponseType(struct soap *soap, const struct ec2__DeleteSnapshotResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DeleteSnapshotResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DeleteSnapshotResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DeleteSnapshotResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DeleteSnapshotResponseType * SOAP_FMAC4 soap_in_ec2__DeleteSnapshotResponseType(struct soap *soap, const char *tag, struct ec2__DeleteSnapshotResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DeleteSnapshotResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DeleteSnapshotResponseType, sizeof(struct ec2__DeleteSnapshotResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DeleteSnapshotResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DeleteSnapshotResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DeleteSnapshotResponseType, 0, sizeof(struct ec2__DeleteSnapshotResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DeleteSnapshotResponseType(struct soap *soap, const struct ec2__DeleteSnapshotResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DeleteSnapshotResponseType);
    if (soap_out_ec2__DeleteSnapshotResponseType(soap, tag?tag:"ec2:DeleteSnapshotResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DeleteSnapshotResponseType * SOAP_FMAC4 soap_get_ec2__DeleteSnapshotResponseType(struct soap *soap, struct ec2__DeleteSnapshotResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DeleteSnapshotResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DeleteSnapshotType(struct soap *soap, struct ec2__DeleteSnapshotType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->snapshotId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DeleteSnapshotType(struct soap *soap, const struct ec2__DeleteSnapshotType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->snapshotId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DeleteSnapshotType(struct soap *soap, const char *tag, int id, const struct ec2__DeleteSnapshotType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DeleteSnapshotType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:snapshotId", -1, &a->snapshotId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DeleteSnapshotType * SOAP_FMAC4 soap_in_ec2__DeleteSnapshotType(struct soap *soap, const char *tag, struct ec2__DeleteSnapshotType *a, const char *type)
  {
    size_t soap_flag_snapshotId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DeleteSnapshotType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DeleteSnapshotType, sizeof(struct ec2__DeleteSnapshotType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DeleteSnapshotType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_snapshotId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:snapshotId", &a->snapshotId, "xsd:string"))
                {       soap_flag_snapshotId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DeleteSnapshotType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DeleteSnapshotType, 0, sizeof(struct ec2__DeleteSnapshotType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_snapshotId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DeleteSnapshotType(struct soap *soap, const struct ec2__DeleteSnapshotType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DeleteSnapshotType);
    if (soap_out_ec2__DeleteSnapshotType(soap, tag?tag:"ec2:DeleteSnapshotType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DeleteSnapshotType * SOAP_FMAC4 soap_get_ec2__DeleteSnapshotType(struct soap *soap, struct ec2__DeleteSnapshotType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DeleteSnapshotType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CreateSnapshotResponseType(struct soap *soap, struct ec2__CreateSnapshotResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->snapshotId);
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->status);
    soap_default_time(soap, &a->startTime);
    soap_default_string(soap, &a->progress);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CreateSnapshotResponseType(struct soap *soap, const struct ec2__CreateSnapshotResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->snapshotId);
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->status);
    soap_serialize_string(soap, &a->progress);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CreateSnapshotResponseType(struct soap *soap, const char *tag, int id, const struct ec2__CreateSnapshotResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CreateSnapshotResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:snapshotId", -1, &a->snapshotId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:status", -1, &a->status, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:startTime", -1, &a->startTime, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:progress", -1, &a->progress, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CreateSnapshotResponseType * SOAP_FMAC4 soap_in_ec2__CreateSnapshotResponseType(struct soap *soap, const char *tag, struct ec2__CreateSnapshotResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_snapshotId = 1;
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_status = 1;
    size_t soap_flag_startTime = 1;
    size_t soap_flag_progress = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CreateSnapshotResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CreateSnapshotResponseType, sizeof(struct ec2__CreateSnapshotResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CreateSnapshotResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_snapshotId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:snapshotId", &a->snapshotId, "xsd:string"))
                {       soap_flag_snapshotId--;
                  continue;
                }
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:status", &a->status, "xsd:string"))
                {       soap_flag_status--;
                  continue;
                }
            if (soap_flag_startTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:startTime", &a->startTime, "xsd:dateTime"))
                {       soap_flag_startTime--;
                  continue;
                }
            if (soap_flag_progress && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:progress", &a->progress, "xsd:string"))
                {       soap_flag_progress--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CreateSnapshotResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CreateSnapshotResponseType, 0, sizeof(struct ec2__CreateSnapshotResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_snapshotId > 0 || soap_flag_volumeId > 0 || soap_flag_status > 0 || soap_flag_startTime > 0 || soap_flag_progress > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CreateSnapshotResponseType(struct soap *soap, const struct ec2__CreateSnapshotResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CreateSnapshotResponseType);
    if (soap_out_ec2__CreateSnapshotResponseType(soap, tag?tag:"ec2:CreateSnapshotResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CreateSnapshotResponseType * SOAP_FMAC4 soap_get_ec2__CreateSnapshotResponseType(struct soap *soap, struct ec2__CreateSnapshotResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CreateSnapshotResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CreateSnapshotType(struct soap *soap, struct ec2__CreateSnapshotType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->volumeId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CreateSnapshotType(struct soap *soap, const struct ec2__CreateSnapshotType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->volumeId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CreateSnapshotType(struct soap *soap, const char *tag, int id, const struct ec2__CreateSnapshotType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CreateSnapshotType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CreateSnapshotType * SOAP_FMAC4 soap_in_ec2__CreateSnapshotType(struct soap *soap, const char *tag, struct ec2__CreateSnapshotType *a, const char *type)
  {
    size_t soap_flag_volumeId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CreateSnapshotType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CreateSnapshotType, sizeof(struct ec2__CreateSnapshotType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CreateSnapshotType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CreateSnapshotType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CreateSnapshotType, 0, sizeof(struct ec2__CreateSnapshotType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CreateSnapshotType(struct soap *soap, const struct ec2__CreateSnapshotType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CreateSnapshotType);
    if (soap_out_ec2__CreateSnapshotType(soap, tag?tag:"ec2:CreateSnapshotType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CreateSnapshotType * SOAP_FMAC4 soap_get_ec2__CreateSnapshotType(struct soap *soap, struct ec2__CreateSnapshotType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CreateSnapshotType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DetachVolumeResponseType(struct soap *soap, struct ec2__DetachVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->instanceId);
    soap_default_string(soap, &a->device);
    soap_default_string(soap, &a->status);
    soap_default_time(soap, &a->attachTime);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DetachVolumeResponseType(struct soap *soap, const struct ec2__DetachVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->device);
    soap_serialize_string(soap, &a->status);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DetachVolumeResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DetachVolumeResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DetachVolumeResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:device", -1, &a->device, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:status", -1, &a->status, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:attachTime", -1, &a->attachTime, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DetachVolumeResponseType * SOAP_FMAC4 soap_in_ec2__DetachVolumeResponseType(struct soap *soap, const char *tag, struct ec2__DetachVolumeResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_device = 1;
    size_t soap_flag_status = 1;
    size_t soap_flag_attachTime = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DetachVolumeResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DetachVolumeResponseType, sizeof(struct ec2__DetachVolumeResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DetachVolumeResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_device && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:device", &a->device, "xsd:string"))
                {       soap_flag_device--;
                  continue;
                }
            if (soap_flag_status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:status", &a->status, "xsd:string"))
                {       soap_flag_status--;
                  continue;
                }
            if (soap_flag_attachTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:attachTime", &a->attachTime, "xsd:dateTime"))
                {       soap_flag_attachTime--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DetachVolumeResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DetachVolumeResponseType, 0, sizeof(struct ec2__DetachVolumeResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_volumeId > 0 || soap_flag_instanceId > 0 || soap_flag_device > 0 || soap_flag_status > 0 || soap_flag_attachTime > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DetachVolumeResponseType(struct soap *soap, const struct ec2__DetachVolumeResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DetachVolumeResponseType);
    if (soap_out_ec2__DetachVolumeResponseType(soap, tag?tag:"ec2:DetachVolumeResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DetachVolumeResponseType * SOAP_FMAC4 soap_get_ec2__DetachVolumeResponseType(struct soap *soap, struct ec2__DetachVolumeResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DetachVolumeResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DetachVolumeType(struct soap *soap, struct ec2__DetachVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->instanceId);
    soap_default_string(soap, &a->device);
    a->force = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DetachVolumeType(struct soap *soap, const struct ec2__DetachVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->device);
    soap_serialize_PointerToxsd__boolean_(soap, &a->force);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DetachVolumeType(struct soap *soap, const char *tag, int id, const struct ec2__DetachVolumeType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DetachVolumeType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:device", -1, &a->device, ""))
      return soap->error;
    if (soap_out_PointerToxsd__boolean_(soap, "ec2:force", -1, &a->force, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DetachVolumeType * SOAP_FMAC4 soap_in_ec2__DetachVolumeType(struct soap *soap, const char *tag, struct ec2__DetachVolumeType *a, const char *type)
  {
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_device = 1;
    size_t soap_flag_force = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DetachVolumeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DetachVolumeType, sizeof(struct ec2__DetachVolumeType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DetachVolumeType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_device && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:device", &a->device, "xsd:string"))
                {       soap_flag_device--;
                  continue;
                }
            if (soap_flag_force && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToxsd__boolean_(soap, "ec2:force", &a->force, "xsd:boolean"))
                {       soap_flag_force--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DetachVolumeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DetachVolumeType, 0, sizeof(struct ec2__DetachVolumeType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DetachVolumeType(struct soap *soap, const struct ec2__DetachVolumeType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DetachVolumeType);
    if (soap_out_ec2__DetachVolumeType(soap, tag?tag:"ec2:DetachVolumeType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DetachVolumeType * SOAP_FMAC4 soap_get_ec2__DetachVolumeType(struct soap *soap, struct ec2__DetachVolumeType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DetachVolumeType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AttachVolumeResponseType(struct soap *soap, struct ec2__AttachVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->instanceId);
    soap_default_string(soap, &a->device);
    soap_default_string(soap, &a->status);
    soap_default_time(soap, &a->attachTime);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AttachVolumeResponseType(struct soap *soap, const struct ec2__AttachVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->device);
    soap_serialize_string(soap, &a->status);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AttachVolumeResponseType(struct soap *soap, const char *tag, int id, const struct ec2__AttachVolumeResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AttachVolumeResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:device", -1, &a->device, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:status", -1, &a->status, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:attachTime", -1, &a->attachTime, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AttachVolumeResponseType * SOAP_FMAC4 soap_in_ec2__AttachVolumeResponseType(struct soap *soap, const char *tag, struct ec2__AttachVolumeResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_device = 1;
    size_t soap_flag_status = 1;
    size_t soap_flag_attachTime = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AttachVolumeResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AttachVolumeResponseType, sizeof(struct ec2__AttachVolumeResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AttachVolumeResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_device && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:device", &a->device, "xsd:string"))
                {       soap_flag_device--;
                  continue;
                }
            if (soap_flag_status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:status", &a->status, "xsd:string"))
                {       soap_flag_status--;
                  continue;
                }
            if (soap_flag_attachTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:attachTime", &a->attachTime, "xsd:dateTime"))
                {       soap_flag_attachTime--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AttachVolumeResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AttachVolumeResponseType, 0, sizeof(struct ec2__AttachVolumeResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_volumeId > 0 || soap_flag_instanceId > 0 || soap_flag_device > 0 || soap_flag_status > 0 || soap_flag_attachTime > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AttachVolumeResponseType(struct soap *soap, const struct ec2__AttachVolumeResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AttachVolumeResponseType);
    if (soap_out_ec2__AttachVolumeResponseType(soap, tag?tag:"ec2:AttachVolumeResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AttachVolumeResponseType * SOAP_FMAC4 soap_get_ec2__AttachVolumeResponseType(struct soap *soap, struct ec2__AttachVolumeResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AttachVolumeResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AttachVolumeType(struct soap *soap, struct ec2__AttachVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->instanceId);
    soap_default_string(soap, &a->device);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AttachVolumeType(struct soap *soap, const struct ec2__AttachVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->device);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AttachVolumeType(struct soap *soap, const char *tag, int id, const struct ec2__AttachVolumeType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AttachVolumeType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:device", -1, &a->device, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AttachVolumeType * SOAP_FMAC4 soap_in_ec2__AttachVolumeType(struct soap *soap, const char *tag, struct ec2__AttachVolumeType *a, const char *type)
  {
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_device = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AttachVolumeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AttachVolumeType, sizeof(struct ec2__AttachVolumeType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AttachVolumeType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_device && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:device", &a->device, "xsd:string"))
                {       soap_flag_device--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AttachVolumeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AttachVolumeType, 0, sizeof(struct ec2__AttachVolumeType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeId > 0 || soap_flag_instanceId > 0 || soap_flag_device > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AttachVolumeType(struct soap *soap, const struct ec2__AttachVolumeType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AttachVolumeType);
    if (soap_out_ec2__AttachVolumeType(soap, tag?tag:"ec2:AttachVolumeType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AttachVolumeType * SOAP_FMAC4 soap_get_ec2__AttachVolumeType(struct soap *soap, struct ec2__AttachVolumeType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AttachVolumeType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AttachmentSetItemResponseType(struct soap *soap, struct ec2__AttachmentSetItemResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->instanceId);
    soap_default_string(soap, &a->device);
    soap_default_string(soap, &a->status);
    soap_default_time(soap, &a->attachTime);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AttachmentSetItemResponseType(struct soap *soap, const struct ec2__AttachmentSetItemResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->device);
    soap_serialize_string(soap, &a->status);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AttachmentSetItemResponseType(struct soap *soap, const char *tag, int id, const struct ec2__AttachmentSetItemResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AttachmentSetItemResponseType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:device", -1, &a->device, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:status", -1, &a->status, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:attachTime", -1, &a->attachTime, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AttachmentSetItemResponseType * SOAP_FMAC4 soap_in_ec2__AttachmentSetItemResponseType(struct soap *soap, const char *tag, struct ec2__AttachmentSetItemResponseType *a, const char *type)
  {
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_device = 1;
    size_t soap_flag_status = 1;
    size_t soap_flag_attachTime = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AttachmentSetItemResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AttachmentSetItemResponseType, sizeof(struct ec2__AttachmentSetItemResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AttachmentSetItemResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_device && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:device", &a->device, "xsd:string"))
                {       soap_flag_device--;
                  continue;
                }
            if (soap_flag_status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:status", &a->status, "xsd:string"))
                {       soap_flag_status--;
                  continue;
                }
            if (soap_flag_attachTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:attachTime", &a->attachTime, "xsd:dateTime"))
                {       soap_flag_attachTime--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AttachmentSetItemResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AttachmentSetItemResponseType, 0, sizeof(struct ec2__AttachmentSetItemResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeId > 0 || soap_flag_instanceId > 0 || soap_flag_device > 0 || soap_flag_status > 0 || soap_flag_attachTime > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AttachmentSetItemResponseType(struct soap *soap, const struct ec2__AttachmentSetItemResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AttachmentSetItemResponseType);
    if (soap_out_ec2__AttachmentSetItemResponseType(soap, tag?tag:"ec2:AttachmentSetItemResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AttachmentSetItemResponseType * SOAP_FMAC4 soap_get_ec2__AttachmentSetItemResponseType(struct soap *soap, struct ec2__AttachmentSetItemResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AttachmentSetItemResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AttachmentSetResponseType(struct soap *soap, struct ec2__AttachmentSetResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AttachmentSetResponseType(struct soap *soap, const struct ec2__AttachmentSetResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__AttachmentSetItemResponseType);
            soap_serialize_ec2__AttachmentSetItemResponseType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AttachmentSetResponseType(struct soap *soap, const char *tag, int id, const struct ec2__AttachmentSetResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AttachmentSetResponseType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__AttachmentSetItemResponseType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AttachmentSetResponseType * SOAP_FMAC4 soap_in_ec2__AttachmentSetResponseType(struct soap *soap, const char *tag, struct ec2__AttachmentSetResponseType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AttachmentSetResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AttachmentSetResponseType, sizeof(struct ec2__AttachmentSetResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AttachmentSetResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__AttachmentSetItemResponseType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__AttachmentSetItemResponseType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__AttachmentSetItemResponseType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__AttachmentSetItemResponseType(soap, "ec2:item", a->item, "ec2:AttachmentSetItemResponseType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__AttachmentSetItemResponseType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AttachmentSetResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AttachmentSetResponseType, 0, sizeof(struct ec2__AttachmentSetResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AttachmentSetResponseType(struct soap *soap, const struct ec2__AttachmentSetResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AttachmentSetResponseType);
    if (soap_out_ec2__AttachmentSetResponseType(soap, tag?tag:"ec2:AttachmentSetResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AttachmentSetResponseType * SOAP_FMAC4 soap_get_ec2__AttachmentSetResponseType(struct soap *soap, struct ec2__AttachmentSetResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AttachmentSetResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeVolumesSetItemResponseType(struct soap *soap, struct ec2__DescribeVolumesSetItemResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->size);
    soap_default_string(soap, &a->snapshotId);
    soap_default_string(soap, &a->availabilityZone);
    soap_default_string(soap, &a->status);
    soap_default_time(soap, &a->createTime);
    a->attachmentSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeVolumesSetItemResponseType(struct soap *soap, const struct ec2__DescribeVolumesSetItemResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->size);
    soap_serialize_string(soap, &a->snapshotId);
    soap_serialize_string(soap, &a->availabilityZone);
    soap_serialize_string(soap, &a->status);
    soap_serialize_PointerToec2__AttachmentSetResponseType(soap, &a->attachmentSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeVolumesSetItemResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeVolumesSetItemResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:size", -1, &a->size, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:snapshotId", -1, &a->snapshotId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:availabilityZone", -1, &a->availabilityZone, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:status", -1, &a->status, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:createTime", -1, &a->createTime, ""))
      return soap->error;
    if (soap_out_PointerToec2__AttachmentSetResponseType(soap, "ec2:attachmentSet", -1, &a->attachmentSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetItemResponseType * SOAP_FMAC4 soap_in_ec2__DescribeVolumesSetItemResponseType(struct soap *soap, const char *tag, struct ec2__DescribeVolumesSetItemResponseType *a, const char *type)
  {
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_size = 1;
    size_t soap_flag_snapshotId = 1;
    size_t soap_flag_availabilityZone = 1;
    size_t soap_flag_status = 1;
    size_t soap_flag_createTime = 1;
    size_t soap_flag_attachmentSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeVolumesSetItemResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType, sizeof(struct ec2__DescribeVolumesSetItemResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeVolumesSetItemResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_size && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:size", &a->size, "xsd:string"))
                {       soap_flag_size--;
                  continue;
                }
            if (soap_flag_snapshotId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:snapshotId", &a->snapshotId, "xsd:string"))
                {       soap_flag_snapshotId--;
                  continue;
                }
            if (soap_flag_availabilityZone && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:availabilityZone", &a->availabilityZone, "xsd:string"))
                {       soap_flag_availabilityZone--;
                  continue;
                }
            if (soap_flag_status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:status", &a->status, "xsd:string"))
                {       soap_flag_status--;
                  continue;
                }
            if (soap_flag_createTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:createTime", &a->createTime, "xsd:dateTime"))
                {       soap_flag_createTime--;
                  continue;
                }
            if (soap_flag_attachmentSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__AttachmentSetResponseType(soap, "ec2:attachmentSet", &a->attachmentSet, "ec2:AttachmentSetResponseType"))
                {       soap_flag_attachmentSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeVolumesSetItemResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType, 0, sizeof(struct ec2__DescribeVolumesSetItemResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeId > 0 || soap_flag_size > 0 || soap_flag_snapshotId > 0 || soap_flag_availabilityZone > 0 || soap_flag_status > 0 || soap_flag_createTime > 0 || soap_flag_attachmentSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeVolumesSetItemResponseType(struct soap *soap, const struct ec2__DescribeVolumesSetItemResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType);
    if (soap_out_ec2__DescribeVolumesSetItemResponseType(soap, tag?tag:"ec2:DescribeVolumesSetItemResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetItemResponseType * SOAP_FMAC4 soap_get_ec2__DescribeVolumesSetItemResponseType(struct soap *soap, struct ec2__DescribeVolumesSetItemResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeVolumesSetItemResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeVolumesSetResponseType(struct soap *soap, struct ec2__DescribeVolumesSetResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeVolumesSetResponseType(struct soap *soap, const struct ec2__DescribeVolumesSetResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeVolumesSetItemResponseType);
            soap_serialize_ec2__DescribeVolumesSetItemResponseType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeVolumesSetResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeVolumesSetResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeVolumesSetResponseType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeVolumesSetItemResponseType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetResponseType * SOAP_FMAC4 soap_in_ec2__DescribeVolumesSetResponseType(struct soap *soap, const char *tag, struct ec2__DescribeVolumesSetResponseType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeVolumesSetResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeVolumesSetResponseType, sizeof(struct ec2__DescribeVolumesSetResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeVolumesSetResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeVolumesSetItemResponseType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeVolumesSetItemResponseType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeVolumesSetItemResponseType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeVolumesSetItemResponseType(soap, "ec2:item", a->item, "ec2:DescribeVolumesSetItemResponseType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeVolumesSetItemResponseType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeVolumesSetResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeVolumesSetResponseType, 0, sizeof(struct ec2__DescribeVolumesSetResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeVolumesSetResponseType(struct soap *soap, const struct ec2__DescribeVolumesSetResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeVolumesSetResponseType);
    if (soap_out_ec2__DescribeVolumesSetResponseType(soap, tag?tag:"ec2:DescribeVolumesSetResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetResponseType * SOAP_FMAC4 soap_get_ec2__DescribeVolumesSetResponseType(struct soap *soap, struct ec2__DescribeVolumesSetResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeVolumesSetResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeVolumesResponseType(struct soap *soap, struct ec2__DescribeVolumesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->volumeSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeVolumesResponseType(struct soap *soap, const struct ec2__DescribeVolumesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__DescribeVolumesSetResponseType(soap, &a->volumeSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeVolumesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeVolumesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeVolumesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__DescribeVolumesSetResponseType(soap, "ec2:volumeSet", -1, &a->volumeSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesResponseType * SOAP_FMAC4 soap_in_ec2__DescribeVolumesResponseType(struct soap *soap, const char *tag, struct ec2__DescribeVolumesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_volumeSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeVolumesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeVolumesResponseType, sizeof(struct ec2__DescribeVolumesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeVolumesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_volumeSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeVolumesSetResponseType(soap, "ec2:volumeSet", &a->volumeSet, "ec2:DescribeVolumesSetResponseType"))
                {       soap_flag_volumeSet--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeVolumesResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeVolumesResponseType, 0, sizeof(struct ec2__DescribeVolumesResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_volumeSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeVolumesResponseType(struct soap *soap, const struct ec2__DescribeVolumesResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeVolumesResponseType);
    if (soap_out_ec2__DescribeVolumesResponseType(soap, tag?tag:"ec2:DescribeVolumesResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesResponseType * SOAP_FMAC4 soap_get_ec2__DescribeVolumesResponseType(struct soap *soap, struct ec2__DescribeVolumesResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeVolumesResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeVolumesSetItemType(struct soap *soap, struct ec2__DescribeVolumesSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->volumeId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeVolumesSetItemType(struct soap *soap, const struct ec2__DescribeVolumesSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->volumeId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeVolumesSetItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeVolumesSetItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeVolumesSetItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetItemType * SOAP_FMAC4 soap_in_ec2__DescribeVolumesSetItemType(struct soap *soap, const char *tag, struct ec2__DescribeVolumesSetItemType *a, const char *type)
  {
    size_t soap_flag_volumeId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeVolumesSetItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeVolumesSetItemType, sizeof(struct ec2__DescribeVolumesSetItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeVolumesSetItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeVolumesSetItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeVolumesSetItemType, 0, sizeof(struct ec2__DescribeVolumesSetItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeVolumesSetItemType(struct soap *soap, const struct ec2__DescribeVolumesSetItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeVolumesSetItemType);
    if (soap_out_ec2__DescribeVolumesSetItemType(soap, tag?tag:"ec2:DescribeVolumesSetItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetItemType * SOAP_FMAC4 soap_get_ec2__DescribeVolumesSetItemType(struct soap *soap, struct ec2__DescribeVolumesSetItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeVolumesSetItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeVolumesSetType(struct soap *soap, struct ec2__DescribeVolumesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeVolumesSetType(struct soap *soap, const struct ec2__DescribeVolumesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeVolumesSetItemType);
            soap_serialize_ec2__DescribeVolumesSetItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeVolumesSetType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeVolumesSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeVolumesSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeVolumesSetItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetType * SOAP_FMAC4 soap_in_ec2__DescribeVolumesSetType(struct soap *soap, const char *tag, struct ec2__DescribeVolumesSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeVolumesSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeVolumesSetType, sizeof(struct ec2__DescribeVolumesSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeVolumesSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeVolumesSetItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeVolumesSetItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeVolumesSetItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeVolumesSetItemType(soap, "ec2:item", a->item, "ec2:DescribeVolumesSetItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeVolumesSetItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeVolumesSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeVolumesSetType, 0, sizeof(struct ec2__DescribeVolumesSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeVolumesSetType(struct soap *soap, const struct ec2__DescribeVolumesSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeVolumesSetType);
    if (soap_out_ec2__DescribeVolumesSetType(soap, tag?tag:"ec2:DescribeVolumesSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesSetType * SOAP_FMAC4 soap_get_ec2__DescribeVolumesSetType(struct soap *soap, struct ec2__DescribeVolumesSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeVolumesSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeVolumesType(struct soap *soap, struct ec2__DescribeVolumesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->volumeSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeVolumesType(struct soap *soap, const struct ec2__DescribeVolumesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeVolumesSetType(soap, &a->volumeSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeVolumesType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeVolumesType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeVolumesType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeVolumesSetType(soap, "ec2:volumeSet", -1, &a->volumeSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesType * SOAP_FMAC4 soap_in_ec2__DescribeVolumesType(struct soap *soap, const char *tag, struct ec2__DescribeVolumesType *a, const char *type)
  {
    size_t soap_flag_volumeSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeVolumesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeVolumesType, sizeof(struct ec2__DescribeVolumesType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeVolumesType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeVolumesSetType(soap, "ec2:volumeSet", &a->volumeSet, "ec2:DescribeVolumesSetType"))
                {       soap_flag_volumeSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeVolumesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeVolumesType, 0, sizeof(struct ec2__DescribeVolumesType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeVolumesType(struct soap *soap, const struct ec2__DescribeVolumesType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeVolumesType);
    if (soap_out_ec2__DescribeVolumesType(soap, tag?tag:"ec2:DescribeVolumesType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeVolumesType * SOAP_FMAC4 soap_get_ec2__DescribeVolumesType(struct soap *soap, struct ec2__DescribeVolumesType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeVolumesType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DeleteVolumeResponseType(struct soap *soap, struct ec2__DeleteVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DeleteVolumeResponseType(struct soap *soap, const struct ec2__DeleteVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DeleteVolumeResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DeleteVolumeResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DeleteVolumeResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DeleteVolumeResponseType * SOAP_FMAC4 soap_in_ec2__DeleteVolumeResponseType(struct soap *soap, const char *tag, struct ec2__DeleteVolumeResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DeleteVolumeResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DeleteVolumeResponseType, sizeof(struct ec2__DeleteVolumeResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DeleteVolumeResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DeleteVolumeResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DeleteVolumeResponseType, 0, sizeof(struct ec2__DeleteVolumeResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DeleteVolumeResponseType(struct soap *soap, const struct ec2__DeleteVolumeResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DeleteVolumeResponseType);
    if (soap_out_ec2__DeleteVolumeResponseType(soap, tag?tag:"ec2:DeleteVolumeResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DeleteVolumeResponseType * SOAP_FMAC4 soap_get_ec2__DeleteVolumeResponseType(struct soap *soap, struct ec2__DeleteVolumeResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DeleteVolumeResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DeleteVolumeType(struct soap *soap, struct ec2__DeleteVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->volumeId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DeleteVolumeType(struct soap *soap, const struct ec2__DeleteVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->volumeId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DeleteVolumeType(struct soap *soap, const char *tag, int id, const struct ec2__DeleteVolumeType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DeleteVolumeType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DeleteVolumeType * SOAP_FMAC4 soap_in_ec2__DeleteVolumeType(struct soap *soap, const char *tag, struct ec2__DeleteVolumeType *a, const char *type)
  {
    size_t soap_flag_volumeId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DeleteVolumeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DeleteVolumeType, sizeof(struct ec2__DeleteVolumeType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DeleteVolumeType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DeleteVolumeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DeleteVolumeType, 0, sizeof(struct ec2__DeleteVolumeType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_volumeId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DeleteVolumeType(struct soap *soap, const struct ec2__DeleteVolumeType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DeleteVolumeType);
    if (soap_out_ec2__DeleteVolumeType(soap, tag?tag:"ec2:DeleteVolumeType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DeleteVolumeType * SOAP_FMAC4 soap_get_ec2__DeleteVolumeType(struct soap *soap, struct ec2__DeleteVolumeType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DeleteVolumeType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CreateVolumeResponseType(struct soap *soap, struct ec2__CreateVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->volumeId);
    soap_default_string(soap, &a->size);
    soap_default_string(soap, &a->snapshotId);
    soap_default_string(soap, &a->availabilityZone);
    soap_default_string(soap, &a->status);
    soap_default_time(soap, &a->createTime);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CreateVolumeResponseType(struct soap *soap, const struct ec2__CreateVolumeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->volumeId);
    soap_serialize_string(soap, &a->size);
    soap_serialize_string(soap, &a->snapshotId);
    soap_serialize_string(soap, &a->availabilityZone);
    soap_serialize_string(soap, &a->status);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CreateVolumeResponseType(struct soap *soap, const char *tag, int id, const struct ec2__CreateVolumeResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CreateVolumeResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:volumeId", -1, &a->volumeId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:size", -1, &a->size, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:snapshotId", -1, &a->snapshotId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:availabilityZone", -1, &a->availabilityZone, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:status", -1, &a->status, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:createTime", -1, &a->createTime, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CreateVolumeResponseType * SOAP_FMAC4 soap_in_ec2__CreateVolumeResponseType(struct soap *soap, const char *tag, struct ec2__CreateVolumeResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_volumeId = 1;
    size_t soap_flag_size = 1;
    size_t soap_flag_snapshotId = 1;
    size_t soap_flag_availabilityZone = 1;
    size_t soap_flag_status = 1;
    size_t soap_flag_createTime = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CreateVolumeResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CreateVolumeResponseType, sizeof(struct ec2__CreateVolumeResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CreateVolumeResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_volumeId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:volumeId", &a->volumeId, "xsd:string"))
                {       soap_flag_volumeId--;
                  continue;
                }
            if (soap_flag_size && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:size", &a->size, "xsd:string"))
                {       soap_flag_size--;
                  continue;
                }
            if (soap_flag_snapshotId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:snapshotId", &a->snapshotId, "xsd:string"))
                {       soap_flag_snapshotId--;
                  continue;
                }
            if (soap_flag_availabilityZone && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:availabilityZone", &a->availabilityZone, "xsd:string"))
                {       soap_flag_availabilityZone--;
                  continue;
                }
            if (soap_flag_status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:status", &a->status, "xsd:string"))
                {       soap_flag_status--;
                  continue;
                }
            if (soap_flag_createTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:createTime", &a->createTime, "xsd:dateTime"))
                {       soap_flag_createTime--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CreateVolumeResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CreateVolumeResponseType, 0, sizeof(struct ec2__CreateVolumeResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_volumeId > 0 || soap_flag_size > 0 || soap_flag_snapshotId > 0 || soap_flag_availabilityZone > 0 || soap_flag_status > 0 || soap_flag_createTime > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CreateVolumeResponseType(struct soap *soap, const struct ec2__CreateVolumeResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CreateVolumeResponseType);
    if (soap_out_ec2__CreateVolumeResponseType(soap, tag?tag:"ec2:CreateVolumeResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CreateVolumeResponseType * SOAP_FMAC4 soap_get_ec2__CreateVolumeResponseType(struct soap *soap, struct ec2__CreateVolumeResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CreateVolumeResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CreateVolumeType(struct soap *soap, struct ec2__CreateVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->size);
    soap_default_string(soap, &a->snapshotId);
    soap_default_string(soap, &a->availabilityZone);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CreateVolumeType(struct soap *soap, const struct ec2__CreateVolumeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->size);
    soap_serialize_string(soap, &a->snapshotId);
    soap_serialize_string(soap, &a->availabilityZone);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CreateVolumeType(struct soap *soap, const char *tag, int id, const struct ec2__CreateVolumeType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CreateVolumeType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:size", -1, &a->size, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:snapshotId", -1, &a->snapshotId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:availabilityZone", -1, &a->availabilityZone, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CreateVolumeType * SOAP_FMAC4 soap_in_ec2__CreateVolumeType(struct soap *soap, const char *tag, struct ec2__CreateVolumeType *a, const char *type)
  {
    size_t soap_flag_size = 1;
    size_t soap_flag_snapshotId = 1;
    size_t soap_flag_availabilityZone = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CreateVolumeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CreateVolumeType, sizeof(struct ec2__CreateVolumeType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CreateVolumeType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_size && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:size", &a->size, "xsd:string"))
                {       soap_flag_size--;
                  continue;
                }
            if (soap_flag_snapshotId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:snapshotId", &a->snapshotId, "xsd:string"))
                {       soap_flag_snapshotId--;
                  continue;
                }
            if (soap_flag_availabilityZone && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:availabilityZone", &a->availabilityZone, "xsd:string"))
                {       soap_flag_availabilityZone--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CreateVolumeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CreateVolumeType, 0, sizeof(struct ec2__CreateVolumeType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_availabilityZone > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CreateVolumeType(struct soap *soap, const struct ec2__CreateVolumeType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CreateVolumeType);
    if (soap_out_ec2__CreateVolumeType(soap, tag?tag:"ec2:CreateVolumeType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CreateVolumeType * SOAP_FMAC4 soap_get_ec2__CreateVolumeType(struct soap *soap, struct ec2__CreateVolumeType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CreateVolumeType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DisassociateAddressResponseType(struct soap *soap, struct ec2__DisassociateAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DisassociateAddressResponseType(struct soap *soap, const struct ec2__DisassociateAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DisassociateAddressResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DisassociateAddressResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DisassociateAddressResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DisassociateAddressResponseType * SOAP_FMAC4 soap_in_ec2__DisassociateAddressResponseType(struct soap *soap, const char *tag, struct ec2__DisassociateAddressResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DisassociateAddressResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DisassociateAddressResponseType, sizeof(struct ec2__DisassociateAddressResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DisassociateAddressResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DisassociateAddressResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DisassociateAddressResponseType, 0, sizeof(struct ec2__DisassociateAddressResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DisassociateAddressResponseType(struct soap *soap, const struct ec2__DisassociateAddressResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DisassociateAddressResponseType);
    if (soap_out_ec2__DisassociateAddressResponseType(soap, tag?tag:"ec2:DisassociateAddressResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DisassociateAddressResponseType * SOAP_FMAC4 soap_get_ec2__DisassociateAddressResponseType(struct soap *soap, struct ec2__DisassociateAddressResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DisassociateAddressResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DisassociateAddressType(struct soap *soap, struct ec2__DisassociateAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DisassociateAddressType(struct soap *soap, const struct ec2__DisassociateAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DisassociateAddressType(struct soap *soap, const char *tag, int id, const struct ec2__DisassociateAddressType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DisassociateAddressType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:publicIp", -1, &a->publicIp, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DisassociateAddressType * SOAP_FMAC4 soap_in_ec2__DisassociateAddressType(struct soap *soap, const char *tag, struct ec2__DisassociateAddressType *a, const char *type)
  {
    size_t soap_flag_publicIp = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DisassociateAddressType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DisassociateAddressType, sizeof(struct ec2__DisassociateAddressType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DisassociateAddressType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_publicIp && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:publicIp", &a->publicIp, "xsd:string"))
                {       soap_flag_publicIp--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DisassociateAddressType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DisassociateAddressType, 0, sizeof(struct ec2__DisassociateAddressType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_publicIp > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DisassociateAddressType(struct soap *soap, const struct ec2__DisassociateAddressType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DisassociateAddressType);
    if (soap_out_ec2__DisassociateAddressType(soap, tag?tag:"ec2:DisassociateAddressType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DisassociateAddressType * SOAP_FMAC4 soap_get_ec2__DisassociateAddressType(struct soap *soap, struct ec2__DisassociateAddressType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DisassociateAddressType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AssociateAddressResponseType(struct soap *soap, struct ec2__AssociateAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AssociateAddressResponseType(struct soap *soap, const struct ec2__AssociateAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AssociateAddressResponseType(struct soap *soap, const char *tag, int id, const struct ec2__AssociateAddressResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AssociateAddressResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AssociateAddressResponseType * SOAP_FMAC4 soap_in_ec2__AssociateAddressResponseType(struct soap *soap, const char *tag, struct ec2__AssociateAddressResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AssociateAddressResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AssociateAddressResponseType, sizeof(struct ec2__AssociateAddressResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AssociateAddressResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AssociateAddressResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AssociateAddressResponseType, 0, sizeof(struct ec2__AssociateAddressResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AssociateAddressResponseType(struct soap *soap, const struct ec2__AssociateAddressResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AssociateAddressResponseType);
    if (soap_out_ec2__AssociateAddressResponseType(soap, tag?tag:"ec2:AssociateAddressResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AssociateAddressResponseType * SOAP_FMAC4 soap_get_ec2__AssociateAddressResponseType(struct soap *soap, struct ec2__AssociateAddressResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AssociateAddressResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AssociateAddressType(struct soap *soap, struct ec2__AssociateAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->publicIp);
    soap_default_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AssociateAddressType(struct soap *soap, const struct ec2__AssociateAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->publicIp);
    soap_serialize_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AssociateAddressType(struct soap *soap, const char *tag, int id, const struct ec2__AssociateAddressType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AssociateAddressType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:publicIp", -1, &a->publicIp, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AssociateAddressType * SOAP_FMAC4 soap_in_ec2__AssociateAddressType(struct soap *soap, const char *tag, struct ec2__AssociateAddressType *a, const char *type)
  {
    size_t soap_flag_publicIp = 1;
    size_t soap_flag_instanceId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AssociateAddressType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AssociateAddressType, sizeof(struct ec2__AssociateAddressType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AssociateAddressType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_publicIp && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:publicIp", &a->publicIp, "xsd:string"))
                {       soap_flag_publicIp--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AssociateAddressType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AssociateAddressType, 0, sizeof(struct ec2__AssociateAddressType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_publicIp > 0 || soap_flag_instanceId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AssociateAddressType(struct soap *soap, const struct ec2__AssociateAddressType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AssociateAddressType);
    if (soap_out_ec2__AssociateAddressType(soap, tag?tag:"ec2:AssociateAddressType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AssociateAddressType * SOAP_FMAC4 soap_get_ec2__AssociateAddressType(struct soap *soap, struct ec2__AssociateAddressType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AssociateAddressType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAddressesResponseItemType(struct soap *soap, struct ec2__DescribeAddressesResponseItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->publicIp);
    soap_default_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAddressesResponseItemType(struct soap *soap, const struct ec2__DescribeAddressesResponseItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->publicIp);
    soap_serialize_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAddressesResponseItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAddressesResponseItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAddressesResponseItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:publicIp", -1, &a->publicIp, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesResponseItemType * SOAP_FMAC4 soap_in_ec2__DescribeAddressesResponseItemType(struct soap *soap, const char *tag, struct ec2__DescribeAddressesResponseItemType *a, const char *type)
  {
    size_t soap_flag_publicIp = 1;
    size_t soap_flag_instanceId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAddressesResponseItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAddressesResponseItemType, sizeof(struct ec2__DescribeAddressesResponseItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAddressesResponseItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_publicIp && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:publicIp", &a->publicIp, "xsd:string"))
                {       soap_flag_publicIp--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAddressesResponseItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAddressesResponseItemType, 0, sizeof(struct ec2__DescribeAddressesResponseItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_publicIp > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAddressesResponseItemType(struct soap *soap, const struct ec2__DescribeAddressesResponseItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAddressesResponseItemType);
    if (soap_out_ec2__DescribeAddressesResponseItemType(soap, tag?tag:"ec2:DescribeAddressesResponseItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesResponseItemType * SOAP_FMAC4 soap_get_ec2__DescribeAddressesResponseItemType(struct soap *soap, struct ec2__DescribeAddressesResponseItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAddressesResponseItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAddressesResponseInfoType(struct soap *soap, struct ec2__DescribeAddressesResponseInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAddressesResponseInfoType(struct soap *soap, const struct ec2__DescribeAddressesResponseInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeAddressesResponseItemType);
            soap_serialize_ec2__DescribeAddressesResponseItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAddressesResponseInfoType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAddressesResponseInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAddressesResponseInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeAddressesResponseItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesResponseInfoType * SOAP_FMAC4 soap_in_ec2__DescribeAddressesResponseInfoType(struct soap *soap, const char *tag, struct ec2__DescribeAddressesResponseInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAddressesResponseInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAddressesResponseInfoType, sizeof(struct ec2__DescribeAddressesResponseInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAddressesResponseInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeAddressesResponseItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeAddressesResponseItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeAddressesResponseItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeAddressesResponseItemType(soap, "ec2:item", a->item, "ec2:DescribeAddressesResponseItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeAddressesResponseItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAddressesResponseInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAddressesResponseInfoType, 0, sizeof(struct ec2__DescribeAddressesResponseInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAddressesResponseInfoType(struct soap *soap, const struct ec2__DescribeAddressesResponseInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAddressesResponseInfoType);
    if (soap_out_ec2__DescribeAddressesResponseInfoType(soap, tag?tag:"ec2:DescribeAddressesResponseInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesResponseInfoType * SOAP_FMAC4 soap_get_ec2__DescribeAddressesResponseInfoType(struct soap *soap, struct ec2__DescribeAddressesResponseInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAddressesResponseInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAddressesResponseType(struct soap *soap, struct ec2__DescribeAddressesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->addressesSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAddressesResponseType(struct soap *soap, const struct ec2__DescribeAddressesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__DescribeAddressesResponseInfoType(soap, &a->addressesSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAddressesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAddressesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAddressesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__DescribeAddressesResponseInfoType(soap, "ec2:addressesSet", -1, &a->addressesSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesResponseType * SOAP_FMAC4 soap_in_ec2__DescribeAddressesResponseType(struct soap *soap, const char *tag, struct ec2__DescribeAddressesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_addressesSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAddressesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAddressesResponseType, sizeof(struct ec2__DescribeAddressesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAddressesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_addressesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeAddressesResponseInfoType(soap, "ec2:addressesSet", &a->addressesSet, "ec2:DescribeAddressesResponseInfoType"))
                {       soap_flag_addressesSet--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAddressesResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAddressesResponseType, 0, sizeof(struct ec2__DescribeAddressesResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_addressesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAddressesResponseType(struct soap *soap, const struct ec2__DescribeAddressesResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAddressesResponseType);
    if (soap_out_ec2__DescribeAddressesResponseType(soap, tag?tag:"ec2:DescribeAddressesResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesResponseType * SOAP_FMAC4 soap_get_ec2__DescribeAddressesResponseType(struct soap *soap, struct ec2__DescribeAddressesResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAddressesResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAddressesItemType(struct soap *soap, struct ec2__DescribeAddressesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAddressesItemType(struct soap *soap, const struct ec2__DescribeAddressesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAddressesItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAddressesItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAddressesItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:publicIp", -1, &a->publicIp, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesItemType * SOAP_FMAC4 soap_in_ec2__DescribeAddressesItemType(struct soap *soap, const char *tag, struct ec2__DescribeAddressesItemType *a, const char *type)
  {
    size_t soap_flag_publicIp = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAddressesItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAddressesItemType, sizeof(struct ec2__DescribeAddressesItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAddressesItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_publicIp && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:publicIp", &a->publicIp, "xsd:string"))
                {       soap_flag_publicIp--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAddressesItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAddressesItemType, 0, sizeof(struct ec2__DescribeAddressesItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_publicIp > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAddressesItemType(struct soap *soap, const struct ec2__DescribeAddressesItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAddressesItemType);
    if (soap_out_ec2__DescribeAddressesItemType(soap, tag?tag:"ec2:DescribeAddressesItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesItemType * SOAP_FMAC4 soap_get_ec2__DescribeAddressesItemType(struct soap *soap, struct ec2__DescribeAddressesItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAddressesItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAddressesInfoType(struct soap *soap, struct ec2__DescribeAddressesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAddressesInfoType(struct soap *soap, const struct ec2__DescribeAddressesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeAddressesItemType);
            soap_serialize_ec2__DescribeAddressesItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAddressesInfoType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAddressesInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAddressesInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeAddressesItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesInfoType * SOAP_FMAC4 soap_in_ec2__DescribeAddressesInfoType(struct soap *soap, const char *tag, struct ec2__DescribeAddressesInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAddressesInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAddressesInfoType, sizeof(struct ec2__DescribeAddressesInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAddressesInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeAddressesItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeAddressesItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeAddressesItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeAddressesItemType(soap, "ec2:item", a->item, "ec2:DescribeAddressesItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeAddressesItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAddressesInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAddressesInfoType, 0, sizeof(struct ec2__DescribeAddressesInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAddressesInfoType(struct soap *soap, const struct ec2__DescribeAddressesInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAddressesInfoType);
    if (soap_out_ec2__DescribeAddressesInfoType(soap, tag?tag:"ec2:DescribeAddressesInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesInfoType * SOAP_FMAC4 soap_get_ec2__DescribeAddressesInfoType(struct soap *soap, struct ec2__DescribeAddressesInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAddressesInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAddressesType(struct soap *soap, struct ec2__DescribeAddressesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->publicIpsSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAddressesType(struct soap *soap, const struct ec2__DescribeAddressesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeAddressesInfoType(soap, &a->publicIpsSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAddressesType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAddressesType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAddressesType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeAddressesInfoType(soap, "ec2:publicIpsSet", -1, &a->publicIpsSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesType * SOAP_FMAC4 soap_in_ec2__DescribeAddressesType(struct soap *soap, const char *tag, struct ec2__DescribeAddressesType *a, const char *type)
  {
    size_t soap_flag_publicIpsSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAddressesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAddressesType, sizeof(struct ec2__DescribeAddressesType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAddressesType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_publicIpsSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeAddressesInfoType(soap, "ec2:publicIpsSet", &a->publicIpsSet, "ec2:DescribeAddressesInfoType"))
                {       soap_flag_publicIpsSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAddressesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAddressesType, 0, sizeof(struct ec2__DescribeAddressesType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_publicIpsSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAddressesType(struct soap *soap, const struct ec2__DescribeAddressesType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAddressesType);
    if (soap_out_ec2__DescribeAddressesType(soap, tag?tag:"ec2:DescribeAddressesType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAddressesType * SOAP_FMAC4 soap_get_ec2__DescribeAddressesType(struct soap *soap, struct ec2__DescribeAddressesType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAddressesType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ReleaseAddressResponseType(struct soap *soap, struct ec2__ReleaseAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ReleaseAddressResponseType(struct soap *soap, const struct ec2__ReleaseAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ReleaseAddressResponseType(struct soap *soap, const char *tag, int id, const struct ec2__ReleaseAddressResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ReleaseAddressResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ReleaseAddressResponseType * SOAP_FMAC4 soap_in_ec2__ReleaseAddressResponseType(struct soap *soap, const char *tag, struct ec2__ReleaseAddressResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ReleaseAddressResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ReleaseAddressResponseType, sizeof(struct ec2__ReleaseAddressResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ReleaseAddressResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ReleaseAddressResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ReleaseAddressResponseType, 0, sizeof(struct ec2__ReleaseAddressResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ReleaseAddressResponseType(struct soap *soap, const struct ec2__ReleaseAddressResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ReleaseAddressResponseType);
    if (soap_out_ec2__ReleaseAddressResponseType(soap, tag?tag:"ec2:ReleaseAddressResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ReleaseAddressResponseType * SOAP_FMAC4 soap_get_ec2__ReleaseAddressResponseType(struct soap *soap, struct ec2__ReleaseAddressResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ReleaseAddressResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ReleaseAddressType(struct soap *soap, struct ec2__ReleaseAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ReleaseAddressType(struct soap *soap, const struct ec2__ReleaseAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ReleaseAddressType(struct soap *soap, const char *tag, int id, const struct ec2__ReleaseAddressType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ReleaseAddressType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:publicIp", -1, &a->publicIp, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ReleaseAddressType * SOAP_FMAC4 soap_in_ec2__ReleaseAddressType(struct soap *soap, const char *tag, struct ec2__ReleaseAddressType *a, const char *type)
  {
    size_t soap_flag_publicIp = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ReleaseAddressType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ReleaseAddressType, sizeof(struct ec2__ReleaseAddressType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ReleaseAddressType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_publicIp && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:publicIp", &a->publicIp, "xsd:string"))
                {       soap_flag_publicIp--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ReleaseAddressType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ReleaseAddressType, 0, sizeof(struct ec2__ReleaseAddressType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_publicIp > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ReleaseAddressType(struct soap *soap, const struct ec2__ReleaseAddressType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ReleaseAddressType);
    if (soap_out_ec2__ReleaseAddressType(soap, tag?tag:"ec2:ReleaseAddressType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ReleaseAddressType * SOAP_FMAC4 soap_get_ec2__ReleaseAddressType(struct soap *soap, struct ec2__ReleaseAddressType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ReleaseAddressType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AllocateAddressResponseType(struct soap *soap, struct ec2__AllocateAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AllocateAddressResponseType(struct soap *soap, const struct ec2__AllocateAddressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->publicIp);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AllocateAddressResponseType(struct soap *soap, const char *tag, int id, const struct ec2__AllocateAddressResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AllocateAddressResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:publicIp", -1, &a->publicIp, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AllocateAddressResponseType * SOAP_FMAC4 soap_in_ec2__AllocateAddressResponseType(struct soap *soap, const char *tag, struct ec2__AllocateAddressResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_publicIp = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AllocateAddressResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AllocateAddressResponseType, sizeof(struct ec2__AllocateAddressResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AllocateAddressResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_publicIp && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:publicIp", &a->publicIp, "xsd:string"))
                {       soap_flag_publicIp--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AllocateAddressResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AllocateAddressResponseType, 0, sizeof(struct ec2__AllocateAddressResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_publicIp > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AllocateAddressResponseType(struct soap *soap, const struct ec2__AllocateAddressResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AllocateAddressResponseType);
    if (soap_out_ec2__AllocateAddressResponseType(soap, tag?tag:"ec2:AllocateAddressResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AllocateAddressResponseType * SOAP_FMAC4 soap_get_ec2__AllocateAddressResponseType(struct soap *soap, struct ec2__AllocateAddressResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AllocateAddressResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AllocateAddressType(struct soap *soap, struct ec2__AllocateAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AllocateAddressType(struct soap *soap, const struct ec2__AllocateAddressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AllocateAddressType(struct soap *soap, const char *tag, int id, const struct ec2__AllocateAddressType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AllocateAddressType), type))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AllocateAddressType * SOAP_FMAC4 soap_in_ec2__AllocateAddressType(struct soap *soap, const char *tag, struct ec2__AllocateAddressType *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AllocateAddressType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AllocateAddressType, sizeof(struct ec2__AllocateAddressType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AllocateAddressType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AllocateAddressType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AllocateAddressType, 0, sizeof(struct ec2__AllocateAddressType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AllocateAddressType(struct soap *soap, const struct ec2__AllocateAddressType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AllocateAddressType);
    if (soap_out_ec2__AllocateAddressType(soap, tag?tag:"ec2:AllocateAddressType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AllocateAddressType * SOAP_FMAC4 soap_get_ec2__AllocateAddressType(struct soap *soap, struct ec2__AllocateAddressType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AllocateAddressType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AvailabilityZoneItemType(struct soap *soap, struct ec2__AvailabilityZoneItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->zoneName);
    soap_default_string(soap, &a->zoneState);
    soap_default_string(soap, &a->regionName);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AvailabilityZoneItemType(struct soap *soap, const struct ec2__AvailabilityZoneItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->zoneName);
    soap_serialize_string(soap, &a->zoneState);
    soap_serialize_string(soap, &a->regionName);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AvailabilityZoneItemType(struct soap *soap, const char *tag, int id, const struct ec2__AvailabilityZoneItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AvailabilityZoneItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:zoneName", -1, &a->zoneName, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:zoneState", -1, &a->zoneState, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:regionName", -1, &a->regionName, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AvailabilityZoneItemType * SOAP_FMAC4 soap_in_ec2__AvailabilityZoneItemType(struct soap *soap, const char *tag, struct ec2__AvailabilityZoneItemType *a, const char *type)
  {
    size_t soap_flag_zoneName = 1;
    size_t soap_flag_zoneState = 1;
    size_t soap_flag_regionName = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AvailabilityZoneItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AvailabilityZoneItemType, sizeof(struct ec2__AvailabilityZoneItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AvailabilityZoneItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_zoneName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:zoneName", &a->zoneName, "xsd:string"))
                {       soap_flag_zoneName--;
                  continue;
                }
            if (soap_flag_zoneState && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:zoneState", &a->zoneState, "xsd:string"))
                {       soap_flag_zoneState--;
                  continue;
                }
            if (soap_flag_regionName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:regionName", &a->regionName, "xsd:string"))
                {       soap_flag_regionName--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AvailabilityZoneItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AvailabilityZoneItemType, 0, sizeof(struct ec2__AvailabilityZoneItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_zoneName > 0 || soap_flag_zoneState > 0 || soap_flag_regionName > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AvailabilityZoneItemType(struct soap *soap, const struct ec2__AvailabilityZoneItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AvailabilityZoneItemType);
    if (soap_out_ec2__AvailabilityZoneItemType(soap, tag?tag:"ec2:AvailabilityZoneItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AvailabilityZoneItemType * SOAP_FMAC4 soap_get_ec2__AvailabilityZoneItemType(struct soap *soap, struct ec2__AvailabilityZoneItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AvailabilityZoneItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AvailabilityZoneSetType(struct soap *soap, struct ec2__AvailabilityZoneSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AvailabilityZoneSetType(struct soap *soap, const struct ec2__AvailabilityZoneSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__AvailabilityZoneItemType);
            soap_serialize_ec2__AvailabilityZoneItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AvailabilityZoneSetType(struct soap *soap, const char *tag, int id, const struct ec2__AvailabilityZoneSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AvailabilityZoneSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__AvailabilityZoneItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AvailabilityZoneSetType * SOAP_FMAC4 soap_in_ec2__AvailabilityZoneSetType(struct soap *soap, const char *tag, struct ec2__AvailabilityZoneSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AvailabilityZoneSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AvailabilityZoneSetType, sizeof(struct ec2__AvailabilityZoneSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AvailabilityZoneSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__AvailabilityZoneItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__AvailabilityZoneItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__AvailabilityZoneItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__AvailabilityZoneItemType(soap, "ec2:item", a->item, "ec2:AvailabilityZoneItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__AvailabilityZoneItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AvailabilityZoneSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AvailabilityZoneSetType, 0, sizeof(struct ec2__AvailabilityZoneSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AvailabilityZoneSetType(struct soap *soap, const struct ec2__AvailabilityZoneSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AvailabilityZoneSetType);
    if (soap_out_ec2__AvailabilityZoneSetType(soap, tag?tag:"ec2:AvailabilityZoneSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AvailabilityZoneSetType * SOAP_FMAC4 soap_get_ec2__AvailabilityZoneSetType(struct soap *soap, struct ec2__AvailabilityZoneSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AvailabilityZoneSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAvailabilityZonesResponseType(struct soap *soap, struct ec2__DescribeAvailabilityZonesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->availabilityZoneInfo = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAvailabilityZonesResponseType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__AvailabilityZoneSetType(soap, &a->availabilityZoneInfo);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAvailabilityZonesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAvailabilityZonesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__AvailabilityZoneSetType(soap, "ec2:availabilityZoneInfo", -1, &a->availabilityZoneInfo, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesResponseType * SOAP_FMAC4 soap_in_ec2__DescribeAvailabilityZonesResponseType(struct soap *soap, const char *tag, struct ec2__DescribeAvailabilityZonesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_availabilityZoneInfo = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAvailabilityZonesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType, sizeof(struct ec2__DescribeAvailabilityZonesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAvailabilityZonesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_availabilityZoneInfo && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__AvailabilityZoneSetType(soap, "ec2:availabilityZoneInfo", &a->availabilityZoneInfo, "ec2:AvailabilityZoneSetType"))
                {       soap_flag_availabilityZoneInfo--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAvailabilityZonesResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType, 0, sizeof(struct ec2__DescribeAvailabilityZonesResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_availabilityZoneInfo > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAvailabilityZonesResponseType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAvailabilityZonesResponseType);
    if (soap_out_ec2__DescribeAvailabilityZonesResponseType(soap, tag?tag:"ec2:DescribeAvailabilityZonesResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesResponseType * SOAP_FMAC4 soap_get_ec2__DescribeAvailabilityZonesResponseType(struct soap *soap, struct ec2__DescribeAvailabilityZonesResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAvailabilityZonesResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAvailabilityZonesSetItemType(struct soap *soap, struct ec2__DescribeAvailabilityZonesSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->zoneName);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAvailabilityZonesSetItemType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->zoneName);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAvailabilityZonesSetItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAvailabilityZonesSetItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:zoneName", -1, &a->zoneName, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesSetItemType * SOAP_FMAC4 soap_in_ec2__DescribeAvailabilityZonesSetItemType(struct soap *soap, const char *tag, struct ec2__DescribeAvailabilityZonesSetItemType *a, const char *type)
  {
    size_t soap_flag_zoneName = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAvailabilityZonesSetItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType, sizeof(struct ec2__DescribeAvailabilityZonesSetItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAvailabilityZonesSetItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_zoneName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:zoneName", &a->zoneName, "xsd:string"))
                {       soap_flag_zoneName--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAvailabilityZonesSetItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType, 0, sizeof(struct ec2__DescribeAvailabilityZonesSetItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_zoneName > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAvailabilityZonesSetItemType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesSetItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType);
    if (soap_out_ec2__DescribeAvailabilityZonesSetItemType(soap, tag?tag:"ec2:DescribeAvailabilityZonesSetItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesSetItemType * SOAP_FMAC4 soap_get_ec2__DescribeAvailabilityZonesSetItemType(struct soap *soap, struct ec2__DescribeAvailabilityZonesSetItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAvailabilityZonesSetItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAvailabilityZonesSetType(struct soap *soap, struct ec2__DescribeAvailabilityZonesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAvailabilityZonesSetType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetItemType);
            soap_serialize_ec2__DescribeAvailabilityZonesSetItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAvailabilityZonesSetType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAvailabilityZonesSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeAvailabilityZonesSetItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesSetType * SOAP_FMAC4 soap_in_ec2__DescribeAvailabilityZonesSetType(struct soap *soap, const char *tag, struct ec2__DescribeAvailabilityZonesSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAvailabilityZonesSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType, sizeof(struct ec2__DescribeAvailabilityZonesSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAvailabilityZonesSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeAvailabilityZonesSetItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeAvailabilityZonesSetItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeAvailabilityZonesSetItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeAvailabilityZonesSetItemType(soap, "ec2:item", a->item, "ec2:DescribeAvailabilityZonesSetItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeAvailabilityZonesSetItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAvailabilityZonesSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType, 0, sizeof(struct ec2__DescribeAvailabilityZonesSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAvailabilityZonesSetType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAvailabilityZonesSetType);
    if (soap_out_ec2__DescribeAvailabilityZonesSetType(soap, tag?tag:"ec2:DescribeAvailabilityZonesSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesSetType * SOAP_FMAC4 soap_get_ec2__DescribeAvailabilityZonesSetType(struct soap *soap, struct ec2__DescribeAvailabilityZonesSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAvailabilityZonesSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeAvailabilityZonesType(struct soap *soap, struct ec2__DescribeAvailabilityZonesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->availabilityZoneSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeAvailabilityZonesType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeAvailabilityZonesSetType(soap, &a->availabilityZoneSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeAvailabilityZonesType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeAvailabilityZonesType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeAvailabilityZonesSetType(soap, "ec2:availabilityZoneSet", -1, &a->availabilityZoneSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesType * SOAP_FMAC4 soap_in_ec2__DescribeAvailabilityZonesType(struct soap *soap, const char *tag, struct ec2__DescribeAvailabilityZonesType *a, const char *type)
  {
    size_t soap_flag_availabilityZoneSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeAvailabilityZonesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeAvailabilityZonesType, sizeof(struct ec2__DescribeAvailabilityZonesType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeAvailabilityZonesType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_availabilityZoneSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeAvailabilityZonesSetType(soap, "ec2:availabilityZoneSet", &a->availabilityZoneSet, "ec2:DescribeAvailabilityZonesSetType"))
                {       soap_flag_availabilityZoneSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeAvailabilityZonesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeAvailabilityZonesType, 0, sizeof(struct ec2__DescribeAvailabilityZonesType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_availabilityZoneSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeAvailabilityZonesType(struct soap *soap, const struct ec2__DescribeAvailabilityZonesType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeAvailabilityZonesType);
    if (soap_out_ec2__DescribeAvailabilityZonesType(soap, tag?tag:"ec2:DescribeAvailabilityZonesType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeAvailabilityZonesType * SOAP_FMAC4 soap_get_ec2__DescribeAvailabilityZonesType(struct soap *soap, struct ec2__DescribeAvailabilityZonesType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeAvailabilityZonesType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ConfirmProductInstanceResponseType(struct soap *soap, struct ec2__ConfirmProductInstanceResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
    soap_default_string(soap, &a->ownerId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ConfirmProductInstanceResponseType(struct soap *soap, const struct ec2__ConfirmProductInstanceResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
    soap_serialize_string(soap, &a->ownerId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ConfirmProductInstanceResponseType(struct soap *soap, const char *tag, int id, const struct ec2__ConfirmProductInstanceResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ConfirmProductInstanceResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:ownerId", -1, &a->ownerId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ConfirmProductInstanceResponseType * SOAP_FMAC4 soap_in_ec2__ConfirmProductInstanceResponseType(struct soap *soap, const char *tag, struct ec2__ConfirmProductInstanceResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    size_t soap_flag_ownerId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ConfirmProductInstanceResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ConfirmProductInstanceResponseType, sizeof(struct ec2__ConfirmProductInstanceResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ConfirmProductInstanceResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            if (soap_flag_ownerId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:ownerId", &a->ownerId, "xsd:string"))
                {       soap_flag_ownerId--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ConfirmProductInstanceResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ConfirmProductInstanceResponseType, 0, sizeof(struct ec2__ConfirmProductInstanceResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ConfirmProductInstanceResponseType(struct soap *soap, const struct ec2__ConfirmProductInstanceResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ConfirmProductInstanceResponseType);
    if (soap_out_ec2__ConfirmProductInstanceResponseType(soap, tag?tag:"ec2:ConfirmProductInstanceResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ConfirmProductInstanceResponseType * SOAP_FMAC4 soap_get_ec2__ConfirmProductInstanceResponseType(struct soap *soap, struct ec2__ConfirmProductInstanceResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ConfirmProductInstanceResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ProductCodesSetItemType(struct soap *soap, struct ec2__ProductCodesSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->productCode);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ProductCodesSetItemType(struct soap *soap, const struct ec2__ProductCodesSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->productCode);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ProductCodesSetItemType(struct soap *soap, const char *tag, int id, const struct ec2__ProductCodesSetItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ProductCodesSetItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:productCode", -1, &a->productCode, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ProductCodesSetItemType * SOAP_FMAC4 soap_in_ec2__ProductCodesSetItemType(struct soap *soap, const char *tag, struct ec2__ProductCodesSetItemType *a, const char *type)
  {
    size_t soap_flag_productCode = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ProductCodesSetItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ProductCodesSetItemType, sizeof(struct ec2__ProductCodesSetItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ProductCodesSetItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_productCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:productCode", &a->productCode, "xsd:string"))
                {       soap_flag_productCode--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ProductCodesSetItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ProductCodesSetItemType, 0, sizeof(struct ec2__ProductCodesSetItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_productCode > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ProductCodesSetItemType(struct soap *soap, const struct ec2__ProductCodesSetItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ProductCodesSetItemType);
    if (soap_out_ec2__ProductCodesSetItemType(soap, tag?tag:"ec2:ProductCodesSetItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ProductCodesSetItemType * SOAP_FMAC4 soap_get_ec2__ProductCodesSetItemType(struct soap *soap, struct ec2__ProductCodesSetItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ProductCodesSetItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ConfirmProductInstanceType(struct soap *soap, struct ec2__ConfirmProductInstanceType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->productCode);
    soap_default_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ConfirmProductInstanceType(struct soap *soap, const struct ec2__ConfirmProductInstanceType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->productCode);
    soap_serialize_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ConfirmProductInstanceType(struct soap *soap, const char *tag, int id, const struct ec2__ConfirmProductInstanceType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ConfirmProductInstanceType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:productCode", -1, &a->productCode, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ConfirmProductInstanceType * SOAP_FMAC4 soap_in_ec2__ConfirmProductInstanceType(struct soap *soap, const char *tag, struct ec2__ConfirmProductInstanceType *a, const char *type)
  {
    size_t soap_flag_productCode = 1;
    size_t soap_flag_instanceId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ConfirmProductInstanceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ConfirmProductInstanceType, sizeof(struct ec2__ConfirmProductInstanceType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ConfirmProductInstanceType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_productCode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:productCode", &a->productCode, "xsd:string"))
                {       soap_flag_productCode--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ConfirmProductInstanceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ConfirmProductInstanceType, 0, sizeof(struct ec2__ConfirmProductInstanceType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_productCode > 0 || soap_flag_instanceId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ConfirmProductInstanceType(struct soap *soap, const struct ec2__ConfirmProductInstanceType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ConfirmProductInstanceType);
    if (soap_out_ec2__ConfirmProductInstanceType(soap, tag?tag:"ec2:ConfirmProductInstanceType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ConfirmProductInstanceType * SOAP_FMAC4 soap_get_ec2__ConfirmProductInstanceType(struct soap *soap, struct ec2__ConfirmProductInstanceType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ConfirmProductInstanceType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AttributeValueType(struct soap *soap, struct ec2__AttributeValueType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->value);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AttributeValueType(struct soap *soap, const struct ec2__AttributeValueType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->value);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AttributeValueType(struct soap *soap, const char *tag, int id, const struct ec2__AttributeValueType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AttributeValueType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:value", -1, &a->value, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AttributeValueType * SOAP_FMAC4 soap_in_ec2__AttributeValueType(struct soap *soap, const char *tag, struct ec2__AttributeValueType *a, const char *type)
  {
    size_t soap_flag_value = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AttributeValueType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AttributeValueType, sizeof(struct ec2__AttributeValueType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AttributeValueType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:value", &a->value, "xsd:string"))
                {       soap_flag_value--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AttributeValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AttributeValueType, 0, sizeof(struct ec2__AttributeValueType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AttributeValueType(struct soap *soap, const struct ec2__AttributeValueType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AttributeValueType);
    if (soap_out_ec2__AttributeValueType(soap, tag?tag:"ec2:AttributeValueType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AttributeValueType * SOAP_FMAC4 soap_get_ec2__AttributeValueType(struct soap *soap, struct ec2__AttributeValueType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AttributeValueType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__NullableAttributeValueType(struct soap *soap, struct ec2__NullableAttributeValueType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->value);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__NullableAttributeValueType(struct soap *soap, const struct ec2__NullableAttributeValueType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->value);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__NullableAttributeValueType(struct soap *soap, const char *tag, int id, const struct ec2__NullableAttributeValueType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__NullableAttributeValueType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:value", -1, &a->value, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__NullableAttributeValueType * SOAP_FMAC4 soap_in_ec2__NullableAttributeValueType(struct soap *soap, const char *tag, struct ec2__NullableAttributeValueType *a, const char *type)
  {
    size_t soap_flag_value = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__NullableAttributeValueType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__NullableAttributeValueType, sizeof(struct ec2__NullableAttributeValueType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__NullableAttributeValueType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:value", &a->value, "xsd:string"))
                {       soap_flag_value--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__NullableAttributeValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__NullableAttributeValueType, 0, sizeof(struct ec2__NullableAttributeValueType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__NullableAttributeValueType(struct soap *soap, const struct ec2__NullableAttributeValueType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__NullableAttributeValueType);
    if (soap_out_ec2__NullableAttributeValueType(soap, tag?tag:"ec2:NullableAttributeValueType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__NullableAttributeValueType * SOAP_FMAC4 soap_get_ec2__NullableAttributeValueType(struct soap *soap, struct ec2__NullableAttributeValueType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__NullableAttributeValueType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImageAttributeResponseType(struct soap *soap, struct ec2__DescribeImageAttributeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->imageId);
    a->__union_DescribeImageAttributeResponseType = 0;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImageAttributeResponseType(struct soap *soap, const struct ec2__DescribeImageAttributeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->imageId);
    soap_serialize__ec2__union_DescribeImageAttributeResponseType(soap, a->__union_DescribeImageAttributeResponseType, &a->union_DescribeImageAttributeResponseType);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImageAttributeResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImageAttributeResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImageAttributeResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageId", -1, &a->imageId, ""))
      return soap->error;
    if (soap_out__ec2__union_DescribeImageAttributeResponseType(soap, a->__union_DescribeImageAttributeResponseType, &a->union_DescribeImageAttributeResponseType))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImageAttributeResponseType * SOAP_FMAC4 soap_in_ec2__DescribeImageAttributeResponseType(struct soap *soap, const char *tag, struct ec2__DescribeImageAttributeResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_imageId = 1;
    size_t soap_flag_union_DescribeImageAttributeResponseType = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImageAttributeResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImageAttributeResponseType, sizeof(struct ec2__DescribeImageAttributeResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImageAttributeResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_imageId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageId", &a->imageId, "xsd:string"))
                {       soap_flag_imageId--;
                  continue;
                }
            if (soap_flag_union_DescribeImageAttributeResponseType && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in__ec2__union_DescribeImageAttributeResponseType(soap, &a->__union_DescribeImageAttributeResponseType, &a->union_DescribeImageAttributeResponseType))
                {       soap_flag_union_DescribeImageAttributeResponseType = 0;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImageAttributeResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImageAttributeResponseType, 0, sizeof(struct ec2__DescribeImageAttributeResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_imageId > 0 || soap_flag_union_DescribeImageAttributeResponseType))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImageAttributeResponseType(struct soap *soap, const struct ec2__DescribeImageAttributeResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImageAttributeResponseType);
    if (soap_out_ec2__DescribeImageAttributeResponseType(soap, tag?tag:"ec2:DescribeImageAttributeResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImageAttributeResponseType * SOAP_FMAC4 soap_get_ec2__DescribeImageAttributeResponseType(struct soap *soap, struct ec2__DescribeImageAttributeResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImageAttributeResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImageAttributeType(struct soap *soap, struct ec2__DescribeImageAttributeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__union_DescribeImageAttributeType = 0;
    soap_default_string(soap, &a->imageId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImageAttributeType(struct soap *soap, const struct ec2__DescribeImageAttributeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__ec2__union_DescribeImageAttributeType(soap, a->__union_DescribeImageAttributeType, &a->union_DescribeImageAttributeType);
    soap_serialize_string(soap, &a->imageId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImageAttributeType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImageAttributeType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImageAttributeType), type))
      return soap->error;
    if (soap_out__ec2__union_DescribeImageAttributeType(soap, a->__union_DescribeImageAttributeType, &a->union_DescribeImageAttributeType))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageId", -1, &a->imageId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImageAttributeType * SOAP_FMAC4 soap_in_ec2__DescribeImageAttributeType(struct soap *soap, const char *tag, struct ec2__DescribeImageAttributeType *a, const char *type)
  {
    size_t soap_flag_union_DescribeImageAttributeType = 1;
    size_t soap_flag_imageId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImageAttributeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImageAttributeType, sizeof(struct ec2__DescribeImageAttributeType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImageAttributeType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_union_DescribeImageAttributeType && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in__ec2__union_DescribeImageAttributeType(soap, &a->__union_DescribeImageAttributeType, &a->union_DescribeImageAttributeType))
                {       soap_flag_union_DescribeImageAttributeType = 0;
                  continue;
                }
            if (soap_flag_imageId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageId", &a->imageId, "xsd:string"))
                {       soap_flag_imageId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImageAttributeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImageAttributeType, 0, sizeof(struct ec2__DescribeImageAttributeType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_union_DescribeImageAttributeType || soap_flag_imageId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImageAttributeType(struct soap *soap, const struct ec2__DescribeImageAttributeType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImageAttributeType);
    if (soap_out_ec2__DescribeImageAttributeType(soap, tag?tag:"ec2:DescribeImageAttributeType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImageAttributeType * SOAP_FMAC4 soap_get_ec2__DescribeImageAttributeType(struct soap *soap, struct ec2__DescribeImageAttributeType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImageAttributeType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ResetImageAttributeResponseType(struct soap *soap, struct ec2__ResetImageAttributeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ResetImageAttributeResponseType(struct soap *soap, const struct ec2__ResetImageAttributeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ResetImageAttributeResponseType(struct soap *soap, const char *tag, int id, const struct ec2__ResetImageAttributeResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ResetImageAttributeResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ResetImageAttributeResponseType * SOAP_FMAC4 soap_in_ec2__ResetImageAttributeResponseType(struct soap *soap, const char *tag, struct ec2__ResetImageAttributeResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ResetImageAttributeResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ResetImageAttributeResponseType, sizeof(struct ec2__ResetImageAttributeResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ResetImageAttributeResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ResetImageAttributeResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ResetImageAttributeResponseType, 0, sizeof(struct ec2__ResetImageAttributeResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ResetImageAttributeResponseType(struct soap *soap, const struct ec2__ResetImageAttributeResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ResetImageAttributeResponseType);
    if (soap_out_ec2__ResetImageAttributeResponseType(soap, tag?tag:"ec2:ResetImageAttributeResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ResetImageAttributeResponseType * SOAP_FMAC4 soap_get_ec2__ResetImageAttributeResponseType(struct soap *soap, struct ec2__ResetImageAttributeResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ResetImageAttributeResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__EmptyElementType(struct soap *soap, struct ec2__EmptyElementType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__EmptyElementType(struct soap *soap, const struct ec2__EmptyElementType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__EmptyElementType(struct soap *soap, const char *tag, int id, const struct ec2__EmptyElementType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__EmptyElementType), type))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__EmptyElementType * SOAP_FMAC4 soap_in_ec2__EmptyElementType(struct soap *soap, const char *tag, struct ec2__EmptyElementType *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__EmptyElementType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__EmptyElementType, sizeof(struct ec2__EmptyElementType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__EmptyElementType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__EmptyElementType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__EmptyElementType, 0, sizeof(struct ec2__EmptyElementType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__EmptyElementType(struct soap *soap, const struct ec2__EmptyElementType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__EmptyElementType);
    if (soap_out_ec2__EmptyElementType(soap, tag?tag:"ec2:EmptyElementType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__EmptyElementType * SOAP_FMAC4 soap_get_ec2__EmptyElementType(struct soap *soap, struct ec2__EmptyElementType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__EmptyElementType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ResetImageAttributeType(struct soap *soap, struct ec2__ResetImageAttributeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__union_ResetImageAttributeType = 0;
    soap_default_string(soap, &a->imageId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ResetImageAttributeType(struct soap *soap, const struct ec2__ResetImageAttributeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__ec2__union_ResetImageAttributeType(soap, a->__union_ResetImageAttributeType, &a->union_ResetImageAttributeType);
    soap_serialize_string(soap, &a->imageId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ResetImageAttributeType(struct soap *soap, const char *tag, int id, const struct ec2__ResetImageAttributeType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ResetImageAttributeType), type))
      return soap->error;
    if (soap_out__ec2__union_ResetImageAttributeType(soap, a->__union_ResetImageAttributeType, &a->union_ResetImageAttributeType))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageId", -1, &a->imageId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ResetImageAttributeType * SOAP_FMAC4 soap_in_ec2__ResetImageAttributeType(struct soap *soap, const char *tag, struct ec2__ResetImageAttributeType *a, const char *type)
  {
    size_t soap_flag_union_ResetImageAttributeType = 1;
    size_t soap_flag_imageId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ResetImageAttributeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ResetImageAttributeType, sizeof(struct ec2__ResetImageAttributeType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ResetImageAttributeType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_union_ResetImageAttributeType && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in__ec2__union_ResetImageAttributeType(soap, &a->__union_ResetImageAttributeType, &a->union_ResetImageAttributeType))
                {       soap_flag_union_ResetImageAttributeType = 0;
                  continue;
                }
            if (soap_flag_imageId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageId", &a->imageId, "xsd:string"))
                {       soap_flag_imageId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ResetImageAttributeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ResetImageAttributeType, 0, sizeof(struct ec2__ResetImageAttributeType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_union_ResetImageAttributeType || soap_flag_imageId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ResetImageAttributeType(struct soap *soap, const struct ec2__ResetImageAttributeType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ResetImageAttributeType);
    if (soap_out_ec2__ResetImageAttributeType(soap, tag?tag:"ec2:ResetImageAttributeType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ResetImageAttributeType * SOAP_FMAC4 soap_get_ec2__ResetImageAttributeType(struct soap *soap, struct ec2__ResetImageAttributeType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ResetImageAttributeType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ModifyImageAttributeResponseType(struct soap *soap, struct ec2__ModifyImageAttributeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ModifyImageAttributeResponseType(struct soap *soap, const struct ec2__ModifyImageAttributeResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ModifyImageAttributeResponseType(struct soap *soap, const char *tag, int id, const struct ec2__ModifyImageAttributeResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ModifyImageAttributeResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ModifyImageAttributeResponseType * SOAP_FMAC4 soap_in_ec2__ModifyImageAttributeResponseType(struct soap *soap, const char *tag, struct ec2__ModifyImageAttributeResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ModifyImageAttributeResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ModifyImageAttributeResponseType, sizeof(struct ec2__ModifyImageAttributeResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ModifyImageAttributeResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ModifyImageAttributeResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ModifyImageAttributeResponseType, 0, sizeof(struct ec2__ModifyImageAttributeResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ModifyImageAttributeResponseType(struct soap *soap, const struct ec2__ModifyImageAttributeResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ModifyImageAttributeResponseType);
    if (soap_out_ec2__ModifyImageAttributeResponseType(soap, tag?tag:"ec2:ModifyImageAttributeResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ModifyImageAttributeResponseType * SOAP_FMAC4 soap_get_ec2__ModifyImageAttributeResponseType(struct soap *soap, struct ec2__ModifyImageAttributeResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ModifyImageAttributeResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ProductCodeItemType(struct soap *soap, struct ec2__ProductCodeItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__union_ProductCodeItemType = 0;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ProductCodeItemType(struct soap *soap, const struct ec2__ProductCodeItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__ec2__union_ProductCodeItemType(soap, a->__union_ProductCodeItemType, &a->union_ProductCodeItemType);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ProductCodeItemType(struct soap *soap, const char *tag, int id, const struct ec2__ProductCodeItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ProductCodeItemType), type))
      return soap->error;
    if (soap_out__ec2__union_ProductCodeItemType(soap, a->__union_ProductCodeItemType, &a->union_ProductCodeItemType))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ProductCodeItemType * SOAP_FMAC4 soap_in_ec2__ProductCodeItemType(struct soap *soap, const char *tag, struct ec2__ProductCodeItemType *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ProductCodeItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ProductCodeItemType, sizeof(struct ec2__ProductCodeItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ProductCodeItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        if (!soap_in__ec2__union_ProductCodeItemType(soap, &a->__union_ProductCodeItemType, &a->union_ProductCodeItemType))
          return NULL;
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ProductCodeItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ProductCodeItemType, 0, sizeof(struct ec2__ProductCodeItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ProductCodeItemType(struct soap *soap, const struct ec2__ProductCodeItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ProductCodeItemType);
    if (soap_out_ec2__ProductCodeItemType(soap, tag?tag:"ec2:ProductCodeItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ProductCodeItemType * SOAP_FMAC4 soap_get_ec2__ProductCodeItemType(struct soap *soap, struct ec2__ProductCodeItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ProductCodeItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__LaunchPermissionItemType(struct soap *soap, struct ec2__LaunchPermissionItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__union_LaunchPermissionItemType = 0;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__LaunchPermissionItemType(struct soap *soap, const struct ec2__LaunchPermissionItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__ec2__union_LaunchPermissionItemType(soap, a->__union_LaunchPermissionItemType, &a->union_LaunchPermissionItemType);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__LaunchPermissionItemType(struct soap *soap, const char *tag, int id, const struct ec2__LaunchPermissionItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__LaunchPermissionItemType), type))
      return soap->error;
    if (soap_out__ec2__union_LaunchPermissionItemType(soap, a->__union_LaunchPermissionItemType, &a->union_LaunchPermissionItemType))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__LaunchPermissionItemType * SOAP_FMAC4 soap_in_ec2__LaunchPermissionItemType(struct soap *soap, const char *tag, struct ec2__LaunchPermissionItemType *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__LaunchPermissionItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__LaunchPermissionItemType, sizeof(struct ec2__LaunchPermissionItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__LaunchPermissionItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        if (!soap_in__ec2__union_LaunchPermissionItemType(soap, &a->__union_LaunchPermissionItemType, &a->union_LaunchPermissionItemType))
          return NULL;
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__LaunchPermissionItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__LaunchPermissionItemType, 0, sizeof(struct ec2__LaunchPermissionItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__LaunchPermissionItemType(struct soap *soap, const struct ec2__LaunchPermissionItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__LaunchPermissionItemType);
    if (soap_out_ec2__LaunchPermissionItemType(soap, tag?tag:"ec2:LaunchPermissionItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__LaunchPermissionItemType * SOAP_FMAC4 soap_get_ec2__LaunchPermissionItemType(struct soap *soap, struct ec2__LaunchPermissionItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__LaunchPermissionItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__LaunchPermissionListType(struct soap *soap, struct ec2__LaunchPermissionListType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__LaunchPermissionListType(struct soap *soap, const struct ec2__LaunchPermissionListType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__LaunchPermissionItemType);
            soap_serialize_ec2__LaunchPermissionItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__LaunchPermissionListType(struct soap *soap, const char *tag, int id, const struct ec2__LaunchPermissionListType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__LaunchPermissionListType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__LaunchPermissionItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__LaunchPermissionListType * SOAP_FMAC4 soap_in_ec2__LaunchPermissionListType(struct soap *soap, const char *tag, struct ec2__LaunchPermissionListType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__LaunchPermissionListType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__LaunchPermissionListType, sizeof(struct ec2__LaunchPermissionListType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__LaunchPermissionListType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__LaunchPermissionItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__LaunchPermissionItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__LaunchPermissionItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__LaunchPermissionItemType(soap, "ec2:item", a->item, "ec2:LaunchPermissionItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__LaunchPermissionItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__LaunchPermissionListType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__LaunchPermissionListType, 0, sizeof(struct ec2__LaunchPermissionListType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__LaunchPermissionListType(struct soap *soap, const struct ec2__LaunchPermissionListType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__LaunchPermissionListType);
    if (soap_out_ec2__LaunchPermissionListType(soap, tag?tag:"ec2:LaunchPermissionListType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__LaunchPermissionListType * SOAP_FMAC4 soap_get_ec2__LaunchPermissionListType(struct soap *soap, struct ec2__LaunchPermissionListType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__LaunchPermissionListType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ProductCodeListType(struct soap *soap, struct ec2__ProductCodeListType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ProductCodeListType(struct soap *soap, const struct ec2__ProductCodeListType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__ProductCodeItemType);
            soap_serialize_ec2__ProductCodeItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ProductCodeListType(struct soap *soap, const char *tag, int id, const struct ec2__ProductCodeListType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ProductCodeListType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__ProductCodeItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ProductCodeListType * SOAP_FMAC4 soap_in_ec2__ProductCodeListType(struct soap *soap, const char *tag, struct ec2__ProductCodeListType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ProductCodeListType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ProductCodeListType, sizeof(struct ec2__ProductCodeListType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ProductCodeListType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__ProductCodeItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__ProductCodeItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__ProductCodeItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__ProductCodeItemType(soap, "ec2:item", a->item, "ec2:ProductCodeItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__ProductCodeItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ProductCodeListType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ProductCodeListType, 0, sizeof(struct ec2__ProductCodeListType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ProductCodeListType(struct soap *soap, const struct ec2__ProductCodeListType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ProductCodeListType);
    if (soap_out_ec2__ProductCodeListType(soap, tag?tag:"ec2:ProductCodeListType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ProductCodeListType * SOAP_FMAC4 soap_get_ec2__ProductCodeListType(struct soap *soap, struct ec2__ProductCodeListType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ProductCodeListType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__LaunchPermissionOperationType(struct soap *soap, struct ec2__LaunchPermissionOperationType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__union_LaunchPermissionOperationType = 0;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__LaunchPermissionOperationType(struct soap *soap, const struct ec2__LaunchPermissionOperationType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize__ec2__union_LaunchPermissionOperationType(soap, a->__union_LaunchPermissionOperationType, &a->union_LaunchPermissionOperationType);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__LaunchPermissionOperationType(struct soap *soap, const char *tag, int id, const struct ec2__LaunchPermissionOperationType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__LaunchPermissionOperationType), type))
      return soap->error;
    if (soap_out__ec2__union_LaunchPermissionOperationType(soap, a->__union_LaunchPermissionOperationType, &a->union_LaunchPermissionOperationType))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__LaunchPermissionOperationType * SOAP_FMAC4 soap_in_ec2__LaunchPermissionOperationType(struct soap *soap, const char *tag, struct ec2__LaunchPermissionOperationType *a, const char *type)
  {
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__LaunchPermissionOperationType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__LaunchPermissionOperationType, sizeof(struct ec2__LaunchPermissionOperationType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__LaunchPermissionOperationType(soap, a);
    if (soap->body && !*soap->href)
      {
        if (!soap_in__ec2__union_LaunchPermissionOperationType(soap, &a->__union_LaunchPermissionOperationType, &a->union_LaunchPermissionOperationType))
          return NULL;
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__LaunchPermissionOperationType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__LaunchPermissionOperationType, 0, sizeof(struct ec2__LaunchPermissionOperationType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__LaunchPermissionOperationType(struct soap *soap, const struct ec2__LaunchPermissionOperationType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__LaunchPermissionOperationType);
    if (soap_out_ec2__LaunchPermissionOperationType(soap, tag?tag:"ec2:LaunchPermissionOperationType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__LaunchPermissionOperationType * SOAP_FMAC4 soap_get_ec2__LaunchPermissionOperationType(struct soap *soap, struct ec2__LaunchPermissionOperationType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__LaunchPermissionOperationType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ModifyImageAttributeType(struct soap *soap, struct ec2__ModifyImageAttributeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->imageId);
    a->__union_ModifyImageAttributeType = 0;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ModifyImageAttributeType(struct soap *soap, const struct ec2__ModifyImageAttributeType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->imageId);
    soap_serialize__ec2__union_ModifyImageAttributeType(soap, a->__union_ModifyImageAttributeType, &a->union_ModifyImageAttributeType);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ModifyImageAttributeType(struct soap *soap, const char *tag, int id, const struct ec2__ModifyImageAttributeType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ModifyImageAttributeType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageId", -1, &a->imageId, ""))
      return soap->error;
    if (soap_out__ec2__union_ModifyImageAttributeType(soap, a->__union_ModifyImageAttributeType, &a->union_ModifyImageAttributeType))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ModifyImageAttributeType * SOAP_FMAC4 soap_in_ec2__ModifyImageAttributeType(struct soap *soap, const char *tag, struct ec2__ModifyImageAttributeType *a, const char *type)
  {
    size_t soap_flag_imageId = 1;
    size_t soap_flag_union_ModifyImageAttributeType = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ModifyImageAttributeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ModifyImageAttributeType, sizeof(struct ec2__ModifyImageAttributeType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ModifyImageAttributeType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_imageId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageId", &a->imageId, "xsd:string"))
                {       soap_flag_imageId--;
                  continue;
                }
            if (soap_flag_union_ModifyImageAttributeType && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in__ec2__union_ModifyImageAttributeType(soap, &a->__union_ModifyImageAttributeType, &a->union_ModifyImageAttributeType))
                {       soap_flag_union_ModifyImageAttributeType = 0;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ModifyImageAttributeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ModifyImageAttributeType, 0, sizeof(struct ec2__ModifyImageAttributeType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_imageId > 0 || soap_flag_union_ModifyImageAttributeType))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ModifyImageAttributeType(struct soap *soap, const struct ec2__ModifyImageAttributeType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ModifyImageAttributeType);
    if (soap_out_ec2__ModifyImageAttributeType(soap, tag?tag:"ec2:ModifyImageAttributeType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ModifyImageAttributeType * SOAP_FMAC4 soap_get_ec2__ModifyImageAttributeType(struct soap *soap, struct ec2__ModifyImageAttributeType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ModifyImageAttributeType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RevokeSecurityGroupIngressResponseType(struct soap *soap, struct ec2__RevokeSecurityGroupIngressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RevokeSecurityGroupIngressResponseType(struct soap *soap, const struct ec2__RevokeSecurityGroupIngressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RevokeSecurityGroupIngressResponseType(struct soap *soap, const char *tag, int id, const struct ec2__RevokeSecurityGroupIngressResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RevokeSecurityGroupIngressResponseType * SOAP_FMAC4 soap_in_ec2__RevokeSecurityGroupIngressResponseType(struct soap *soap, const char *tag, struct ec2__RevokeSecurityGroupIngressResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RevokeSecurityGroupIngressResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType, sizeof(struct ec2__RevokeSecurityGroupIngressResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RevokeSecurityGroupIngressResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RevokeSecurityGroupIngressResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType, 0, sizeof(struct ec2__RevokeSecurityGroupIngressResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RevokeSecurityGroupIngressResponseType(struct soap *soap, const struct ec2__RevokeSecurityGroupIngressResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RevokeSecurityGroupIngressResponseType);
    if (soap_out_ec2__RevokeSecurityGroupIngressResponseType(soap, tag?tag:"ec2:RevokeSecurityGroupIngressResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RevokeSecurityGroupIngressResponseType * SOAP_FMAC4 soap_get_ec2__RevokeSecurityGroupIngressResponseType(struct soap *soap, struct ec2__RevokeSecurityGroupIngressResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RevokeSecurityGroupIngressResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RevokeSecurityGroupIngressType(struct soap *soap, struct ec2__RevokeSecurityGroupIngressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->userId);
    soap_default_string(soap, &a->groupName);
    a->ipPermissions = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RevokeSecurityGroupIngressType(struct soap *soap, const struct ec2__RevokeSecurityGroupIngressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->userId);
    soap_serialize_string(soap, &a->groupName);
    soap_serialize_PointerToec2__IpPermissionSetType(soap, &a->ipPermissions);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RevokeSecurityGroupIngressType(struct soap *soap, const char *tag, int id, const struct ec2__RevokeSecurityGroupIngressType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RevokeSecurityGroupIngressType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:userId", -1, &a->userId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupName", -1, &a->groupName, ""))
      return soap->error;
    if (soap_out_PointerToec2__IpPermissionSetType(soap, "ec2:ipPermissions", -1, &a->ipPermissions, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RevokeSecurityGroupIngressType * SOAP_FMAC4 soap_in_ec2__RevokeSecurityGroupIngressType(struct soap *soap, const char *tag, struct ec2__RevokeSecurityGroupIngressType *a, const char *type)
  {
    size_t soap_flag_userId = 1;
    size_t soap_flag_groupName = 1;
    size_t soap_flag_ipPermissions = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RevokeSecurityGroupIngressType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RevokeSecurityGroupIngressType, sizeof(struct ec2__RevokeSecurityGroupIngressType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RevokeSecurityGroupIngressType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_userId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:userId", &a->userId, "xsd:string"))
                {       soap_flag_userId--;
                  continue;
                }
            if (soap_flag_groupName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupName", &a->groupName, "xsd:string"))
                {       soap_flag_groupName--;
                  continue;
                }
            if (soap_flag_ipPermissions && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__IpPermissionSetType(soap, "ec2:ipPermissions", &a->ipPermissions, "ec2:IpPermissionSetType"))
                {       soap_flag_ipPermissions--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RevokeSecurityGroupIngressType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RevokeSecurityGroupIngressType, 0, sizeof(struct ec2__RevokeSecurityGroupIngressType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_userId > 0 || soap_flag_groupName > 0 || soap_flag_ipPermissions > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RevokeSecurityGroupIngressType(struct soap *soap, const struct ec2__RevokeSecurityGroupIngressType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RevokeSecurityGroupIngressType);
    if (soap_out_ec2__RevokeSecurityGroupIngressType(soap, tag?tag:"ec2:RevokeSecurityGroupIngressType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RevokeSecurityGroupIngressType * SOAP_FMAC4 soap_get_ec2__RevokeSecurityGroupIngressType(struct soap *soap, struct ec2__RevokeSecurityGroupIngressType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RevokeSecurityGroupIngressType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AuthorizeSecurityGroupIngressResponseType(struct soap *soap, struct ec2__AuthorizeSecurityGroupIngressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AuthorizeSecurityGroupIngressResponseType(struct soap *soap, const struct ec2__AuthorizeSecurityGroupIngressResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AuthorizeSecurityGroupIngressResponseType(struct soap *soap, const char *tag, int id, const struct ec2__AuthorizeSecurityGroupIngressResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AuthorizeSecurityGroupIngressResponseType * SOAP_FMAC4 soap_in_ec2__AuthorizeSecurityGroupIngressResponseType(struct soap *soap, const char *tag, struct ec2__AuthorizeSecurityGroupIngressResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AuthorizeSecurityGroupIngressResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType, sizeof(struct ec2__AuthorizeSecurityGroupIngressResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AuthorizeSecurityGroupIngressResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AuthorizeSecurityGroupIngressResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType, 0, sizeof(struct ec2__AuthorizeSecurityGroupIngressResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AuthorizeSecurityGroupIngressResponseType(struct soap *soap, const struct ec2__AuthorizeSecurityGroupIngressResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressResponseType);
    if (soap_out_ec2__AuthorizeSecurityGroupIngressResponseType(soap, tag?tag:"ec2:AuthorizeSecurityGroupIngressResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AuthorizeSecurityGroupIngressResponseType * SOAP_FMAC4 soap_get_ec2__AuthorizeSecurityGroupIngressResponseType(struct soap *soap, struct ec2__AuthorizeSecurityGroupIngressResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AuthorizeSecurityGroupIngressResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__AuthorizeSecurityGroupIngressType(struct soap *soap, struct ec2__AuthorizeSecurityGroupIngressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->userId);
    soap_default_string(soap, &a->groupName);
    a->ipPermissions = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__AuthorizeSecurityGroupIngressType(struct soap *soap, const struct ec2__AuthorizeSecurityGroupIngressType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->userId);
    soap_serialize_string(soap, &a->groupName);
    soap_serialize_PointerToec2__IpPermissionSetType(soap, &a->ipPermissions);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__AuthorizeSecurityGroupIngressType(struct soap *soap, const char *tag, int id, const struct ec2__AuthorizeSecurityGroupIngressType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:userId", -1, &a->userId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupName", -1, &a->groupName, ""))
      return soap->error;
    if (soap_out_PointerToec2__IpPermissionSetType(soap, "ec2:ipPermissions", -1, &a->ipPermissions, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__AuthorizeSecurityGroupIngressType * SOAP_FMAC4 soap_in_ec2__AuthorizeSecurityGroupIngressType(struct soap *soap, const char *tag, struct ec2__AuthorizeSecurityGroupIngressType *a, const char *type)
  {
    size_t soap_flag_userId = 1;
    size_t soap_flag_groupName = 1;
    size_t soap_flag_ipPermissions = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__AuthorizeSecurityGroupIngressType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType, sizeof(struct ec2__AuthorizeSecurityGroupIngressType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__AuthorizeSecurityGroupIngressType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_userId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:userId", &a->userId, "xsd:string"))
                {       soap_flag_userId--;
                  continue;
                }
            if (soap_flag_groupName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupName", &a->groupName, "xsd:string"))
                {       soap_flag_groupName--;
                  continue;
                }
            if (soap_flag_ipPermissions && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__IpPermissionSetType(soap, "ec2:ipPermissions", &a->ipPermissions, "ec2:IpPermissionSetType"))
                {       soap_flag_ipPermissions--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__AuthorizeSecurityGroupIngressType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType, 0, sizeof(struct ec2__AuthorizeSecurityGroupIngressType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_userId > 0 || soap_flag_groupName > 0 || soap_flag_ipPermissions > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__AuthorizeSecurityGroupIngressType(struct soap *soap, const struct ec2__AuthorizeSecurityGroupIngressType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__AuthorizeSecurityGroupIngressType);
    if (soap_out_ec2__AuthorizeSecurityGroupIngressType(soap, tag?tag:"ec2:AuthorizeSecurityGroupIngressType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__AuthorizeSecurityGroupIngressType * SOAP_FMAC4 soap_get_ec2__AuthorizeSecurityGroupIngressType(struct soap *soap, struct ec2__AuthorizeSecurityGroupIngressType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__AuthorizeSecurityGroupIngressType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__SecurityGroupItemType(struct soap *soap, struct ec2__SecurityGroupItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->ownerId);
    soap_default_string(soap, &a->groupName);
    soap_default_string(soap, &a->groupDescription);
    a->ipPermissions = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__SecurityGroupItemType(struct soap *soap, const struct ec2__SecurityGroupItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->ownerId);
    soap_serialize_string(soap, &a->groupName);
    soap_serialize_string(soap, &a->groupDescription);
    soap_serialize_PointerToec2__IpPermissionSetType(soap, &a->ipPermissions);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__SecurityGroupItemType(struct soap *soap, const char *tag, int id, const struct ec2__SecurityGroupItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__SecurityGroupItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:ownerId", -1, &a->ownerId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupName", -1, &a->groupName, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupDescription", -1, &a->groupDescription, ""))
      return soap->error;
    if (soap_out_PointerToec2__IpPermissionSetType(soap, "ec2:ipPermissions", -1, &a->ipPermissions, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__SecurityGroupItemType * SOAP_FMAC4 soap_in_ec2__SecurityGroupItemType(struct soap *soap, const char *tag, struct ec2__SecurityGroupItemType *a, const char *type)
  {
    size_t soap_flag_ownerId = 1;
    size_t soap_flag_groupName = 1;
    size_t soap_flag_groupDescription = 1;
    size_t soap_flag_ipPermissions = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__SecurityGroupItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__SecurityGroupItemType, sizeof(struct ec2__SecurityGroupItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__SecurityGroupItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ownerId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:ownerId", &a->ownerId, "xsd:string"))
                {       soap_flag_ownerId--;
                  continue;
                }
            if (soap_flag_groupName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupName", &a->groupName, "xsd:string"))
                {       soap_flag_groupName--;
                  continue;
                }
            if (soap_flag_groupDescription && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupDescription", &a->groupDescription, "xsd:string"))
                {       soap_flag_groupDescription--;
                  continue;
                }
            if (soap_flag_ipPermissions && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__IpPermissionSetType(soap, "ec2:ipPermissions", &a->ipPermissions, "ec2:IpPermissionSetType"))
                {       soap_flag_ipPermissions--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__SecurityGroupItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__SecurityGroupItemType, 0, sizeof(struct ec2__SecurityGroupItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ownerId > 0 || soap_flag_groupName > 0 || soap_flag_groupDescription > 0 || soap_flag_ipPermissions > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__SecurityGroupItemType(struct soap *soap, const struct ec2__SecurityGroupItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__SecurityGroupItemType);
    if (soap_out_ec2__SecurityGroupItemType(soap, tag?tag:"ec2:SecurityGroupItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__SecurityGroupItemType * SOAP_FMAC4 soap_get_ec2__SecurityGroupItemType(struct soap *soap, struct ec2__SecurityGroupItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__SecurityGroupItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__UserIdGroupPairType(struct soap *soap, struct ec2__UserIdGroupPairType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->userId);
    soap_default_string(soap, &a->groupName);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__UserIdGroupPairType(struct soap *soap, const struct ec2__UserIdGroupPairType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->userId);
    soap_serialize_string(soap, &a->groupName);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__UserIdGroupPairType(struct soap *soap, const char *tag, int id, const struct ec2__UserIdGroupPairType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__UserIdGroupPairType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:userId", -1, &a->userId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupName", -1, &a->groupName, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__UserIdGroupPairType * SOAP_FMAC4 soap_in_ec2__UserIdGroupPairType(struct soap *soap, const char *tag, struct ec2__UserIdGroupPairType *a, const char *type)
  {
    size_t soap_flag_userId = 1;
    size_t soap_flag_groupName = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__UserIdGroupPairType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__UserIdGroupPairType, sizeof(struct ec2__UserIdGroupPairType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__UserIdGroupPairType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_userId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:userId", &a->userId, "xsd:string"))
                {       soap_flag_userId--;
                  continue;
                }
            if (soap_flag_groupName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupName", &a->groupName, "xsd:string"))
                {       soap_flag_groupName--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__UserIdGroupPairType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__UserIdGroupPairType, 0, sizeof(struct ec2__UserIdGroupPairType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_userId > 0 || soap_flag_groupName > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__UserIdGroupPairType(struct soap *soap, const struct ec2__UserIdGroupPairType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__UserIdGroupPairType);
    if (soap_out_ec2__UserIdGroupPairType(soap, tag?tag:"ec2:UserIdGroupPairType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__UserIdGroupPairType * SOAP_FMAC4 soap_get_ec2__UserIdGroupPairType(struct soap *soap, struct ec2__UserIdGroupPairType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__UserIdGroupPairType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__IpRangeItemType(struct soap *soap, struct ec2__IpRangeItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->cidrIp);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__IpRangeItemType(struct soap *soap, const struct ec2__IpRangeItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->cidrIp);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__IpRangeItemType(struct soap *soap, const char *tag, int id, const struct ec2__IpRangeItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__IpRangeItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:cidrIp", -1, &a->cidrIp, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__IpRangeItemType * SOAP_FMAC4 soap_in_ec2__IpRangeItemType(struct soap *soap, const char *tag, struct ec2__IpRangeItemType *a, const char *type)
  {
    size_t soap_flag_cidrIp = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__IpRangeItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__IpRangeItemType, sizeof(struct ec2__IpRangeItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__IpRangeItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_cidrIp && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:cidrIp", &a->cidrIp, "xsd:string"))
                {       soap_flag_cidrIp--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__IpRangeItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__IpRangeItemType, 0, sizeof(struct ec2__IpRangeItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_cidrIp > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__IpRangeItemType(struct soap *soap, const struct ec2__IpRangeItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__IpRangeItemType);
    if (soap_out_ec2__IpRangeItemType(soap, tag?tag:"ec2:IpRangeItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__IpRangeItemType * SOAP_FMAC4 soap_get_ec2__IpRangeItemType(struct soap *soap, struct ec2__IpRangeItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__IpRangeItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__IpRangeSetType(struct soap *soap, struct ec2__IpRangeSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__IpRangeSetType(struct soap *soap, const struct ec2__IpRangeSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__IpRangeItemType);
            soap_serialize_ec2__IpRangeItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__IpRangeSetType(struct soap *soap, const char *tag, int id, const struct ec2__IpRangeSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__IpRangeSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__IpRangeItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__IpRangeSetType * SOAP_FMAC4 soap_in_ec2__IpRangeSetType(struct soap *soap, const char *tag, struct ec2__IpRangeSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__IpRangeSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__IpRangeSetType, sizeof(struct ec2__IpRangeSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__IpRangeSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__IpRangeItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__IpRangeItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__IpRangeItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__IpRangeItemType(soap, "ec2:item", a->item, "ec2:IpRangeItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__IpRangeItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__IpRangeSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__IpRangeSetType, 0, sizeof(struct ec2__IpRangeSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__IpRangeSetType(struct soap *soap, const struct ec2__IpRangeSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__IpRangeSetType);
    if (soap_out_ec2__IpRangeSetType(soap, tag?tag:"ec2:IpRangeSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__IpRangeSetType * SOAP_FMAC4 soap_get_ec2__IpRangeSetType(struct soap *soap, struct ec2__IpRangeSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__IpRangeSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__UserIdGroupPairSetType(struct soap *soap, struct ec2__UserIdGroupPairSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__UserIdGroupPairSetType(struct soap *soap, const struct ec2__UserIdGroupPairSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__UserIdGroupPairType);
            soap_serialize_ec2__UserIdGroupPairType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__UserIdGroupPairSetType(struct soap *soap, const char *tag, int id, const struct ec2__UserIdGroupPairSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__UserIdGroupPairSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__UserIdGroupPairType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__UserIdGroupPairSetType * SOAP_FMAC4 soap_in_ec2__UserIdGroupPairSetType(struct soap *soap, const char *tag, struct ec2__UserIdGroupPairSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__UserIdGroupPairSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__UserIdGroupPairSetType, sizeof(struct ec2__UserIdGroupPairSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__UserIdGroupPairSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__UserIdGroupPairType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__UserIdGroupPairType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__UserIdGroupPairType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__UserIdGroupPairType(soap, "ec2:item", a->item, "ec2:UserIdGroupPairType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__UserIdGroupPairType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__UserIdGroupPairSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__UserIdGroupPairSetType, 0, sizeof(struct ec2__UserIdGroupPairSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__UserIdGroupPairSetType(struct soap *soap, const struct ec2__UserIdGroupPairSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__UserIdGroupPairSetType);
    if (soap_out_ec2__UserIdGroupPairSetType(soap, tag?tag:"ec2:UserIdGroupPairSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__UserIdGroupPairSetType * SOAP_FMAC4 soap_get_ec2__UserIdGroupPairSetType(struct soap *soap, struct ec2__UserIdGroupPairSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__UserIdGroupPairSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__IpPermissionType(struct soap *soap, struct ec2__IpPermissionType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->ipProtocol);
    soap_default_int(soap, &a->fromPort);
    soap_default_int(soap, &a->toPort);
    a->groups = NULL;
    a->ipRanges = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__IpPermissionType(struct soap *soap, const struct ec2__IpPermissionType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->ipProtocol);
    soap_embedded(soap, &a->fromPort, SOAP_TYPE_int);
    soap_embedded(soap, &a->toPort, SOAP_TYPE_int);
    soap_serialize_PointerToec2__UserIdGroupPairSetType(soap, &a->groups);
    soap_serialize_PointerToec2__IpRangeSetType(soap, &a->ipRanges);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__IpPermissionType(struct soap *soap, const char *tag, int id, const struct ec2__IpPermissionType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__IpPermissionType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:ipProtocol", -1, &a->ipProtocol, ""))
      return soap->error;
    if (soap_out_int(soap, "ec2:fromPort", -1, &a->fromPort, ""))
      return soap->error;
    if (soap_out_int(soap, "ec2:toPort", -1, &a->toPort, ""))
      return soap->error;
    if (soap_out_PointerToec2__UserIdGroupPairSetType(soap, "ec2:groups", -1, &a->groups, ""))
      return soap->error;
    if (soap_out_PointerToec2__IpRangeSetType(soap, "ec2:ipRanges", -1, &a->ipRanges, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__IpPermissionType * SOAP_FMAC4 soap_in_ec2__IpPermissionType(struct soap *soap, const char *tag, struct ec2__IpPermissionType *a, const char *type)
  {
    size_t soap_flag_ipProtocol = 1;
    size_t soap_flag_fromPort = 1;
    size_t soap_flag_toPort = 1;
    size_t soap_flag_groups = 1;
    size_t soap_flag_ipRanges = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__IpPermissionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__IpPermissionType, sizeof(struct ec2__IpPermissionType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__IpPermissionType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_ipProtocol && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:ipProtocol", &a->ipProtocol, "xsd:string"))
                {       soap_flag_ipProtocol--;
                  continue;
                }
            if (soap_flag_fromPort && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_int(soap, "ec2:fromPort", &a->fromPort, "xsd:int"))
                {       soap_flag_fromPort--;
                  continue;
                }
            if (soap_flag_toPort && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_int(soap, "ec2:toPort", &a->toPort, "xsd:int"))
                {       soap_flag_toPort--;
                  continue;
                }
            if (soap_flag_groups && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__UserIdGroupPairSetType(soap, "ec2:groups", &a->groups, "ec2:UserIdGroupPairSetType"))
                {       soap_flag_groups--;
                  continue;
                }
            if (soap_flag_ipRanges && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__IpRangeSetType(soap, "ec2:ipRanges", &a->ipRanges, "ec2:IpRangeSetType"))
                {       soap_flag_ipRanges--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__IpPermissionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__IpPermissionType, 0, sizeof(struct ec2__IpPermissionType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ipProtocol > 0 || soap_flag_fromPort > 0 || soap_flag_toPort > 0 || soap_flag_groups > 0 || soap_flag_ipRanges > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__IpPermissionType(struct soap *soap, const struct ec2__IpPermissionType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__IpPermissionType);
    if (soap_out_ec2__IpPermissionType(soap, tag?tag:"ec2:IpPermissionType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__IpPermissionType * SOAP_FMAC4 soap_get_ec2__IpPermissionType(struct soap *soap, struct ec2__IpPermissionType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__IpPermissionType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__IpPermissionSetType(struct soap *soap, struct ec2__IpPermissionSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__IpPermissionSetType(struct soap *soap, const struct ec2__IpPermissionSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__IpPermissionType);
            soap_serialize_ec2__IpPermissionType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__IpPermissionSetType(struct soap *soap, const char *tag, int id, const struct ec2__IpPermissionSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__IpPermissionSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__IpPermissionType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__IpPermissionSetType * SOAP_FMAC4 soap_in_ec2__IpPermissionSetType(struct soap *soap, const char *tag, struct ec2__IpPermissionSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__IpPermissionSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__IpPermissionSetType, sizeof(struct ec2__IpPermissionSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__IpPermissionSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__IpPermissionType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__IpPermissionType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__IpPermissionType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__IpPermissionType(soap, "ec2:item", a->item, "ec2:IpPermissionType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__IpPermissionType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__IpPermissionSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__IpPermissionSetType, 0, sizeof(struct ec2__IpPermissionSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__IpPermissionSetType(struct soap *soap, const struct ec2__IpPermissionSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__IpPermissionSetType);
    if (soap_out_ec2__IpPermissionSetType(soap, tag?tag:"ec2:IpPermissionSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__IpPermissionSetType * SOAP_FMAC4 soap_get_ec2__IpPermissionSetType(struct soap *soap, struct ec2__IpPermissionSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__IpPermissionSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__SecurityGroupSetType(struct soap *soap, struct ec2__SecurityGroupSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__SecurityGroupSetType(struct soap *soap, const struct ec2__SecurityGroupSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__SecurityGroupItemType);
            soap_serialize_ec2__SecurityGroupItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__SecurityGroupSetType(struct soap *soap, const char *tag, int id, const struct ec2__SecurityGroupSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__SecurityGroupSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__SecurityGroupItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__SecurityGroupSetType * SOAP_FMAC4 soap_in_ec2__SecurityGroupSetType(struct soap *soap, const char *tag, struct ec2__SecurityGroupSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__SecurityGroupSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__SecurityGroupSetType, sizeof(struct ec2__SecurityGroupSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__SecurityGroupSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__SecurityGroupItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__SecurityGroupItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__SecurityGroupItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__SecurityGroupItemType(soap, "ec2:item", a->item, "ec2:SecurityGroupItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__SecurityGroupItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__SecurityGroupSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__SecurityGroupSetType, 0, sizeof(struct ec2__SecurityGroupSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__SecurityGroupSetType(struct soap *soap, const struct ec2__SecurityGroupSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__SecurityGroupSetType);
    if (soap_out_ec2__SecurityGroupSetType(soap, tag?tag:"ec2:SecurityGroupSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__SecurityGroupSetType * SOAP_FMAC4 soap_get_ec2__SecurityGroupSetType(struct soap *soap, struct ec2__SecurityGroupSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__SecurityGroupSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSecurityGroupsResponseType(struct soap *soap, struct ec2__DescribeSecurityGroupsResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->securityGroupInfo = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSecurityGroupsResponseType(struct soap *soap, const struct ec2__DescribeSecurityGroupsResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__SecurityGroupSetType(soap, &a->securityGroupInfo);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSecurityGroupsResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSecurityGroupsResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__SecurityGroupSetType(soap, "ec2:securityGroupInfo", -1, &a->securityGroupInfo, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsResponseType * SOAP_FMAC4 soap_in_ec2__DescribeSecurityGroupsResponseType(struct soap *soap, const char *tag, struct ec2__DescribeSecurityGroupsResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_securityGroupInfo = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSecurityGroupsResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType, sizeof(struct ec2__DescribeSecurityGroupsResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSecurityGroupsResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_securityGroupInfo && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__SecurityGroupSetType(soap, "ec2:securityGroupInfo", &a->securityGroupInfo, "ec2:SecurityGroupSetType"))
                {       soap_flag_securityGroupInfo--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSecurityGroupsResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType, 0, sizeof(struct ec2__DescribeSecurityGroupsResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_securityGroupInfo > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSecurityGroupsResponseType(struct soap *soap, const struct ec2__DescribeSecurityGroupsResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSecurityGroupsResponseType);
    if (soap_out_ec2__DescribeSecurityGroupsResponseType(soap, tag?tag:"ec2:DescribeSecurityGroupsResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsResponseType * SOAP_FMAC4 soap_get_ec2__DescribeSecurityGroupsResponseType(struct soap *soap, struct ec2__DescribeSecurityGroupsResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSecurityGroupsResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSecurityGroupsSetItemType(struct soap *soap, struct ec2__DescribeSecurityGroupsSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->groupName);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSecurityGroupsSetItemType(struct soap *soap, const struct ec2__DescribeSecurityGroupsSetItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->groupName);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSecurityGroupsSetItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSecurityGroupsSetItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupName", -1, &a->groupName, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsSetItemType * SOAP_FMAC4 soap_in_ec2__DescribeSecurityGroupsSetItemType(struct soap *soap, const char *tag, struct ec2__DescribeSecurityGroupsSetItemType *a, const char *type)
  {
    size_t soap_flag_groupName = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSecurityGroupsSetItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType, sizeof(struct ec2__DescribeSecurityGroupsSetItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSecurityGroupsSetItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_groupName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupName", &a->groupName, "xsd:string"))
                {       soap_flag_groupName--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSecurityGroupsSetItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType, 0, sizeof(struct ec2__DescribeSecurityGroupsSetItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_groupName > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSecurityGroupsSetItemType(struct soap *soap, const struct ec2__DescribeSecurityGroupsSetItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType);
    if (soap_out_ec2__DescribeSecurityGroupsSetItemType(soap, tag?tag:"ec2:DescribeSecurityGroupsSetItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsSetItemType * SOAP_FMAC4 soap_get_ec2__DescribeSecurityGroupsSetItemType(struct soap *soap, struct ec2__DescribeSecurityGroupsSetItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSecurityGroupsSetItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSecurityGroupsSetType(struct soap *soap, struct ec2__DescribeSecurityGroupsSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSecurityGroupsSetType(struct soap *soap, const struct ec2__DescribeSecurityGroupsSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeSecurityGroupsSetItemType);
            soap_serialize_ec2__DescribeSecurityGroupsSetItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSecurityGroupsSetType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSecurityGroupsSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeSecurityGroupsSetItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsSetType * SOAP_FMAC4 soap_in_ec2__DescribeSecurityGroupsSetType(struct soap *soap, const char *tag, struct ec2__DescribeSecurityGroupsSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSecurityGroupsSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsSetType, sizeof(struct ec2__DescribeSecurityGroupsSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSecurityGroupsSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeSecurityGroupsSetItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeSecurityGroupsSetItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeSecurityGroupsSetItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeSecurityGroupsSetItemType(soap, "ec2:item", a->item, "ec2:DescribeSecurityGroupsSetItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeSecurityGroupsSetItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSecurityGroupsSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSecurityGroupsSetType, 0, sizeof(struct ec2__DescribeSecurityGroupsSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSecurityGroupsSetType(struct soap *soap, const struct ec2__DescribeSecurityGroupsSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSecurityGroupsSetType);
    if (soap_out_ec2__DescribeSecurityGroupsSetType(soap, tag?tag:"ec2:DescribeSecurityGroupsSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsSetType * SOAP_FMAC4 soap_get_ec2__DescribeSecurityGroupsSetType(struct soap *soap, struct ec2__DescribeSecurityGroupsSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSecurityGroupsSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeSecurityGroupsType(struct soap *soap, struct ec2__DescribeSecurityGroupsType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->securityGroupSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeSecurityGroupsType(struct soap *soap, const struct ec2__DescribeSecurityGroupsType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeSecurityGroupsSetType(soap, &a->securityGroupSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeSecurityGroupsType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeSecurityGroupsType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeSecurityGroupsSetType(soap, "ec2:securityGroupSet", -1, &a->securityGroupSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsType * SOAP_FMAC4 soap_in_ec2__DescribeSecurityGroupsType(struct soap *soap, const char *tag, struct ec2__DescribeSecurityGroupsType *a, const char *type)
  {
    size_t soap_flag_securityGroupSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeSecurityGroupsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeSecurityGroupsType, sizeof(struct ec2__DescribeSecurityGroupsType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeSecurityGroupsType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_securityGroupSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeSecurityGroupsSetType(soap, "ec2:securityGroupSet", &a->securityGroupSet, "ec2:DescribeSecurityGroupsSetType"))
                {       soap_flag_securityGroupSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeSecurityGroupsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeSecurityGroupsType, 0, sizeof(struct ec2__DescribeSecurityGroupsType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_securityGroupSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeSecurityGroupsType(struct soap *soap, const struct ec2__DescribeSecurityGroupsType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeSecurityGroupsType);
    if (soap_out_ec2__DescribeSecurityGroupsType(soap, tag?tag:"ec2:DescribeSecurityGroupsType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeSecurityGroupsType * SOAP_FMAC4 soap_get_ec2__DescribeSecurityGroupsType(struct soap *soap, struct ec2__DescribeSecurityGroupsType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeSecurityGroupsType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DeleteSecurityGroupResponseType(struct soap *soap, struct ec2__DeleteSecurityGroupResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DeleteSecurityGroupResponseType(struct soap *soap, const struct ec2__DeleteSecurityGroupResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DeleteSecurityGroupResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DeleteSecurityGroupResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DeleteSecurityGroupResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DeleteSecurityGroupResponseType * SOAP_FMAC4 soap_in_ec2__DeleteSecurityGroupResponseType(struct soap *soap, const char *tag, struct ec2__DeleteSecurityGroupResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DeleteSecurityGroupResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DeleteSecurityGroupResponseType, sizeof(struct ec2__DeleteSecurityGroupResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DeleteSecurityGroupResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DeleteSecurityGroupResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DeleteSecurityGroupResponseType, 0, sizeof(struct ec2__DeleteSecurityGroupResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DeleteSecurityGroupResponseType(struct soap *soap, const struct ec2__DeleteSecurityGroupResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DeleteSecurityGroupResponseType);
    if (soap_out_ec2__DeleteSecurityGroupResponseType(soap, tag?tag:"ec2:DeleteSecurityGroupResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DeleteSecurityGroupResponseType * SOAP_FMAC4 soap_get_ec2__DeleteSecurityGroupResponseType(struct soap *soap, struct ec2__DeleteSecurityGroupResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DeleteSecurityGroupResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DeleteSecurityGroupType(struct soap *soap, struct ec2__DeleteSecurityGroupType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->groupName);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DeleteSecurityGroupType(struct soap *soap, const struct ec2__DeleteSecurityGroupType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->groupName);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DeleteSecurityGroupType(struct soap *soap, const char *tag, int id, const struct ec2__DeleteSecurityGroupType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DeleteSecurityGroupType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupName", -1, &a->groupName, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DeleteSecurityGroupType * SOAP_FMAC4 soap_in_ec2__DeleteSecurityGroupType(struct soap *soap, const char *tag, struct ec2__DeleteSecurityGroupType *a, const char *type)
  {
    size_t soap_flag_groupName = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DeleteSecurityGroupType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DeleteSecurityGroupType, sizeof(struct ec2__DeleteSecurityGroupType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DeleteSecurityGroupType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_groupName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupName", &a->groupName, "xsd:string"))
                {       soap_flag_groupName--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DeleteSecurityGroupType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DeleteSecurityGroupType, 0, sizeof(struct ec2__DeleteSecurityGroupType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_groupName > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DeleteSecurityGroupType(struct soap *soap, const struct ec2__DeleteSecurityGroupType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DeleteSecurityGroupType);
    if (soap_out_ec2__DeleteSecurityGroupType(soap, tag?tag:"ec2:DeleteSecurityGroupType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DeleteSecurityGroupType * SOAP_FMAC4 soap_get_ec2__DeleteSecurityGroupType(struct soap *soap, struct ec2__DeleteSecurityGroupType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DeleteSecurityGroupType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CreateSecurityGroupResponseType(struct soap *soap, struct ec2__CreateSecurityGroupResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CreateSecurityGroupResponseType(struct soap *soap, const struct ec2__CreateSecurityGroupResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CreateSecurityGroupResponseType(struct soap *soap, const char *tag, int id, const struct ec2__CreateSecurityGroupResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CreateSecurityGroupResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CreateSecurityGroupResponseType * SOAP_FMAC4 soap_in_ec2__CreateSecurityGroupResponseType(struct soap *soap, const char *tag, struct ec2__CreateSecurityGroupResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CreateSecurityGroupResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CreateSecurityGroupResponseType, sizeof(struct ec2__CreateSecurityGroupResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CreateSecurityGroupResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CreateSecurityGroupResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CreateSecurityGroupResponseType, 0, sizeof(struct ec2__CreateSecurityGroupResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CreateSecurityGroupResponseType(struct soap *soap, const struct ec2__CreateSecurityGroupResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CreateSecurityGroupResponseType);
    if (soap_out_ec2__CreateSecurityGroupResponseType(soap, tag?tag:"ec2:CreateSecurityGroupResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CreateSecurityGroupResponseType * SOAP_FMAC4 soap_get_ec2__CreateSecurityGroupResponseType(struct soap *soap, struct ec2__CreateSecurityGroupResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CreateSecurityGroupResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__CreateSecurityGroupType(struct soap *soap, struct ec2__CreateSecurityGroupType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->groupName);
    soap_default_string(soap, &a->groupDescription);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__CreateSecurityGroupType(struct soap *soap, const struct ec2__CreateSecurityGroupType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->groupName);
    soap_serialize_string(soap, &a->groupDescription);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__CreateSecurityGroupType(struct soap *soap, const char *tag, int id, const struct ec2__CreateSecurityGroupType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__CreateSecurityGroupType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupName", -1, &a->groupName, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:groupDescription", -1, &a->groupDescription, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__CreateSecurityGroupType * SOAP_FMAC4 soap_in_ec2__CreateSecurityGroupType(struct soap *soap, const char *tag, struct ec2__CreateSecurityGroupType *a, const char *type)
  {
    size_t soap_flag_groupName = 1;
    size_t soap_flag_groupDescription = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__CreateSecurityGroupType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__CreateSecurityGroupType, sizeof(struct ec2__CreateSecurityGroupType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__CreateSecurityGroupType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_groupName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupName", &a->groupName, "xsd:string"))
                {       soap_flag_groupName--;
                  continue;
                }
            if (soap_flag_groupDescription && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:groupDescription", &a->groupDescription, "xsd:string"))
                {       soap_flag_groupDescription--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__CreateSecurityGroupType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__CreateSecurityGroupType, 0, sizeof(struct ec2__CreateSecurityGroupType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_groupName > 0 || soap_flag_groupDescription > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__CreateSecurityGroupType(struct soap *soap, const struct ec2__CreateSecurityGroupType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__CreateSecurityGroupType);
    if (soap_out_ec2__CreateSecurityGroupType(soap, tag?tag:"ec2:CreateSecurityGroupType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__CreateSecurityGroupType * SOAP_FMAC4 soap_get_ec2__CreateSecurityGroupType(struct soap *soap, struct ec2__CreateSecurityGroupType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__CreateSecurityGroupType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesResponseItemType(struct soap *soap, struct ec2__DescribeImagesResponseItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->imageId);
    soap_default_string(soap, &a->imageLocation);
    soap_default_string(soap, &a->imageState);
    soap_default_string(soap, &a->imageOwnerId);
    soap_default_xsd__boolean_(soap, &a->isPublic);
    a->productCodes = NULL;
    soap_default_string(soap, &a->architecture);
    soap_default_string(soap, &a->imageType);
    soap_default_string(soap, &a->kernelId);
    soap_default_string(soap, &a->ramdiskId);
    soap_default_string(soap, &a->platform);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesResponseItemType(struct soap *soap, const struct ec2__DescribeImagesResponseItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->imageId);
    soap_serialize_string(soap, &a->imageLocation);
    soap_serialize_string(soap, &a->imageState);
    soap_serialize_string(soap, &a->imageOwnerId);
    soap_embedded(soap, &a->isPublic, SOAP_TYPE_xsd__boolean_);
    soap_serialize_PointerToec2__ProductCodesSetType(soap, &a->productCodes);
    soap_serialize_string(soap, &a->architecture);
    soap_serialize_string(soap, &a->imageType);
    soap_serialize_string(soap, &a->kernelId);
    soap_serialize_string(soap, &a->ramdiskId);
    soap_serialize_string(soap, &a->platform);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesResponseItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesResponseItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesResponseItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageId", -1, &a->imageId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageLocation", -1, &a->imageLocation, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageState", -1, &a->imageState, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageOwnerId", -1, &a->imageOwnerId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:isPublic", -1, &a->isPublic, ""))
      return soap->error;
    if (soap_out_PointerToec2__ProductCodesSetType(soap, "ec2:productCodes", -1, &a->productCodes, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:architecture", -1, &a->architecture, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageType", -1, &a->imageType, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:kernelId", -1, &a->kernelId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:ramdiskId", -1, &a->ramdiskId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:platform", -1, &a->platform, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesResponseItemType * SOAP_FMAC4 soap_in_ec2__DescribeImagesResponseItemType(struct soap *soap, const char *tag, struct ec2__DescribeImagesResponseItemType *a, const char *type)
  {
    size_t soap_flag_imageId = 1;
    size_t soap_flag_imageLocation = 1;
    size_t soap_flag_imageState = 1;
    size_t soap_flag_imageOwnerId = 1;
    size_t soap_flag_isPublic = 1;
    size_t soap_flag_productCodes = 1;
    size_t soap_flag_architecture = 1;
    size_t soap_flag_imageType = 1;
    size_t soap_flag_kernelId = 1;
    size_t soap_flag_ramdiskId = 1;
    size_t soap_flag_platform = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesResponseItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesResponseItemType, sizeof(struct ec2__DescribeImagesResponseItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesResponseItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_imageId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageId", &a->imageId, "xsd:string"))
                {       soap_flag_imageId--;
                  continue;
                }
            if (soap_flag_imageLocation && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageLocation", &a->imageLocation, "xsd:string"))
                {       soap_flag_imageLocation--;
                  continue;
                }
            if (soap_flag_imageState && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageState", &a->imageState, "xsd:string"))
                {       soap_flag_imageState--;
                  continue;
                }
            if (soap_flag_imageOwnerId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageOwnerId", &a->imageOwnerId, "xsd:string"))
                {       soap_flag_imageOwnerId--;
                  continue;
                }
            if (soap_flag_isPublic && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:isPublic", &a->isPublic, "xsd:boolean"))
                {       soap_flag_isPublic--;
                  continue;
                }
            if (soap_flag_productCodes && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__ProductCodesSetType(soap, "ec2:productCodes", &a->productCodes, "ec2:ProductCodesSetType"))
                {       soap_flag_productCodes--;
                  continue;
                }
            if (soap_flag_architecture && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:architecture", &a->architecture, "xsd:string"))
                {       soap_flag_architecture--;
                  continue;
                }
            if (soap_flag_imageType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageType", &a->imageType, "xsd:string"))
                {       soap_flag_imageType--;
                  continue;
                }
            if (soap_flag_kernelId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:kernelId", &a->kernelId, "xsd:string"))
                {       soap_flag_kernelId--;
                  continue;
                }
            if (soap_flag_ramdiskId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:ramdiskId", &a->ramdiskId, "xsd:string"))
                {       soap_flag_ramdiskId--;
                  continue;
                }
            if (soap_flag_platform && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:platform", &a->platform, "xsd:string"))
                {       soap_flag_platform--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesResponseItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesResponseItemType, 0, sizeof(struct ec2__DescribeImagesResponseItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_imageId > 0 || soap_flag_imageLocation > 0 || soap_flag_imageState > 0 || soap_flag_imageOwnerId > 0 || soap_flag_isPublic > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesResponseItemType(struct soap *soap, const struct ec2__DescribeImagesResponseItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesResponseItemType);
    if (soap_out_ec2__DescribeImagesResponseItemType(soap, tag?tag:"ec2:DescribeImagesResponseItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesResponseItemType * SOAP_FMAC4 soap_get_ec2__DescribeImagesResponseItemType(struct soap *soap, struct ec2__DescribeImagesResponseItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesResponseItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesResponseInfoType(struct soap *soap, struct ec2__DescribeImagesResponseInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesResponseInfoType(struct soap *soap, const struct ec2__DescribeImagesResponseInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeImagesResponseItemType);
            soap_serialize_ec2__DescribeImagesResponseItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesResponseInfoType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesResponseInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesResponseInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeImagesResponseItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesResponseInfoType * SOAP_FMAC4 soap_in_ec2__DescribeImagesResponseInfoType(struct soap *soap, const char *tag, struct ec2__DescribeImagesResponseInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesResponseInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesResponseInfoType, sizeof(struct ec2__DescribeImagesResponseInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesResponseInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeImagesResponseItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeImagesResponseItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeImagesResponseItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeImagesResponseItemType(soap, "ec2:item", a->item, "ec2:DescribeImagesResponseItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeImagesResponseItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesResponseInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesResponseInfoType, 0, sizeof(struct ec2__DescribeImagesResponseInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesResponseInfoType(struct soap *soap, const struct ec2__DescribeImagesResponseInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesResponseInfoType);
    if (soap_out_ec2__DescribeImagesResponseInfoType(soap, tag?tag:"ec2:DescribeImagesResponseInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesResponseInfoType * SOAP_FMAC4 soap_get_ec2__DescribeImagesResponseInfoType(struct soap *soap, struct ec2__DescribeImagesResponseInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesResponseInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesResponseType(struct soap *soap, struct ec2__DescribeImagesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->imagesSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesResponseType(struct soap *soap, const struct ec2__DescribeImagesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__DescribeImagesResponseInfoType(soap, &a->imagesSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__DescribeImagesResponseInfoType(soap, "ec2:imagesSet", -1, &a->imagesSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesResponseType * SOAP_FMAC4 soap_in_ec2__DescribeImagesResponseType(struct soap *soap, const char *tag, struct ec2__DescribeImagesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_imagesSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesResponseType, sizeof(struct ec2__DescribeImagesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_imagesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeImagesResponseInfoType(soap, "ec2:imagesSet", &a->imagesSet, "ec2:DescribeImagesResponseInfoType"))
                {       soap_flag_imagesSet--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesResponseType, 0, sizeof(struct ec2__DescribeImagesResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_imagesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesResponseType(struct soap *soap, const struct ec2__DescribeImagesResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesResponseType);
    if (soap_out_ec2__DescribeImagesResponseType(soap, tag?tag:"ec2:DescribeImagesResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesResponseType * SOAP_FMAC4 soap_get_ec2__DescribeImagesResponseType(struct soap *soap, struct ec2__DescribeImagesResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesExecutableByType(struct soap *soap, struct ec2__DescribeImagesExecutableByType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->user);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesExecutableByType(struct soap *soap, const struct ec2__DescribeImagesExecutableByType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->user);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesExecutableByType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesExecutableByType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesExecutableByType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:user", -1, &a->user, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesExecutableByType * SOAP_FMAC4 soap_in_ec2__DescribeImagesExecutableByType(struct soap *soap, const char *tag, struct ec2__DescribeImagesExecutableByType *a, const char *type)
  {
    size_t soap_flag_user = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesExecutableByType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesExecutableByType, sizeof(struct ec2__DescribeImagesExecutableByType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesExecutableByType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_user && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:user", &a->user, "xsd:string"))
                {       soap_flag_user--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesExecutableByType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesExecutableByType, 0, sizeof(struct ec2__DescribeImagesExecutableByType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_user > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesExecutableByType(struct soap *soap, const struct ec2__DescribeImagesExecutableByType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesExecutableByType);
    if (soap_out_ec2__DescribeImagesExecutableByType(soap, tag?tag:"ec2:DescribeImagesExecutableByType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesExecutableByType * SOAP_FMAC4 soap_get_ec2__DescribeImagesExecutableByType(struct soap *soap, struct ec2__DescribeImagesExecutableByType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesExecutableByType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesOwnerType(struct soap *soap, struct ec2__DescribeImagesOwnerType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->owner);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesOwnerType(struct soap *soap, const struct ec2__DescribeImagesOwnerType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->owner);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesOwnerType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesOwnerType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesOwnerType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:owner", -1, &a->owner, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesOwnerType * SOAP_FMAC4 soap_in_ec2__DescribeImagesOwnerType(struct soap *soap, const char *tag, struct ec2__DescribeImagesOwnerType *a, const char *type)
  {
    size_t soap_flag_owner = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesOwnerType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesOwnerType, sizeof(struct ec2__DescribeImagesOwnerType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesOwnerType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_owner && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:owner", &a->owner, "xsd:string"))
                {       soap_flag_owner--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesOwnerType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesOwnerType, 0, sizeof(struct ec2__DescribeImagesOwnerType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_owner > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesOwnerType(struct soap *soap, const struct ec2__DescribeImagesOwnerType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesOwnerType);
    if (soap_out_ec2__DescribeImagesOwnerType(soap, tag?tag:"ec2:DescribeImagesOwnerType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesOwnerType * SOAP_FMAC4 soap_get_ec2__DescribeImagesOwnerType(struct soap *soap, struct ec2__DescribeImagesOwnerType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesOwnerType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesItemType(struct soap *soap, struct ec2__DescribeImagesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->imageId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesItemType(struct soap *soap, const struct ec2__DescribeImagesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->imageId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageId", -1, &a->imageId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesItemType * SOAP_FMAC4 soap_in_ec2__DescribeImagesItemType(struct soap *soap, const char *tag, struct ec2__DescribeImagesItemType *a, const char *type)
  {
    size_t soap_flag_imageId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesItemType, sizeof(struct ec2__DescribeImagesItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_imageId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageId", &a->imageId, "xsd:string"))
                {       soap_flag_imageId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesItemType, 0, sizeof(struct ec2__DescribeImagesItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_imageId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesItemType(struct soap *soap, const struct ec2__DescribeImagesItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesItemType);
    if (soap_out_ec2__DescribeImagesItemType(soap, tag?tag:"ec2:DescribeImagesItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesItemType * SOAP_FMAC4 soap_get_ec2__DescribeImagesItemType(struct soap *soap, struct ec2__DescribeImagesItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesOwnersType(struct soap *soap, struct ec2__DescribeImagesOwnersType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesOwnersType(struct soap *soap, const struct ec2__DescribeImagesOwnersType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeImagesOwnerType);
            soap_serialize_ec2__DescribeImagesOwnerType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesOwnersType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesOwnersType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesOwnersType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeImagesOwnerType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesOwnersType * SOAP_FMAC4 soap_in_ec2__DescribeImagesOwnersType(struct soap *soap, const char *tag, struct ec2__DescribeImagesOwnersType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesOwnersType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesOwnersType, sizeof(struct ec2__DescribeImagesOwnersType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesOwnersType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeImagesOwnerType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeImagesOwnerType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeImagesOwnerType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeImagesOwnerType(soap, "ec2:item", a->item, "ec2:DescribeImagesOwnerType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeImagesOwnerType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesOwnersType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesOwnersType, 0, sizeof(struct ec2__DescribeImagesOwnersType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesOwnersType(struct soap *soap, const struct ec2__DescribeImagesOwnersType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesOwnersType);
    if (soap_out_ec2__DescribeImagesOwnersType(soap, tag?tag:"ec2:DescribeImagesOwnersType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesOwnersType * SOAP_FMAC4 soap_get_ec2__DescribeImagesOwnersType(struct soap *soap, struct ec2__DescribeImagesOwnersType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesOwnersType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesInfoType(struct soap *soap, struct ec2__DescribeImagesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesInfoType(struct soap *soap, const struct ec2__DescribeImagesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeImagesItemType);
            soap_serialize_ec2__DescribeImagesItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesInfoType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeImagesItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesInfoType * SOAP_FMAC4 soap_in_ec2__DescribeImagesInfoType(struct soap *soap, const char *tag, struct ec2__DescribeImagesInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesInfoType, sizeof(struct ec2__DescribeImagesInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeImagesItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeImagesItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeImagesItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeImagesItemType(soap, "ec2:item", a->item, "ec2:DescribeImagesItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeImagesItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesInfoType, 0, sizeof(struct ec2__DescribeImagesInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesInfoType(struct soap *soap, const struct ec2__DescribeImagesInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesInfoType);
    if (soap_out_ec2__DescribeImagesInfoType(soap, tag?tag:"ec2:DescribeImagesInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesInfoType * SOAP_FMAC4 soap_get_ec2__DescribeImagesInfoType(struct soap *soap, struct ec2__DescribeImagesInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesExecutableBySetType(struct soap *soap, struct ec2__DescribeImagesExecutableBySetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesExecutableBySetType(struct soap *soap, const struct ec2__DescribeImagesExecutableBySetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeImagesExecutableByType);
            soap_serialize_ec2__DescribeImagesExecutableByType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesExecutableBySetType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesExecutableBySetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesExecutableBySetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeImagesExecutableByType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesExecutableBySetType * SOAP_FMAC4 soap_in_ec2__DescribeImagesExecutableBySetType(struct soap *soap, const char *tag, struct ec2__DescribeImagesExecutableBySetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesExecutableBySetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesExecutableBySetType, sizeof(struct ec2__DescribeImagesExecutableBySetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesExecutableBySetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeImagesExecutableByType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeImagesExecutableByType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeImagesExecutableByType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeImagesExecutableByType(soap, "ec2:item", a->item, "ec2:DescribeImagesExecutableByType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeImagesExecutableByType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesExecutableBySetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesExecutableBySetType, 0, sizeof(struct ec2__DescribeImagesExecutableBySetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesExecutableBySetType(struct soap *soap, const struct ec2__DescribeImagesExecutableBySetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesExecutableBySetType);
    if (soap_out_ec2__DescribeImagesExecutableBySetType(soap, tag?tag:"ec2:DescribeImagesExecutableBySetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesExecutableBySetType * SOAP_FMAC4 soap_get_ec2__DescribeImagesExecutableBySetType(struct soap *soap, struct ec2__DescribeImagesExecutableBySetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesExecutableBySetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeImagesType(struct soap *soap, struct ec2__DescribeImagesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->executableBySet = NULL;
    a->imagesSet = NULL;
    a->ownersSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeImagesType(struct soap *soap, const struct ec2__DescribeImagesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeImagesExecutableBySetType(soap, &a->executableBySet);
    soap_serialize_PointerToec2__DescribeImagesInfoType(soap, &a->imagesSet);
    soap_serialize_PointerToec2__DescribeImagesOwnersType(soap, &a->ownersSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeImagesType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeImagesType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeImagesType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeImagesExecutableBySetType(soap, "ec2:executableBySet", -1, &a->executableBySet, ""))
      return soap->error;
    if (soap_out_PointerToec2__DescribeImagesInfoType(soap, "ec2:imagesSet", -1, &a->imagesSet, ""))
      return soap->error;
    if (soap_out_PointerToec2__DescribeImagesOwnersType(soap, "ec2:ownersSet", -1, &a->ownersSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesType * SOAP_FMAC4 soap_in_ec2__DescribeImagesType(struct soap *soap, const char *tag, struct ec2__DescribeImagesType *a, const char *type)
  {
    size_t soap_flag_executableBySet = 1;
    size_t soap_flag_imagesSet = 1;
    size_t soap_flag_ownersSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeImagesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeImagesType, sizeof(struct ec2__DescribeImagesType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeImagesType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_executableBySet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeImagesExecutableBySetType(soap, "ec2:executableBySet", &a->executableBySet, "ec2:DescribeImagesExecutableBySetType"))
                {       soap_flag_executableBySet--;
                  continue;
                }
            if (soap_flag_imagesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeImagesInfoType(soap, "ec2:imagesSet", &a->imagesSet, "ec2:DescribeImagesInfoType"))
                {       soap_flag_imagesSet--;
                  continue;
                }
            if (soap_flag_ownersSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeImagesOwnersType(soap, "ec2:ownersSet", &a->ownersSet, "ec2:DescribeImagesOwnersType"))
                {       soap_flag_ownersSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeImagesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeImagesType, 0, sizeof(struct ec2__DescribeImagesType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_imagesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeImagesType(struct soap *soap, const struct ec2__DescribeImagesType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeImagesType);
    if (soap_out_ec2__DescribeImagesType(soap, tag?tag:"ec2:DescribeImagesType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeImagesType * SOAP_FMAC4 soap_get_ec2__DescribeImagesType(struct soap *soap, struct ec2__DescribeImagesType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeImagesType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ReservationSetType(struct soap *soap, struct ec2__ReservationSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ReservationSetType(struct soap *soap, const struct ec2__ReservationSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__ReservationInfoType);
            soap_serialize_ec2__ReservationInfoType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ReservationSetType(struct soap *soap, const char *tag, int id, const struct ec2__ReservationSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ReservationSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__ReservationInfoType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ReservationSetType * SOAP_FMAC4 soap_in_ec2__ReservationSetType(struct soap *soap, const char *tag, struct ec2__ReservationSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ReservationSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ReservationSetType, sizeof(struct ec2__ReservationSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ReservationSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__ReservationInfoType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__ReservationInfoType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__ReservationInfoType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__ReservationInfoType(soap, "ec2:item", a->item, "ec2:ReservationInfoType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__ReservationInfoType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ReservationSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ReservationSetType, 0, sizeof(struct ec2__ReservationSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ReservationSetType(struct soap *soap, const struct ec2__ReservationSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ReservationSetType);
    if (soap_out_ec2__ReservationSetType(soap, tag?tag:"ec2:ReservationSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ReservationSetType * SOAP_FMAC4 soap_get_ec2__ReservationSetType(struct soap *soap, struct ec2__ReservationSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ReservationSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeInstancesResponseType(struct soap *soap, struct ec2__DescribeInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->reservationSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeInstancesResponseType(struct soap *soap, const struct ec2__DescribeInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__ReservationSetType(soap, &a->reservationSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeInstancesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeInstancesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeInstancesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__ReservationSetType(soap, "ec2:reservationSet", -1, &a->reservationSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesResponseType * SOAP_FMAC4 soap_in_ec2__DescribeInstancesResponseType(struct soap *soap, const char *tag, struct ec2__DescribeInstancesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_reservationSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeInstancesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeInstancesResponseType, sizeof(struct ec2__DescribeInstancesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeInstancesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_reservationSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__ReservationSetType(soap, "ec2:reservationSet", &a->reservationSet, "ec2:ReservationSetType"))
                {       soap_flag_reservationSet--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeInstancesResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeInstancesResponseType, 0, sizeof(struct ec2__DescribeInstancesResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_reservationSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeInstancesResponseType(struct soap *soap, const struct ec2__DescribeInstancesResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeInstancesResponseType);
    if (soap_out_ec2__DescribeInstancesResponseType(soap, tag?tag:"ec2:DescribeInstancesResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesResponseType * SOAP_FMAC4 soap_get_ec2__DescribeInstancesResponseType(struct soap *soap, struct ec2__DescribeInstancesResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeInstancesResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeInstancesItemType(struct soap *soap, struct ec2__DescribeInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeInstancesItemType(struct soap *soap, const struct ec2__DescribeInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeInstancesItemType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeInstancesItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeInstancesItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesItemType * SOAP_FMAC4 soap_in_ec2__DescribeInstancesItemType(struct soap *soap, const char *tag, struct ec2__DescribeInstancesItemType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeInstancesItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeInstancesItemType, sizeof(struct ec2__DescribeInstancesItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeInstancesItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeInstancesItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeInstancesItemType, 0, sizeof(struct ec2__DescribeInstancesItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeInstancesItemType(struct soap *soap, const struct ec2__DescribeInstancesItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeInstancesItemType);
    if (soap_out_ec2__DescribeInstancesItemType(soap, tag?tag:"ec2:DescribeInstancesItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesItemType * SOAP_FMAC4 soap_get_ec2__DescribeInstancesItemType(struct soap *soap, struct ec2__DescribeInstancesItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeInstancesItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeInstancesInfoType(struct soap *soap, struct ec2__DescribeInstancesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeInstancesInfoType(struct soap *soap, const struct ec2__DescribeInstancesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__DescribeInstancesItemType);
            soap_serialize_ec2__DescribeInstancesItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeInstancesInfoType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeInstancesInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeInstancesInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__DescribeInstancesItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesInfoType * SOAP_FMAC4 soap_in_ec2__DescribeInstancesInfoType(struct soap *soap, const char *tag, struct ec2__DescribeInstancesInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeInstancesInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeInstancesInfoType, sizeof(struct ec2__DescribeInstancesInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeInstancesInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__DescribeInstancesItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__DescribeInstancesItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__DescribeInstancesItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__DescribeInstancesItemType(soap, "ec2:item", a->item, "ec2:DescribeInstancesItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__DescribeInstancesItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeInstancesInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeInstancesInfoType, 0, sizeof(struct ec2__DescribeInstancesInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeInstancesInfoType(struct soap *soap, const struct ec2__DescribeInstancesInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeInstancesInfoType);
    if (soap_out_ec2__DescribeInstancesInfoType(soap, tag?tag:"ec2:DescribeInstancesInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesInfoType * SOAP_FMAC4 soap_get_ec2__DescribeInstancesInfoType(struct soap *soap, struct ec2__DescribeInstancesInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeInstancesInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__DescribeInstancesType(struct soap *soap, struct ec2__DescribeInstancesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->instancesSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__DescribeInstancesType(struct soap *soap, const struct ec2__DescribeInstancesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__DescribeInstancesInfoType(soap, &a->instancesSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__DescribeInstancesType(struct soap *soap, const char *tag, int id, const struct ec2__DescribeInstancesType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__DescribeInstancesType), type))
      return soap->error;
    if (soap_out_PointerToec2__DescribeInstancesInfoType(soap, "ec2:instancesSet", -1, &a->instancesSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesType * SOAP_FMAC4 soap_in_ec2__DescribeInstancesType(struct soap *soap, const char *tag, struct ec2__DescribeInstancesType *a, const char *type)
  {
    size_t soap_flag_instancesSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__DescribeInstancesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__DescribeInstancesType, sizeof(struct ec2__DescribeInstancesType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__DescribeInstancesType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instancesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__DescribeInstancesInfoType(soap, "ec2:instancesSet", &a->instancesSet, "ec2:DescribeInstancesInfoType"))
                {       soap_flag_instancesSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__DescribeInstancesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__DescribeInstancesType, 0, sizeof(struct ec2__DescribeInstancesType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instancesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__DescribeInstancesType(struct soap *soap, const struct ec2__DescribeInstancesType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__DescribeInstancesType);
    if (soap_out_ec2__DescribeInstancesType(soap, tag?tag:"ec2:DescribeInstancesType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__DescribeInstancesType * SOAP_FMAC4 soap_get_ec2__DescribeInstancesType(struct soap *soap, struct ec2__DescribeInstancesType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__DescribeInstancesType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RebootInstancesResponseType(struct soap *soap, struct ec2__RebootInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_xsd__boolean_(soap, &a->return_);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RebootInstancesResponseType(struct soap *soap, const struct ec2__RebootInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_embedded(soap, &a->return_, SOAP_TYPE_xsd__boolean_);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RebootInstancesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__RebootInstancesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RebootInstancesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_xsd__boolean_(soap, "ec2:return", -1, &a->return_, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesResponseType * SOAP_FMAC4 soap_in_ec2__RebootInstancesResponseType(struct soap *soap, const char *tag, struct ec2__RebootInstancesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_return_ = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RebootInstancesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RebootInstancesResponseType, sizeof(struct ec2__RebootInstancesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RebootInstancesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_return_ && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_xsd__boolean_(soap, "ec2:return", &a->return_, "xsd:boolean"))
                {       soap_flag_return_--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RebootInstancesResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RebootInstancesResponseType, 0, sizeof(struct ec2__RebootInstancesResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_return_ > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RebootInstancesResponseType(struct soap *soap, const struct ec2__RebootInstancesResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RebootInstancesResponseType);
    if (soap_out_ec2__RebootInstancesResponseType(soap, tag?tag:"ec2:RebootInstancesResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesResponseType * SOAP_FMAC4 soap_get_ec2__RebootInstancesResponseType(struct soap *soap, struct ec2__RebootInstancesResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RebootInstancesResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RebootInstancesItemType(struct soap *soap, struct ec2__RebootInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RebootInstancesItemType(struct soap *soap, const struct ec2__RebootInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RebootInstancesItemType(struct soap *soap, const char *tag, int id, const struct ec2__RebootInstancesItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RebootInstancesItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesItemType * SOAP_FMAC4 soap_in_ec2__RebootInstancesItemType(struct soap *soap, const char *tag, struct ec2__RebootInstancesItemType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RebootInstancesItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RebootInstancesItemType, sizeof(struct ec2__RebootInstancesItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RebootInstancesItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RebootInstancesItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RebootInstancesItemType, 0, sizeof(struct ec2__RebootInstancesItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RebootInstancesItemType(struct soap *soap, const struct ec2__RebootInstancesItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RebootInstancesItemType);
    if (soap_out_ec2__RebootInstancesItemType(soap, tag?tag:"ec2:RebootInstancesItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesItemType * SOAP_FMAC4 soap_get_ec2__RebootInstancesItemType(struct soap *soap, struct ec2__RebootInstancesItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RebootInstancesItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RebootInstancesInfoType(struct soap *soap, struct ec2__RebootInstancesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RebootInstancesInfoType(struct soap *soap, const struct ec2__RebootInstancesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__RebootInstancesItemType);
            soap_serialize_ec2__RebootInstancesItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RebootInstancesInfoType(struct soap *soap, const char *tag, int id, const struct ec2__RebootInstancesInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RebootInstancesInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__RebootInstancesItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesInfoType * SOAP_FMAC4 soap_in_ec2__RebootInstancesInfoType(struct soap *soap, const char *tag, struct ec2__RebootInstancesInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RebootInstancesInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RebootInstancesInfoType, sizeof(struct ec2__RebootInstancesInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RebootInstancesInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__RebootInstancesItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__RebootInstancesItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__RebootInstancesItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__RebootInstancesItemType(soap, "ec2:item", a->item, "ec2:RebootInstancesItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__RebootInstancesItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RebootInstancesInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RebootInstancesInfoType, 0, sizeof(struct ec2__RebootInstancesInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (a->__sizeitem < 1))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RebootInstancesInfoType(struct soap *soap, const struct ec2__RebootInstancesInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RebootInstancesInfoType);
    if (soap_out_ec2__RebootInstancesInfoType(soap, tag?tag:"ec2:RebootInstancesInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesInfoType * SOAP_FMAC4 soap_get_ec2__RebootInstancesInfoType(struct soap *soap, struct ec2__RebootInstancesInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RebootInstancesInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RebootInstancesType(struct soap *soap, struct ec2__RebootInstancesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->instancesSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RebootInstancesType(struct soap *soap, const struct ec2__RebootInstancesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__RebootInstancesInfoType(soap, &a->instancesSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RebootInstancesType(struct soap *soap, const char *tag, int id, const struct ec2__RebootInstancesType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RebootInstancesType), type))
      return soap->error;
    if (soap_out_PointerToec2__RebootInstancesInfoType(soap, "ec2:instancesSet", -1, &a->instancesSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesType * SOAP_FMAC4 soap_in_ec2__RebootInstancesType(struct soap *soap, const char *tag, struct ec2__RebootInstancesType *a, const char *type)
  {
    size_t soap_flag_instancesSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RebootInstancesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RebootInstancesType, sizeof(struct ec2__RebootInstancesType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RebootInstancesType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instancesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__RebootInstancesInfoType(soap, "ec2:instancesSet", &a->instancesSet, "ec2:RebootInstancesInfoType"))
                {       soap_flag_instancesSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RebootInstancesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RebootInstancesType, 0, sizeof(struct ec2__RebootInstancesType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instancesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RebootInstancesType(struct soap *soap, const struct ec2__RebootInstancesType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RebootInstancesType);
    if (soap_out_ec2__RebootInstancesType(soap, tag?tag:"ec2:RebootInstancesType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RebootInstancesType * SOAP_FMAC4 soap_get_ec2__RebootInstancesType(struct soap *soap, struct ec2__RebootInstancesType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RebootInstancesType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__TerminateInstancesResponseItemType(struct soap *soap, struct ec2__TerminateInstancesResponseItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
    a->shutdownState = NULL;
    a->previousState = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__TerminateInstancesResponseItemType(struct soap *soap, const struct ec2__TerminateInstancesResponseItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_PointerToec2__InstanceStateType(soap, &a->shutdownState);
    soap_serialize_PointerToec2__InstanceStateType(soap, &a->previousState);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__TerminateInstancesResponseItemType(struct soap *soap, const char *tag, int id, const struct ec2__TerminateInstancesResponseItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__TerminateInstancesResponseItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_PointerToec2__InstanceStateType(soap, "ec2:shutdownState", -1, &a->shutdownState, ""))
      return soap->error;
    if (soap_out_PointerToec2__InstanceStateType(soap, "ec2:previousState", -1, &a->previousState, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesResponseItemType * SOAP_FMAC4 soap_in_ec2__TerminateInstancesResponseItemType(struct soap *soap, const char *tag, struct ec2__TerminateInstancesResponseItemType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_shutdownState = 1;
    size_t soap_flag_previousState = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__TerminateInstancesResponseItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__TerminateInstancesResponseItemType, sizeof(struct ec2__TerminateInstancesResponseItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__TerminateInstancesResponseItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_shutdownState && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__InstanceStateType(soap, "ec2:shutdownState", &a->shutdownState, "ec2:InstanceStateType"))
                {       soap_flag_shutdownState--;
                  continue;
                }
            if (soap_flag_previousState && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__InstanceStateType(soap, "ec2:previousState", &a->previousState, "ec2:InstanceStateType"))
                {       soap_flag_previousState--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__TerminateInstancesResponseItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__TerminateInstancesResponseItemType, 0, sizeof(struct ec2__TerminateInstancesResponseItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0 || soap_flag_shutdownState > 0 || soap_flag_previousState > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__TerminateInstancesResponseItemType(struct soap *soap, const struct ec2__TerminateInstancesResponseItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__TerminateInstancesResponseItemType);
    if (soap_out_ec2__TerminateInstancesResponseItemType(soap, tag?tag:"ec2:TerminateInstancesResponseItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesResponseItemType * SOAP_FMAC4 soap_get_ec2__TerminateInstancesResponseItemType(struct soap *soap, struct ec2__TerminateInstancesResponseItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__TerminateInstancesResponseItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__TerminateInstancesResponseInfoType(struct soap *soap, struct ec2__TerminateInstancesResponseInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__TerminateInstancesResponseInfoType(struct soap *soap, const struct ec2__TerminateInstancesResponseInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__TerminateInstancesResponseItemType);
            soap_serialize_ec2__TerminateInstancesResponseItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__TerminateInstancesResponseInfoType(struct soap *soap, const char *tag, int id, const struct ec2__TerminateInstancesResponseInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__TerminateInstancesResponseInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__TerminateInstancesResponseItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesResponseInfoType * SOAP_FMAC4 soap_in_ec2__TerminateInstancesResponseInfoType(struct soap *soap, const char *tag, struct ec2__TerminateInstancesResponseInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__TerminateInstancesResponseInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__TerminateInstancesResponseInfoType, sizeof(struct ec2__TerminateInstancesResponseInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__TerminateInstancesResponseInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__TerminateInstancesResponseItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__TerminateInstancesResponseItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__TerminateInstancesResponseItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__TerminateInstancesResponseItemType(soap, "ec2:item", a->item, "ec2:TerminateInstancesResponseItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__TerminateInstancesResponseItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__TerminateInstancesResponseInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__TerminateInstancesResponseInfoType, 0, sizeof(struct ec2__TerminateInstancesResponseInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__TerminateInstancesResponseInfoType(struct soap *soap, const struct ec2__TerminateInstancesResponseInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__TerminateInstancesResponseInfoType);
    if (soap_out_ec2__TerminateInstancesResponseInfoType(soap, tag?tag:"ec2:TerminateInstancesResponseInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesResponseInfoType * SOAP_FMAC4 soap_get_ec2__TerminateInstancesResponseInfoType(struct soap *soap, struct ec2__TerminateInstancesResponseInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__TerminateInstancesResponseInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__TerminateInstancesResponseType(struct soap *soap, struct ec2__TerminateInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    a->instancesSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__TerminateInstancesResponseType(struct soap *soap, const struct ec2__TerminateInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_PointerToec2__TerminateInstancesResponseInfoType(soap, &a->instancesSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__TerminateInstancesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__TerminateInstancesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__TerminateInstancesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_PointerToec2__TerminateInstancesResponseInfoType(soap, "ec2:instancesSet", -1, &a->instancesSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesResponseType * SOAP_FMAC4 soap_in_ec2__TerminateInstancesResponseType(struct soap *soap, const char *tag, struct ec2__TerminateInstancesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_instancesSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__TerminateInstancesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__TerminateInstancesResponseType, sizeof(struct ec2__TerminateInstancesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__TerminateInstancesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_instancesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__TerminateInstancesResponseInfoType(soap, "ec2:instancesSet", &a->instancesSet, "ec2:TerminateInstancesResponseInfoType"))
                {       soap_flag_instancesSet--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__TerminateInstancesResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__TerminateInstancesResponseType, 0, sizeof(struct ec2__TerminateInstancesResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_instancesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__TerminateInstancesResponseType(struct soap *soap, const struct ec2__TerminateInstancesResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__TerminateInstancesResponseType);
    if (soap_out_ec2__TerminateInstancesResponseType(soap, tag?tag:"ec2:TerminateInstancesResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesResponseType * SOAP_FMAC4 soap_get_ec2__TerminateInstancesResponseType(struct soap *soap, struct ec2__TerminateInstancesResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__TerminateInstancesResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__TerminateInstancesItemType(struct soap *soap, struct ec2__TerminateInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__TerminateInstancesItemType(struct soap *soap, const struct ec2__TerminateInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__TerminateInstancesItemType(struct soap *soap, const char *tag, int id, const struct ec2__TerminateInstancesItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__TerminateInstancesItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesItemType * SOAP_FMAC4 soap_in_ec2__TerminateInstancesItemType(struct soap *soap, const char *tag, struct ec2__TerminateInstancesItemType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__TerminateInstancesItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__TerminateInstancesItemType, sizeof(struct ec2__TerminateInstancesItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__TerminateInstancesItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__TerminateInstancesItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__TerminateInstancesItemType, 0, sizeof(struct ec2__TerminateInstancesItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__TerminateInstancesItemType(struct soap *soap, const struct ec2__TerminateInstancesItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__TerminateInstancesItemType);
    if (soap_out_ec2__TerminateInstancesItemType(soap, tag?tag:"ec2:TerminateInstancesItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesItemType * SOAP_FMAC4 soap_get_ec2__TerminateInstancesItemType(struct soap *soap, struct ec2__TerminateInstancesItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__TerminateInstancesItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__TerminateInstancesInfoType(struct soap *soap, struct ec2__TerminateInstancesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__TerminateInstancesInfoType(struct soap *soap, const struct ec2__TerminateInstancesInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__TerminateInstancesItemType);
            soap_serialize_ec2__TerminateInstancesItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__TerminateInstancesInfoType(struct soap *soap, const char *tag, int id, const struct ec2__TerminateInstancesInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__TerminateInstancesInfoType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__TerminateInstancesItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesInfoType * SOAP_FMAC4 soap_in_ec2__TerminateInstancesInfoType(struct soap *soap, const char *tag, struct ec2__TerminateInstancesInfoType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__TerminateInstancesInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__TerminateInstancesInfoType, sizeof(struct ec2__TerminateInstancesInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__TerminateInstancesInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__TerminateInstancesItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__TerminateInstancesItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__TerminateInstancesItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__TerminateInstancesItemType(soap, "ec2:item", a->item, "ec2:TerminateInstancesItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__TerminateInstancesItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__TerminateInstancesInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__TerminateInstancesInfoType, 0, sizeof(struct ec2__TerminateInstancesInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (a->__sizeitem < 1))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__TerminateInstancesInfoType(struct soap *soap, const struct ec2__TerminateInstancesInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__TerminateInstancesInfoType);
    if (soap_out_ec2__TerminateInstancesInfoType(soap, tag?tag:"ec2:TerminateInstancesInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesInfoType * SOAP_FMAC4 soap_get_ec2__TerminateInstancesInfoType(struct soap *soap, struct ec2__TerminateInstancesInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__TerminateInstancesInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__TerminateInstancesType(struct soap *soap, struct ec2__TerminateInstancesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->instancesSet = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__TerminateInstancesType(struct soap *soap, const struct ec2__TerminateInstancesType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_PointerToec2__TerminateInstancesInfoType(soap, &a->instancesSet);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__TerminateInstancesType(struct soap *soap, const char *tag, int id, const struct ec2__TerminateInstancesType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__TerminateInstancesType), type))
      return soap->error;
    if (soap_out_PointerToec2__TerminateInstancesInfoType(soap, "ec2:instancesSet", -1, &a->instancesSet, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesType * SOAP_FMAC4 soap_in_ec2__TerminateInstancesType(struct soap *soap, const char *tag, struct ec2__TerminateInstancesType *a, const char *type)
  {
    size_t soap_flag_instancesSet = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__TerminateInstancesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__TerminateInstancesType, sizeof(struct ec2__TerminateInstancesType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__TerminateInstancesType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instancesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__TerminateInstancesInfoType(soap, "ec2:instancesSet", &a->instancesSet, "ec2:TerminateInstancesInfoType"))
                {       soap_flag_instancesSet--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__TerminateInstancesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__TerminateInstancesType, 0, sizeof(struct ec2__TerminateInstancesType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instancesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__TerminateInstancesType(struct soap *soap, const struct ec2__TerminateInstancesType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__TerminateInstancesType);
    if (soap_out_ec2__TerminateInstancesType(soap, tag?tag:"ec2:TerminateInstancesType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__TerminateInstancesType * SOAP_FMAC4 soap_get_ec2__TerminateInstancesType(struct soap *soap, struct ec2__TerminateInstancesType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__TerminateInstancesType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__GetConsoleOutputResponseType(struct soap *soap, struct ec2__GetConsoleOutputResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->instanceId);
    soap_default_time(soap, &a->timestamp);
    soap_default_string(soap, &a->output);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__GetConsoleOutputResponseType(struct soap *soap, const struct ec2__GetConsoleOutputResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->output);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__GetConsoleOutputResponseType(struct soap *soap, const char *tag, int id, const struct ec2__GetConsoleOutputResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__GetConsoleOutputResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:timestamp", -1, &a->timestamp, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:output", -1, &a->output, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__GetConsoleOutputResponseType * SOAP_FMAC4 soap_in_ec2__GetConsoleOutputResponseType(struct soap *soap, const char *tag, struct ec2__GetConsoleOutputResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_timestamp = 1;
    size_t soap_flag_output = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__GetConsoleOutputResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__GetConsoleOutputResponseType, sizeof(struct ec2__GetConsoleOutputResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__GetConsoleOutputResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:timestamp", &a->timestamp, "xsd:dateTime"))
                {       soap_flag_timestamp--;
                  continue;
                }
            if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:output", &a->output, "xsd:string"))
                {       soap_flag_output--;
                  continue;
                }
            soap_check_result(soap, "ec2:requestId");
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__GetConsoleOutputResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__GetConsoleOutputResponseType, 0, sizeof(struct ec2__GetConsoleOutputResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId > 0 || soap_flag_instanceId > 0 || soap_flag_timestamp > 0 || soap_flag_output > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__GetConsoleOutputResponseType(struct soap *soap, const struct ec2__GetConsoleOutputResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__GetConsoleOutputResponseType);
    if (soap_out_ec2__GetConsoleOutputResponseType(soap, tag?tag:"ec2:GetConsoleOutputResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__GetConsoleOutputResponseType * SOAP_FMAC4 soap_get_ec2__GetConsoleOutputResponseType(struct soap *soap, struct ec2__GetConsoleOutputResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__GetConsoleOutputResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__GetConsoleOutputType(struct soap *soap, struct ec2__GetConsoleOutputType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__GetConsoleOutputType(struct soap *soap, const struct ec2__GetConsoleOutputType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__GetConsoleOutputType(struct soap *soap, const char *tag, int id, const struct ec2__GetConsoleOutputType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__GetConsoleOutputType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__GetConsoleOutputType * SOAP_FMAC4 soap_in_ec2__GetConsoleOutputType(struct soap *soap, const char *tag, struct ec2__GetConsoleOutputType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__GetConsoleOutputType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__GetConsoleOutputType, sizeof(struct ec2__GetConsoleOutputType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__GetConsoleOutputType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__GetConsoleOutputType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__GetConsoleOutputType, 0, sizeof(struct ec2__GetConsoleOutputType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__GetConsoleOutputType(struct soap *soap, const struct ec2__GetConsoleOutputType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__GetConsoleOutputType);
    if (soap_out_ec2__GetConsoleOutputType(soap, tag?tag:"ec2:GetConsoleOutputType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__GetConsoleOutputType * SOAP_FMAC4 soap_get_ec2__GetConsoleOutputType(struct soap *soap, struct ec2__GetConsoleOutputType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__GetConsoleOutputType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__PlacementResponseType(struct soap *soap, struct ec2__PlacementResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->availabilityZone);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__PlacementResponseType(struct soap *soap, const struct ec2__PlacementResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->availabilityZone);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__PlacementResponseType(struct soap *soap, const char *tag, int id, const struct ec2__PlacementResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__PlacementResponseType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:availabilityZone", -1, &a->availabilityZone, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__PlacementResponseType * SOAP_FMAC4 soap_in_ec2__PlacementResponseType(struct soap *soap, const char *tag, struct ec2__PlacementResponseType *a, const char *type)
  {
    size_t soap_flag_availabilityZone = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__PlacementResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__PlacementResponseType, sizeof(struct ec2__PlacementResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__PlacementResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_availabilityZone && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:availabilityZone", &a->availabilityZone, "xsd:string"))
                {       soap_flag_availabilityZone--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__PlacementResponseType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__PlacementResponseType, 0, sizeof(struct ec2__PlacementResponseType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_availabilityZone > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__PlacementResponseType(struct soap *soap, const struct ec2__PlacementResponseType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__PlacementResponseType);
    if (soap_out_ec2__PlacementResponseType(soap, tag?tag:"ec2:PlacementResponseType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__PlacementResponseType * SOAP_FMAC4 soap_get_ec2__PlacementResponseType(struct soap *soap, struct ec2__PlacementResponseType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__PlacementResponseType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ProductCodesSetType(struct soap *soap, struct ec2__ProductCodesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ProductCodesSetType(struct soap *soap, const struct ec2__ProductCodesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__ProductCodesSetItemType);
            soap_serialize_ec2__ProductCodesSetItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ProductCodesSetType(struct soap *soap, const char *tag, int id, const struct ec2__ProductCodesSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ProductCodesSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__ProductCodesSetItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ProductCodesSetType * SOAP_FMAC4 soap_in_ec2__ProductCodesSetType(struct soap *soap, const char *tag, struct ec2__ProductCodesSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ProductCodesSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ProductCodesSetType, sizeof(struct ec2__ProductCodesSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ProductCodesSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__ProductCodesSetItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__ProductCodesSetItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__ProductCodesSetItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__ProductCodesSetItemType(soap, "ec2:item", a->item, "ec2:ProductCodesSetItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__ProductCodesSetItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ProductCodesSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ProductCodesSetType, 0, sizeof(struct ec2__ProductCodesSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ProductCodesSetType(struct soap *soap, const struct ec2__ProductCodesSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ProductCodesSetType);
    if (soap_out_ec2__ProductCodesSetType(soap, tag?tag:"ec2:ProductCodesSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ProductCodesSetType * SOAP_FMAC4 soap_get_ec2__ProductCodesSetType(struct soap *soap, struct ec2__ProductCodesSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ProductCodesSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__InstanceStateType(struct soap *soap, struct ec2__InstanceStateType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_int(soap, &a->code);
    soap_default_string(soap, &a->name);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__InstanceStateType(struct soap *soap, const struct ec2__InstanceStateType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_embedded(soap, &a->code, SOAP_TYPE_int);
    soap_serialize_string(soap, &a->name);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__InstanceStateType(struct soap *soap, const char *tag, int id, const struct ec2__InstanceStateType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__InstanceStateType), type))
      return soap->error;
    if (soap_out_int(soap, "ec2:code", -1, &a->code, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:name", -1, &a->name, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__InstanceStateType * SOAP_FMAC4 soap_in_ec2__InstanceStateType(struct soap *soap, const char *tag, struct ec2__InstanceStateType *a, const char *type)
  {
    size_t soap_flag_code = 1;
    size_t soap_flag_name = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__InstanceStateType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__InstanceStateType, sizeof(struct ec2__InstanceStateType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__InstanceStateType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_code && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_int(soap, "ec2:code", &a->code, "xsd:int"))
                {       soap_flag_code--;
                  continue;
                }
            if (soap_flag_name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:name", &a->name, "xsd:string"))
                {       soap_flag_name--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__InstanceStateType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__InstanceStateType, 0, sizeof(struct ec2__InstanceStateType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_code > 0 || soap_flag_name > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__InstanceStateType(struct soap *soap, const struct ec2__InstanceStateType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__InstanceStateType);
    if (soap_out_ec2__InstanceStateType(soap, tag?tag:"ec2:InstanceStateType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__InstanceStateType * SOAP_FMAC4 soap_get_ec2__InstanceStateType(struct soap *soap, struct ec2__InstanceStateType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__InstanceStateType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RunningInstancesItemType(struct soap *soap, struct ec2__RunningInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->instanceId);
    soap_default_string(soap, &a->imageId);
    a->instanceState = NULL;
    soap_default_string(soap, &a->privateDnsName);
    soap_default_string(soap, &a->dnsName);
    soap_default_string(soap, &a->reason);
    soap_default_string(soap, &a->keyName);
    soap_default_string(soap, &a->amiLaunchIndex);
    a->productCodes = NULL;
    soap_default_string(soap, &a->instanceType);
    soap_default_time(soap, &a->launchTime);
    a->placement = NULL;
    soap_default_string(soap, &a->kernelId);
    soap_default_string(soap, &a->ramdiskId);
    soap_default_string(soap, &a->platform);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RunningInstancesItemType(struct soap *soap, const struct ec2__RunningInstancesItemType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->instanceId);
    soap_serialize_string(soap, &a->imageId);
    soap_serialize_PointerToec2__InstanceStateType(soap, &a->instanceState);
    soap_serialize_string(soap, &a->privateDnsName);
    soap_serialize_string(soap, &a->dnsName);
    soap_serialize_string(soap, &a->reason);
    soap_serialize_string(soap, &a->keyName);
    soap_serialize_string(soap, &a->amiLaunchIndex);
    soap_serialize_PointerToec2__ProductCodesSetType(soap, &a->productCodes);
    soap_serialize_string(soap, &a->instanceType);
    soap_serialize_PointerToec2__PlacementResponseType(soap, &a->placement);
    soap_serialize_string(soap, &a->kernelId);
    soap_serialize_string(soap, &a->ramdiskId);
    soap_serialize_string(soap, &a->platform);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RunningInstancesItemType(struct soap *soap, const char *tag, int id, const struct ec2__RunningInstancesItemType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RunningInstancesItemType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceId", -1, &a->instanceId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:imageId", -1, &a->imageId, ""))
      return soap->error;
    if (soap_out_PointerToec2__InstanceStateType(soap, "ec2:instanceState", -1, &a->instanceState, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:privateDnsName", -1, &a->privateDnsName, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:dnsName", -1, &a->dnsName, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:reason", -1, &a->reason, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:keyName", -1, &a->keyName, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:amiLaunchIndex", -1, &a->amiLaunchIndex, ""))
      return soap->error;
    if (soap_out_PointerToec2__ProductCodesSetType(soap, "ec2:productCodes", -1, &a->productCodes, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:instanceType", -1, &a->instanceType, ""))
      return soap->error;
    if (soap_out_time(soap, "ec2:launchTime", -1, &a->launchTime, ""))
      return soap->error;
    if (soap_out_PointerToec2__PlacementResponseType(soap, "ec2:placement", -1, &a->placement, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:kernelId", -1, &a->kernelId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:ramdiskId", -1, &a->ramdiskId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:platform", -1, &a->platform, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RunningInstancesItemType * SOAP_FMAC4 soap_in_ec2__RunningInstancesItemType(struct soap *soap, const char *tag, struct ec2__RunningInstancesItemType *a, const char *type)
  {
    size_t soap_flag_instanceId = 1;
    size_t soap_flag_imageId = 1;
    size_t soap_flag_instanceState = 1;
    size_t soap_flag_privateDnsName = 1;
    size_t soap_flag_dnsName = 1;
    size_t soap_flag_reason = 1;
    size_t soap_flag_keyName = 1;
    size_t soap_flag_amiLaunchIndex = 1;
    size_t soap_flag_productCodes = 1;
    size_t soap_flag_instanceType = 1;
    size_t soap_flag_launchTime = 1;
    size_t soap_flag_placement = 1;
    size_t soap_flag_kernelId = 1;
    size_t soap_flag_ramdiskId = 1;
    size_t soap_flag_platform = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RunningInstancesItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RunningInstancesItemType, sizeof(struct ec2__RunningInstancesItemType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RunningInstancesItemType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_instanceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceId", &a->instanceId, "xsd:string"))
                {       soap_flag_instanceId--;
                  continue;
                }
            if (soap_flag_imageId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:imageId", &a->imageId, "xsd:string"))
                {       soap_flag_imageId--;
                  continue;
                }
            if (soap_flag_instanceState && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__InstanceStateType(soap, "ec2:instanceState", &a->instanceState, "ec2:InstanceStateType"))
                {       soap_flag_instanceState--;
                  continue;
                }
            if (soap_flag_privateDnsName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:privateDnsName", &a->privateDnsName, "xsd:string"))
                {       soap_flag_privateDnsName--;
                  continue;
                }
            if (soap_flag_dnsName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:dnsName", &a->dnsName, "xsd:string"))
                {       soap_flag_dnsName--;
                  continue;
                }
            if (soap_flag_reason && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:reason", &a->reason, "xsd:string"))
                {       soap_flag_reason--;
                  continue;
                }
            if (soap_flag_keyName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:keyName", &a->keyName, "xsd:string"))
                {       soap_flag_keyName--;
                  continue;
                }
            if (soap_flag_amiLaunchIndex && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:amiLaunchIndex", &a->amiLaunchIndex, "xsd:string"))
                {       soap_flag_amiLaunchIndex--;
                  continue;
                }
            if (soap_flag_productCodes && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__ProductCodesSetType(soap, "ec2:productCodes", &a->productCodes, "ec2:ProductCodesSetType"))
                {       soap_flag_productCodes--;
                  continue;
                }
            if (soap_flag_instanceType && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:instanceType", &a->instanceType, "xsd:string"))
                {       soap_flag_instanceType--;
                  continue;
                }
            if (soap_flag_launchTime && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_time(soap, "ec2:launchTime", &a->launchTime, "xsd:dateTime"))
                {       soap_flag_launchTime--;
                  continue;
                }
            if (soap_flag_placement && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__PlacementResponseType(soap, "ec2:placement", &a->placement, "ec2:PlacementResponseType"))
                {       soap_flag_placement--;
                  continue;
                }
            if (soap_flag_kernelId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:kernelId", &a->kernelId, "xsd:string"))
                {       soap_flag_kernelId--;
                  continue;
                }
            if (soap_flag_ramdiskId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:ramdiskId", &a->ramdiskId, "xsd:string"))
                {       soap_flag_ramdiskId--;
                  continue;
                }
            if (soap_flag_platform && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:platform", &a->platform, "xsd:string"))
                {       soap_flag_platform--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RunningInstancesItemType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RunningInstancesItemType, 0, sizeof(struct ec2__RunningInstancesItemType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_instanceId > 0 || soap_flag_imageId > 0 || soap_flag_instanceState > 0 || soap_flag_privateDnsName > 0 || soap_flag_dnsName > 0 || soap_flag_instanceType > 0 || soap_flag_launchTime > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RunningInstancesItemType(struct soap *soap, const struct ec2__RunningInstancesItemType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RunningInstancesItemType);
    if (soap_out_ec2__RunningInstancesItemType(soap, tag?tag:"ec2:RunningInstancesItemType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RunningInstancesItemType * SOAP_FMAC4 soap_get_ec2__RunningInstancesItemType(struct soap *soap, struct ec2__RunningInstancesItemType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RunningInstancesItemType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__ReservationInfoType(struct soap *soap, struct ec2__ReservationInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->reservationId);
    soap_default_string(soap, &a->ownerId);
    a->groupSet = NULL;
    a->instancesSet = NULL;
    soap_default_string(soap, &a->requesterId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__ReservationInfoType(struct soap *soap, const struct ec2__ReservationInfoType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->reservationId);
    soap_serialize_string(soap, &a->ownerId);
    soap_serialize_PointerToec2__GroupSetType(soap, &a->groupSet);
    soap_serialize_PointerToec2__RunningInstancesSetType(soap, &a->instancesSet);
    soap_serialize_string(soap, &a->requesterId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__ReservationInfoType(struct soap *soap, const char *tag, int id, const struct ec2__ReservationInfoType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__ReservationInfoType), type))
      return soap->error;
    if (soap_out_string(soap, "ec2:reservationId", -1, &a->reservationId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:ownerId", -1, &a->ownerId, ""))
      return soap->error;
    if (soap_out_PointerToec2__GroupSetType(soap, "ec2:groupSet", -1, &a->groupSet, ""))
      return soap->error;
    if (soap_out_PointerToec2__RunningInstancesSetType(soap, "ec2:instancesSet", -1, &a->instancesSet, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:requesterId", -1, &a->requesterId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__ReservationInfoType * SOAP_FMAC4 soap_in_ec2__ReservationInfoType(struct soap *soap, const char *tag, struct ec2__ReservationInfoType *a, const char *type)
  {
    size_t soap_flag_reservationId = 1;
    size_t soap_flag_ownerId = 1;
    size_t soap_flag_groupSet = 1;
    size_t soap_flag_instancesSet = 1;
    size_t soap_flag_requesterId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__ReservationInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__ReservationInfoType, sizeof(struct ec2__ReservationInfoType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__ReservationInfoType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_reservationId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:reservationId", &a->reservationId, "xsd:string"))
                {       soap_flag_reservationId--;
                  continue;
                }
            if (soap_flag_ownerId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:ownerId", &a->ownerId, "xsd:string"))
                {       soap_flag_ownerId--;
                  continue;
                }
            if (soap_flag_groupSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__GroupSetType(soap, "ec2:groupSet", &a->groupSet, "ec2:GroupSetType"))
                {       soap_flag_groupSet--;
                  continue;
                }
            if (soap_flag_instancesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__RunningInstancesSetType(soap, "ec2:instancesSet", &a->instancesSet, "ec2:RunningInstancesSetType"))
                {       soap_flag_instancesSet--;
                  continue;
                }
            if (soap_flag_requesterId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requesterId", &a->requesterId, "xsd:string"))
                {       soap_flag_requesterId--;
                  continue;
                }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__ReservationInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__ReservationInfoType, 0, sizeof(struct ec2__ReservationInfoType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_reservationId > 0 || soap_flag_ownerId > 0 || soap_flag_groupSet > 0 || soap_flag_instancesSet > 0))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__ReservationInfoType(struct soap *soap, const struct ec2__ReservationInfoType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__ReservationInfoType);
    if (soap_out_ec2__ReservationInfoType(soap, tag?tag:"ec2:ReservationInfoType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__ReservationInfoType * SOAP_FMAC4 soap_get_ec2__ReservationInfoType(struct soap *soap, struct ec2__ReservationInfoType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__ReservationInfoType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RunningInstancesSetType(struct soap *soap, struct ec2__RunningInstancesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    a->__sizeitem = 0;
    a->item = NULL;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RunningInstancesSetType(struct soap *soap, const struct ec2__RunningInstancesSetType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          {
            soap_embedded(soap, a->item + i, SOAP_TYPE_ec2__RunningInstancesItemType);
            soap_serialize_ec2__RunningInstancesItemType(soap, a->item + i);
          }
      }
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RunningInstancesSetType(struct soap *soap, const char *tag, int id, const struct ec2__RunningInstancesSetType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RunningInstancesSetType), type))
      return soap->error;
    if (a->item)
      {       int i;
        for (i = 0; i < a->__sizeitem; i++)
          if (soap_out_ec2__RunningInstancesItemType(soap, "ec2:item", -1, a->item + i, ""))
            return soap->error;
      }
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RunningInstancesSetType * SOAP_FMAC4 soap_in_ec2__RunningInstancesSetType(struct soap *soap, const char *tag, struct ec2__RunningInstancesSetType *a, const char *type)
  {
    struct soap_blist *soap_blist_item = NULL;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RunningInstancesSetType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RunningInstancesSetType, sizeof(struct ec2__RunningInstancesSetType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RunningInstancesSetType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ec2:item", 1, NULL))
              {       if (a->item == NULL)
                  {       if (soap_blist_item == NULL)
                      soap_blist_item = soap_new_block(soap);
                    a->item = (struct ec2__RunningInstancesItemType *)soap_push_block(soap, soap_blist_item, sizeof(struct ec2__RunningInstancesItemType));
                    if (a->item == NULL)
                      return NULL;
                    soap_default_ec2__RunningInstancesItemType(soap, a->item);
                  }soap_revert(soap);
                if (soap_in_ec2__RunningInstancesItemType(soap, "ec2:item", a->item, "ec2:RunningInstancesItemType"))
                  {       a->__sizeitem++;
                    a->item = NULL;
                    continue;
                  }
              }
            if (soap->error == SOAP_TAG_MISMATCH)
              soap->error = soap_ignore_element(soap);
            if (soap->error == SOAP_NO_TAG)
              break;
            if (soap->error)
              return NULL;
          }
        if (a->item)
          soap_pop_block(soap, soap_blist_item);
        if (a->__sizeitem)
          a->item = (struct ec2__RunningInstancesItemType *)soap_save_block(soap, soap_blist_item, NULL, 1);
        else
          {       a->item = NULL;
            if (soap_blist_item)
              soap_end_block(soap, soap_blist_item);
          }
        if (soap_element_end_in(soap, tag))
          return NULL;
      }
    else
      {       a = (struct ec2__RunningInstancesSetType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ec2__RunningInstancesSetType, 0, sizeof(struct ec2__RunningInstancesSetType), 0, NULL);
        if (soap->body && soap_element_end_in(soap, tag))
          return NULL;
      }
    if ((soap->mode & SOAP_XML_STRICT) && (a->__sizeitem < 1))
      {       soap->error = SOAP_OCCURS;
        return NULL;
      }
    return a;
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_put_ec2__RunningInstancesSetType(struct soap *soap, const struct ec2__RunningInstancesSetType *a, const char *tag, const char *type)
  {
    register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ec2__RunningInstancesSetType);
    if (soap_out_ec2__RunningInstancesSetType(soap, tag?tag:"ec2:RunningInstancesSetType", id, a, type))
      return soap->error;
    return soap_putindependent(soap);
  }

  SOAP_FMAC3 struct ec2__RunningInstancesSetType * SOAP_FMAC4 soap_get_ec2__RunningInstancesSetType(struct soap *soap, struct ec2__RunningInstancesSetType *p, const char *tag, const char *type)
  {
    if ((p = soap_in_ec2__RunningInstancesSetType(soap, tag, p, type)))
      if (soap_getindependent(soap))
        return NULL;
    return p;
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_default_ec2__RunInstancesResponseType(struct soap *soap, struct ec2__RunInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_default_string(soap, &a->requestId);
    soap_default_string(soap, &a->reservationId);
    soap_default_string(soap, &a->ownerId);
    a->groupSet = NULL;
    a->instancesSet = NULL;
    soap_default_string(soap, &a->requesterId);
  }

  SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ec2__RunInstancesResponseType(struct soap *soap, const struct ec2__RunInstancesResponseType *a)
  {
    (void)soap; (void)a; /* appease -Wall -Werror */
    soap_serialize_string(soap, &a->requestId);
    soap_serialize_string(soap, &a->reservationId);
    soap_serialize_string(soap, &a->ownerId);
    soap_serialize_PointerToec2__GroupSetType(soap, &a->groupSet);
    soap_serialize_PointerToec2__RunningInstancesSetType(soap, &a->instancesSet);
    soap_serialize_string(soap, &a->requesterId);
  }

  SOAP_FMAC3 int SOAP_FMAC4 soap_out_ec2__RunInstancesResponseType(struct soap *soap, const char *tag, int id, const struct ec2__RunInstancesResponseType *a, const char *type)
  {
    if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ec2__RunInstancesResponseType), type))
      return soap->error;
    if (a->requestId)
      soap_element_result(soap, "ec2:requestId");
    if (soap_out_string(soap, "ec2:requestId", -1, &a->requestId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:reservationId", -1, &a->reservationId, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:ownerId", -1, &a->ownerId, ""))
      return soap->error;
    if (soap_out_PointerToec2__GroupSetType(soap, "ec2:groupSet", -1, &a->groupSet, ""))
      return soap->error;
    if (soap_out_PointerToec2__RunningInstancesSetType(soap, "ec2:instancesSet", -1, &a->instancesSet, ""))
      return soap->error;
    if (soap_out_string(soap, "ec2:requesterId", -1, &a->requesterId, ""))
      return soap->error;
    return soap_element_end_out(soap, tag);
  }

  SOAP_FMAC3 struct ec2__RunInstancesResponseType * SOAP_FMAC4 soap_in_ec2__RunInstancesResponseType(struct soap *soap, const char *tag, struct ec2__RunInstancesResponseType *a, const char *type)
  {
    size_t soap_flag_requestId = 1;
    size_t soap_flag_reservationId = 1;
    size_t soap_flag_ownerId = 1;
    size_t soap_flag_groupSet = 1;
    size_t soap_flag_instancesSet = 1;
    size_t soap_flag_requesterId = 1;
    if (soap_element_begin_in(soap, tag, 0, type))
      return NULL;
    a = (struct ec2__RunInstancesResponseType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ec2__RunInstancesResponseType, sizeof(struct ec2__RunInstancesResponseType), 0, NULL, NULL, NULL);
    if (!a)
      return NULL;
    soap_default_ec2__RunInstancesResponseType(soap, a);
    if (soap->body && !*soap->href)
      {
        for (;;)
          {       soap->error = SOAP_TAG_MISMATCH;
            if (soap_flag_requestId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:requestId", &a->requestId, "xsd:string"))
                {       soap_flag_requestId--;
                  continue;
                }
            if (soap_flag_reservationId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:reservationId", &a->reservationId, "xsd:string"))
                {       soap_flag_reservationId--;
                  continue;
                }
            if (soap_flag_ownerId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
              if (soap_in_string(soap, "ec2:ownerId", &a->ownerId, "xsd:string"))
                {       soap_flag_ownerId--;
                  continue;
                }
            if (soap_flag_groupSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__GroupSetType(soap, "ec2:groupSet", &a->groupSet, "ec2:GroupSetType"))
                {       soap_flag_groupSet--;
                  continue;
                }
            if (soap_flag_instancesSet && soap->error == SOAP_TAG_MISMATCH)
              if (soap_in_PointerToec2__RunningInstancesSetType(soap, "ec2:instancesSet", &a->instancesSet, "ec2:RunningInstancesSetType"))
                {       soap_flag_instancesSet--;
       