/**
 * @file MonitoringThread.hh
 *
 * @brief  actively collects monitoring information for DIET, mainly from FAST
 *
 * @author  Georg Hoesch (hoesch@in.tum.de)
 *          Cyrille Pontvieux (cyrille.pontvieux@edu.univ-fcomte.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _MONITORINGTHREAD_HH_
#define _MONITORINGTHREAD_HH_

#include <omniconfig.h>
#include <omnithread.h>

#include "DietLogComponent.hh"

/**
 * This thread actively queries FAST every second for mem, load and
 * other passive values which cannot be measured directly in the
 * sorucecode
 */
class MonitoringThread : public omni_thread {
public:
  /**
   * Constructor.
   * @param DLC reference to the DietLogComponent of this thread.
   */
  explicit
  MonitoringThread(DietLogComponent *DLC);

  /**
   * Start the thread.
   */
  void
  startThread();

  /**
   * Stop the thread.
   * The object will be deleted by the orb.
   */
  void
  stopThread();

protected:
  /**
   * The main loop of the thread.
   * Logs FAST values with the dietLogComponent
   */
  void *
  run_undetached(void *params);

  /**
   * Destructor. Is called by the orb when the thread is
   * stopped. Do not call it yourself.
   */
  ~MonitoringThread();

private:
  /**
   * This threads dietLogComponent. NULL if no monitoring information
   * is to be gathered (although you don't need to start this thread then)
   */
  DietLogComponent *dietLogComponent;

  /**
   * controls the main loop
   */
  bool threadRunning;
};

#endif /* ifndef _MONITORINGTHREAD_HH_ */
