/**
 * @file SeDDescrParser.hh
 *
 * @brief   Parser of XML files used to convert external service into SeD
 *
 * @author   Benjamin ISNARD (benjamin.isnard@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _SEDDESCRPARSER_HH_
#define _SEDDESCRPARSER_HH_

// Standard library headers
#include <list>
#include <string>

// Xerces headers
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>
#include <xercesc/dom/DOMImplementation.hpp>
#include <xercesc/dom/DOMImplementationLS.hpp>
#include <xercesc/dom/DOMImplementationRegistry.hpp>
#include <xercesc/dom/DOMException.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/dom/DOMError.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/dom/DOMLocator.hpp>
#include <xercesc/dom/DOMNamedNodeMap.hpp>
#include <xercesc/dom/DOMElement.hpp>
#include <xercesc/dom/DOMAttr.hpp>

// Diet headers
#include "WfUtils.hh"
#include "SeDService.hh"

XERCES_CPP_NAMESPACE_USE


/*****************************************************************************/
/*                          CLASS SeDDescrParser                             */
/*****************************************************************************/


class SeDDescrParser {
public:
  explicit
  SeDDescrParser(const std::string &fileName);

  virtual ~SeDDescrParser();

  void
  parseXml(bool checkValid = false);

  virtual void
  evalTemplate(SeDArgument *arg, string &value) = 0;

  const list<SeDService *> &
  getServices();

protected:
  virtual void
  parseRoot(DOMNode *root) = 0;

  /**
   * XML File name
   */
  std::string myXmlFileName;

  /**
   * Xml document
   */
  DOMDocument *document;

  /**
   * Generated objects storage
   */
  std::list<SeDService *>  myServiceList;
};


/*****************************************************************************/
/*                            CLASS GASWParser                               */
/*****************************************************************************/

class GASWParser : public SeDDescrParser {
public:
  explicit
  GASWParser(const std::string &fileName);

  virtual void
  evalTemplate(SeDArgument *arg, std::string &value);

protected:
  virtual std::string
  parseValueURI(const DOMElement *element);

  virtual void
  parseRoot(DOMNode *root);

  virtual void
  parseExecutable(const DOMElement *element);

  virtual void
  parseInput(const DOMElement *element, SeDService *service);

  virtual void
  parseOutput(const DOMElement *element, SeDService *service);

  virtual void
  parseDependency(const DOMElement *element, SeDService *service);
};

#endif /* ifndef _SEDDESCRPARSER_HH_ */
