/**
 * @file  statistics.hh
 *
 * @brief  DIET statistics tools source code
 *
 * @author  Ludovic BERTSCH (Ludovic.Bertsch@ens-lyon.fr)
 *          Eddy CARON (Eddy.Caron@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#include "stats_config.h"

#ifndef _STATISTICS_HH_
#define _STATISTICS_HH_

// The first part is ALWAYS defined, so we can link any program
// even when the macro HAVE_STATISTICS is not defined

#include <cstdio>
#ifdef WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif
#ifdef __WIN32__
#define DIET_API_LIB __declspec(dllexport)
#else
#define DIET_API_LIB
#endif

#if HAVE_STATISTICS

enum stat_type {
  STAT_IN,
  STAT_OUT,
  STAT_INFO
};


// Please, don't use those variables
extern FILE  *  STAT_FILE;
extern const char *const STAT_TYPE_STRING[3];

// Don't call this, call stat_in, stat_out & stat_info instead
DIET_API_LIB void
gen_stat(int type, const char *myname, const char *message);

// Don't call this, call init_stat instead!
DIET_API_LIB void
do_stat_init();
DIET_API_LIB void
do_stat_flush();
DIET_API_LIB void
do_stat_finalize();

// ///////////////////////////////
// Use only the following calls :

#  define stat_init() do_stat_init()
#  define stat_in(myname, message) gen_stat(STAT_IN, myname, message)
#  define stat_out(myname, message) gen_stat(STAT_OUT, myname, message)
#  define stat_info(myname, message) gen_stat(STAT_INFO, myname, message)
#  define stat_finalize() do_stat_finalize()
#  define stat_flush() do_stat_flush()

#else  // HAVE_STATISTICS

#  define stat_init()
#  define stat_in(myname, message)
#  define stat_out(myname, message)
#  define stat_info(myname, message)
#  define stat_finalize()
#  define stat_flush()

#endif  // HAVE_STATISTICS

#endif  // _STATISTICS_HH_
