/**
 * @file Cori_Easy_CPU.hh
 *
 * @brief  CoRI Colleting CPU Information for EASY
 *
 * @author  Frauenkron Peter (Peter.Frauenkron@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef _CORI_EASY_CPU_HH_
#define _CORI_EASY_CPU_HH_

#include <vector>

class Easy_CPU {
public:
  int
  get_CPU_Frequence(std::vector<double> *vlist);

  int
  get_CPU_Cache(std::vector<double> *vlist);

  int
  get_CPU_Bogomips(std::vector<double> *vlist);

  int
  get_CPU_Number(double *number);

  int
  get_CPU_ActualLoad(double *actualload);

  int
  get_CPU_Avg(int interval, double *resultat);

private:
  int
  get_CPU_Avg_byGetloadavg(int interval, double *resultat);

  int
  get_CPU_Number_byget_nprocs(double *result);

  int
  get_CPU_Number_byNum_Proc(double *result);

  int
  get_CPU_Freq_From_Proc(std::vector<double> *vlist);

  int
  get_Bogomips_From_Proc(std::vector<double> *vlist);

  int
  get_CPU_Cache_From_Proc(std::vector<double> *vlist);

  int
  get_CPU_Freq_for_FreeBSD(std::vector<double> *vlist);

  int
  get_CPU_Freq_for_Darwin(std::vector<double> *vlist);

  int
  get_CPU_Freq_for_NetBSD(std::vector<double> *vlist);

  int
  get_CPU_ActualLoad_Byps(double *actualload);
};

#endif  // _CORI_EASY_CPU_HH_
