#
# Try to find DeltaCloud library 
#
# References: for info on Deltacloud refer to https://deltacloud.apache.org/
# 
# The following variables are set:
#   DELTACLOUD_FOUND		- When false, deltacloud is not founded  
#   DELTACLOUD_INCLUDE_DIR	- Directories to include to use Apache Deltacloud 
#   DELTACLOUD_LIBRARY 	- Files to link against to use Apache Deltacloud
#
# Authors: Eddy Caron (Eddy.Caron@ens-lyon.fr), Rodrigue Chakode (Rodrigue.Chakode@sysfera.com), Lamiel Toch (lamiel.toch@ens-lyon.fr)
# 
 
FILE( APPEND ${CMAKE_BINARY_DIR}/CMakeOutput.log
      "FindDeltacloud.cmake: Looking for Deltacloud library.\n\n" )

FIND_LIBRARY(DELTACLOUD_LIBRARY NAMES deltacloud)

##############################################################################
# find headers
##############################################################################
FIND_PATH(DELTACLOUD_INCLUDE_DIR
  NAMES libdeltacloud/libdeltacloud.h
  PATHS
  ${DELTACLOUD_LIBRARY}/include
  $ENV{DELTACLOUD_LIBRARY}/include
  /usr/local/include
  /opt/local/include
  ${DELTACLOUD_INCLUDE_DIRS}
)

IF (DELTACLOUD_INCLUDE_DIR)
FILE( APPEND ${CMAKE_BINARY_DIR}/CMakeOutput.log
      "FindDeltacloud.cmake: libdeltacloud.h was found in ${DELTACLOUD_INCLUDE_DIR} \n\n" )
ENDIF (DELTACLOUD_INCLUDE_DIR)
 
FIND_LIBRARY(DELTACLOUD_LIBRARY
  NAMES deltacloud
  PATHS
  ${DELTACLOUD_LIBRARY}/lib
  $ENV{DELTACLOUD_LIBRARY}/lib
  /usr/local/lib
  /opt/local/lib
  ${DELTACLOUD_LIBRARY_DIRS}
)

IF (DELTACLOUD_INCLUDE_DIR AND DELTACLOUD_LIBRARY)
  set(DELTACLOUD_FOUND "Yes")
  mark_as_advanced(DELTACLOUD_INCLUDE_DIR)
  mark_as_advanced(DELTACLOUD_LIBRARY)
ENDIF(DELTACLOUD_INCLUDE_DIR AND DELTACLOUD_LIBRARY)

IF(NOT DELTACLOUD_FOUND )
  MESSAGE("DELTACLOUD library was not found. Please provide DELTACLOUD_INCLUDE_DIR ")
  MESSAGE("  - through the GUI when working with ccmake, ")
  MESSAGE("  - as a command line argument when working with cmake e.g. ")
  MESSAGE("    cmake .. -DDELTACLOUD_INCLUDE_DIR:PATH=/usr/local/libdeltacloud/include")
  MESSAGE("Note: the following message is triggered by cmake on the first ")
  MESSAGE("    undefined necessary PATH variable (e.g. DELTACLOUD_INCLUDE_DIR)")
  MESSAGE("    Providing DELTACLOUD_INCLUDE_DIR (as above described) is probably the")
  MESSAGE("    simplest solution unless you have a really customized/odd")
  MESSAGE("    Deltacloud installation...")
  MESSAGE(" ")
  MESSAGE(" Deltacloud library can be found here: https://git.fedorahosted.org/git/deltacloud/libdeltacloud.git")
ENDIF( NOT DELTACLOUD_FOUND )
