#
# Try to find the diet log service module 
#
# The following variables are set:
#   LOG_LIB_DIR		  - Directory containing all the lib
#   LOG_INCLUDE_DIR	  - Directory containing the files to include
#

SET(libName "LogServiceComponentBase")
MARK_AS_ADVANCED(libName)

IF(BUILD_SHARED_LIBS)
  SET(PREFIX ${CMAKE_SHARED_LIBRARY_PREFIX})
  SET(SUFFIX ${CMAKE_SHARED_LIBRARY_SUFFIX})
ELSE()
  SET(PREFIX ${CMAKE_STATIC_LIBRARY_PREFIX})
  SET(SUFFIX ${CMAKE_STATIC_LIBRARY_SUFFIX})
ENDIF()

FIND_PATH(LOG_INCLUDE_DIR LogORBMgr.hh
  PATHS ${LOGSERVICE_DIR}/include 
  DOC "Directory containing the log service include files")

FIND_LIBRARY(LOG_LIBRARY_COMPONENT ${libName}
  PATHS ${LOGSERVICE_DIR}/lib
  DOC "The log service library")
FIND_LIBRARY(LOG_LIBRARY_UTILS  "LogForwarderUtils"
  PATHS ${LOGSERVICE_DIR}/lib
  DOC "The log service library")
FIND_LIBRARY(LOG_LIBRARY_BASE "LogServiceComponentBase"
  PATHS ${LOGSERVICE_DIR}/lib
  DOC "The log service library")
FIND_LIBRARY(LOG_LIBRARY_BASE "LogServiceToolBase"
  PATHS ${LOGSERVICE_DIR}/lib
  DOC "The log service library")
SET(LOG_LIBRARY ${LOG_LIBRARY_COMPONENT})
SET(LOG_LIBRARIES ${LOG_LIBRARY_COMPONENT}
  ${LOG_LIBRARY_UTILS} ${LOG_LIBRARY_BASE}
  ${LOG_LIBRARY_TBASE} ${LOG_LIBRARY_CORBA})
IF(WIN32)
  FIND_LIBRARY(LOG_LIBRARY_CORBA "LogCorba" 
    PATHS ${LOGSERVICE_DIR}/lib 
    DOC "The log service library")
  SET(LOG_LIBRARIES ${LOG_LIBRARIES} ${LOG_LIBRARY_CORBA})
ENDIF()


include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(LOGSERVICE DEFAULT_MSG LOG_INCLUDE_DIR LOG_LIBRARY)

IF(NOT LOGSERVICE_FOUND)
  MESSAGE(STATUS
    "Log not found on this machine. DIET will not be able to use the log system.")
  SET(LOGSERVICE_DIR "" CACHE PATH "Root of log service tree installation.")
ENDIF()

