/**
 * @file  MultiCall.cc
 *
 * @brief   Used to divide a profile and make several calls with just one SeD
 *
 * @author   Ghislain Charrier (Ghislain.Charrier@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright ENS Lyon, INRIA, UCBL, SysFera (2000)
 *
 * - Frederic.Desprez@ens-lyon.fr (Project Manager)
 * - Eddy.Caron@ens-lyon.fr (Technical Manager)
 * - Tech@sysfera.com (Maintainer and Technical Support)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include <iostream>
#include <cstdlib>
#include <string>

#include "MultiCall.hh"
#include "est_internal.hh"
#include "ORBMgr.hh"

using namespace std;

corba_response_t *MultiCall::corba_response = NULL;

void
MultiCall::set_response(corba_response_t *response) {
  corba_response = response;
}

corba_response_t *
MultiCall::get_response() {
  return corba_response;
}

// computes the number of scenario per cluster
vector<int>
MultiCall::cerfacsSchedule() {
  vector<int> nbDags;
  int nbClusters = corba_response->servers.length();
  int NS = (&(corba_response->servers[0]).estim)->estValues.length() - 1;

  for (int i = 0; i < nbClusters; i++) {
    nbDags.push_back(0);
  }

  for (int dag = 0; dag < NS; dag++) {
    int MSmin = -1;
    int clusterMin = 0;
    for (int i = 0; i < nbClusters; i++) {
      int temp =
        diet_est_get_internal((&(corba_response->servers[i]).estim),
                              EST_USERDEFINED + (nbDags[i]),
                              0);
      if (MSmin == -1 || temp < MSmin) {
        MSmin = temp;
        clusterMin = i;
      }
    }
    nbDags[clusterMin]++;
  }
  return nbDags;
} // cerfacsSchedule

bool
MultiCall::updateCall(diet_profile_t *profile, SeD_var &chosenServer) {
  static vector<int> nb_scenarios;
  static int counter = 0;
  static char *save;
  char *s;
  char c[2];
  char *stemp;
  c[0] = '#';
  c[1] = '\0';
  chosenServer = SeD::_nil();


  // some datas need to be initialized just once
  if (counter == 0) {
    nb_scenarios = MultiCall::cerfacsSchedule();
    diet_paramstring_get(diet_parameter(profile, 2), &save, NULL);
  }

  s = (char *) malloc((strlen(save) + 1) * sizeof(char));
  strcpy(s, save);

  stemp = (char *) malloc((strlen(s) + 1) * sizeof(char));
  stemp[0] = '\0';

  // if there is at least a scenario on this SeD
  if (nb_scenarios[counter] != 0) {
    string serverName = string(corba_response->servers[counter].loc.SeDName);
    chosenServer = ORBMgr::getMgr()->resolve<SeD, SeD_var>(SEDCTXT, serverName);

    diet_scalar_set(diet_parameter(profile, 0),
                    &(nb_scenarios[counter]),
                    DIET_VOLATILE, DIET_INT);
    // splits the mnemonics
    char *tmp;
    tmp = strtok(save, c);
    for (int counter2 = 0; counter2 < nb_scenarios[counter]; counter2++) {
      if (counter2 != 0) {
        stemp = strcat(stemp, c);
      }
      stemp = strcat(stemp, tmp);
      tmp = strtok(NULL, c);
    }
    // reconstruct the end of the string
    int counter2 = 0;
    s[0] = '\0';
    while (tmp != NULL) {
      if (counter2 > 0) {
        s = strcat(s, c);
      }
      s = strcat(s, tmp);
      tmp = strtok(NULL, c);
      counter2++;
    }

    // updating the profile
    diet_paramstring_set(diet_parameter(profile, 2), stemp, DIET_VOLATILE);
  }

  strcpy(save, s);
  free(s);
  free(stemp);

  // there are scenarios to send, so call
  if (nb_scenarios[counter] != 0) {
    counter++;
    return true;
  }

  counter++;

  return false;
} // updateCall
