/**
 * @file scalars_server.c
 *
 * @brief  DIET scalars example: a server for additions of all types of scalars.
 *
 * @author  Philippe COMBES (Philippe.Combes@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef __WIN32__
#include <unistd.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "DIET_server.h"

int sendEcho(diet_profile_t *pb) {
	char* name = NULL;
	char* result =malloc(80*sizeof(char));
	strcpy(result, "Bonjour ");

	diet_string_get(diet_parameter(pb, 0), &name, DIET_VOLATILE);
	printf("Received : %s\n", name);

	strcat(result, name);
	printf("Server : %s\n", result);
	size_t length = diet_string_get_desc(diet_parameter(pb,1))->length;
	printf("Server : %zx\n", length);
	diet_free_data(diet_parameter(pb,0));
//	diet_string_get(diet_parameter(pb, 1), &name, DIET_VOLATILE);

	diet_string_set(diet_parameter(pb, 1), result, DIET_VOLATILE);
	return 0;
}

int usage(char *cmd) {
	fprintf(stderr, "Usage: %s <file.cfg>\n", cmd);
	return 1;
}

/*
 * MAIN
 */

int main(int argc, char *argv[]) {
	int res;

	diet_profile_desc_t *profile = NULL;

	if (argc < 2) {
		return usage(argv[0]);
	}

	diet_service_table_init(1);

	profile = diet_profile_desc_alloc("echo", 0, 0, 1);

	diet_generic_desc_set(diet_param_desc(profile, 0),
		DIET_STRING, DIET_CHAR);
	diet_generic_desc_set(diet_param_desc(profile, 1),
		DIET_STRING, DIET_CHAR);

	if (diet_service_table_add(profile, NULL, sendEcho)) {
		return 1;

	}
	diet_profile_desc_free(profile);

	diet_print_service_table();
	res = diet_SeD(argv[1], argc, argv);
	/* Not reached */
	return res;
} /* main */
