/**
 * @file marshalling.hh
 *
 * @brief  DIET CORBA marshalling header
 *
 * @author  Philippe COMBES (Philippe.Combes@ens-lyon.fr)
 *          Frederic LOMBARD (Frederc.Lombard@lifc.univ-fcomte.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _MARSHALLING_HH_
#define _MARSHALLING_HH_

#include "DIET_data.h"
#include "DIET_server.h"

#include "DIET_data_internal.hh"
#include "common_types.hh"
#ifdef WIN32
   #define DIET_API_LIB __declspec(dllexport)
#else
   #define DIET_API_LIB
#endif
/*--------------------------------------------------------------------------*/
/* <FIXME: This comments should be updated>                                 */
/* These functions allow to copy the content of diet structures between     */
/* Corba and standard versions. Whenever it's possible, no data should be   */
/* shared between the two copies. This should prevent the Corba stub/skel   */
/* from deallocating usefull datas.                                         */
/* </FIXME>                                                                 */
/*                                                                          */
/* Functions whose name begins with "mrsh" are marshalling functions, i.e.  */
/* they convert standard C or C++ data into CORBA structures.               */
/* Functions whose name begins with "unmrsh" are unmarshalling functions.   */
/* Conversion are not always from structures to their exact equivalent,     */
/* but their name and prototype should be relevant enough.                  */
/*--------------------------------------------------------------------------*/

DIET_API_LIB int
__mrsh_data_desc_type(corba_data_desc_t *dest,
                      const diet_data_desc_t *const src);

/*
 * Trace Level
 */
DIET_API_LIB void
mrsh_set_trace_level(int level);


/*
 * Profile conversion
 */

// To add a CORBA service into the SeD service table
DIET_API_LIB int
mrsh_profile_desc(corba_profile_desc_t *dest, const diet_profile_desc_t *src);

// To submit a request from the client DIET profile
DIET_API_LIB int
mrsh_pb_desc(corba_pb_desc_t *dest, const diet_profile_t *const src);


// To send the input data from client to SeD
DIET_API_LIB int
mrsh_profile_to_in_args(corba_profile_t *dest, const diet_profile_t *src);

// To convert client data profile to service profile
DIET_API_LIB int
unmrsh_in_args_to_profile(diet_profile_t *dest, corba_profile_t *src,
                          const diet_convertor_t *cvt);
/* Needed by DAGDA. */
DIET_API_LIB int
mrsh_data_desc(corba_data_desc_t *dest, diet_data_desc_t *src);

// To reconvert service output data to client data profile
DIET_API_LIB int
mrsh_profile_to_out_args(corba_profile_t *dest, const diet_profile_t *src,
                         const diet_convertor_t *cvt);

// To receive output data on the client
DIET_API_LIB int
unmrsh_out_args_to_profile(diet_profile_t *dpb, corba_profile_t *cpb);

// Force the unmarshalling of INOUT parameters (useful in async mdode)
DIET_API_LIB int
unmrsh_inout_args_to_profile(diet_profile_t *dpb, corba_profile_t *cpb);

// tmpDir is the prefix of where data are stored on server
#if defined HAVE_ALT_BATCH
DIET_API_LIB int
unmrsh_data(diet_data_t *dest, corba_data_t *src, int, const char *tmpDir);
#else
DIET_API_LIB int
unmrsh_data(diet_data_t *dest, corba_data_t *src, int);
#endif

// unmarshall only the data description (needed for custom
// performance metrics)
DIET_API_LIB int
unmrsh_data_desc(diet_data_desc_t *dest, const corba_data_desc_t *const src);


#ifdef HAVE_WORKFLOW
// Workflow structure marshaling
DIET_API_LIB int
mrsh_wf_desc(corba_wf_desc_t *dest, const diet_wf_desc_t *const src);
#endif

DIET_API_LIB int
unmrsh_profile_desc(diet_profile_desc_t *dest,
                    const corba_profile_desc_t *src);

#endif  // _MARSHALLING_HH_
