/**
 * @file DagdaFactory.hh
 *
 * @brief  Used to obtain this DIET component data manager easil from everywhere.
 *
 * @author  Gael Le Mahec (lemahec@clermont.in2p3.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _DAGDAFACTORY_HH_
#define _DAGDAFACTORY_HH_

#include <string>
#include "DagdaImpl.hh"

#ifdef WIN32
   #define DIET_API_LIB __declspec(dllexport)
#else
   #define DIET_API_LIB
#endif

/* A class factory to simplify the extensions of the Dagda object. */
class DIET_API_LIB DagdaFactory {
public:
  static DagdaImpl *
  getClientDataManager();

  static DagdaImpl *
  getSeDDataManager();

  static DagdaImpl *
  getAgentDataManager();

  static DagdaImpl *
  getDataManager();

  static const char *
  getStorageDir();

  static unsigned long
  getMaxMsgSize();

  static unsigned long
  getMaxDiskSpace();

  static unsigned long
  getMaxMemSpace();

  static const char *
  getParentName();

  static const char *
  getClientName();

  static const char *
  getSeDName();

  static const char *
  getAgentName();

  static const char *
  getDefaultName();

 static void
  reset();

private:
  static DagdaImpl *clientDataManager;
  static DagdaImpl *sedDataManager;
  static DagdaImpl *agentDataManager;
  static DagdaImpl *localDataManager;
  static std::string storageDir;

  static DagdaImpl *
  createDataManager(dagda_manager_type_t type);

  static unsigned long defaultMaxMsgSize;
  static unsigned long defaultMaxDiskSpace;
  static unsigned long defaultMaxMemSpace;

  static std::string
  getDefaultStorageDir();
};

#endif /* ifndef _DAGDAFACTORY_HH_ */
