/**
* @file CommonParser.hh
* 
* @brief  Parser common utilities 
* 
* @author  Haikel Guemar (haikel.guemar@sysfera.com)
* 
* @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/



#ifndef _COMMON_PARSER_HH_
#define _COMMON_PARSER_HH_



#include <functional>
#include <iostream>
#include <map>
#include <string>
#include <vector>


extern std::ostream debug;
extern std::string nullString;
#ifdef __WIN32__
#define DIET_API_LIB __declspec(dllexport)
#else
#define DIET_API_LIB
#endif
/**
 *  @typedef std::map<std::string, std::string> ConfigMap
 *
 *  Configuration Map (key, value)
 */
typedef std::map<std::string, std::string> ConfigMap;
/**
 *  @typedef std::map<std::string, std::string> OptionMap
 *
 *  Configuration/Option Map (key, value)
 */
typedef std::map<std::string, std::string> OptionMap;

/**
 * @author hguemar <hguemar@sysfera.com>
 *
 * @class StartsWith
 * @brief functor used to find short/long options
 * @internal
 */
class StartsWith : public std::unary_function<std::string, bool> {
public:
  explicit StartsWith(const std::string& str) : s1(str) {
  }

  bool
  operator() (const std::string& s2) const;

private:
  std::string s1;
};

/**
 * @author hguemar <hguemar@sysfera.com>
 *
 * @class Splitter
 * @brief functor working as token generator
 * @internal
 */
class Splitter {
public:
  Splitter();

  explicit Splitter(const char c);

  Splitter(const std::string& str, const char c);

  bool
  hasNext() const {
    return hasNext_;
  }

  void
  reset(const std::string& str);

  void
  reset(const std::string& str, const char c);

  std::string&
  operator() ();

private:
  char delim_;
  bool hasNext_;
  std::string::size_type previous_;
  std::string::size_type current_;
  std::string token_;
  std::string str_;
};

DIET_API_LIB ConfigMap * GetConfigPtr();
#endif /* _COMMON_PARSER_HH_ */
