/**
 * @file  LocalAgentImpl.hh
 *
 * @brief  DIET local agent implementation header
 *
 * @author  Philippe COMBES (Philippe.Combes@ens-lyon.fr)
 *          Sylvain DAHAN (Sylvain.Dahan@lifc.univ-fcomte.fr)
 *          Frederic LOMBARD (Frederic.Lombard@lifc.univ-fcomte.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _LOCALAGENTIMPL_HH_
#define _LOCALAGENTIMPL_HH_

#include "Agent.hh"
#include "AgentImpl.hh"
#include "Singleton.hh"

#include "Forwarder.hh"
#include "LocalAgentFwdr.hh"

class LocalAgentImpl
: public POA_LocalAgent
, public AgentImpl
// , public Singleton<LocalAgentImpl>
{
	// friend Singleton<LocalAgentImpl>;
	// private:
	public:
		LocalAgentImpl();

	public:
		~LocalAgentImpl() = default;

		/** Force call for POA_LocalAgent::_this. */
		inline LocalAgent_ptr
		_this() { return this->POA_LocalAgent::_this(); }

		/** Change the parent */
		CORBA::Long
		bindParent(const char *parentName);

		/** Disconnect from the parent */
		CORBA::Long
		disconnect();

		/** Sends a request to the agent to commit suicide.
		 * If "recursive" is true, then the agent forwards the request
		 * to its children.
		 */
		virtual CORBA::Long
		removeElement(bool recursive);

		virtual void
		removeElementClean(bool recursive);

		/** Launch this agent (initialization + registration in the hierarchy). */
		int
		run();

		/** Get a request from the parent */
		virtual void
		getRequest(const corba_request_t &req);

		/**
		 * Add \c services into the service table, and attach them to child \c me.
		 * Then, propagate information to the parent
		 */
		virtual CORBA::Long
		addServices(CORBA::ULong myID, const SeqCorbaProfileDesc_t &services);

		virtual CORBA::Long
		childUnsubscribe(CORBA::ULong childID,
		                 const SeqCorbaProfileDesc_t &services);

		/** Remove services into the service table for a given child */
		virtual CORBA::Long
		childRemoveService(CORBA::ULong childID,
		                   const corba_profile_desc_t &profile);

		virtual SeqString*
		searchData(const char *request);

	private:

	/** Reference of the parent */
	Agent_var parent;
	/** ID of this agent amongst the children of its parent */
	ChildID childID;
};  // LocalAgentImpl

class LocalAgentFwdrImpl
: public POA_LocalAgentFwdr
, public PortableServer::RefCountServantBase
{
	public:
		LocalAgentFwdrImpl(Forwarder_ptr fwdr, const char *objName);

		virtual CORBA::Long
		agentSubscribe(const char *me, const char *hostName,
		               const SeqCorbaProfileDesc_t &services);
		virtual CORBA::Long
		serverSubscribe(const char *me, const char *hostName,
		                const SeqCorbaProfileDesc_t &services);

		virtual CORBA::Long
		childUnsubscribe(CORBA::ULong childID,
		                 const SeqCorbaProfileDesc_t &services);

		virtual CORBA::Long
		removeElement(bool recursive);

		CORBA::Long
		bindParent(const char *parentName);

		CORBA::Long
		disconnect();

		virtual void
		getRequest(const corba_request_t &req);

		virtual void
		getResponse(const corba_response_t &resp);

		virtual CORBA::Long
		ping();

		virtual char*
		getHostname();

		virtual CORBA::Long
		addServices(CORBA::ULong myID, const SeqCorbaProfileDesc_t &services);

		virtual CORBA::Long
		childRemoveService(CORBA::ULong childID,
		                   const corba_profile_desc_t &profile);

		virtual char*
		getDataManager();

		virtual SeqString *
		searchData(const char *request);

	private:
		Forwarder_ptr forwarder;
		char *objName;
};

#endif  // _LOCALAGENTIMPL_HH_
