/**
 * @file client.c
 *
 * @brief  DIET scalars example: a client for additions of all types of scalars
 *
 * @author  Peter Frauenkron (Peter.Frauenkron@gmail.com)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "DIET_client.h"

#define NB_PB 1
static const char *PB[NB_PB] =
{"FIBO"};


/* argv[1]: client config file path
   argv[2]: one of the strings above
   argv[3]: number of fibonacci      */

void
usage(char *cmd) {
  fprintf(stderr, "Usage: %s <file.cfg> [%s] <fibonacci number> \n",
          cmd, PB[0]);
  exit(1);
}

int
main(int argc, char *argv[]) {
  char *path;
  diet_profile_t *profile = NULL;
  /* Use the long type for all "integer" types. */
  long l1 = 0;
  long *pl2 = NULL;
  if (argc != 4) {
    usage(argv[0]);
  }
  path = argv[2];

  if (diet_initialize(argv[1], argc, argv)) {
    fprintf(stderr, "DIET initialization failed !\n");
    return 1;
  }

  profile = diet_profile_alloc(path, 0, 0, 1);

  l1 = atol(argv[3]);
  if (l1 > 46) {
    printf("too big number! %ld\n", (long) l1);
    exit(1);
  }

  printf("Before the call: fibo=%ld\n", (long) l1);
  diet_scalar_set(diet_parameter(profile, 0), &l1, DIET_VOLATILE, DIET_LONGINT);
  diet_scalar_set(diet_parameter(profile, 1), NULL, DIET_VOLATILE, DIET_LONGINT);

  if (!diet_call(profile)) {
    diet_scalar_get(diet_parameter(profile, 1), &pl2, NULL);

    printf("After the call: fibo=%ld\n", (long) *pl2);
  } else {
    fprintf(stderr, "diet_call has returned with an error code !!!\n");
    return 1;
  }

  diet_free_data(diet_parameter(profile, 1));
  diet_profile_free(profile);
  diet_finalize();

  return 0;
} /* main */
