/**
 * @file client.c
 *
 * @brief  Multicall client
 *
 * @author  Ghislain Charrier (ghislain.charrier@inria.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "DIET_client.h"

void
usage(char *cmd) {
  fprintf(stdout, "Usage: %S <file.cfg> string\n", cmd);
  fprintf(stdout, "The string must contain simulations names separated by #\n");
  fprintf(stdout, "exemple : simu1#simu2#simu3#simu4\n");
  exit(1);
}

int
main(int argc, char *argv[]) {
  int NR = 1800;
  int NS = 0;
  char c = '#';
  diet_profile_t *profile = NULL;

  if (argc != 3) {
    usage(argv[0]);
  }


  if (diet_initialize(argv[1], argc, argv)) {
    fprintf(stderr, "DIET initialization failed !\n");
    return 1;
  }

  char *s = argv[2];
  char *temp = (char *) malloc((strlen(s) + 1) * sizeof(char));
  char *tempBak = temp;
  temp = strcpy(temp, s);


  while ((temp = strtok(temp, &c)) != NULL) {
    temp = NULL;
    NS++;
  }
  free(tempBak);

  profile = diet_profile_alloc("CERFACS", 2, 2, 2);
  diet_scalar_set(diet_parameter(profile, 0), &NS, DIET_VOLATILE, DIET_INT);
  diet_scalar_set(diet_parameter(profile, 1), &NR, DIET_VOLATILE, DIET_INT);
  diet_paramstring_set(diet_parameter(profile, 2), s, DIET_VOLATILE);

  diet_reqID_t rst;

  if (!diet_call_async(profile, &rst)) {
    printf("call done\n");
  } else {
    fprintf(stderr, "diet_call has returned with an error code !!!\n");
    return 1;
  }
  diet_wait(rst);
  diet_profile_free(profile);
  diet_finalize();
  return 0;
} /* main */
