#
# Try to find the gSOAP package installation or build tree
#
# The following variables are set:
#   GSOAP_FOUND         - boolean variable to tell if the package was found
#   GSOAP_LIBRARIES     - path of the gsoapssl++ library
#   GSOAP_INCLUDE_DIR   - include directory of the gSOAP installation
#
# Authors: Adrian Muresan (Adrian.Muresan@ens-lyon.fr), Eddy Caron (Eddy.Caron@ens-lyon.fr)
# 

FILE( APPEND ${CMAKE_BINARY_DIR}/CMakeOutput.log
  "FindGSOAP.cmake: Looking for GSOAP library.\n\n" )

FIND_PATH(
  GSOAP_INCLUDE_DIR stdsoap2.h 
  PATHS
  ${GSOAP_DIR}/include
  /usr/include
  /usr/local/include
  )


FIND_LIBRARY(GSOAP_LIBRARY NAMES gsoapssl
  PATHS ${GSOAP_SRC_DIR}/gsoap)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GSOAP DEFAULT_MSG GSOAP_LIBRARY GSOAP_INCLUDE_DIR)

IF(GSOAP_FOUND)
  set(GSOAP_LIBRARIES ${GSOAP_LIBRARY})
  set(GSOAP_INCLUDE_DIRS ${GSOAP_INCLUDE_DIR})
  MARK_AS_ADVANCED(GSOAP_SRC_DIR)
  MARK_AS_ADVANCED(GSOAP_LIBRARY)
  MARK_AS_ADVANCED(GSOAP_LIBRARIES)
  MARK_AS_ADVANCED(GSOAP_INCLUDE_DIR)
  MARK_AS_ADVANCED(GSOAP_INCLUDE_DIRS)
ENDIF(GSOAP_FOUND)

