/**
 * @file Deltacloud_BatchSystem.hh
 *
 * @brief Batch system for Deltacloud
 *
 * @author Guillaume Verger (guillaume.verger@inria.fr)
 *         Lamiel Toch (lamiel.toch@ens-lyon.fr)
 *
 * @section License
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef _DELTACLOUD_BATCHSYSTEM_HH
#define _DELTACLOUD_BATCHSYSTEM_HH

#include "BatchSystem.hh"
#include "cloud-utils/CloudCredentials.hh"

#include <boost/thread/mutex.hpp>
#include <libdeltacloud/libdeltacloud.h>
#include <string>
#include <vector>
#include <map>

class Deltacloud_BatchSystem : public BatchSystem
{
  public:
    Deltacloud_BatchSystem(int batchID, const char *batchName);
    virtual ~Deltacloud_BatchSystem ();

    virtual int
      diet_submit_parallel(diet_profile_t *profile,
          const char *addon_prologue,
          const char *command);

    virtual batchJobState
      askBatchJobStatus(int batchJobID);

    virtual int
      isBatchJobCompleted(int batchJobID);

    virtual int
      getNbTotResources();

    virtual int
      getNbResources();

    virtual int
      getMaxWalltime();

    virtual int
      getMaxProcs();

    virtual int
      getNbTotFreeResources();

    virtual int
      getNbFreeResources();

  private:
    int
      init();

    std::vector<std::string>
      instanciateVMs(diet_profile_t *profile, std::string jobid);

    int
      killVMs(std::vector<std::string> vm_ids);

    bool
      cleanJob(std::string jobid);

    char *
      getImageId(char * image_name);

    char *
      getHardwareProfileId(char * profile_name);

    std::string
      getIPAddress(const deltacloud_instance & instance);

    bool
      runOn(const deltacloud_instance & instance, std::string command);

    bool
      runDietCommand(std::vector<std::string> vm_ids, const char * addon_prologue,
          const char * command, diet_profile_t * profile, std::string jobid);

    deltacloud_api api;
    CloudCredentials credentials;
    std::map<std::string,std::string> addresses;
    boost::mutex nfsfile_mutex;

};


#endif /* _DELTACLOUD_BATCHSYSTEM_HH */
