/**
 * @file  CallbackImpl.cc
 *
 * @brief   POA callback implementation
 *
 * @author   Christophe PERA (christophe.pera@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */




#include <iostream>
#include <CallbackImpl.hh>
#define TRACE_LEVEL 50
#include "debug.hh"

#include "Forwarder.hh"
#include "CallbackFwdr.hh"

using namespace std;

CallbackImpl::CallbackImpl()
{
	// nothing
}

CallbackImpl::~CallbackImpl()
{
	// nothing
}

CORBA::Long
CallbackImpl::ping()
{
	return 0;
}

CORBA::Long
CallbackImpl::notifyResults(const char *path,
                            const corba_profile_t &pb,
                            CORBA::Long reqID)
{
	/*
		 if (solve_res != GRPC_NO_ERROR)
		 CallAsyncMgr::get().setReqErrorCode(reqID, solve_res);
	 */
	return 0;
}

CORBA::Long
CallbackImpl::solveResults(const char *path,
                           const corba_profile_t &pb,
                           CORBA::Long reqID,
                           CORBA::Long solve_res)
{
	// notify solve result availability
	int err = CallAsyncMgr::get().notifyRst(int(reqID), &(const_cast<corba_profile_t &>(pb)));
	if (solve_res != GRPC_NO_ERROR)
	{
		CallAsyncMgr::get().setReqErrorCode(reqID, solve_res);
	}
	return err;
}

CallbackFwdrImpl::CallbackFwdrImpl(Forwarder_ptr fwdr, const char *objName)
: forwarder(Forwarder::_duplicate(fwdr))
, objName  (CORBA::string_dup(objName))
{
}

CORBA::Long
CallbackFwdrImpl::ping()
{
	return forwarder->ping(objName);
}

CORBA::Long
CallbackFwdrImpl::notifyResults(const char *path,
                                const corba_profile_t &pb,
                                CORBA::Long reqID)
{
	return forwarder->notifyResults(path, pb, reqID, objName);
}

CORBA::Long
CallbackFwdrImpl::solveResults(const char *path,
                               const corba_profile_t &pb,
                               CORBA::Long reqID,
                               CORBA::Long solve_res)
{
	return forwarder->solveResults(path, pb, reqID, solve_res, objName);
}
