/**
* @file  NodeSet.hh
* 
* @brief  Absctract class common parent to dag and workflows 
* 
* @author  Benjamin ISNARD (Benjamin.Isnard@ens-lyon.fr)
* 
* @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/


#ifndef _NODESET_
#define _NODESET_

#include <string>
#include "WfUtils.hh"
#include "WfNode.hh"

/*****************************************************************************/
/*                    CLASS NodeSet (ABSTRACT)                               */
/*****************************************************************************/

/**
 * NodeSet class
 *
 * Used by the DagWfParser to create either a dag or workflow
 * Used by Node class to manage relationships between nodes (this
 * applies to both dags or workflows)
 */

class NodeSet {
public:
  virtual ~NodeSet() {
  }

  /**
   * Get a node from the nodeset
   * @param nodeId  the identifier (string) of the node
   * @return pointer to node (does not return NULL)
   */
  virtual WfNode*
  getNode(const std::string& nodeId) noexcept(false) = 0;

  /**
   * Check that the relationships between nodes are correct
   * @param contextNodeSet the nodeSet used to find nodes referenced in the
   * current nodeSet (can be the current nodeSet itself)
   */
  virtual void
  checkPrec(NodeSet* contextNodeSet) noexcept(false) = 0;
};

#endif  // _NODESET_
