/**
 * @file DagdaCatalog.hh
 *
 * @brief  Dagda catalog implementation header.
 *
 * @author  Gael Le Mahec (lemahec@clermont.in2p3.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef _DAGDACATALOG_HH_
#define _DAGDACATALOG_HH_

#include <list>
#include <map>
#include <string>
#include <omniORB4/CORBA.h>
#ifdef WIN32
   #define DIET_API_LIB __declspec(dllexport)
#else
   #define DIET_API_LIB
#endif
typedef std::list<std::string> attributes_t;

class DagdaCatalog {
public:
  virtual ~DagdaCatalog() {
  }

  virtual attributes_t
  request(std::string req) = 0;

  virtual int
  insert(std::string key, attributes_t values) = 0;

  virtual bool
  exists(std::string key) = 0;
};

class DIET_API_LIB MapDagdaCatalog : public DagdaCatalog {
public:
  virtual ~MapDagdaCatalog() {
  }

  virtual attributes_t
  request(std::string req);

  virtual int
  insert(std::string key, attributes_t values);

  virtual bool
  exists(std::string key);

protected:
  attributes_t
  getAttributes(std::string key) {
    attributes_t ret;
    if (!exists(key)) {
      return ret;
    }
    dbMutex.lock();
    ret = database[key];
    dbMutex.unlock();
    return ret;
  }

  void
  setAttributes(std::string key, attributes_t values) {
    dbMutex.lock();
    database[key] = values;
    dbMutex.unlock();
  }

private:
  omni_mutex dbMutex;
  std::map<std::string, attributes_t> database;
};

#endif  // _DAGDACATALOG_HH_
