/**
* @file  FLoopNode.hh
* 
* @brief  The classes representing the for/while loops of a functional workflow
* 
* @author  Benjamin ISNARD (Benjamin.Isnard@ens-lyon.fr)
* 
* @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/


#ifndef _FLOOPNODE_HH_
#define _FLOOPNODE_HH_

#include <string>
#include <vector>
#include "FNode.hh"
#include "WfExpression.hh"

class FLoopNode : public FProcNode {
public:
  FLoopNode(FWorkflow* wf, const std::string& id);
  virtual ~FLoopNode();

  // ******************** NODE SETUP *********************

  virtual WfPort *
  newPort(std::string portId,
          unsigned int ind,
          WfPort::WfPortType portType,
          WfCst::WfDataType dataType,
          unsigned int depth) noexcept(false);

  virtual void
  connectNodePorts() noexcept(false);

  void
  setDoMap(const std::string& leftPortName,
           const std::string& rightPortName)
    noexcept(false);

  void
  setWhileCondition(const std::string& conditionStr)
    noexcept(false);

  // ******************** INSTANCIATION *********************

  virtual void
  initialize();

  virtual void
  instanciate(Dag* dag);

  virtual void
  createRealInstance(Dag* dag, const FDataTag& currTag,
                     std::vector<FDataHandle*>& currDataLine);

  virtual void
  createVoidInstance(const FDataTag& currTag,
                     std::vector<FDataHandle*>& currDataLine);

  virtual void
  updateInstanciationStatus();

protected:
  virtual void
  checkCondition() noexcept(false);

  bool
  testCondition(const std::vector<FDataHandle*>& currDataLine);

  void
  initLoopInPorts(std::vector<FDataHandle*>& currDataLine);

  std::vector<WfExprVariable*>*  myConditionVars;
  WfBooleanExpression* myCondition;
  FNodePortMap myDoMap;        // used for IN LOOP => OUT LOOP
  FNodePortMap myFinalOutMap;  // used for IN LOOP => OUT
  FNodePortMap myFinalLoopMap;  // used for VOID => OUT LOOP
  FNodePortMap myFinalVoidOutMap;  // used for VOID => OUT
  FNodePortMap myDirectInOutMap;   // used for IN => OUT (no loop iteration)
  InputIterator* myLoopIterator;

private:
  /**
   * Total nb of running loop instances
   */
  int activeInstanceNb;

  /**
   * Length of loop tags
   */
  unsigned int loopTagLength;
};

#endif  // _FLOOPNODE_HH_
