/**
 * @file file_transfer_server.c
 *
 * @brief  file_transfer example: server side
 *
 * @author  Philippe COMBES (Philippe.Combes@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef __WIN32__
#include <unistd.h>
#else
#include <Winsock2.h>
#include <windows.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>

#include "DIET_server.h"




int
solve_size(diet_profile_t *pb) {
  size_t arg_size = 0;
  char *path1 = NULL;
  char *path2 = NULL;
  int status = 0;
  struct stat buf;
  size_t *s1 = NULL;
  size_t *s2 = NULL;

  fprintf(stderr, "Solve size ");

  diet_file_get(diet_parameter(pb, 0), &path1, NULL, &arg_size);
  fprintf(stderr, "on %s (%lu) ", path1, arg_size);
  if ((status = stat(path1, &buf))) {
    return status;
  }
  /* Regular file */
  if (!(buf.st_mode & S_IFREG)) {
    return 2;
  }
  s1 = (size_t *)calloc(1, sizeof *s1);
  *s1 = buf.st_size;
  diet_scalar_set(diet_parameter(pb, 2), s1, DIET_VOLATILE, DIET_INT);

  diet_file_get(diet_parameter(pb, 1), &path2, NULL, &arg_size);
  fprintf(stderr, "and %s (%lu) ...", path2, arg_size);
  if ((status = stat(path2, &buf))) {
    return status;
  }
  if (!(buf.st_mode & S_IFREG)) {
    return 2;
  }
  s2 = (size_t *)calloc(1, sizeof *s2);
  *s2 = buf.st_size;
  diet_scalar_set(diet_parameter(pb, 3), s2, DIET_VOLATILE, DIET_INT);

  path2 = strdup(path1);

  if (diet_file_set(diet_parameter(pb, 4), path2, DIET_VOLATILE)) {
    printf("diet_file_desc_set error\n");
    return 1;
  }
  printf(" done\n");

  printf("Returned file: %s.\n", path2);

  /* **************
     Don't free the string names since they are not replicated from CORBA obj
  ************** */

  return 0;
} /* solve_size */


/*
 * MAIN
 */

int
main(int argc, char *argv[]) {
  int res;
  diet_profile_desc_t *profile = NULL;

  if (argc < 2) {
    fprintf(stderr, "Usage: %s <file.cfg>\n", argv[0]);
    return 1;
  }

  /* This is for solve function (OUT parameter) */
  srand(time(NULL));


  diet_service_table_init(1);
  profile = diet_profile_desc_alloc("size", 1, 1, 4);
  diet_generic_desc_set(diet_param_desc(profile, 0), DIET_FILE, DIET_CHAR);
  diet_generic_desc_set(diet_param_desc(profile, 1), DIET_FILE, DIET_CHAR);
  diet_generic_desc_set(diet_param_desc(profile, 2), DIET_SCALAR, DIET_INT);
  diet_generic_desc_set(diet_param_desc(profile, 3), DIET_SCALAR, DIET_INT);
  diet_generic_desc_set(diet_param_desc(profile, 4), DIET_FILE, DIET_CHAR);
  if (diet_service_table_add(profile, NULL, solve_size)) {
    return 1;
  }

  diet_profile_desc_free(profile);
  diet_print_service_table();
  res = diet_SeD(argv[1], argc, argv);
  /* Not reached */
  return res;
} /* main */
