/**
 * @file job.c
 *
 * @brief   Tools for job management on SCALAPACK servers (source code)
 *
 * @author  Bert VAN HEUKELOM  (Bert.Van-Heukelom@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>
#include <math.h>
#include "job.h"


job *
job_construct(int nbProcs) {
  job *j;
  j = malloc(sizeof(job));

  j->procs = calloc(nbProcs, sizeof(int));
  j->commAll = malloc(sizeof(MPI_Comm));
  j->comm1x1 = malloc(sizeof(MPI_Comm));
  j->commWorkers = malloc(sizeof(MPI_Comm));
  j->intercomm = malloc(sizeof(MPI_Comm));
  j->procCount = -1;
  j->row = -1;
  j->col = -1;
  j->colCount = -1;
  j->rowCount = -1;
  j->sedId = -1;
  j->contextAll = -1;
  j->context1x1 = -1;
  j->contextWorkers = -1;
  return j;
} /* job_construct */


void
job_destruct(job *j) {
  free(j->commAll);
  free(j->commWorkers);
  free(j->comm1x1);
  free(j->intercomm);
  free(j->procs);
  free(j);
  j = 0;
}
