/**
 * @file Global_macros.hh
 *
 * @brief  DIET macros for use with thte asynchronous versions of dmat_manips
 *
 * @author  Christophe PERA (Philippe.Combes@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _GLOBAL_MACROS_HH_
#define _GLOBAL_MACROS_HH_

#include <ctime>
#include <iostream>
#ifndef __WIN32__
#include <unistd.h>
#include <sys/time.h>
#else
#include <Winsock2.h>
#include <windows.h>
#include <sys/timeb.h>
#endif
#include <omniconfig.h>
#include <omnithread.h>

// Others debug Traces

#define traceTimer 1
#define traceThreadId 1
#define traceFile 1
#define traceLine 1
#define traceFunction 1

#define FILE_OUTPUT()                           \
  cout << "file=" << __FILE__ << "|";
#define LINE_OUTPUT()                           \
  cout << "line=" << __LINE__ << "|";
#define FUNCTION_OUTPUT()                       \
  cout << "function=" << __FUNCTION__ << "|";
#define OMNITHREADID_OUTPUT()                   \
  int id = omni_thread::self()->id();           \
  cout << "ThreaID=" << id << "|";
#define TIMER_OUTPUT()                          \
  timeval tval;                                 \
  gettimeofday(&tval, NULL);                    \
  std::cout << "timer=" << tval.tv_sec << ", " << tval.tv_usec << "|";
#define VARIABLE_OUTPUT(X)                      \
  cout << # X << "=" << X;
#define TEXT_OUTPUT(X)                          \
  printf X;
# if defined (DIET_NDEBUG)
#   define DIET_DEBUG(X)
# else
#   define DIET_DEBUG(X) DIET_TRACE_IMPL(X)
# endif

# define DIET_TRACE_IMPL(X)                             \
  do {                                                  \
    if (traceTimer == 1) {TIMER_OUTPUT()}             \
    if (traceThreadId == 1) {OMNITHREADID_OUTPUT()}    \
    if (traceFile == 1) {FILE_OUTPUT()}               \
    if (traceLine == 1) {LINE_OUTPUT()}               \
    if (traceFunction == 1) {FUNCTION_OUTPUT()}       \
    X                                                   \
    std::cout << "\n";                                \
    fflush(stdout);                                     \
    fflush(stderr);                                     \
  } while (0);

#endif /* _GLOBAL_MACROS_H_ */
