/**
* @file DIET_mutex.h
* 
* @brief  DIET mutex interface for multi-threaded server applications 
* 
* @author Philippe COMBES (Philippe.Combes@ens-lyon.fr)                  
*         Bert VAN HEUKELOM (Bert.Van-Heukelom@ens-lyon.fr) 
* 
* @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/



#ifndef _DIET_MUTEX_H_
#define _DIET_MUTEX_H_

#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus
  typedef int diet_mutex_t;

  /**
   * @brief initialize DIET mutexes
   *
   */
  void
  diet_mutex_initialize();

  /**
   * @brief create mutex
   *
   * @param ret
   */
  void
  diet_mutex_create(int* ret);

  /**
   * @brief lock mutex
   *
   * @param i index of the mutex to be locked
   */
  void
  diet_mutex_lock(int i);

  /**
   * @brief unlock mutex
   *
   * @param i index of the mutex to be unlocked
   */
  void
  diet_mutex_unlock(int i);

  /**
   * @brief free mutex
   *
   * @param i
   */
  void
  diet_mutex_free(int* i);

  /**
   * @brief finalize DIET mutexes
   *
   */
  void
  diet_mutex_finalize();

  /**
   * @brief put current thread to sleep
   *
   * @param m seconds
   * @param n nanoseconds
   */
  void
  diet_thread_sleep(int m, int n);

  /**
   * @brief yield current thread
   *
   */
  void
  diet_thread_yield();

  /**
   * @brief get current thread id
   *
   * @return thread id
   */
  int
  diet_thread_id();
#ifdef __cplusplus
}
#endif  // __cplusplus

#endif  // _DIET_MUTEX_H_


