#include "DIET_uuid.hh"

boost::uuids::uuid
diet_generate_uuid()
{
	static boost::mutex mutex;
	boost::mutex::scoped_lock lock(mutex);

	/*
	 * Random uuid generator using boost
	 *
	 * The default constructor for boost::uuids::random_generator
	 * uses OS entropy to initiate the seed of the internal pseudorandom generator
	 * This is better then trying to seed using time(null) and creting name
	 * conflicts when 2 process start at the same epoch
	 */

	static boost::uuids::random_generator rg{};
	return rg();
}
