/**
 * @file service2.cc
 *
 * @brief  Service example for dynamic loading. This is only a 'Hello world'
 *
 * @author  Benjamin Depardon (benjamin.depardon@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#include "service2.hh"

#include <iostream>
#include <cstring>

#include "DIET_server.h"
#include "DIET_Dagda.h"


static const char service_name[] = "Dynamic_creation2";

static diet_profile_desc_t *
set_profile_desc() {
  diet_profile_desc_t *profile = NULL;
  unsigned int pos = 0;

  /* Set profile parameters: */
  profile = diet_profile_desc_alloc(strdup(service_name), 0, 0, 0);

  diet_generic_desc_set(diet_param_desc(profile, pos++), DIET_STRING, DIET_CHAR);
  return profile;
}

const char * const
serviceName() {
  return service_name;
}


/*
 * SOLVE FUNCTION
 */
int
service(diet_profile_t *pb) {
  char *str;

  if (pb->pb_name) {
    std::cout << "## Executing " << pb->pb_name << std::endl;
  } else {
    std::cout << "## ERROR: No name for the service" << std::endl;
    return -1;
  }

  diet_string_get(diet_parameter(pb, 0), &str, NULL);

  std::cout << "*****************************************************" <<
  std::endl
            << service_name << std::endl
            << " Message: '" << str << "'" << std::endl
            << "*****************************************************" <<
  std::endl;

  return 0;
} // service


/*
 * add_service function:
 * declare the DIET's service
 */
int
addService() {
  diet_profile_desc_t *profile = set_profile_desc();

  /* Add service to the service table */
  if (diet_service_table_add(profile, NULL, service)) {
    return 1;
  }

  /* Free the profile, since it was deep copied */
  diet_profile_desc_free(profile);

  return 0;
} // addService



int
removeService() {
  diet_profile_desc_t *profile = set_profile_desc();

  std::cout << "## Removing service " << profile->path << std::endl;
  diet_service_table_remove_desc(profile);
  std::cout << "## Service removed" << std::endl;

  diet_profile_desc_free(profile);

  return 0;
} // removeService
