/**
* @file  WfLogServiceImpl.hh
* 
* @brief Workflow LogService 
* 
* @author  Gaël Le Mahec (gael.le.mahec@ens-lyon.fr)
* 
* @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
*/


#ifndef WFLOGSERVICEIMPL_HH
#define WFLOGSERVICEIMPL_HH

#include "WfLogService.hh"
#include "Forwarder.hh"
#include "WfLogServiceFwdr.hh"

class WfLogServiceFwdrImpl : public POA_WfLogServiceFwdr,
                             public PortableServer::RefCountServantBase {
public:
  WfLogServiceFwdrImpl(Forwarder_ptr fwdr, const char* objName);

  virtual void
  initWorkflow(const char* wfId, const char* name, const char* parentWfId);

  virtual void
  updateWorkflow(const char* wfId, const char* wfState, const char* data);

  virtual void
  createDag(const char* dagId, const char* wfId);

  virtual void
  updateDag(const char* dagId, const char* wfId,
            const char* dagState, const char* data);

  virtual void
  createDagNode(const char* dagNodeId, const char* dagId, const char* wfId);

  virtual void
  createDagNodePort(const char* dagNodePortId, const char* portDirection,
                    const char* dagNodeId, const char* wfId);

  virtual void
  setInPortDependencies(const char* dagNodePortId, const char* dagNodeId,
                        const char* wfId, const char* dependencies);

  virtual void
  createDagNodeLink(const char* srcNodeId, const char* srcWfId,
                    const char* destNodeId, const char* destWfId);

  virtual void
  createDagNodeData(const char* dagNodeId, const char* wfId,
                    const char* dagNodePortId, const char* dataId);

  virtual void
  createDataElements(const char* dataId, const char* elementIdList);

  virtual void
  createSourceDataTree(const char* sourceId, const char* wfId,
                       const char* dataIdTree);

  virtual void
  createSinkData(const char* sinkId, const char* wfId, const char* dataId);

  virtual void
  nodeIsReady(const char* dagNodeId, const char* wfId);

  virtual void
  nodeIsStarting(const char* dagNodeId, const char* wfId,
                 const char* pbName, const char* hostname);

  virtual void
  nodeIsRunning(const char* dagNodeId, const char* wfId);

  virtual void
  nodeIsDone(const char* dagNodeId, const char* wfId);

  virtual void
  nodeIsFailed(const char* dagNodeId, const char* wfId);

protected:
  Forwarder_ptr forwarder;
  char* objName;
};
#endif
