/**
 * @file echo_client.c
 *
 * @brief  DIET echo example: a client that ask for an echo.
 *
 * @author  Guillaume Verger (guillaume.verger@inria.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#ifndef __WIN32__
#include <unistd.h>
#endif
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "DIET_client.h"

#define print_condition 1

/* argv[1]: client config file path
 argv[2]: one of the strings above */

void usage(char *cmd) {
	fprintf(stderr, "Usage: %s <file.cfg> <name>\n", cmd);
	exit(1);
}

int main(int argc, char *argv[]) {
	diet_profile_t *profile = NULL;
	char * name = NULL; // Name of the client
	char * echo = NULL; // Answer of the server

	if (argc != 3) {
		usage(argv[0]);
	}

	if (diet_initialize(argv[1], argc, argv)) {
		fprintf(stderr, "DIET initialization failed !\n");
		return 1;
	}

	profile = diet_profile_alloc("echo", 0, 0, 1);

	name = argv[2];

	diet_string_set(diet_parameter(profile, 0), name, DIET_VOLATILE);
	diet_string_set(diet_parameter(profile, 1), NULL, DIET_VOLATILE);

	if (!diet_call(profile)) {
		diet_string_get(diet_parameter(profile, 1), &echo, DIET_VOLATILE);
		printf("Answer : %s\n", echo);
	}

	diet_profile_free(profile);
	diet_finalize();

	return 0;
} /* main */
