/**
 * @file file_transfer_client.c
 *
 * @brief  file_transfer example: client side
 *
 * @author  Philippe COMBES (Philippe.Combes@ens-lyon.fr)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#include <string.h>

#ifndef __WIN32__
#include <unistd.h>
#else
#include <Winsock2.h>
#include <windows.h>
#endif

#include <stdlib.h>
#include <stdio.h>

#include "DIET_client.h"

/* argv[1]: client config file path
   argv[2]: path of the file to transfer */

int
main(int argc, char *argv[]) {
  char *path = NULL;
  diet_profile_t *profile = NULL;
  int *size1 = NULL;
  int *size2 = NULL;
  size_t out_size = 0;


  if (argc != 4) {
    fprintf(stderr, "Usage: %s <file.cfg> <file1> <file2>\n", argv[0]);
    return 1;
  }
  path = "size";

  if (diet_initialize(argv[1], argc, argv)) {
    fprintf(stderr, "DIET initialization failed !\n");
    return 1;
  }

  profile = diet_profile_alloc(path, 1, 1, 4);
  if (diet_file_set(diet_parameter(profile, 0), argv[2], DIET_PERSISTENT)) {
    printf("diet_file_set error\n");
    return 1;
  }
  if (diet_file_set(diet_parameter(profile, 1), argv[3], DIET_VOLATILE)) {
    printf("diet_file_set error\n");
    return 1;
  }
  diet_scalar_set(diet_parameter(profile, 2), NULL, DIET_VOLATILE, DIET_INT);
  diet_scalar_set(diet_parameter(profile, 3), NULL, DIET_VOLATILE, DIET_INT);
  if (diet_file_set(diet_parameter(profile, 4), NULL, DIET_VOLATILE)) {
    printf("diet_file_set error\n");
    return 1;
  }

  if (!diet_call(profile)) {
    diet_scalar_get(diet_parameter(profile, 2), &size1, NULL);
    diet_scalar_get(diet_parameter(profile, 3), &size2, NULL);
    if (size1 && size2) {
      printf("Answered sizes are %d and %d.\n", *size1, *size2);
      /* No need to free size1 and size2: CORBA takes care of them */
    } else {
      fprintf(stderr, "Error: Cannot get answered sizes !\n");
    }
    diet_file_get(diet_parameter(profile, 4), &path, NULL, &out_size);
    if (path && (*path != '\0')) {
      printf("Location of returned file is %s, its size is %lu.\n",
             path, out_size);
      /* If uncommented, next line unlink file */
      /* diet_free_data(diet_parameter(profile, 4)); */
    }
  }

  diet_profile_free(profile);

  diet_finalize();

  return 0;
} /* main */
