/**
 * @file HostnameRR.cc
 *
 * @brief  Hostname scheduler
 *
 * @author  David Loureiro (david.loureiro@sysfera.com)
 *
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */

#include <map>
#include <string>

#include "GlobalSchedulers.hh"
#include "UserScheduler.hh"
#include "est_internal.hh"

std::map<std::string, unsigned int> hostCounter;

class HostnameRR: public UserScheduler {
public:
  static const char *stName;

  HostnameRR();
  ~HostnameRR();
  void
  init();

  static char *
  serialize(HostnameRR *GS);
  static HostnameRR *
  deserialize(const char *serializedScheduler);
/* Overriden aggregate method to schedule jobs with the SRA policy. */
  int
  aggregate(corba_response_t *aggrResp, size_t max_srv,
            const size_t nb_responses, const corba_response_t *responses);
};

using namespace std;

const char *HostnameRR::stName = "UserGS";

HostnameRR::~HostnameRR() {
}

HostnameRR::HostnameRR() {
  this->name = this->stName;
  this->nameLength = strlen(this->name);
}

int
HostnameRR::aggregate(corba_response_t *aggrResp, size_t max_srv,
                      const size_t nb_responses,
                      const corba_response_t *responses) {
  ServerList::iterator itSeD;
  unsigned int nbUsage = 0;
  corba_server_estimation_t selected;


  cout << "******************** HostnameRR ********************" << endl;
  ServerList candidates = CORBA_to_STL(responses, nb_responses);

  for (itSeD = candidates.begin(); itSeD != candidates.end(); ++itSeD) {
    // We select the SeD by its host usage.
    if (hostCounter[HOSTNAME(*itSeD)] <= nbUsage) {
      selected = *itSeD;
    }
  }

  aggrResp->servers.length(1);
  aggrResp->servers[0] = selected;

  return 0;
} // aggregate

SCHEDULER_CLASS(HostnameRR)
