/**
 * @file DIET_admin.h
 * 
 * @brief  Header for the admin API
 * 
 * @author - Benjamin DEPARDON (Benjamin.Depardon@ens-lyon.fr)                  
 *         - Kevin COULOMB (kevin.coulomb@-sysfera.fr) 
 * 
 * @section Licence
 *
 * Copyright Inria, ENS Lyon and UCBL (2000-2017) 
 * Copyright SysFera (2010-2015)
 *
 * - Eddy.Caron@ens-lyon.fr (Project Manager)
 *
 * This software is a computer program whose purpose is to provide an
 * easy and transparent access to distributed and heterogeneous
 * platforms.
 *
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided
 * only with a limited warranty  and the software's author,  the holder
 * of the economic rights,  and the successive licensors  have only
 * limited liability.
 *
 * In this respect, the user's attention is drawn to the risks
 * associated with loading,  using,  modifying and/or developing or
 * reproducing the software by the user in light of its specific status
 * of free software, that may mean  that it is complicated to
 * manipulate, and  that  also therefore means  that it is reserved for
 * developers and experienced professionals having in-depth computer
 * knowledge. Users are therefore encouraged to load and test the
 * software's suitability as regards their requirements in conditions
 * enabling the security of their systems and/or data to be ensured and,
 * more generally, to use and operate it in the same conditions as
 * regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */


#ifndef _DIET_ADMIN_H_
#define _DIET_ADMIN_H_



#ifdef WIN32
   #define DIET_API_LIB __declspec(dllexport)
#else
   #define DIET_API_LIB
#endif
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

//------------------------------------------------------------------------
// Error code
//------------------------------------------------------------------------
#define DIET_NO_ERROR         0  /*!< No error has occured */
#define DIET_COMM_ERROR       1  /*!< A communication error has occured, before
                                  *   changing the shape of the hierarchy */
#define DIET_UNKNOWN_ERROR    2  /*!< An unknown error has occured */
#define DIET_ADMIN_CALL_ERROR 3  /*!< An error occured while changing the shape
                                  *   of the hierarchy */

  //------------------------------------------------------------------------
  // Datatypes
  //------------------------------------------------------------------------


  /**
   * @brief Enumeration to specify the type of the component to administrate
   */
  typedef enum dynamic_type_t {
    SED = 0, /*!< The element is a SeD */
    AGENT,   /*!< The element is an agent */
    LA,      /*!< The element is a local agent */
    MA,      /*!< The element is a master agent */
    MADAG    /*!< The element is an MA DAG */
  } dynamic_type_t;

  //------------------------------------------------------------------------
  // API
  //------------------------------------------------------------------------

  /**
   * @brief Remove a component from the hierarchy
   * @param type The type of the element to disconnect
   * @param name The name of the component to disconnect
   (as recorded in the naming service)
   * @param recursive if 0, not recursive, otherwise the children are also
   removed
   * @return DIET_SUCCESS on success, an error code otherwise
   */
  DIET_API_LIB int
  diet_remove_from_hierarchy(dynamic_type_t type, const char *name,
                             int recursive);

  /**
   * @brief Change the parent of a component in the hierarchy
   * @param type The type of the element to change the parent of
   * @param name The name of the component to change the parent of
   (as recorded in the naming service)
   * @param parent_name the name of the new parent in the hierarchy
   (as recorded in the naming service)
   * @return DIET_SUCCESS on success, an error code otherwise
   */
  DIET_API_LIB int
  diet_change_parent(dynamic_type_t type, const char *name,
                     const char *parent_name);


  /**
   * @brief Disconnect an element from its parent in the hierarchy
   * @param type The type of the element to disconnect
   * @param name The name of the component to disconnect
   (as recorded in the naming service)
   * @return DIET_SUCCESS on success, an error code otherwise
   */
  DIET_API_LIB int
  diet_disconnect_from_hierarchy(dynamic_type_t type, const char *name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _DIET_ADMIN_H_ */
